/*
 * libdpkg - Debian packaging suite library routines
 * vercmp.c - comparison of version numbers
 *
 * Copyright (C) 1995 Ian Jackson <ian@chiark.greenend.org.uk>
 *
 * This is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2,
 * or (at your option) any later version.
 *
 * This is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with dpkg; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include <config.h>

#include <ctype.h>
#include <string.h>

#define cisdigit isdigit
#define cisalpha isalpha

/* assume ascii; warning: evaluates x multiple times! */
#define order(x) ((x) == '~' ? -1 \
    : cisdigit((x)) ? 0 \
    : !(x) ? 0 \
    : cisalpha((x)) ? (x) \
    : (x) + 256)

int verrevcmp(const char *val, const char *ref) {
  if (!val) val= "";
  if (!ref) ref= "";

// ////////////////////////////////////////////////////////////////////////
// This block was copy-pasted from rpmvercmp-patched.c
// TODO: big cleanup
// ////////////////////////////////////////////////////////////////////////
  const char *a = val;
  const char *b = ref;

  char oldch1, oldch2;
  char * str1, * str2;
  char * one, * two;
  size_t length1, length2;
  int rc;
  int isnum;

  /* easy comparison to see if versions are identical */
  if (!strcmp(a, b)) return 0;

  length1 = strlen(a);
  length2 = strlen(b);
  one = alloca(length1 + 1);
  two = alloca(length2 + 1);
  strcpy(one, a);
  strcpy(two, b);

  /* walk trough string from end lexicographically */
  str1 = one + length1;
  str2 = two + length2;
  while (str1-one>0 && str2-two>0 && *str1 == *str2) {
    str1--;
    str2--;
  }
  if (*str1 && *str2) {
    str1++;
    str2++;
  }
  /* preserve version strings while cutting suffix */
  while (*str1 && !isalpha(*(str1+1))) {
    str1++;
    str2++;
  }
  while (*str1 && *str1!='.') {
    str1++;
    str2++;
  }
  /* cut suffix if any*/
  *str1 = '\0';
  *str2 = '\0';

  val = one;
  ref = two;
// ////////////////////////////////////////////////////////////////////////

  while (*val || *ref) {
    int first_diff= 0;

    while ( (*val && !cisdigit(*val)) || (*ref && !cisdigit(*ref)) ) {
      int vc= order(*val), rc= order(*ref);
      if (vc != rc) return vc - rc;
      val++; ref++;
    }

    while ( *val == '0' ) val++;
    while ( *ref == '0' ) ref++;
    while (cisdigit(*val) && cisdigit(*ref)) {
      if (!first_diff) first_diff= *val - *ref;
      val++; ref++;
    }
    if (cisdigit(*val)) return 1;
    if (cisdigit(*ref)) return -1;
    if (first_diff) return first_diff;
  }
  return 0;
}

