#include <sys/types.h>
#include <unistd.h>
#include <sys/time.h>
#include <time.h>
#include <stdlib.h>
#include <iostream>
#include <vector>
#include <string>
#include <sstream>

using namespace std;

class RandGenerator {
  public:
    // Initialize random generator seed
    RandGenerator() {
      // Get system clock
      struct timeval tv;
      if (0 != gettimeofday(&tv, NULL))
        // Failed to read system time
        throw std::bad_alloc();

      // Convert to microseconds
      int clk = tv.tv_usec;

      // Initialize seed
      this->seed = clk * getpid();
#if 0//ndef NDEBUG
      std::cerr << "RandGenerator::RandGenerator(): seed=" << seed << std::endl;
#endif // NDEBUG
    }
    // Return random number in interval <0,1)
    float getRand() {
      float rnd = rand_r(&seed);
      return rnd/RAND_MAX;
    }
    // Return random float in interval <min,max)
    float getRand(float min, float max) {
      float rnd = this->getRand();
      rnd *= max-min;
      rnd += min;
      return rnd;
    }
    // Return random int in interval <min,max)
    int getRand(int min, int max) {
      float rnd = this->getRand(
          static_cast<float>(min),
          static_cast<float>(max)
          );
      return static_cast<int>(rnd);
    }
  private:
    unsigned int seed;
};

/**
 * USAGE:
 *   vergen COUNT
 */
int main(int argc, char *argv[]) {
  if (argc<2) {
    std::cerr << "Usage: vergen COUNT" << std::endl;
    return -1;
  }

  const int COUNT = atoi(argv[1]);
  if (0==COUNT) {
    std::cerr << "Usage: vergen COUNT" << std::endl;
    return -1;
  }

  // Random numbers generator
  RandGenerator rnd;

  // ATOMs
  vector<string> atoms;
  atoms.push_back("gcc-c++");
  atoms.push_back("redhat-rpm-config");
  atoms.push_back("glibc");
  atoms.push_back("glibc-devel");
  atoms.push_back("glibc-common");
  atoms.push_back("libstdc++");
  atoms.push_back("libstdc++-devel");
  atoms.push_back("nss_db");
  atoms.push_back("nss_ldap");
  atoms.push_back("xfce4-icon-theme");

  // EXTRAs
  vector<string> extras;
  extras.push_back("");
  extras.push_back("a");
  extras.push_back("b");
  extras.push_back("beta1");
  extras.push_back("beta2");
  extras.push_back("-0.1.beta1");
  extras.push_back("-0.2.beta1");
  extras.push_back("-0.2.beta2");
  extras.push_back(".20040110svn");
  extras.push_back(".20040110cvs");
  extras.push_back(".20040204svn");
  extras.push_back(".20040204cvs");
  extras.push_back("-1");
  extras.push_back("-2");
  extras.push_back("-0.1a");
  extras.push_back("-0.2a");
  extras.push_back("-0.2b");
  extras.push_back("-0.3b");
  extras.push_back("-0.4b");
  extras.push_back("-0.6rc1");
  extras.push_back("-0.6rc2");
  extras.push_back("-0.7rc2");

  // TAGs
  vector<string> tags;
  tags.push_back("");
  tags.push_back(".fc8");
  tags.push_back(".fc9");
  tags.push_back(".fc10");

  // SUFFIXes
  vector<string> suffixes;
  suffixes.push_back("");
  suffixes.push_back(".tar.bz2");
  suffixes.push_back(".tar.gz");
  suffixes.push_back(".rpm");
  suffixes.push_back(".deb");
  suffixes.push_back(".ebuild");

  // Generator main loop
  for (int count=0; count<COUNT; count++) {
    // print atom
    std::cout << atoms[rnd.getRand(0, atoms.size())];

    // print major version
    std::cout << "-" << rnd.getRand(0, 13);

    // print minor versions
    const int nMinors = rnd.getRand(0, 4);
    for (int i=0; i<nMinors; i++)
      std::cout << "." << rnd.getRand(0, 13);

    // print extra
    std::cout << extras[rnd.getRand(0, extras.size())];

    // print tag
    std::cout << tags[rnd.getRand(0, tags.size())];

    // print suffix
    std::cout << suffixes[rnd.getRand(0, suffixes.size())] << std::endl;
  }
  // new line at end of file generated
  std::cout << std::endl;
}
