#include <wchar.h>
#include <locale.h>
#include <stdio.h>

#define WIN32_LEAN_AND_MEAN
#include <windows.h>

#define A(s) fprintf(stderr, "%s = %d\n", #s, (s) != 0)

int
main(void)
{
    setlocale(LC_ALL, "");

    HANDLE h;

    A(CreateDirectoryW(L"dir1", NULL));
    A(CreateDirectoryW(L"dir1/subdir1", NULL));

    A(CreateDirectoryW(L"dir2", NULL));
    A(CreateDirectoryW(L"dir2/subdir2", NULL));

    A((h = CreateFileW(L"dir1/subdir1/file1.txt",
                       GENERIC_WRITE, 0, NULL,
                       CREATE_NEW, FILE_ATTRIBUTE_NORMAL, NULL)
      ) != INVALID_HANDLE_VALUE);
    A(WriteFile(h, "file1.txt\r\n", 11, NULL, NULL));
    A(CloseHandle(h));

    A((h = CreateFileW(L"dir2/subdir2/..\u2044..\u2044dir1\u2044subdir1\u2044file1.txt",
                        GENERIC_WRITE, 0, NULL,
                        CREATE_NEW, FILE_ATTRIBUTE_NORMAL, NULL)
      ) != INVALID_HANDLE_VALUE);
    A(WriteFile(h, "dangerous\r\n", 11, NULL, NULL));
    A(CloseHandle(h));


    wchar_t utf8max[1024] = L"utf8max";
    A(CreateDirectoryW(utf8max, NULL));

    utf8max[7] = '/';

    // 126 times 'ä'. Each character consumes one wchar_t or
    // two bytes as UTF-8.
    wmemset(utf8max + 8, 0x00E4, 126);

    // ASCII digits 1-9.
    for (size_t i = 0; i < 9; ++i)
        utf8max[8 + 126 + i] = L'1' + i;

    // With the terminating \0, the UTF-8 form consumes 262 bytes which is
    // more than MAX_PATH (260). However, if the leading directory names
    // are short enough, accessing this file with _open() works even
    // without longPathAware in the application manifest. Apparently
    // NT-based Windows counts MAX_PATH as wide chars even though the
    // MAX_PATH constant appears in the "ANSI" APIs as well.
    utf8max[8 + 126 + 9] = L'\0';

    A((h = CreateFileW(utf8max,
                        GENERIC_WRITE, 0, NULL,
                        CREATE_NEW, FILE_ATTRIBUTE_NORMAL, NULL)
      ) != INVALID_HANDLE_VALUE);
    A(WriteFile(h, "261+1 bytes as UTF-8\r\n", 22, NULL, NULL));
    A(CloseHandle(h));


    wchar_t *p = utf8max + 8;

    // First 250 chars are filled with circled latin letters A to Y.
    // Each letter appears ten times in a row.
    // Each character consumes one wchar_t or three bytes as UTF-8.
    for (size_t i = 0; i < 25; ++i) {
        wmemset(p, L'\u24B6' + i, 10);
        p += 10;
    }

    // Final five characters are circled digits 1-5.
    // Space consumption is like above.
    for (size_t i = 0; i < 5; ++i)
        *p++ = L'\u2460' + i;

    // The 255 Unicode characters + \0 consume 766 bytes as UTF-8
    // which is more than MAX_PATH (260). Unless the file was
    // created in a root directory, the absolute path as wide chars
    // will exceed MAX_PATH too. Thus, accessing this file requires
    // that the application is long path aware (and the registry setting).
    *p = L'\0';

    A((h = CreateFileW(utf8max,
                        GENERIC_WRITE, 0, NULL,
                        CREATE_NEW, FILE_ATTRIBUTE_NORMAL, NULL)
      ) != INVALID_HANDLE_VALUE);
    A(WriteFile(h, "long path aware only\r\n", 22, NULL, NULL));
    A(CloseHandle(h));

    // NOTE: While this is about native apps, one can observe in Cygwin
    // that its build of "ls" cannot list the filenames in utf8max
    // (they are truncated). Perhaps it's because the names exceed
    // Cygwin's NAME_MAX which affects struct dirent in <dirent.h>.

    return 0;
}
