/*
 *  Author:       Serg Stoyan
 *
 *  Classes:      AppController : NSObject
 *
 *  Description:  Application delegate
 */

#include "AppController.h"

#include <AppKit/NSMenu.h>
#include <AppKit/NSCell.h>
#include <AppKit/NSWindow.h>
#include <AppKit/NSPanel.h>

#include "TestWindow.h"

@implementation AppController

/*-------------------------------------------------------------------------*
 *  Application delegate methods
 *-------------------------------------------------------------------------*/
- (void) applicationWillFinishLaunching: (NSNotification *)notify
{
  [self createMenu];
}

- (void) applicationDidFinishLaunching: (NSNotification *)notify;
{
/*  testWindow = [TestWindow new];
  [testWindow orderFront: self];*/
}

- (BOOL) applicationShouldTerminate: (id)sender
{
  return YES;
}

- (void) createMenu
{
  NSMenu *menu;
  NSMenu *info;
  NSMenu *document;
  NSMenu *windows;
  NSMenu *services;
  NSMenu *shortM;
  NSMenu *wideM;

  SEL action = @selector(method:);

  menu = [[NSMenu alloc] initWithTitle: @"NSMenu"];

	// Main menu
  [menu addItemWithTitle: @"Info" 
		action: @selector(showInfoPanel:) keyEquivalent: @""];
  [menu addItemWithTitle: @"Document"
    action: action keyEquivalent: @""];
		
  [menu addItemWithTitle: @"Short"
    action: action keyEquivalent: @""];
  [menu addItemWithTitle: @"Workspace"
    action: action keyEquivalent: @""];

  [menu addItemWithTitle: @"Windows"
    action: action keyEquivalent: @""];
  [menu addItemWithTitle: @"Services"
    action: action keyEquivalent: @""];
  [menu addItemWithTitle: @"Hide"
    action:@selector (hide:) keyEquivalent: @"h"];
	[menu addItemWithTitle:
		@"Quit" action:@selector(terminate:) keyEquivalent: @"q"];

	// Submenus
  info = AUTORELEASE([[NSMenu alloc] init]);
  [menu setSubmenu:info forItem:[menu itemWithTitle:@"Info"]];
  [info addItemWithTitle:@"Info Panel..."
		action:@selector(showInfoPanel:) keyEquivalent:@""];
  [info addItemWithTitle:@"Preferences..." 
		action:@selector(showPrefPanel:) keyEquivalent:@""];
  [info addItemWithTitle:@"Help..." action:action keyEquivalent:@"?"];
 
	// Document
  document = AUTORELEASE([[NSMenu alloc] init]);
  [document addItemWithTitle:@"New..." 
		   action: @selector(newDocument:) keyEquivalent:@"n"];
  [menu setSubmenu: document forItem: [menu itemWithTitle:@"Document"]];

	//
  shortM = [NSMenu new];
  [menu setSubmenu: shortM forItem: [menu itemWithTitle: @"Short"]];

	//
  wideM = AUTORELEASE([[NSMenu alloc] init]);
  [menu setSubmenu: wideM forItem:[menu itemWithTitle:@"Workspace"]];
  [wideM addItemWithTitle: @"S" action:action keyEquivalent:@"W"];
	[[wideM itemWithTitle: @"S"] setState: NSOnState];
//  [wideM addItemWithTitle: @"This is very long menu item" action:action keyEquivalent:@""];

  // Windows
  windows = [NSMenu new];
  [windows addItemWithTitle: @"Arrange in Front" 
		action: @selector (arrangeInFront:) keyEquivalent: @""];
  [windows addItemWithTitle: @"Miniaturize Window" 
		action: @selector (performMiniaturize:) keyEquivalent: @"m"];
  [windows addItemWithTitle: @"Close Window" 
    action: @selector (performClose:) keyEquivalent: @"w"];
  [menu setSubmenu: windows forItem: [menu itemWithTitle:@"Windows"]];

	// Services
  services = [NSMenu new];
  [menu setSubmenu: services forItem: [menu itemWithTitle: @"Services"]];
  
  [NSApp setWindowsMenu: windows];
  [NSApp setServicesMenu: services];
  [NSApp setMainMenu: menu];
}

- (TestWindow *) testWindow
{
  return testWindow;
}

/*-------------------------------------------------------------------------*
 *  Menu action methods
 *-------------------------------------------------------------------------*/
- (void) showInfoPanel: (id)sender
{
}

- (void) newDocument: (id)sender
{
	[[TestWindow new] orderFront: self];
}

// NSMenuValidation protocol
/*- (BOOL) validateMenuItem: (NSMenuItem *)aMenuItem
{
  return YES;
}*/

//Windows
/*- (void) miniaturizeKeyWindow: (id)sender
{
  [[NSApp keyWindow] miniaturize: sender];
}*/

/*- (void) closeKeyWindow
{
  [[NSApp keyWindow] close];
}
*/

@end

