/*
 *  Author:       Serg Stoyan
 *
 *  Class:        TestWindow : NSObject
 *
 *  Description:  
 */

#include <Foundation/NSFileHandle.h>
#include <Foundation/NSNotification.h>

#include <AppKit/NSView.h>
#include <AppKit/NSWindow.h>
#include <AppKit/NSTitleView.h>

#include "AppController.h"
#include "TestWindow.h"

@implementation TestWindow

- init
{
  NSView       *windowContentView;
  NSRect       windowContentRect = NSMakeRect(0, 0, 500, 500);
  unsigned int windowStyleMask;

  windowStyleMask = 
		NSTitledWindowMask 
		| NSResizableWindowMask
		| NSClosableWindowMask;
		| NSMiniaturizableWindowMask;

  // Session Window 
  window = [[NSWindow alloc] initWithContentRect: windowContentRect
                                       styleMask: windowStyleMask
                                         backing: NSBackingStoreRetained
                                           defer: NO];

  [window setTitle: @"NSMenu test program"];
  [window setReleasedWhenClosed: NO];
  [window setDelegate: self];
  [window setMaxSize: NSMakeSize (1e7, 1e7)];
  [window setMinSize: [NSWindow frameRectForContentRect: windowContentRect
                                            styleMask: windowStyleMask].size];
  windowContentView = [window contentView];
  
  // Title hack
  titleView = [NSTitleView new];
  [titleView setOwner: window];
	[titleView setFrame:
		NSMakeRect (-1, [window frame].size.height - [NSTitleView height] - 40,
								[window frame].size.width + 2, [NSTitleView height])];

  [windowContentView addSubview: titleView];

  return self;
}

/*-------------------------------------------------------------------------*
 *  Window delegate methods
 *-------------------------------------------------------------------------*/
- (void) orderFront: (id)sender
{
//  [window makeFirstResponder: usernameTF];
//  [usernameTF lockFocus];

  if (![window setFrameUsingName: @"TestWindow"])
  {
    [window center];
  }
  [window orderFront: nil];
}

- (void) dealloc
{
//  NSLog(@"TestWindow: dealloc");

  RELEASE(window);

  [super dealloc];
}

- (void) windowWillClose: (NSNotification *)notif
{
  NSLog(@"TestWindow: will close");

  [window saveFrameUsingName: @"TestWindow"];

  [self release];
}

- (BOOL) canBecomeKeyWindow
{
  NSLog (@"canBecomeKey");
  return YES;
}

- (BOOL) canBecomeMainWindow
{
  return YES;
}

/*-------------------------------------------------------------------------*
 *  Misc methods
 *-------------------------------------------------------------------------*/

/*-------------------------------------------------------------------------*
 *  Controls' action methods
 *-------------------------------------------------------------------------*/

/*-------------------------------------------------------------------------*
 *  Utility methods
 *-------------------------------------------------------------------------*/

@end

