/*

    GSInputServerImpl.h

    Author: Kazunobu Kuriyama <kazunobu.kuriyama@nifty.com>
    Date:   July, 2003

 */


#ifndef __GSInputServerImpl_h
#define __GSInputServerImpl_h


#include <Foundation/NSObject.h>
#include <AppKit/NSInputServer.h>


// ----------------------------------------------------------------------------
//  GSInputServer
// ----------------------------------------------------------------------------
@interface GSInputServer : NSObject <NSInputServiceProvider,
                                     NSInputServerMouseTracker>
{
}

+ (id) sharedInstance;

- (id) init;

/* --- NSInputServiceProvider Protocol Methods --- */
- (void) activeConversationChanged: (id)sender
                 toNewConversation: (long)newConversation;
- (void) activeConversationWillChange: (id)sender
                  fromOldConversation: (long)oldConversation;
- (BOOL) canBeDisabled;
- (void) doCommandBySelector: (SEL)aSelector
                      client: (id)sender;
- (void) inputClientBecomeActive: (id)sender;
- (void) inputClientDisabled: (id)sender;
- (void) inputClientEnabled: (id)sender;
- (void) inputClientResignActive: (id)sender;
- (void) insertText: (id)aString
             client: (id)sender;
- (void) markedTextAbandoned: (id)sender;
- (void) markedTextSelectionChanged: (NSRange)newSelection
                             client: (id)sender;
- (void) terminate: (id)sender;
- (BOOL) wantsToDelayTextChangeNotifications;
- (BOOL) wantsToHandleMouseEvents;
- (BOOL) wantsToInterpretAllKeystrokes;

/* --- NSInputServerMouseTracker Protocol Methods --- */
- (BOOL) mouseDownOnCharacterIndex: (unsigned)index
                      atCoordinate: (NSPoint)point
                      withModifier: (unsigned int)flags
                            client: (id)sender;
- (BOOL) mouseDraggedOnCharacterIndex: (unsigned)index
                         atCoordinate: (NSPoint)point
                         withModifier: (unsigned int)flags
                               client: (id)sender;
- (void) mouseUpOnCharacterIndex: (unsigned)index
                    atCoordinate: (NSPoint)point
                    withModifier: (unsigned int)flags
                          client: (id)sender;
@end // @interface GSInputServer : NSObject <NSInputServiceProvider,
     //                                      NSInputServerMouseTracker>

#endif // __GSInputServerImpl_h
