#include <stdio.h>
#include <gsl/gsl_errno.h>
#include <gsl/gsl_matrix.h>
#include <gsl/gsl_odeiv.h>

#define NEQS 8
#define kmax 20000
#define VERYSMALLNUM 1E-18
#define FOURPI ((double)12.566370614359172954)
/* FUNCTION: int_de
 * 
 * AUTHOR: Brian Powell
 *
 * RETURNS: int status = 0 for successful integration, != 0 for failure
 *
 * ARGUMENTS: gsl_vector **y: When function is called, this vector contains the
 *                     initial values of the slow-roll parameters. When
 *                     function returns, y contains the values of the
 *                     slow roll parameters Nefolds before the end of
 *                     inflation.
 *            	double N: number of e-folds to start integration from.
 *	 	double Nend: number of e-folds to end integration on.
 *              int *kount: returns total number of integration steps.
 *              int kmax: maximum number of allowed integration steps.
 *           gsl_matrix ** ypp: pointer to matrix that is filled with
 *                             intermediate values of y.
 *           gsl_vector ** xpp: pointer to vector that is filled with
 *                             intermediate values of N.
 *               int NEQS: number of flow equations.
 *           int (derivs): this function stores the derivative array
 *                         dydN.  
 */
int derivs(double , const double *, double *, void * );


//int int_de (gsl_vector *y, double N, double Nend, int *kount, int kmax,
//gsl_matrix *ypp, gsl_vector *xpp, int NEQS, int (*derivs)(double,const
//double *, double *,void *))
int main()
{
//	double h = 1e-2;  //initial step size
	double h = 1e-8;  //initial step size
 	int i,status;
 	int count=0;
 	double ydoub[NEQS];

	/*
	 * Initializing/allocating gsl stepper routines and variable
	 * step-size routines.
	 */
	
//	const gsl_odeiv_step_type * T = gsl_odeiv_step_rkf45;
	const gsl_odeiv_step_type * T = gsl_odeiv_step_rk4;
 	gsl_odeiv_step * s = gsl_odeiv_step_alloc(T,NEQS);
	gsl_odeiv_control *c = gsl_odeiv_control_y_new(1e-6,1e-6);
//gsl_odeiv_control*c=gsl_odeiv_control_standard_new(0.0,0.01,1.0,1.0);
	gsl_odeiv_evolve * e = gsl_odeiv_evolve_alloc(NEQS);
 	gsl_odeiv_system sys = {derivs,(void *)NULL,NEQS,(void *)NULL};

	/*
	 * Change gsl_vector to double * for use in gsl routines.
	 */
FILE * outfile;
outfile = fopen("out.dat","w");
	ydoub[0]=0.0;
	ydoub[1]=1.0;
	ydoub[2]=1.078847e-01 ; 
	ydoub[3]= -2.529963e-01 ;
	ydoub[4]=6.320602e-03;
	ydoub[5]=3.322627e-04;
	ydoub[6]=1.150792e-05 ;
	ydoub[7]=1.965224e-07;
	double N =52.973977;
	double Nend = 0;
/*	for(i=0;i<NEQS;i++)
        {
		ydoub[i]=gsl_vector_get(y,i);
  	}
 
*/
if(N>Nend)
  	{
   		h=-h;  //so that we may integrate in both directions
  	}
 	while(N!=Nend)
 	{
  		status = gsl_odeiv_evolve_apply (e,c,s,&sys,&N,Nend,&h,ydoub);
  		if (status!=GSL_SUCCESS)
   		{
    			break;
   		}
 /*       	for(i=0;i<NEQS;i++) //change double * back to gsl_vector
   		{
    			gsl_vector_set(y,i,ydoub[i]);
		}*/
/*  		for(i=0;i<NEQS;i++) 
   		{
    			gsl_matrix_set(ypp,i,count,gsl_vector_get(y,i));
   		}
  		gsl_vector_set(xpp,count,N); */
		fprintf(outfile,"%le %le %le %le %le %le %le %le %lf\n",ydoub[0],ydoub[1],ydoub[2],ydoub[3],ydoub[4],ydoub[5],ydoub[6],ydoub[7],N);	
		if (++count==kmax)
   		{
    			break;
   		}
 	}
// 	*kount = count;
fclose(outfile); 
 	gsl_odeiv_evolve_free (e);
 	gsl_odeiv_control_free (c);
 	gsl_odeiv_step_free (s);

	return 0;
}

int derivs(double t, const double y[], double dydN[], void * params)
{
 	
	/*
	 * FUNCTION: derivs
	 *
	 * RETURNS: GSL_SUCCESS for successful execution
	 *
	 * ARGUMENTS: double t: independent variable of differential equations
	 * 	      const double y[]: dependent variables of system
	 * 	      double dydN[]: derivatives of dependent variables of system
	 * 	      void * params: parameters appearing in system
	 */
	 
	 int i;
 
 	/*
	 * Check if we are past epsilon = 1 and cut off the evolution at
	 * that point.
	 */

 	if(y[2]>=1.0)
 	{
  		/*
		 * Inflation is over, cut off the evolution.
		 */
		for(i=0;i<NEQS;i++)
  		{
   			dydN[i] = 0.0;
  		}
 	}
 	else
 	{
  		if(y[2] > VERYSMALLNUM)/*Here for numerical issues in
						sqrt()*/
  		{
   			dydN[0]= - sqrt(y[2]/FOURPI); //d phi/ d N
  		}
  		else
  		{
   			dydN[0] = 0.0;
  		}
  		dydN[1] = y[1]*y[2]; // dH / dN
  		dydN[2] = y[2]*(y[3]+2.0*y[2]); // d epsilon / dN
  		dydN[3] = 2.0*y[4]-5.0*y[2]*y[3]-12.0*y[2]*y[2];

 		/*
		 * The highest order flow equations form a system.
		 * Truncate the highest order equation.
		 */
		for(i=4;i<NEQS-1;i++)
 		{
  			dydN[i] = (0.5*(i-3)*y[3]+(i-4)*y[2])*y[i]+y[i+1];
 		}
 		dydN[NEQS-1] = (0.5*(NEQS-4)*y[3]+(NEQS-5)*y[2])*y[NEQS-1];
	
 	}
 	return GSL_SUCCESS;
}





