
/**************************************************************************
 * Desc: GSL randist_preproc test program
 * Author: Andrew Howard
 * Date: 21 Jan 2002
 * Modified: 4 May 2009 by Srecko Juric-Kavelj
 * CVS: $Id$
 *************************************************************************/

#include <assert.h>
#include <stdio.h>
#include <gsl/gsl_rng.h>
#include <gsl/gsl_randist.h>


int main()
{
  int i, x;
  int count;
  double probs[1000];
  double psum = 0.005;
  gsl_rng *rng;
  gsl_ran_discrete_t *ran;
    
  // Initialize the random number generator
  rng = gsl_rng_alloc(gsl_rng_taus);
  gsl_rng_set(rng, 0);
  
  // Initialize the probabilities with uniform values
  count = 279;
  psum = 0;

  for (i = 0; i < count; i++)
    psum += 0.005;

  for (i = 0; i < count; i++)
    probs[i] = psum / count;

  // Initialize the discrete distribution generator
  ran = gsl_ran_discrete_preproc(count, probs);

  // Generate some samples
  for (i = 0; i < 10; i++)
  {
    x = gsl_ran_discrete(rng, ran);
    printf("%d %d\n", i, x);
    assert(0 <= x && x < count);
  }

  gsl_ran_discrete_free(ran);
  gsl_rng_free(rng);

  return 0;
}

