#ifndef __GSL_INTERP_EXT_H__
#define __GSL_INTERP_EXT_H__
#include <gsl/gsl_interp.h>

#undef __BEGIN_DECLS
#undef __END_DECLS
#ifdef __cplusplus
# define __BEGIN_DECLS extern "C" {
# define __END_DECLS }
#else
# define __BEGIN_DECLS /* empty */
# define __END_DECLS /* empty */
#endif

__BEGIN_DECLS

GSL_VAR const gsl_interp_type * gsl_interp_cspline_ext;

int gsl_interp_batch_cspline_ext( gsl_spline *spline, 
        const double x[], const double y[], size_t n_in, 
        double x_out[], double y_out[], size_t n_out, 
        double deriv2_ratio, gsl_interp_accel *acc);

int gsl_interp_grid2d_cspline_ext(gsl_spline *spline[], const double *z, 
        const double x[], size_t nx,
        const double y[], double zwrk[], size_t ny,
        const double x_out[], const double y_out[], double z_out[], size_t n_out, 
        double deriv2_ratio, gsl_interp_accel *accx, gsl_interp_accel *accy);

__END_DECLS

#endif /* __GSL_INTERP_EXT_H__ */
