#include <iostream>
#include <vector>

using namespace std;

vector<void (*)(void)> init_func;

void add_scm_init_func (void (*fun)(void))
{
  init_func.push_back (fun);
}


#include "smobs.hh"

class Family : public Smob<Family>
{
  // private default and copy constructors
  Family ();
  Family (const Family &);
public:
  virtual SCM mark_smob ();
  vector <Family *> kids;
  int count ();
  Family (int totals, int branch);
};

Family::Family (int totals, int branch)
{
  smobify_self ();
  for (int l=0; l<branch; l++)
    {
      if (l >= totals)
	break;
      Family *n = new Family ((totals-l-1)/branch, branch);
      kids.push_back (n);
      n->unprotect ();
    }
}

SCM
Family::mark_smob ()
{
  for (int i = 0; i < kids.size (); i++)
    scm_gc_mark (kids[i]->self_scm ());
  return SCM_EOL;
}

int
Family::count ()
{
  int sum = 1;
  for (int i = 0; i < kids.size (); i++)
    sum += kids[i]->count ();
  return sum;
}

void *workload (void *avv)
{
  char **av = (char**)avv;
  for (int i=0; i<init_func.size (); ++i)
    init_func[i]();
  SCM k = SCM_UNDEFINED;
  int iter = atoi(av[3]);
  int branch = atoi(av[1]);
  int totals = atoi(av[2]);

  for (int i=0; i<iter; i++)
    {
      cout << "Iteration " << i << endl;
      k = (new Family(totals-1, branch))->unprotect ();
    }
  cout << "last has " << Family::unsmob (k)->count () << endl;
  return 0;
}

int
main (int ac, char **av)
{
  if (ac != 4)
    {
      cerr << "Usage: ./test <branchout> <total> <iterations>\n";
      exit (1);
    }
  scm_with_guile (workload, av);
  return 0;
}
