/*
 * resolv - command-line interface to use the libc name resolver
 * Copyright (C) 2010 Tanguy Ortolo <tanguy+resolv@ortolo.eu>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stdio.h>
#include <netdb.h>
#include <arpa/inet.h>

void print_host_info(struct hostent *host)
{
 int i ;
 char *addr ;
 char paddr[INET6_ADDRSTRLEN] ;
 printf("Name: %s\n", host->h_name) ;
 printf("Aliases:") ;
 for (i = 0 ; host->h_aliases[i] != NULL ; i++)
 {
  printf(" %s", host->h_aliases[i]) ;
 }
 printf("\n") ;
 printf("Address type: ") ;
 switch (host->h_addrtype)
 {
  case AF_INET : printf("inet\n") ;
    break ;
  case AF_INET6 : printf("inet6\n") ;
    break ;
 }
 printf("Address length: %d\n", host->h_length) ;
 printf("Addresses:") ;
 for (i = 0 ; host->h_addr_list[i] != NULL ; i++)
 {
  addr = host->h_addr_list[i] ;
  printf(" %s", inet_ntop(host->h_addrtype, addr, paddr, INET6_ADDRSTRLEN)) ;
 }
 printf("\n") ;
}

int main(int argc, char **argv)
{
 if (argc != 2)
 {
  printf("Need a single hostname.\n") ;
  return 1 ;
 }
 struct hostent *host ;
 char host4 = 0, host6 = 0 ;
 if ((host = gethostbyname2(argv[1], AF_INET)))
 {
  host4 = 1 ;
  print_host_info(host) ;
 }
 if ((host = gethostbyname2(argv[1], AF_INET6)))
 {
  host6 = 1;
  if (host4)
  {
   printf("\n") ;
  }
  print_host_info(host) ;
 }
 if (!host4 && !host6)
 {
  printf("Host not found.\n") ;
 }
 return 0 ;
}
