# -*- Mode: Makefile; Modified: "Mon 31 Jan 2000 16:07:01 by dave"; -*- 

### This is a compiler-specific definitions file for GNU compilers.

### It can define the following variables:
### For C++ compilers:
###   cxxdbgflags   specifies the compiler options for debugging
###   cxxoptflags   specifies the compiler options for optimization
###   cxxprofflags  specifies the compiler option to enable profiling
###   cppnewinclude specifies the cpp option to search for "new" C++ include files
###                  in one of the $CHOMBO_HOME/std_include subdirectories, if the
###                  compiler doesn't support the "new" include files directly
###   CPP           specifies the command name to invoke `cpp' for Fortran source
### For Fortran compilers:
###   fdbgflags     specifies the compiler options for debugging
###   foptflags     specifies the compiler options for optimization
###   fprofflags    specifies the compiler option to enable profiling
###   flibflags     specifies C++ linker options needed to link with Fortran code

#
# GNU g++ v2.8 or 2.9*
#
ifeq ($(cxx),g++)
  #NOTE: `template-depth' is needed to keep mangled function names from
  #      getting too long for some linkers to handle.
#  cxxoptflags = -O3 -ftemplate-depth-20
  cxxoptflags = -O -ftemplate-depth-20 
  cxxdbgflags = -g -pedantic -Wall -Wno-sign-compare -ftemplate-depth-20
  ifeq ($(system),OSF1)
    cxxdbgflags += -gstabs
  else
    cxxdbgflags += -ggdb
  endif
  # HDF5 uses `long long', but g++ v2.9+ complains about it.
  #NOTE: this assumes that g++ v2.7x can't compile Chombo.
  _gppversion := $(shell $(CXX) --version)
  ifeq ($(findstring 2.8,$(_gppversion)),)
    cxxdbgflags += -Wno-long-long
    cxxoptflags += -Wno-long-long
  endif
  # g++ handles "new" C++ standard include files so it doesn't need to
  # search the Chombo std_include directory.
  cppnewinclude = 
endif

## This compiler name is used for test versions of g++
## (assume g++ version is at least 2.9*)
ifeq ($(cxx),eg++)
  cxxoptflags = -O -ftemplate-depth-20
  cxxdbgflags = -g -pedantic -Wall -Wno-sign-compare -Wno-long-long
  ifeq ($(system),OSF1)
    cxxdbgflags += -gstabs
  else
    cxxdbgflags += -ggdb
  endif
  # g++ handles "new" std include files so it doesn't need to
  # search the Chombo std_include directory.
  cppnewinclude = 
endif


ifeq ($(fc),g77)
# -malign-double is not recognized by g77 on the indy
# who knows why
#  foptflags = -O3 -malign-double -funroll-loops -fno-second-underscore
#  -O fails for Average, Interp in AMRTools - so we use unoptimized 
#  g77 (PC: 7/24/2000).
  foptflags = -funroll-loops -fno-second-underscore 
  fdbgflags = -g -Wimplicit -Wall -fno-second-underscore
  ifeq ($(system),OSF1)
    fdbgflags += -gstabs
  else
    fdbgflags += -ggdb
  endif
  # Yuck.  This is ugly but necessary for when $(CXX) isn't g++.
  # It extracts the library directories that g77 will use so another compiler
  # can find libg2c.a, which contains the Fortran interfaces to the C library.
  # There is no guarantee this will actually work, since the GCC library may not
  # interoperate with the $(CXX) library.  You may have to add `-lgcc' to 
  # $(flibflags) in `Make.defs.local' or in `Make.defs.<compiler>'
  flibflags = $(shell $(FC) -v  | & egrep '^ *(.*/)*ld ' | tr ' ' '\012' | grep '\-L') -lg2c -lm
endif

## This compiler name is used for test versions of g77
ifeq ($(fc),eg77)
  foptflags = -O -malign-double -funroll-loops -fno-second-underscore
  fdbgflags = -g -Wimplicit -Wall -fno-second-underscore
  ifeq ($(system),OSF1)
    fdbgflags += -gstabs
  else
    fdbgflags += -ggdb
  endif
  # See comments above for $(fc)==g77
  flibflags = $(shell $(FC) -v  | & egrep '^ *(.*/)*ld ' | tr ' ' '\012' | grep '\-L') -lg2c -lm
endif
