#!/usr/local/gnu/bin/perl -w
####  _______              __
#### / ___/ /  ___  __ _  / /  ___
####/ /__/ _ \/ _ \/  ' \/ _ \/ _ \
####\___/_//_/\___/_/_/_/_.__/\___/ 
####
####
#### This software is copyright (C) by the Lawrence Berkeley
#### National Laboratory.  Permission is granted to reproduce
#### this software for non-commercial purposes provided that
#### this notice is left intact.
#### 
#### It is acknowledged that the U.S. Government has rights to
#### this software under Contract DE-AC03-765F00098 between
#### the U.S.  Department of Energy and the University of
#### California.
####
#### This software is provided as a professional and academic
#### contribution for joint exchange. Thus it is experimental,
#### is provided ``as is'', with no warranties of any kind
#### whatsoever, no support, no promise of updates, or printed
#### documentation. By using this software, you acknowledge
#### that the Lawrence Berkeley National Laboratory and
#### Regents of the University of California shall have no
#### liability with respect to the infringement of other
#### copyrights by any part of this software.
####

# -------------------------------------------------------------------------
# this 
# -------------------------------------------------------------------------

package SubroutProc;

use vars qw(@ISA @EXPORT @EXPORT_OK %EXPORT_TAGS $VERSION);
use Exporter;
$VERSION = 1.32;
@ISA = qw(Exporter);
@EXPORT = qw(&procSubrout);
@EXPORT_OK = qw(&procSubrout);
@EXPORT_TAGS= ();

sub SubroutProc::procSubrout
{
    use strict;
### Constants
    my ($FINFile, $COUTFile, $FOUTFile, $SpaceDim, $debug, $basename) = @_;
    $SubroutProc::indentstr = "\n      ";
    $SubroutProc::continstr = "\n     &           ";
    if($debug)
    {
        print "SubroutProc: \n";
        print "input file  = $FINFile \n";
        print "fortran output file = $FOUTFile \n";
        print "c prototype file = $COUTFile \n";
        print "SpaceDim    = $SpaceDim \n";
        print "basename    = $basename \n";
    }


    open(SubroutProc::COUT,">" . $COUTFile) 
        or die "Error: cannot open output file " . $COUTFile . "\n";
    open(SubroutProc::FOUT,">" . $FOUTFile) 
        or die "Error: cannot open output file " . $FOUTFile . "\n";
    open(SubroutProc::FIN, "<" . $FINFile) 
        or die "Error: cannot open input file " . $FINFile . "\n";

### initialize the output files
    &startFFile();
    &startCFile($basename);
    
    
### loop through lines in the input file and stuff them
### into one buffer
    my $callbuf = "" ;   
    my $insubst = 0;
    my $infirstline = 0;
    while (defined( my $linebuf = <FIN> )) 
    {
        ###if we find a subroutine call
        ###go into buffering mode
        if ($linebuf =~ m/^\s*subroutine/i)
        {
            $insubst = 1;
            $infirstline = 1;
            if($debug)
            {
                print "subroutProc::first line = $linebuf\n";
            }
        }
        ###if we are in buffering mode,
        ###add  the line to the buffer
        if($insubst)
        {
            ####this strips out beginning spaces and 
            ####continuation characters
            ### only do this on non-first lines
            my $nosixbuf = "";
            if($infirstline)
            {
                $nosixbuf = $linebuf;
                $infirstline = 0;
            }
            else
            {
                $nosixbuf = substr($linebuf, 6);
            }
            $callbuf .= $nosixbuf;
            ###check to see if this is the last
            ###line of the buffer
            if($linebuf =~ /\)/)
            {
                my $stripbuf = $callbuf;
                ### strip out carraige returns 
                $stripbuf =~ s/\n//sg;
                ### strip out the word "subroutine" and white space
                $stripbuf =~ s/subroutine//i;
                $stripbuf =~ s/\s//g;
                
                if($debug)
                {
                    print "subroutProc::whole buffer = $callbuf\n";
                    my $striplen = length($stripbuf);
                    print "subroutProc::length stripped buffer = $striplen \n";
                    print "subroutProc::stripped buffer = $stripbuf\n";
                }
                &procSubStatement($stripbuf,  $debug);
                ###reset in subrout flag to false
                ###and calling buffer to null
                $insubst = 0;
                $callbuf = "";
                
            }
        }
        else 
        {
            ### not inside subroutine declaration
            ###just print it back out
            print SubroutProc::FOUT $linebuf;
        }
    }
    &finishCFile() ;

    ###close files.
    close(SubroutProc::COUT);
    close(SubroutProc::FIN);
    close(SubroutProc::FOUT);
    return 1;
    
    
# -------------------------------------------------------------------
# -------------------------------------------------------------------
    sub SubroutProc::procSubStatement
    {
        my ($fullstring,  $debug) = @_;
        ###coming into this routine the string is everthing 
        ###between subroutine and ")" possibly including ")"
        ###without any continuation characters or white space
        ###first get the name of the subroutine name 
        ###which is the string before "(" 
        my $tempbuf = $fullstring;
        $tempbuf =~ m/\(/ig;
        my $offset = pos $tempbuf   or 
            die "no beginning \( in sub string $fullstring\n";
        my $length = $offset;
        my $subname = substr($fullstring, 0, $length);
        my $argstring = substr($fullstring, $offset);
        ###remove the now unnessesary parentheses
        $subname =~ s/\(//ig;
        $subname =~ s/\)//ig;
        $argstring =~ s/\(//ig;
        $argstring =~ s/\)//ig;
        if($debug)
        {
            print "procSubStatement:fullstring = $fullstring\n";
            print "procSubStatement:offset = $offset\n";
            print "procSubStatement:subname = $subname\n";
            print "procSubStatement:argstring = $argstring\n";
        }
        &SubroutProc::doFortranProc($subname, $argstring, $debug);
        &SubroutProc::doCPrototype($subname, $argstring, $debug);
    }


# -------------------------------------------------------------------
# -------------------------------------------------------------------

sub SubroutProc::doFortranProc 
{
    my ($subname, $argstring, $debug) = @_;
###    print "in subroutProc\n";
###subname is the name of the subroutine
###argstring is the string of arguments
### without carraige returns, continuation characters
###or whitespace or parentheses
###the number of indentations shall be eight
###and eight shall be the number of indents
    my $indentstr = $SubroutProc::indentstr;
    my $continstr = $SubroutProc::continstr;
    my $subnamecap = uc($subname);
    my @subargs = split(",",$argstring);
    my $arguments = "";
    my $declarations = "";
###create argument list and declaration stuff
    for(my $iarg = 0; $iarg <= $#subargs; $iarg++)
    {
        my $singarg = $subargs[$iarg];
        my $singname = &SubroutProc::getNamedThing($singarg);
        if($debug)
        {
            print "doFortranProc: singarg = $singarg\n";
            print "doFortranProc: singname= $singname\n";
        }
        ###the first argument of any declaration will
        ###only have a comma if it is not the first argument
        ###overall
        my $comma = "";
        if($iarg > 0)
        {
            $comma = ",";
        }
        if($singarg =~ /CHF\_INT/ig)
        {
            $arguments .= $continstr.$comma.$singname;
            $declarations .= $indentstr."integer $singname";
        }
        elsif($singarg =~ /CHF\_CONST\_INT/ig)
        {
            $arguments .= $continstr.$comma.$singname;
            $declarations .= $indentstr."integer $singname";
        }
        elsif($singarg =~ /CHF\_REAL/ig)
        {
            $arguments .= $continstr.$comma.$singname;
            $declarations .= $indentstr."REAL_T $singname";
        }
        elsif($singarg =~ /CHF\_CONST\_REAL/ig)
        {
            $arguments .= $continstr.$comma.$singname;
            $declarations .= $indentstr."REAL_T $singname";
        }
        elsif($singarg =~ /CHF\_BOX/ig)
        {
            ### box declaration has all the neccessary carraige returns 
            ### and continuation characters.
            my $boxdec = &SubroutProc::getBoxDecl($singname);
            my $boxarg = &SubroutProc::getBoxArgs($singname);
            $declarations .= $boxdec;
            $arguments    .= $continstr.$comma.$boxarg;
        }
        elsif($singarg =~ /CHF\_CONST\_FIA1/ig)
        {
            ###single component integer fab.  
            ### box declaration has all the neccessary carraige returns 
            ### and continuation characters.
            ### the fab ints is just the ddecl part of the declaration
            ### because we need to do both real and integer fabs and
            ### both single and multiple-component fabs
            my $boxdec = &SubroutProc::getBoxDecl($singname);
            my $fabint = &SubroutProc::getFabIntArgs($singname);
            my $boxarg = &SubroutProc::getBoxArgs($singname);
            
            ###arguments are the name
            ###and the boxints
            ###no ncomp argumetn or declaration (1 var)
            $arguments    .= $continstr.$comma.$singname;
            $arguments    .= $continstr.",".$boxarg;
            ###declare the boxints and the fab
            $declarations .= $boxdec;
            $declarations .= $indentstr."integer $singname\(";
            $declarations .= $continstr.$fabint."\)";
        }
        elsif($singarg =~ /CHF\_FIA1/ig)
        {
            ###single component integer fab.  
            ### box declaration has all the neccessary carraige returns 
            ### and continuation characters.
            ### the fab ints is just the ddecl part of the declaration
            ### because we need to do both real and integer fabs and
            ### both single and multiple-component fabs

            my $boxdec = &SubroutProc::getBoxDecl($singname);
            my $fabint = &SubroutProc::getFabIntArgs($singname);
            my $boxarg = &SubroutProc::getBoxArgs($singname);
            ###arguments are the name
            ###and the boxints
            ###no ncomp argumetn or declaration (1 var)
            $arguments    .= $continstr.$comma.$singname;
            $arguments    .= $continstr.",".$boxarg;
            ###declare the boxints and the fab
            $declarations .= $boxdec;
            $declarations .= $indentstr."integer $singname\(";
            $declarations .= $continstr.$fabint."\)";
        }
        elsif($singarg =~ /CHF\_CONST\_FRA1/ig)
        {
            ###single component real fab.  
            ### box declaration has all the neccessary carraige returns 
            ### and continuation characters.
            ### the fab ints is just the ddecl part of the declaration
            ### because we need to do both real and integer fabs and
            ### both single and multiple-component fabs

            my $boxdec = &SubroutProc::getBoxDecl($singname);
            my $fabint = &SubroutProc::getFabIntArgs($singname);
            my $boxarg = &SubroutProc::getBoxArgs($singname);
            ###arguments are the name
            ###and the boxints
            ###no ncomp argumetn or declaration (1 var)
            $arguments    .= $continstr.$comma.$singname;
            $arguments    .= $continstr.",".$boxarg;
            ###declare the boxints and the fab
            $declarations .= $boxdec;
            $declarations .= $indentstr."REAL_T $singname\(";
            $declarations .= $continstr.$fabint."\)";
        }
        elsif($singarg =~ /CHF\_FRA1/ig)
        {
            ###single component real fab.  
            ### box declaration has all the neccessary carraige returns 
            ### and continuation characters.
            ### the fab ints is just the ddecl part of the declaration
            ### because we need to do both real and integer fabs and
            ### both single and multiple-component fabs

            my $boxdec = &SubroutProc::getBoxDecl($singname);
            my $fabint = &SubroutProc::getFabIntArgs($singname);
            my $boxarg = &SubroutProc::getBoxArgs($singname);
            ###arguments are the name
            ###and the boxints
            ###no ncomp argumetn or declaration (1 var)
            $arguments    .= $continstr.$comma.$singname;
            $arguments    .= $continstr.",".$boxarg;
            ###declare the boxints and the fab
            $declarations .= $boxdec;
            $declarations .= $indentstr."REAL_T $singname\(";
            $declarations .= $continstr.$fabint."\)";
        }
        elsif($singarg =~ /CHF\_CONST\_FRA/ig)
        {
            ###multiple component real fab.  
            ### box declaration has all the neccessary carraige returns 
            ### and continuation characters.
            ### the fab ints is just the ddecl part of the declaration
            ### because we need to do both real and integer fabs and
            ### both single and multiple-component fabs
            my $boxdec = &SubroutProc::getBoxDecl($singname);
            my $fabint = &SubroutProc::getFabIntArgs($singname);
            my $boxarg = &SubroutProc::getBoxArgs($singname);
            my $compnm = "n".$singname."comp";

            ###arguments are the name
            ###and the boxints
            ###the the ncomp thing
            $arguments    .= $continstr.$comma.$singname;
            $arguments    .= $continstr.",".$boxarg;
            $arguments    .= $continstr.",".$compnm;
            ###declare the boxints and the fab
            $declarations .= $indentstr."integer $compnm";
            $declarations .= $boxdec;
            $declarations .= $indentstr."REAL_T $singname\(";
            $declarations .= $continstr.$fabint.",";
            $declarations .= $continstr."0:$compnm-1\)";
        }
        elsif($singarg =~ /CHF\_FRA/ig)
        {
            ###multiple component real fab.  
            ### box declaration has all the neccessary carraige returns 
            ### and continuation characters.
            ### the fab ints is just the ddecl part of the declaration
            ### because we need to do both real and integer fabs and
            ### both single and multiple-component fabs
            my $boxdec = &SubroutProc::getBoxDecl($singname);
            my $fabint = &SubroutProc::getFabIntArgs($singname);
            my $boxarg = &SubroutProc::getBoxArgs($singname);
            my $compnm = "n".$singname."comp";

            ###arguments are the name
            ###and the boxints
            ###the the ncomp thing
            $arguments    .= $continstr.$comma.$singname;
            $arguments    .= $continstr.",".$boxarg;
            $arguments    .= $continstr.",".$compnm;
            ###declare the boxints and the fab
            $declarations .= $indentstr."integer $compnm";
            $declarations .= $boxdec;
            $declarations .= $indentstr."REAL_T $singname\(";
            $declarations .= $continstr.$fabint.",";
            $declarations .= $continstr."0:$compnm-1\)";
        }
        elsif($singarg =~ /CHF\_CONST\_FIA/ig)
        {
            ###multiple component integer fab.  
            ### box declaration has all the neccessary carraige returns 
            ### and continuation characters.
            ### the fab ints is just the ddecl part of the declaration
            ### because we need to do both real and integer fabs and
            ### both single and multiple-component fabs
            my $boxdec = &SubroutProc::getBoxDecl($singname);
            my $fabint = &SubroutProc::getFabIntArgs($singname);
            my $boxarg = &SubroutProc::getBoxArgs($singname);
            my $compnm = "n".$singname."comp";

            ###arguments are the name
            ###and the boxints
            ###the the ncomp thing
            $arguments    .= $continstr.$comma.$singname;
            $arguments    .= $continstr.",".$boxarg;
            $arguments    .= $continstr.",".$compnm;
            ###declare the boxints and the fab
            $declarations .= $indentstr."integer $compnm";
            $declarations .= $boxdec;
            $declarations .= $indentstr."integer $singname\(";
            $declarations .= $continstr.$fabint.",";
            $declarations .= $continstr."0:$compnm-1\)";
        }
        elsif($singarg =~ /CHF\_FIA/ig)
        {
            ###multiple component integer fab.  
            ### box declaration has all the neccessary carraige returns 
            ### and continuation characters.
            ### the fab ints is just the ddecl part of the declaration
            ### because we need to do both real and integer fabs and
            ### both single and multiple-component fabs
            my $compnm = "n".$singname."comp";
            my $boxdec = &SubroutProc::getBoxDecl($singname);
            my $fabint = &SubroutProc::getFabIntArgs($singname);
            my $boxarg = &SubroutProc::getBoxArgs($singname);
            ###arguments are the name
            ###and the boxints
            ###the the ncomp thing
            $arguments    .= $continstr.$comma.$singname;
            $arguments    .= $continstr.",".$boxarg;
            $arguments    .= $continstr.",".$compnm;
            ###declare the boxints and the fab
            $declarations .= $indentstr."integer $compnm";
            $declarations .= $boxdec;
            $declarations .= $indentstr."integer $singname\(";
            $declarations .= $continstr.$fabint.",";
            $declarations .= $continstr."0:$compnm-1\)";
        }
        else
        {
            die 
            "doFortranProc::unable to process argument $singarg\n";
        }
    }
    
###start printing all this crap out        
    print  SubroutProc::FOUT  $indentstr."subroutine $subnamecap(" ;
    print  SubroutProc::FOUT  $arguments;
    
    print SubroutProc::FOUT   $continstr.")\n" ;
###print preliminary stuff that is in every procedure.
###recall indentstr includes a carraige return
    print SubroutProc::FOUT $indentstr."implicit none";
    print SubroutProc::FOUT $indentstr."integer CHF_ID(0:2,0:2)" ;
    print SubroutProc::FOUT $indentstr."data CHF_ID/ 1,0,0 ,0,1,0 ,0,0,1 /\n";
    print SubroutProc::FOUT "\n" ;
###print declarations
    print  SubroutProc::FOUT  $declarations;
}
#--------------------------------------------------------------
###get name out of  string of the form blah[name]
#--------------------------------------------------------------
sub SubroutProc::getNamedThing
{
    my ($argstring) = @_;
###find where there is a [
    my $teststring = $argstring;
    ###mulitple-argument things should not be sent here.
    if($teststring =~ /;/)
    {
        die "getNamedThing got something with a ;.\n";
    }
    
    $argstring =~ /\[/ig or 
        die "no \[ in argument to getNamedThing\n";
    my $beginoffset = pos $argstring;
    my $restring = substr($argstring, $beginoffset);
    $restring =~ s/\[//g;
    $restring =~ s/\]//g;
    return $restring;
    
}
#--------------------------------------------------------------
#--------------------------------------------------------------
sub SubroutProc::getBoxDecl
{
    my ($singname) = @_;
    my $indentstr = $SubroutProc::indentstr;
    my $continstr = $SubroutProc::continstr;
    my $declarations = "";
    my $loarg = "CHF\_DDECL\[";
    my $hiarg = "CHF\_DDECL\[";
    my $semicolon = "";
    for(my $idir =0; $idir < 3; $idir++)
    {
        if($idir > 0)
        {
            $semicolon = ";";
        }
        $loarg .= $semicolon."i".$singname."lo".$idir;
        $hiarg .= $semicolon."i".$singname."hi".$idir;
    }
    $loarg .= "\]";
    $hiarg .= "\]";
    $declarations .= $indentstr."integer $loarg";
    $declarations .= $indentstr."integer $hiarg";
    return $declarations;
}
#--------------------------------------------------------------
#--------------------------------------------------------------
sub SubroutProc::getFabIntArgs
{
    my ($singname) = @_;
    my $indentstr = $SubroutProc::indentstr;
    my $continstr = $SubroutProc::continstr;
    my $intargs = "CHF\_DDECL\[";
    my $semicolon = "";
    my $colon = ":";
    for(my $idir =0; $idir < 3; $idir++)
    {
        if($idir > 0)
        {
            $semicolon = ";$continstr";
        }
        $intargs .= $semicolon."i".$singname."lo".$idir;
        $intargs .= $colon."i".$singname."hi".$idir;
    }
    $intargs .= "\]";
    return $intargs;
}
#--------------------------------------------------------------
#--------------------------------------------------------------
sub SubroutProc::getBoxArgs
{
    my ($singname,$comma) = @_;
    my $indentstr = $SubroutProc::indentstr;
    my $continstr = $SubroutProc::continstr;
    my $arguments = "";
    my $loarg = "CHF\_DDECL\[";
    my $hiarg = "CHF\_DDECL\[";
    my $semicolon = "";
    for(my $idir =0; $idir < 3; $idir++)
    {
        if($idir > 0)
        {
            $semicolon = ";";
        }
        $loarg .= $semicolon."i".$singname."lo".$idir;
        $hiarg .= $semicolon."i".$singname."hi".$idir;
    }
    $loarg .= "\]";
    $hiarg .= "\]";
    $arguments .= $loarg."$continstr,".$hiarg;
}
#--------------------------------------------------------------
#--------------------------------------------------------------
sub SubroutProc::doCPrototype 
{ 
    my ($subname, $argstring,  $debug) = @_;
    my $subnamecap = uc($subname);
    my $subnamelc = lc($subname);
    my @subargs = split(",",$argstring);
    my $arguments = "";
    my $indentstr = $SubroutProc::indentstr;
###create argument list and declaration stuff
    for(my $iarg = 0; $iarg <= $#subargs; $iarg++)
    {
        my $singarg = $subargs[$iarg];
        my $singname = &SubroutProc::getNamedThing($singarg);
        if($debug)
        {
            print "doCProtoType: singarg = $singarg\n";
            print "doCProtoType: singname= $singname\n";
        }
        my $comma = "";
        if($iarg > 0)
        {
            $comma = ",";
        }
        if($singarg =~ /CHF\_INT/ig)
        {
            $arguments .= $indentstr.$comma."CHFp\_INT\($singname\)";
        }
        elsif($singarg =~ /CHF\_CONST\_INT/ig)
        {
            $arguments .= $indentstr.$comma."CHFp\_CONST\_INT\($singname\)";
        }
        elsif($singarg =~ /CHF\_REAL/ig)
        {
            $arguments .= $indentstr.$comma."CHFp\_REAL\($singname\)";
        }
        elsif($singarg =~ /CHF\_CONST\_REAL/ig)
        {
            $arguments .= $indentstr.$comma."CHFp\_CONST\_REAL\($singname\)";
        }
        elsif($singarg =~ /CHF\_BOX/ig)
        {
            $arguments .= $indentstr.$comma."CHFp\_BOX\($singname\)";
        }
        elsif($singarg =~ /CHF\_CONST\_FIA1/ig)
        {
            $arguments .= $indentstr.$comma."CHFp\_CONST\_FIA1\($singname\)";
        }
        elsif($singarg =~ /CHF\_FIA1/ig)
        {
            $arguments .= $indentstr.$comma."CHFp\_FIA1\($singname\)";
        }
        elsif($singarg =~ /CHF\_CONST\_FRA1/ig)
        {
            $arguments .= $indentstr.$comma."CHFp\_CONST\_FRA1\($singname\)";
        }
        elsif($singarg =~ /CHF\_FRA1/ig)
        {
            $arguments .= $indentstr.$comma."CHFp\_FRA1\($singname\)";
        }
        elsif($singarg =~ /CHF\_CONST\_FRA/ig)
        {
            $arguments .= $indentstr.$comma."CHFp\_CONST\_FRA\($singname\)";
        }
        elsif($singarg =~ /CHF\_FRA/ig)
        {
            $arguments .= $indentstr.$comma."CHFp\_FRA\($singname\)";
        }
        elsif($singarg =~ /CHF\_CONST\_FIA/ig)
        {
            $arguments .= $indentstr.$comma."CHFp\_CONST\_FIA\($singname\)";
        }
        elsif($singarg =~ /CHF\_FIA/ig)
        {
            $arguments .= $indentstr.$comma."CHFp\_FIA\($singname\)";
        }
        else
        {
            die 
            "doCPrototype::unable to process argument $singarg\n";
        }
    }
    ####preliminary stuff
    print SubroutProc::COUT "\n" ;
    print SubroutProc::COUT "// Prototype for Fortran procedure $subname ...\n//\n" ;
    print SubroutProc::COUT "#define FORT_$subnamecap FORTRAN_NAME( $subnamecap ,$subnamelc )\n" ;
    print SubroutProc::COUT "void \nFORT_$subnamecap(" ;
    print SubroutProc::COUT $arguments;
    print SubroutProc::COUT " \);\n" ;
}
# -------------------------------------------------------------------
# Subroutine: startFFile
# -------------------------------------------------------------------

sub SubroutProc::startFFile 
{
    print SubroutProc::FOUT "#include \"REAL.H\"\n" ;
    print SubroutProc::FOUT "#include \"SPACE.H\"\n" ;
    print SubroutProc::FOUT "#include \"CONSTANTS.H\"\n" ;
    print SubroutProc::FOUT "\n" ;
}

# -------------------------------------------------------------------
# Subroutine: startCFile
# -------------------------------------------------------------------

sub startCFile 
{
    my ($basename) = @_;
    ##print "startcfile basename = $basename \n";
    print SubroutProc::COUT "#ifndef \_".$basename."\_F\_H\_\n" ;
    print SubroutProc::COUT "#define \_".$basename."\_F\_H\_\n" ;
    print SubroutProc::COUT "\n" ;
    print SubroutProc::COUT "#include \"FORT_PROTO.H\"\n" ;
    print SubroutProc::COUT "#include \"REAL.H\"\n" ;
    print SubroutProc::COUT "\n" ;
    print SubroutProc::COUT "extern \"C\"\n" ;
    print SubroutProc::COUT "{\n" ;    
}


# -------------------------------------------------------------------
# Subroutine: finishCFile
# -------------------------------------------------------------------

sub SubroutProc::finishCFile 
{
    print SubroutProc::COUT "\n}\n" ;
    print SubroutProc::COUT "#endif\n" ;
}




}
###i have no idea why this is here.
###the perl cookbook book told me to put it there.
###really.
1;
