#!/usr/local/gnu/bin/perl -w

####  _______              __
#### / ___/ /  ___  __ _  / /  ___
####/ /__/ _ \/ _ \/  ' \/ _ \/ _ \
####\___/_//_/\___/_/_/_/_.__/\___/ 
####
####
#### This software is copyright (C) by the Lawrence Berkeley
#### National Laboratory.  Permission is granted to reproduce
#### this software for non-commercial purposes provided that
#### this notice is left intact.
#### 
#### It is acknowledged that the U.S. Government has rights to
#### this software under Contract DE-AC03-765F00098 between
#### the U.S.  Department of Energy and the University of
#### California.
####
#### This software is provided as a professional and academic
#### contribution for joint exchange. Thus it is experimental,
#### is provided ``as is'', with no warranties of any kind
#### whatsoever, no support, no promise of updates, or printed
#### documentation. By using this software, you acknowledge
#### that the Lawrence Berkeley National Laboratory and
#### Regents of the University of California shall have no
#### liability with respect to the infringement of other
#### copyrights by any part of this software.
####
####
#########################################
#### This is an augmented version of ChomboFortran.
#### It also removes the thrice-accursed D_TERM
####  DTGraves July 2000
#########################################
package ChF;
use strict;
BEGIN
{
##global variables god help us all
##all have the package name ChF    
    $ChF::CHFPP_Version = "1.23" ;
    $ChF::FComment = "C";
    $ChF::debug  = 0; 
    $ChF::FINFile   = "";
    $ChF::FOUTFile = "";
    $ChF::COUTFile = "";
    $ChF::baseName = "";
    $ChF::basePath = "";
    $ChF::SpaceDim = -1;
    $ChF::T1File = "chfpp03079.tmp";
    $ChF::T2File = "chfpp94720.tmp";
    
    
###parse the command line
###and generate appropriate file names
    &ChF::parseInputs();
    
####    #install atexit-style handler so that when we exit or die,
####    #we automatically delete this temporary file
    
    END{unlink($ChF::T1File) 
            or die "cannot unlink $ChF::T1File \n";}
    END{unlink($ChF::T2File) 
            or die "cannot unlink $ChF::T1File \n";}

    ###need two temp files because final output can be /dev/null
###Strip comments because they are evil
    require "stripcompp.pm";
    DTERMProc->import();
    unless(my $flag = &StripComProc::StripComments($ChF::FINFile, $ChF::T2File,
                                                   $ChF::SpaceDim, $ChF::debug))
    {
        die "problem in commentstripper\n";
    }
    
###parse all the chombo chacha and put fortran
###into T1File and C header into COUT
###this also substitutes CHF_DDECL for CHF_IX
    use File::Basename ;
# extract leading directory and file basename.  Throw away the trailing suffix.
    ($ChF::basename,$ChF::basepath) = fileparse( $ChF::FINFile ,'\..*' ) ;
    
    require "subrout.pm";
    SubroutProc->import();
    unless(my $flag = 
           &SubroutProc::procSubrout($ChF::T2File, $ChF::COUTFile, $ChF::T1File, 
                                     $ChF::SpaceDim, $ChF::debug, $ChF::basename))
    {
        die "problem in chombofortran\n";
    }
    
###process multido statements
    require "multidopp.pm";
    MultiDoProc->import();
    unless(my $flag = &MultiDoProc::procMultiDoMacros($ChF::T1File, $ChF::T2File, 
                                                      $ChF::SpaceDim, $ChF::debug))
    {
        die "problem in multido processor\n";
    }
    
###process LBOUND macros.   
    require "lboundpp.pm";
    LBoundProc->import();
    unless(my $flag = &LBoundProc::procLBoundMacros($ChF::T2File, $ChF::T1File, 
                                                    $ChF::SpaceDim, $ChF::debug))
    {
        die "problem in lbound processor\n";
    }
    
###process UBOUND macros.   
    require "uboundpp.pm";
    UboundProc->import();
    unless(my $flag = &UboundProc::procUboundMacros($ChF::T1File, $ChF::T2File, 
                                                    $ChF::SpaceDim, $ChF::debug))
    {
        die "problem in ubound processor\n";
    }
    
###process NCOMP macros.   
    require "ncomppp.pm";
    NcompProc->import();
    unless(my $flag = &NcompProc::procNcompMacros($ChF::T2File, $ChF::T1File, 
                                                  $ChF::SpaceDim, $ChF::debug))
    {
        die "problem in ncomp processor\n";
    }

###process CHF_IX macros.  
    require "chfixpp.pm";
    ChfixProc->import();
    unless(my $flag = &ChfixProc::procChfixMacros($ChF::T1File, $ChF::T2File, 
                                                  $ChF::SpaceDim, $ChF::debug))
    {
        die "problem in chfixprocessor\n";
    }
    
    
###process DTERM macros.   
    require "dtermpp.pm";
    DTERMProc->import();
    unless(my $flag = &DTermProc::procDTermMacros($ChF::T2File, $ChF::T1File, 
                                                  $ChF::SpaceDim, $ChF::debug))
    {
        die "problem in dterm processor\n";
    }
    
    
###process DDECL macros.  
    require "ddeclpp.pm";
    DDeclProc->import();
    unless(my $flag = &DDeclProc::procDDeclMacros($ChF::T1File, $ChF::FOUTFile, 
                                                  $ChF::SpaceDim, $ChF::debug))
    {
        die "problem in ddeclprocessor\n";
    }
    
    
    
###blow town
    exit 0 ;
    
    
    
#########################################
# Subroutine: parseInputs
# Inputs: none
# Returns: none
# list goes like this:
# -f <inputfilename>  (optional) -p < fort output filename> -c <coutfilename>
# -D <SpaceDim>  
# if the fortran file output name is not specified it goes to baseName.F
# if the c header  output name is not specified it goes to baseName_F.H
# Globals (all outputs): 
# FINFile input file name
# FOUTFile fortran file name for output
# COUTFile c header file name for output
# baseName base name of input file
# basePath
#########################################
# -------------------------------------------------------------------
    sub ChF::parseInputs
    {
        use File::Basename;
        package ChF::parseInputs;
        my $l_FINFile = "";
        my $l_FOUTFile= "";
        my $l_COUTFile= "";
        my $l_baseName= ""; 
        my $l_basePath = "";
        my $l_debug = 0;
        my $l_SpaceDim = -1;
        use Getopt::Std;
        
#if -d then debugging is enabled
        my %l_option;
        
      Getopt::Std::getopts("dc:f:p:D:" , \%l_option);
        if($l_option{d})
        {
            $l_debug = 1;
        }
        if ($l_option{f}) 
        {
            $l_FINFile = $l_option{f};
        } 
        else
        {
            die "no input file specified\n";
        }
        
        if ($l_option{D}) 
        {
            $l_SpaceDim = $l_option{D};
            if($l_SpaceDim > 3)
            {
                die "bogus spacedim specified= ".$l_SpaceDim.
                    "maxSpaceDim=".$ChF::MAXDIM;
            }
            if(($l_SpaceDim < 1))
                
            {
                die "negative spacedim specified= ".$l_SpaceDim;
            }
        
        } 
        else
        {
            die "no SpaceDim specified (-D option)\n";
        }
        
        use File::Basename;
        ($l_baseName,$l_basePath) = fileparse( $l_FINFile ,'\..*' ) ;
        if ($l_option{c}) 
        {
            $l_COUTFile = $l_option{c};
        } 
        else
        {
            $l_COUTFile = $l_baseName . "_F.H" ;
        }
        if ($l_option{p}) 
        {
            $l_FOUTFile = $l_option{p};
        } 
        else
        {
            $l_FOUTFile = $l_baseName . ".F" ;
        }
        if($l_debug)
        {
            print "starting chombo fortran preprocessing ";
            print "with debug enabled\n";
            print "input file  = $l_FINFile\n";
            print "baseName= $l_baseName \n";
            print "basePath= $l_basePath \n";
            print "outputting fortran source to $l_FOUTFile \n";
            print "outputting header for c++ to $l_COUTFile \n";
        }
        $ChF::debug = $l_debug;
        $ChF::FINFile = $l_FINFile;
        $ChF::FOUTFile = $l_FOUTFile;
        $ChF::COUTFile = $l_COUTFile;
        $ChF::baseName = $l_baseName;
        $ChF::basePath = $l_basePath;
        $ChF::SpaceDim = $l_SpaceDim;
    }
}
