#ifndef _ARRAYVIEW_DATA_H_
#define _ARRAYVIEW_DATA_H_

//
// ArrayViewData.H
//
// ArrayViewData is a wrapper around LayoutData<BaseFab<Real>> for use
// in ArrayView.  It provides random access and the ability to
// directly set the data.  If you use it outside ArrayView, and it
// doesn't work, your whining complaints will be ignored.
//

#include "LayoutData.H"
#include "BaseFab.H"
#include "REAL.H"
#include "FArrayBox.H"

class ArrayViewData
{
public:
  ArrayViewData() : m_layoutdata_ptr(NULL) {};
  ~ArrayViewData() {};
  ArrayViewData(LayoutData<BaseFab<Real> >* a_layoutdata_ptr)
    :
    m_layoutdata_ptr(a_layoutdata_ptr)
    {};

  ArrayViewData(LayoutData<FArrayBox>* a_layoutdata_ptr)
    :
    m_layoutdata_ptr((LayoutData<BaseFab<Real> >*) a_layoutdata_ptr)
    {};

  BaseFab<Real>& 
  operator[](int a_elem)
    {
      return *(m_layoutdata_ptr->m_vector[a_elem]);
    }

  void
  set(int a_elem, BaseFab<Real>* a_fab_ptr)
    {
      m_layoutdata_ptr->m_vector[a_elem] = a_fab_ptr;
    }

private:
  LayoutData<BaseFab<Real> >* m_layoutdata_ptr;
};

#endif
