#include <string.h>
#include "BitSet.H"
#include <cstdlib>
#include <malloc.h>
#include "MayDay.H"


BitSet BitSetIterator::emptyBitSet = BitSet();

WORD BitSet::trueMasks[WORD_SIZE];

int BitSet::initialize()
{
  trueMasks[WORD_SIZE-1] = 1;
  for(int i=WORD_SIZE-2; i>=0 ; --i)
    {
      trueMasks[i] = trueMasks[i+1] << 1;
    }
  return 0;
}

BitSet::BitSet()
  :
  m_bits(NULL),
  m_size(0),
  m_length(0)
{}

BitSet::BitSet(int bits, bool init)
  :
  m_bits(NULL),
  m_size(bits),
  m_length(0)
{
  static int initialized = initialize();
  assert(bits >= 0);
  if(bits==0) return;

  m_length = bits/WORD_SIZE;
  if(m_length*WORD_SIZE != bits) m_length +=1;
  
  m_bits = (WORD*)malloc(m_length*sizeof(WORD));
  if(m_bits == NULL)
    {
	  MayDay::Error("Memory Error in BitSet::BitSet(int bits, bool init)");
    }
  if(init)
    {
      memset(m_bits, ~0, m_length*sizeof(WORD));
    }
  else
    {
      memset(m_bits, 0, m_length*sizeof(WORD));
    }
}

void BitSet::define(int bits, bool init)
{
  if(m_bits != NULL) free(m_bits);
  m_size = bits;
  assert(bits >= 0);
  m_length = bits/WORD_SIZE;
  if(bits == 0) { m_bits = NULL; return;}
  if(m_length*WORD_SIZE != bits) m_length +=1;
  m_bits = (WORD*)malloc(m_length*sizeof(WORD));
  if(m_bits == NULL)
    {
	  MayDay::Error("Memory Error in BitSet::BitSet(int bits, bool init)");
    }
  if(init)
    {
      memset(m_bits, ~0, m_length*sizeof(WORD));
    }
  else
    {
      memset(m_bits, 0, m_length*sizeof(WORD));
    }
}

BitSet::BitSet(const BitSet& rhs)
  :
  m_bits(NULL),
  m_size(rhs.m_size),
  m_length(rhs.m_length)
{
  if(m_length == 0) return;
  m_bits = (WORD*)malloc(m_length*sizeof(WORD));
  if(m_bits == NULL)
    {
      MayDay::Error("Memory Error in BitSet::BitSet(const BitSet& rhs)");
    }

  memcpy(m_bits, rhs.m_bits, m_length*sizeof(WORD));
}

bool BitSet::isEmpty() const
{
  if(m_length == 0) return true;
  for(int i=0; i<m_length-1; ++i)
	{
	  if(m_bits[i] > 0) return false;
	}
  for(int i=(m_length-1)*WORD_SIZE; i<m_size; ++i)
	{
	  if (this->operator[](i)) return false;
	}
  return true;
}

bool BitSet::isFull() const
{
  WORD g=0;
  g=~g;
  for(int i=0; i<m_length-1; ++i)
	{
	  if(m_bits[i] != g) return false;
	}
  for(int i=m_length*WORD_SIZE; i<m_size; ++i)
	{
	  if (!this->operator[](i)) return false;
	}
  return true;
}

BitSet& BitSet::operator=(const BitSet& rhs)
{
  m_length=rhs.m_length;
  m_size =rhs.m_size;
  if(m_bits != NULL) free(m_bits);
  if(rhs.m_bits != NULL)
    m_bits = (WORD*)malloc(m_length*sizeof(WORD));
  else
    {
      m_bits = NULL;
      return *this;
    }
  if(m_bits == NULL)
    {
      MayDay::Error("Memory Error in BitSet::operator=(const BitSet& rhs)");
    }

  memcpy(m_bits, rhs.m_bits, m_length*sizeof(WORD));
  return *this;
}

BitSet::~BitSet()
{
  if(m_bits != NULL) free(m_bits);
}

void BitSet::setFalse(int i)
{
  // WORD* tm = trueMasks;
  assert(i>=0);
  assert(i<m_size);
  int index = i/WORD_SIZE;
  assert(index < m_length);
  int remainder = i-WORD_SIZE*index;
  WORD* word = m_bits+index;

  *word = *word & ~(trueMasks[remainder]);
}

void BitSet::setTrue(int i)
{
  assert(i>=0);
  assert(i<m_size);
  int index = i/WORD_SIZE;
  assert(index < m_length);
  int remainder = i-WORD_SIZE*index;
  WORD* word = m_bits+index;

  *word = *word | trueMasks[remainder];
}


void BitSetIterator::end()
{
  m_index = m_length;
  m_remainder = m_partialBits;
}
void BitSetIterator::begin()
{
  m_index = 0;
  m_remainder = 0;
}
