#include "BoxLayoutData.H"

#ifdef MPI
#include <mpi.h>
#endif

Real norm(const BoxLayoutData<FArrayBox>& a_layout, 
	  const Interval& interval,
	  const int& p)
{
  const BoxLayout validRegion = a_layout.boxLayout();
  DataIterator it = validRegion.dataIterator();
  Real norm = 0;
  if(p == 0)  // max norm
    {
      for(;it.ok(); ++it)
	{
	norm = Max(norm, a_layout[it()].norm(validRegion[it()],
					     0,
					     interval.begin(),
					     interval.size()));
	}
#     ifdef MPI
      Real recv;
      int result = MPI_Allreduce(&norm, &recv, 1, MPI_CH_REAL,
				 MPI_MAX, Chombo_MPI::comm);
      if(result != MPI_SUCCESS){ //bark!!!
	MayDay::Error("sorry, but I had a communcation error on norm");
      }
      norm = recv;
#     endif
    }
  else if(p == 1) // abs sum norm
    {
      for(;it.ok(); ++it)
	{
	norm += a_layout[it()].norm(validRegion[it()],
				    1,
				    interval.begin(),
				    interval.size());
	}
#     ifdef MPI
      Real recv;
      int result = MPI_Allreduce(&norm, &recv, 1, MPI_CH_REAL,
				 MPI_SUM, Chombo_MPI::comm);
      if(result != MPI_SUCCESS){ //bark!!!
	MayDay::Error("sorry, but I had a communcation error on norm");
      }
      norm = recv;
#     endif
    }
  else
    {
      for(;it.ok(); ++it)
	{
	  norm+=a_layout[it()].sumPow(validRegion[it()],
				      p,
				      interval.begin(),
				      interval.size());
	}
#     ifdef MPI
      Real recv;
      int result = MPI_Allreduce(&norm, &recv, 1, MPI_CH_REAL,
				 MPI_SUM, Chombo_MPI::comm);
      if(result != MPI_SUCCESS){ //bark!!!
	MayDay::Error("sorry, but I had a communcation error on norm");
      }
      norm = recv;
#     endif
      Real invpwr = 1.0/p;
      norm = pow(norm, invpwr);
    }
  
  return norm;
}

template <>
BaseFab<int>* DataFactory<BaseFab<int> >::create(const Box& box, int ncomps) const
{
  return new BaseFab<int>(box, ncomps);
}

template <>
FArrayBox* DataFactory<FArrayBox>::create(const Box& box, int ncomps) const
{
  return new FArrayBox(box, ncomps);
}
