#ifndef CH_CONSTANTS_H
#define CH_CONSTANTS_H

#ifdef CH_LANG_CC
/* _______              __
  / ___/ /  ___  __ _  / /  ___
 / /__/ _ \/ _ \/  ' \/ _ \/ _ \
 \___/_//_/\___/_/_/_/_.__/\___/ 
*/
// CONSTANTS.H
//
// This software is copyright (C) by the Lawrence Berkeley
// National Laboratory.  Permission is granted to reproduce
// this software for non-commercial purposes provided that
// this notice is left intact.
// 
// It is acknowledged that the U.S. Government has rights to
// this software under Contract DE-AC03-765F00098 between
// the U.S.  Department of Energy and the University of
// California.
//
// This software is provided as a professional and academic
// contribution for joint exchange. Thus it is experimental,
// is provided ``as is'', with no warranties of any kind
// whatsoever, no support, no promise of updates, or printed
// documentation. By using this software, you acknowledge
// that the Lawrence Berkeley National Laboratory and
// Regents of the University of California shall have no
// liability with respect to the infringement of other
// copyrights by any part of this software.
//
/* CH_COPYRIGHT_NOTICE */

/*
** $Id: CONSTANTS.H,v 1.3 2000/11/09 19:45:14 graves Exp $
*/
#endif

#if defined(CH_LANG_FORT) || defined(CH_CRAY)

/* use single-precision constants on the T3E regardless of whether
 * USE_FLOAT or USE_DOUBLE is defined
*/
#if defined(CH_USE_FLOAT)

#define bigreal 1.0e+30
#define zero    0.0e0
#define one     1.0e0
#define two     2.0e0
#define three   3.0e0
#define four    4.0e0
#define five    5.0e0
#define six     6.0e0
#define seven   7.0e0
#define eight   8.0e0
#define nine    9.0e0
#define ten     10.0e0
#define twelve  12.0e0
#define fifteen 15.0e0
#define sixteen 16.0e0
#define twenty  20.0e0
#define tenth   1.0e0 / 10.0e0
#define eighth  1.0e0 / 8.0e0
#define sixth   1.0e0 / 6.0e0
#define forth   1.0e0 / 4.0e0
#define fourth  1.0e0 / 4.0e0
#define third   1.0e0 / 3.0e0
#define half    1.0e0 / 2.0e0
#define two3rd  2.0e0 / 3.0e0
#define Pi      3.14159265358979

#elif defined(CH_USE_DOUBLE)

#define bigreal 1.0d+30
#define zero    0.0d0
#define one     1.0d0
#define two     2.0d0
#define three   3.0d0
#define four    4.0d0
#define five    5.0d0
#define six     6.0d0
#define seven   7.0d0
#define eight   8.0d0
#define nine    9.0d0
#define ten     10.0d0
#define twelve  12.0d0
#define fifteen 15.0d0
#define sixteen 16.0d0
#define twenty  20.0d0
#define tenth   1.0d0 / 10.0d0
#define eighth  1.0d0 / 8.0d0
#define sixth   1.0d0 / 6.0d0
#define forth   1.0d0 / 4.0d0
#define fourth  1.0d0 / 4.0d0
#define third   1.0d0 / 3.0d0
#define half    1.0d0 / 2.0d0
#define two3rd  2.0d0 / 3.0d0
#define Pi      3.14159265358979d0

#else

#error One of CH_USE_{FLOAT,DOUBLE} must be defined

#endif

#endif /*CH_LANG_FORT*/

#endif /*CH_CONSTANTS_H*/
