/* _______              __
  / ___/ /  ___  __ _  / /  ___
 / /__/ _ \/ _ \/  ' \/ _ \/ _ \
 \___/_//_/\___/_/_/_/_.__/\___/ 
*/
// DataIndex.H
//
// This software is copyright (C) by the Lawrence Berkeley
// National Laboratory.  Permission is granted to reproduce
// this software for non-commercial purposes provided that
// this notice is left intact.
// 
// It is acknowledged that the U.S. Government has rights to
// this software under Contract DE-AC03-765F00098 between
// the U.S.  Department of Energy and the University of
// California.
//
// This software is provided as a professional and academic
// contribution for joint exchange. Thus it is experimental,
// is provided ``as is'', with no warranties of any kind
// whatsoever, no support, no promise of updates, or printed
// documentation. By using this software, you acknowledge
// that the Lawrence Berkeley National Laboratory and
// Regents of the University of California shall have no
// liability with respect to the infringement of other
// copyrights by any part of this software.
//
#ifndef DATAINDEX_H
#define DATAINDEX_H

class BoxLayout;

#include <cstdlib>

class DataIterator;
class LayoutIterator;

///An index for LayoutIterator
class LayoutIndex
{
public:

  ///
  inline LayoutIndex();
  
  // default copy and assign shoule be fine.

  ///
  inline bool operator == (const LayoutIndex& rhs) const;
  
  ///
  bool operator != (const LayoutIndex& rhs) const
  { return !(*this == rhs);}

  /// returns 'true' if this DataIndex has been null constructed.
  bool isNull() const;

  // not user function. breaks design encapsulation. method not
  // intended for users. The alternative is to make this class a friend
  // of BoxLayoutData<T>, which implicitly makes this class templated, which
  // makes no bloody sense.  The behaviour of this method is undefined for
  // users.  bvs
  int intCode() const;

private:
  friend class DataIterator;
  friend class LayoutIterator;
  friend class BoxLayout;
  friend class DataIndex;

  int m_index;
  const int* m_layoutIntPtr;
  LayoutIndex(int a_index, const int* layoutID)
    : m_index(a_index), m_layoutIntPtr(layoutID){}
};


class DataIndex : public LayoutIndex
{
public:
  explicit DataIndex(const LayoutIndex& promotion)
    :LayoutIndex(promotion){}
  DataIndex()
    : LayoutIndex(){}

private:
  friend class LayoutIterator;
  friend class DataIterator;
  friend class BoxLayout;
  friend class Copier;
  DataIndex(int a_index, const int* layoutID)
    :LayoutIndex(a_index, layoutID) {}
};


inline LayoutIndex::LayoutIndex()
  : m_index(0), m_layoutIntPtr(NULL){}

inline bool LayoutIndex::operator==(const LayoutIndex& rhs) const
{
  return (m_index == rhs.m_index);
}

inline int LayoutIndex::intCode() const
{
  return m_index;
}

inline bool LayoutIndex::isNull() const
{
  return m_layoutIntPtr == NULL;
}


#endif // DATAITERATOR_H
