/* _______              __
  / ___/ /  ___  __ _  / /  ___
 / /__/ _ \/ _ \/  ' \/ _ \/ _ \
 \___/_//_/\___/_/_/_/_.__/\___/ 
*/

//
// This software is copyright (C) by the Lawrence Berkeley
// National Laboratory.  Permission is granted to reproduce
// this software for non-commercial purposes provided that
// this notice is left intact.
// 
// It is acknowledged that the U.S. Government has rights to
// this software under Contract DE-AC03-765F00098 between
// the U.S.  Department of Energy and the University of
// California.
//
// This software is provided as a professional and academic
// contribution for joint exchange. Thus it is experimental,
// is provided ``as is'', with no warranties of any kind
// whatsoever, no support, no promise of updates, or printed
// documentation. By using this software, you acknowledge
// that the Lawrence Berkeley National Laboratory and
// Regents of the University of California shall have no
// liability with respect to the infringement of other
// copyrights by any part of this software.
//

#ifndef _DebugOut_H_
#define _DebugOut_H_

#include "DisjointBoxLayout.H"
#include "BoxLayout.H"
#include "Vector.H"
#include "Box.H"
#include "IntVectSet.H"
#include "FArrayBox.H"
#include "LevelData.H"
#include "LayoutIterator.H"
#include "BoxIterator.H"

extern "C"
{
  void
  dumpLDF(const LevelData<FArrayBox>*  memLDF);

  void dumpDBL(const DisjointBoxLayout* a_dblInPtr);

  void dumpBL(const BoxLayout* a_dblInPtr);

  void dumpIVS(const IntVectSet* a_ivsInPtr);

  void dumpBox(const Box* a_boxPtr);

  void dumpVBox(const Vector<Box>* a_vectPtr);

  void dumpVVBox(const Vector<Vector<Box> >* a_vectPtr);
}

#endif
