/* _______              __
  / ___/ /  ___  __ _  / /  ___
 / /__/ _ \/ _ \/  ' \/ _ \/ _ \
 \___/_//_/\___/_/_/_/_.__/\___/ 
*/

//
// This software is copyright (C) by the Lawrence Berkeley
// National Laboratory.  Permission is granted to reproduce
// this software for non-commercial purposes provided that
// this notice is left intact.
// 
// It is acknowledged that the U.S. Government has rights to
// this software under Contract DE-AC03-765F00098 between
// the U.S.  Department of Energy and the University of
// California.
//
// This software is provided as a professional and academic
// contribution for joint exchange. Thus it is experimental,
// is provided ``as is'', with no warranties of any kind
// whatsoever, no support, no promise of updates, or printed
// documentation. By using this software, you acknowledge
// that the Lawrence Berkeley National Laboratory and
// Regents of the University of California shall have no
// liability with respect to the infringement of other
// copyrights by any part of this software.
//
#include "DebugOut.H"
#include "LayoutIterator.H"

static const char *indent2 = "      " ;

void
dumpLDF(const LevelData<FArrayBox>*  memLDF_Ptr)
{   
  const LevelData<FArrayBox>& memLDF = *memLDF_Ptr;
  Vector<Box> boxes;
  const DisjointBoxLayout& memDBL =memLDF.getBoxes();
  LayoutIterator lit  = memDBL.layoutIterator();
  for(lit.reset(); lit.ok(); ++lit)
    boxes.push_back(memDBL.get(lit()));

  Vector<int> assign(boxes.size(), 0);
  DisjointBoxLayout locDBL(boxes, assign);
  locDBL.close();
  LevelData<FArrayBox> locLDF(locDBL, 
                              memLDF.nComp(), 
                              memLDF.ghostVect());
  const Interval& interv = memLDF.interval();
  memLDF.copyTo(interv,
                locLDF,
                interv);

  DataIterator dit = locLDF.dataIterator();
  for(dit.reset(); dit.ok(); ++dit)
    {
      const FArrayBox& fab = locLDF[dit()];
      BoxIterator bit(fab.box());
      for(bit.reset(); bit.ok(); ++bit)
        {
          cout << "\t" << bit() << "\t" << fab(bit(),0) << endl;;
        }
    }
}
void dumpDBL(const DisjointBoxLayout* a_dblInPtr)
{
   cout << indent2 <<"DisjointBoxLayout ";
  if(a_dblInPtr->isClosed()) cout<<"closed\n";
  else                       cout<<"open\n";
  cout << *a_dblInPtr<<endl; ;

}
void dumpBL(const BoxLayout* a_dblInPtr)
{
   cout << indent2 <<"BoxLayout ";
  if(a_dblInPtr->isClosed()) cout<<"closed\n";
  else                       cout<<"open\n";
  cout << *a_dblInPtr<<endl; ;

}
void dumpIVS(const IntVectSet* a_ivsInPtr)
{
  const IntVectSet& a_ivsIn = *a_ivsInPtr;
  IVSIterator it(a_ivsIn);
  cout << indent2 
       << ": IntVects in the IVS are:" << endl ;
  cout << indent2 ;
  for(it.begin(); it.ok(); ++it)
    {
      cout << it() << "  ";
    }
  cout << endl;
}

void dumpBox(const Box* a_boxPtr)
{
  cout << indent2 << *a_boxPtr << endl;
}

void dumpVBox(const Vector<Box>* a_vectPtr)
{
  Vector<Box> vect = *a_vectPtr;
  for(int ivec = 0; ivec < vect.size(); ivec++)
    cout << indent2 << vect[ivec] << endl;
}

void dumpVVBox(const Vector<Vector<Box> >* a_vectPtr)
{
  Vector<Vector<Box> > vect = *a_vectPtr;
  for(int iveco = 0; iveco < vect.size(); iveco++)
    {
      cout << indent2;
      for(int iveci = 0; iveci < vect[iveco].size(); iveci++)
        cout <<  vect[iveco][iveci] << "   ";
      cout << endl;
    }
}
