/* _______              __
  / ___/ /  ___  __ _  / /  ___
 / /__/ _ \/ _ \/  ' \/ _ \/ _ \
 \___/_//_/\___/_/_/_/_.__/\___/ 
*/
// FORT_PROTO.H
//
// This software is copyright (C) by the Lawrence Berkeley
// National Laboratory.  Permission is granted to reproduce
// this software for non-commercial purposes provided that
// this notice is left intact.
// 
// It is acknowledged that the U.S. Government has rights to
// this software under Contract DE-AC03-765F00098 between
// the U.S.  Department of Energy and the University of
// California.
//
// This software is provided as a professional and academic
// contribution for joint exchange. Thus it is experimental,
// is provided ``as is'', with no warranties of any kind
// whatsoever, no support, no promise of updates, or printed
// documentation. By using this software, you acknowledge
// that the Lawrence Berkeley National Laboratory and
// Regents of the University of California shall have no
// liability with respect to the infringement of other
// copyrights by any part of this software.
//

#ifndef _FORT_PROTO_H_
#define _FORT_PROTO_H_

#include "REAL.H"
#include "SPACE.H"

#ifdef CH_FORT_UPPERCASE
  #ifdef CH_FORT_UNDERSCORE
     #define FORTRAN_NAME( NAME ,name ) NAME ## _
  #else
     #define FORTRAN_NAME( NAME ,name ) NAME
  #endif
#else
  #ifdef CH_FORT_UNDERSCORE
     #define FORTRAN_NAME( NAME ,name ) name ## _
  #else
     #define FORTRAN_NAME( NAME ,name ) name
  #endif
#endif


// ChomboFortran declaration macros for Application code

// primitive data types

#define CHF_INT( i ) &i
#define CHF_REAL( r ) &r
#define CHF_CONST_INT( i ) &i
#define CHF_CONST_REAL( r ) &r

// Chombo data types

#define CHF_BOX( b ) D_DECL( &b.loVect()[0] \
                            ,&b.loVect()[1] \
                            ,&b.loVect()[2] ) \
                    ,D_DECL( &b.hiVect()[0] \
                            ,&b.hiVect()[1] \
                            ,&b.hiVect()[2] ) 

#define CHF_FIA( a ) a.dataPtr( 0 ) \
                     ,D_DECL( &a.loVect()[0] \
                             ,&a.loVect()[1] \
                             ,&a.loVect()[2] ) \
                     ,D_DECL( &a.hiVect()[0] \
                             ,&a.hiVect()[1] \
                             ,&a.hiVect()[2] ) \
                     ,a.nCompPtr()

#define CHF_FRA( a ) a.dataPtr( 0 ) \
                     ,D_DECL( &a.loVect()[0] \
                             ,&a.loVect()[1] \
                             ,&a.loVect()[2] ) \
                     ,D_DECL( &a.hiVect()[0] \
                             ,&a.hiVect()[1] \
                             ,&a.hiVect()[2] ) \
                     ,a.nCompPtr()

#define CHF_CONST_FIA( a ) a.dataPtr( 0 ) \
                     ,D_DECL( &a.loVect()[0] \
                             ,&a.loVect()[1] \
                             ,&a.loVect()[2] ) \
                     ,D_DECL( &a.hiVect()[0] \
                             ,&a.hiVect()[1] \
                             ,&a.hiVect()[2] ) \
                     ,a.nCompPtr()

#define CHF_CONST_FRA( a ) a.dataPtr( 0 ) \
                     ,D_DECL( &a.loVect()[0] \
                             ,&a.loVect()[1] \
                             ,&a.loVect()[2] ) \
                     ,D_DECL( &a.hiVect()[0] \
                             ,&a.hiVect()[1] \
                             ,&a.hiVect()[2] ) \
                     ,a.nCompPtr()

#define CHF_FIA1( a,n ) a.dataPtr( n ) \
                     ,D_DECL( &a.loVect()[0] \
                             ,&a.loVect()[1] \
                             ,&a.loVect()[2] ) \
                     ,D_DECL( &a.hiVect()[0] \
                             ,&a.hiVect()[1] \
                             ,&a.hiVect()[2] )

#define CHF_FRA1( a,n ) a.dataPtr( n ) \
                     ,D_DECL( &a.loVect()[0] \
                             ,&a.loVect()[1] \
                             ,&a.loVect()[2] ) \
                     ,D_DECL( &a.hiVect()[0] \
                             ,&a.hiVect()[1] \
                             ,&a.hiVect()[2] )

#define CHF_CONST_FIA1( a,n ) a.dataPtr( n ) \
                     ,D_DECL( &a.loVect()[0] \
                             ,&a.loVect()[1] \
                             ,&a.loVect()[2] ) \
                     ,D_DECL( &a.hiVect()[0] \
                             ,&a.hiVect()[1] \
                             ,&a.hiVect()[2] )

#define CHF_CONST_FRA1( a,n ) a.dataPtr( n ) \
                     ,D_DECL( &a.loVect()[0] \
                             ,&a.loVect()[1] \
                             ,&a.loVect()[2] ) \
                     ,D_DECL( &a.hiVect()[0] \
                             ,&a.hiVect()[1] \
                             ,&a.hiVect()[2] )


// Macros used in automatically-generated Chombo Fortran prototypes

#define CHFp_INT( i ) int* const i
#define CHFp_CONST_INT( i ) const int* const i
#define CHFp_REAL( r ) Real* const r
#define CHFp_CONST_REAL( r ) const Real* const r

#define CHFp_BOX( b ) D_DECL( const int* const i ## b ## lo0 \
                             ,const int* const i ## b ## lo1 \
                             ,const int* const i ## b ## lo2 ) \
                     ,D_DECL( const int* const i ## b ## hi0 \
                             ,const int* const i ## b ## hi1 \
                             ,const int* const i ## b ## hi2 ) 

#define CHFp_FIA( a ) int *const a \
                     ,D_DECL( const int* const i ## a ## lo0 \
                             ,const int* const i ## a ## lo1 \
                             ,const int* const i ## a ## lo2 ) \
                     ,D_DECL( const int* const i ## a ## hi0 \
                             ,const int* const i ## a ## hi1 \
                             ,const int* const i ## a ## hi2 ) \
                             ,const int* const n ## a ## comp
#define CHFp_FRA( a ) Real *const a \
                     ,D_DECL( const int* const i ## a ## lo0 \
                             ,const int* const i ## a ## lo1 \
                             ,const int* const i ## a ## lo2 ) \
                     ,D_DECL( const int* const i ## a ## hi0 \
                             ,const int* const i ## a ## hi1 \
                             ,const int* const i ## a ## hi2 ) \
                             ,const int* const n ## a ## comp
#define CHFp_CONST_FIA( a ) const int *const a \
                     ,D_DECL( const int* const i ## a ## lo0 \
                             ,const int* const i ## a ## lo1 \
                             ,const int* const i ## a ## lo2 ) \
                     ,D_DECL( const int* const i ## a ## hi0 \
                             ,const int* const i ## a ## hi1 \
                             ,const int* const i ## a ## hi2 ) \
                             ,const int* const n ## a ## comp
#define CHFp_CONST_FRA( a ) const Real *const a \
                     ,D_DECL( const int* const i ## a ## lo0 \
                             ,const int* const i ## a ## lo1 \
                             ,const int* const i ## a ## lo2 ) \
                     ,D_DECL( const int* const i ## a ## hi0 \
                             ,const int* const i ## a ## hi1 \
                             ,const int* const i ## a ## hi2 ) \
                             ,const int* const n ## a ## comp
#define CHFp_FIA1( a ) int *const a \
                     ,D_DECL( const int* const i ## a ## lo0 \
                             ,const int* const i ## a ## lo1 \
                             ,const int* const i ## a ## lo2 ) \
                     ,D_DECL( const int* const i ## a ## hi0 \
                             ,const int* const i ## a ## hi1 \
                             ,const int* const i ## a ## hi2 )
#define CHFp_FRA1( a ) Real *const a \
                     ,D_DECL( const int* const i ## a ## lo0 \
                             ,const int* const i ## a ## lo1 \
                             ,const int* const i ## a ## lo2 ) \
                     ,D_DECL( const int* const i ## a ## hi0 \
                             ,const int* const i ## a ## hi1 \
                             ,const int* const i ## a ## hi2 )
#define CHFp_CONST_FIA1( a ) const int *const a \
                     ,D_DECL( const int* const i ## a ## lo0 \
                             ,const int* const i ## a ## lo1 \
                             ,const int* const i ## a ## lo2 ) \
                     ,D_DECL( const int* const i ## a ## hi0 \
                             ,const int* const i ## a ## hi1 \
                             ,const int* const i ## a ## hi2 )
#define CHFp_CONST_FRA1( a ) const Real *const a \
                     ,D_DECL( const int* const i ## a ## lo0 \
                             ,const int* const i ## a ## lo1 \
                             ,const int* const i ## a ## lo2 ) \
                     ,D_DECL( const int* const i ## a ## hi0 \
                             ,const int* const i ## a ## hi1 \
                             ,const int* const i ## a ## hi2 )

#endif
