/*
** This software is copyright (C) by the Lawrence Berkeley National
** Laboratory.  Permission is granted to reproduce this software for
** non-commercial purposes provided that this notice is left intact.
**  
** It is acknowledged that the U.S. Government has rights to this
** software under Contract DE-AC03-765F00098 between the U.S.  Department
** of Energy and the University of California.
**  
** This software is provided as a professional and academic contribution
** for joint exchange. Thus it is experimental, is provided ``as is'',
** with no warranties of any kind whatsoever, no support, no promise of
** updates, or printed documentation. By using this software, you
** acknowledge that the Lawrence Berkeley National Laboratory and Regents
** of the University of California shall have no liability with respect
** to the infringement of other copyrights by any part of this software.
**  
*/


#include <cassert>
#include "MayDay.H"
#include "Misc.H"
#include "IntVect.H"
using std::ostream;
using std::istream;
using std::ws;


const size_t  IntVect::IntVectSize = SpaceDim*sizeof(int);
const IntVect IntVect::Unit(D_DECL(1,1,1));
const IntVect IntVect::Zero(D_DECL(0,0,0));

//
// Returns IntVect which is the componentwise integer projection
// of IntVect p1 by IntVect p2.
//

ostream&
operator<< (ostream&       os,
            const IntVect& p)
{
    os << D_TERM( '(' << p[0] , <<
                  ',' << p[1] , <<
                  ',' << p[2])  << ')';
    if (os.fail())
        MayDay::Error("operator<<(ostream&,IntVect&) failed");
    return os;
}

//
// Copied from <Utility.H>
//
#define CH_IGNORE_MAX 100000

istream&
operator>> (istream& is,
            IntVect& p)
{
    is >> ws;
    char c;
    is >> c;
    is.putback(c);
    if (c == '(')
    {
        D_EXPR(is.ignore(CH_IGNORE_MAX, '(') >> p[0],
               is.ignore(CH_IGNORE_MAX, ',') >> p[1],
               is.ignore(CH_IGNORE_MAX, ',') >> p[2]);
        is.ignore(CH_IGNORE_MAX, ')');
    }
    else if (c == '<')
    {
        D_EXPR(is.ignore(CH_IGNORE_MAX, '<') >> p[0],
               is.ignore(CH_IGNORE_MAX, ',') >> p[1],
               is.ignore(CH_IGNORE_MAX, ',') >> p[2]);
        is.ignore(CH_IGNORE_MAX, '>');
    }
    else
        MayDay::Error("operator>>(istream&,IntVect&): expected \'(\' or \'<\'");

    if (is.fail())
        MayDay::Error("operator>>(istream&,IntVect&) failed");

    return is;
}

void
IntVect::printOn (ostream& os) const
{
    os << "IntVect: " << *this << '\n';
}

void
IntVect::dumpOn (ostream& os) const
{
    os << "IntVect(" << MayDay::version << ")= " << *this << '\n';
}
