// -*- Mode: C++; c-file-style: "gnu"; Modified: "Thu 20 Jan 2000 14:04:09 by dave"; -*- 
// file: IntVectSet_old.H

/* 
     _______              __
    / ___/ /  ___  __ _  / /  ___
   / /__/ _ \/ _ \/  ' \/ _ \/ _ \
   \___/_//_/\___/_/_/_/_.__/\___/ 
*/

//
// This software is copyright (C) by the Lawrence Berkeley
// National Laboratory.  Permission is granted to reproduce
// this software for non-commercial purposes provided that
// this notice is left intact.
// 
// It is acknowledged that the U.S. Government has rights to
// this software under Contract DE-AC03-765F00098 between
// the U.S.  Department of Energy and the University of
// California.
//
// This software is provided as a professional and academic
// contribution for joint exchange. Thus it is experimental,
// is provided ``as is'', with no warranties of any kind
// whatsoever, no support, no promise of updates, or printed
// documentation. By using this software, you acknowledge
// that the Lawrence Berkeley National Laboratory and
// Regents of the University of California shall have no
// liability with respect to the infringement of other
// copyrights by any part of this software.
//
// DTGraves

#ifndef _INTVECTSET_H_
#define _INTVECTSET_H_
#include <iostream>
#include "Tree.H"
#include "Box.H"
#include "IntVect.H"

/// An irregular domain on an integer lattice
/**
   IntVectSet_old represents an irregular region in an integer lattice
   SpaceDim-dimensional index space as an arbitrary collection of
   IntVects.  A full set calculus is defined.  Any IntVect or
   cell-centered Box can be fully represented as an IntVectSet_old.  There
   is an iterator that provides access to the contents of an
   IntVectSet_old.  IntVectSet_olds are implicitly cell-centered.
   Intersection, union, and complement operations are defined for
   pairs of IntVectSet_olds (and, by extension, an IntVectSet_old and an
   IntVect or an IntVectSet_old and a Box).  The minimum Box of an
   IntVectSet_old is defined as the smallest Box that contains every
   IntVect in the IntVectSet_old.

   The IntVects in an IntVectSet_old do not have a canonical ordering.
*/
class IntVectSet_old
{
public:
  friend
  class IVSIterator_old;
  /// {\bf Constructors, Destructor, and defines}

  /// 
  /** default constructor: 
      defines an empty IntVectSet_old. */
  IntVectSet_old();
  void
  define();

  /// 
  /** copy constructor:
      defines this to be a copy of ige_in. */
  IntVectSet_old(const IntVectSet_old& ige_in);
  void
  define(const IntVectSet_old& ige_in);

  /// 
  /** IntVect constructor:
      defines this to be an IntVectSet_old with just one IntVect. */
  explicit
  IntVectSet_old(const IntVect& iv_in);
  void
  define(const IntVect& iv_in);

  /// 
  /** Box constructor:
      defines this to be an IntVectSet_old with all the cells in a Box. */
  explicit
  IntVectSet_old(const Box& b);
  void
  define(const Box& b);


  /// 
  /** destructor. */
  ~IntVectSet_old();


  /// 
  /** assignment operator:
      copies ivs_in to this. */
  IntVectSet_old&
  operator=(const IntVectSet_old& ivs_in);



  /// {\bf union operators}

  ///
  /** 
      Returns the union of two IntVectSet_olds. \\
      {\bf Arguments:} \\
      ivs1, ivs2 (not modified): \\
      {\bf Returns:} \\
      The union of the two IntVectSet_olds ivs1 and ivs2.\\
  */
  friend
  IntVectSet_old 
  operator|(const IntVectSet_old& ivs1, const IntVectSet_old& ivs2);

  ///
  /** 
      Returns the union of an IntVectSet_old and an IntVect. \\
      {\bf Arguments:} \\
      ivs (not modified) \\
      iv (not modified): \\
      {\bf Returns:} \\
      The union of the IntVectSet_old ivs and the IntVect iv.\\
  */
  friend
  IntVectSet_old 
  operator|(const IntVectSet_old& ivs, const IntVect& iv);

  ///
  /** 
      Returns the union of an IntVectSet_old and an IntVect. \\
      {\bf Arguments:} \\
      ivs (not modified) \\
      iv (not modified): \\
      {\bf Returns:} \\
      The union of the IntVectSet_old ivs and the IntVect iv.\\
  */
  friend
  IntVectSet_old 
  operator|(const IntVect& iv, const IntVectSet_old& ivs);

  ///
  /** 
      Returns the union of an IntVectSet_old and a Box. \\
      {\bf Arguments:} \\
      ivs (not midified): \\
      b (not modified): \\
      {\bf Returns:} \\
      The union of the IntVectSet_old ivs and the Box b.\\
  */
  friend
  IntVectSet_old 
  operator|(const IntVectSet_old& ivs, const Box& b);

  ///
  /** 
      Returns the union of an IntVectSet_old and a Box. \\
      {\bf Arguments:} \\
      ivs (not midified): \\
      b (not modified): \\
      {\bf Returns:} \\
      The union of the IntVectSet_old ivs and the Box b.\\
  */
  friend
  IntVectSet_old 
  operator|(const Box& b, const IntVectSet_old& ivs);


  ///
  /** 
      Sets this IntVectSet_old to its union with another IntVectSet_old. \\
      {\bf Arguments:} \\
      ivs (not modified): \\
      {\bf Returns:} \\
      The union of the two IntVectSet_olds.\\
      {\bf This:} \\
      ---The object is modified---
  */
  IntVectSet_old&
  operator|=(const IntVectSet_old& ivs);


  ///
  /** 
      Sets this IntVectSet_old to its union with an IntVect. \\
      {\bf Arguments:} \\
      iv (not modified): \\
      {\bf Returns:} \\
      The union of this IntVectSet_old and the IntVect.\\
      {\bf This:} \\
      ---The object is modified---
  */
  IntVectSet_old&
  operator|=(const IntVect& iv);


  ///
  /** 
      Sets this IntVectSet_old to its union with a Box. \\
      {\bf Arguments:} \\
      box (not modified): \\
      {\bf Returns:} \\
      The union of this IntVect and the Box.\\
      {\bf This:} \\
      ---The object is modified---
  */
  IntVectSet_old&
  operator|=(const Box& b);



  /// {\bf complement operators}

  /// 
  /** 
      Return the complement of the argument IntVectSet_old within this IntVectSet_old.
   */
  IntVectSet_old
  operator-(const IntVectSet_old& ivs) const;

  /// 
  /** 
      Return the complement of the argument Box within this IntVectSet_old.
   */
  IntVectSet_old
  operator-(const Box& b) const;

  /// 
  IntVectSet_old 
  /** 
      Return the complement of the argument IntVect within this IntVectSet_old.
   */
  operator-(const IntVect& iv) const;

  /// 
  /**
     Modifies this IntVectSet_old to be the complement of the argument
     IntVectSet_old within this IntVectSet_old.  \\
      {\bf This:} \\
      ---This object is modified.---
  */
  IntVectSet_old&
  operator-=(const IntVectSet_old& ivs);

  /// 
  /**
     Modifies this IntVectSet_old to be the complement of the argument
     Box within this IntVectSet_old.  \\
      {\bf This:} \\
      ---This object is modified.---
  */
  IntVectSet_old&
  operator-=(const Box& b);

  /// 
  /**
     Modifies this IntVectSet_old to be the complement of the argument
     IntVect within this IntVectSet_old.\\
      {\bf This:} \\
      ---This object is modified.---  
  */
  IntVectSet_old&
  operator-=(const IntVect& iv);


  /// {\bf Intersection operators}

  /// 
  /** 
      Returns the intersection of two IntVectSet_olds.   The result may be empty.\\
      {\bf Arguments:} \\
      ivs1, ivs2 (not modified): \\
      {\bf Returns:} \\
      The intersection of the two IntVectSet_olds ivs1 and ivs2.\\
  */
  friend 
  IntVectSet_old
  operator&(const IntVectSet_old& ivs1, const IntVectSet_old& ivs2);

  /// 
  /** 
      Returns the intersection of an IntVectSet_old and an IntVect.  The
      result will either be empty or have one cell. \\ 
      {\bf Arguments:} \\ 
      ivs (not modified): \\ 
      iv (not modified)\\
      {\bf Returns:} \\ 
      The intersection of the IntVectSet_old and the IntVect.\\ 
  */
  friend
  IntVectSet_old 
  operator&(const IntVectSet_old& ivs, const IntVect& iv);

  /// 
  /** 
      Returns the intersection of an IntVectSet_old and an IntVect.  The
      result will either be empty or have one cell. \\ 
      {\bf Arguments:} \\ 
      ivs (not modified): \\ 
      iv (not modified)\\
      {\bf Returns:} \\ 
      The intersection of the IntVectSet_old and the IntVect.\\ 
  */
  friend
  IntVectSet_old 
  operator&(const IntVect& iv, const IntVectSet_old& ivs);

  /// 
  /** 
      Returns the intersection of an IntVectSet_old and a Box. \\
      {\bf Arguments:} \\
      ivs (not modified): \\
      {\bf Returns:} \\
      The intersection of the IntVectSet_old and the Box.\\
  */
  friend
  IntVectSet_old 
  operator&(const IntVectSet_old& ivs, const Box& b);

  /// 
  /** 
      Returns the intersection of an IntVectSet_old and a Box. \\
      {\bf Arguments:} \\
      ivs (not modified): \\
      {\bf Returns:} \\
      The intersection of the IntVectSet_old and the Box.\\
  */
  friend
  IntVectSet_old 
  operator&(const Box& b, const IntVectSet_old& ivs);

  /// 
  /** 
      Sets this IntVectSet_old to its intersection with another IntVectSet_old. \\
      {\bf Arguments:} \\
      ivs (not modified): \\
      {\bf Returns:} \\
      The intersection of the two IntVectSet_olds.\\
      {\bf This:} \\
      ---This object is modified.---
  */
  IntVectSet_old&
  operator&=(const IntVectSet_old& ivs);

  /// 
  /** 
      Modifies this IntVectSet_old to be its intersection with an IntVect.
      The result will either be empty or have one cell. \\ 
      {\bf Arguments:} \\ 
      ivs (not modified): \\ 
      iv (not modified)\\
      {\bf Returns:} \\ 
      The intersection of this IntVectSet_old and the IntVect.\\ 
      {\bf This:} \\
      ---This object is modified.--- */
  IntVectSet_old&
  operator&=(const IntVect& iv);

  /// 
  /** 
      Modifies this IntVectSet_old to be its intersection with a Box. \\
      {\bf Arguments:} \\
      box (not modified): \\
      {\bf Returns:} \\
      The intersection of the this IntVectSet_old and the Box.\\
      {\bf This:} \\
      ---This object is modified.---
  */
  IntVectSet_old&
  operator&=(const Box& b);


  /// {\bf modification functions}

  ///
  /** 
      Returns the argument IntVectSet_old grown it by the specified number
      of cells in all directions, including diagonal.  \\
      {\bf Arguments:} \\
      ivs (not modified): \\
      igrow (not midified): number of cells to grow.\\
      {\bf Returns:} \\
      The argument IntVectSet_old grown by igrow in all directions.\\
*/
  friend
  IntVectSet_old
  grow(const IntVectSet_old& ivs, int igrow);

  ///
  /** 
      Modifies this IntVectSet_old by growing it by the specified number
      of cells in all directions, including diagonal.  It is an error
      if igrow < 0. \\
      {\bf Arguments:} \\
      igrow (not modified): number of cells to grow.\\
      {\bf Returns:} \\
      This IntVectSet_old grown by igrow in all directions.\\ 
      {\bf This:} \\
      ---This object is modified.---
*/
  IntVectSet_old&
  grow(int igrow);

  ///
  /** 
      Modifies this IntVectSet_old by growing it by the specified number
      of cells in the specified coordinate direction.  Directions are
      zero-based.\\
      {\bf Arguments:} \\
      idir (not modified): zero-based coordinate direction to grow in.\\
      igrow (not modified): number of cells to grow.\\
      {\bf Returns:} \\
      This IntVectSet_old grown by igrow the direction idir.\\ 
      {\bf This:} \\
      ---This object is modified.---
*/
  IntVectSet_old&
  grow(int idir, int igrow);

  /// 
  /**
     Modifies this IntVectSet_old by refining it by a specified factor
     iref.  It is an error if iref <= 0.  Definition of refinement:
     For each IntVect iv in the original IntVectSet_old, the refined
     IntVectSet_old will contain the Box refine(Box(iv,iv),iref).\\
      {\bf This:} \\
      ---This object is modified.---

   */
  IntVectSet_old&
  refine(int iref = 2);

  /// 
  /**
     Returns the IntVectSet_old that is the argument IntVectSet_old refined by
     a specified factor iref.  It is an error if iref <= 0.
     Definition of refinement: For each IntVect iv in the original
     IntVectSet_old, the refined IntVectSet_old will contain the Box
     refine(Box(iv,iv),iref).

   */
  friend
  IntVectSet_old
  refine(const IntVectSet_old& ivs, int iref = 2);


  /// 
  /**
     Modifies this IntVectSet_old by coarsening it by a specified factor
     iref.  It is an error if iref <= 0.  Definition of coarsening:
     For each IntVect iv in the original IntVectSet_old, the refined
     IntVectSet_old will contain the IntVect coarsen(iv,iref).\\
      {\bf This:} \\
      ---This object is modified.---

   */
  IntVectSet_old&
  coarsen(int iref = 2);

  /// 
  /**
     Returns the IntVectSet_old that is the argument IntVectSet_old coarsened
     by a specified factor iref.  It is an error if iref <= 0.
     Definition of coarsening: For each IntVect iv in the original
     IntVectSet_old, the refined IntVectSet_old will contain the IntVect
     coarsen(iv,iref).

   */
  friend
  IntVectSet_old
  coarsen(const IntVectSet_old& ivs, int iref = 2);

  ///
  /** 
      Increment all the IntVects in this IntVectSet_old by the given iv.\\
      --this IS changed--
   */
  void
  shift(IntVect iv);

  ///
  /** sets this IntVectSet_old to be empty */
  void
  makeEmpty();

  ///
  /** Chop the IntVectSet_old  at the chop_pnt in the dir direction \\
      Returns one IntVectSet_old and  modifies the object IntVectSet_old. \\
      The union of the two is the original IntVectSet_old. \\
      The modified IntVectSet_old is the low end, the returned IntvectSet \\
      is the high end. */
  IntVectSet_old
  chop(int dir, int chop_pnt);


  /// {\bf accessor and inquiry functions}

  ///
  /** Returns number of IntVects in this IntVectSet_old. */
  int
  numPts() const;

  ///
  /** Returns minimum enclosing box of this IntVectSet_old. */
  inline const Box&
  minBox() const;

  ///
  /** Returns true if no cells are in this IntVectSet_old. */
  bool
  isEmpty() const;

  ///
  /** Does this IntVectSet_old contain the argument IntVect? */
  bool
  contains(const IntVect& iv) const;

  ///{\bf I/O functions}

  ///
  /**
     Read IntVectSet_old ivs from an input stream.
   */
  friend istream&
  operator>>(istream& a_is,       IntVectSet_old& ivs);

  ///
  /**
     Write IntVectSet_old to an output stream.
   */
  friend ostream&
  operator<<(ostream& a_os, const IntVectSet_old& ivs);

  ///
  /**
     Returns Vector<Box> representation of this IntVectSet_old.
  */
  Vector<Box>
  boxes() const;

  ///
  /**
     Write Vector<Box> representation to an output stream.
  */
  void
  printBoxes(ostream& a_ostrm) const;

  ///
  /**
     Write plotfile of Vector<Box> representation in GNUplot format.
  */
  ostream&
  writeBoxesPlotfile(ostream& a_ostrm) const;

  ///
  /**
     Write ASCII plot of this IntVectSet_old.  
     [x%] is a point in this IntVectSet_old.  
     [.|-+] is a point not in this IntVectSet_old.
  */
  ostream&
  plotASCII(ostream& a_ostrm) const;

private:
  //absolutely, positively not for public consumption
  void
  getNewMinBox();

protected:

  /* return internal tree structure.
      not recommended.  use the iterator */
  const Tree* getTreePtr() const
  { 
    return tree_ptr;
  }

  Tree* tree_ptr;
  Box minbox;
};


///Iterator for an IntVectSet_old
/**
   IVSIterator_old iterates over every point (IntVect)
   in an IntVectSet_old.  It has exactly the same
   syntax and sematic as BoxIterator.  Typical usage:\\

\begin{verbatim}
   IntVectSet_old ivs;
   ...
   IVSIterator_old ivsit (ivs); 
   for (ivsit.begin(); ivsit.ok(); ++ivsit)  
   {  
     IntVect iv = ivsit(); 
     (do operations involving iv) 
   } 
\end{verbatim}
*/
class IVSIterator_old
{
public:

  ///{\bf constructors, destructor and defines}

  ///
  /**
     Null constructor.
  */
  IVSIterator_old ()
  {
    ivs_ptr = NULL;
  }

  ///
  /**
     Construct an iterator for the argument IntVectSet_old.
   */
  IVSIterator_old(const IntVectSet_old& ivs)
  {
    define(ivs);
  }

  ///
  /**
     Set this IVSIterator_old to iterate over the argument IntVectSet_old.
   */
  void
  define (const IntVectSet_old& ivs)
  {
    ivs_ptr = &ivs;
    leaf_it.define(ivs_ptr->tree_ptr, Leaf::Regular);
    //boxint already initialized to invalid box--good enough
#if(CH_SPACEDIM == 1)
    IntVect hi(777);
    IntVect lo(777);
#elif(CH_SPACEDIM == 2)
    IntVect hi(777,777);
    IntVect lo(777,777);
#elif(CH_SPACEDIM == 3)
    IntVect hi(777,777,777);
    IntVect lo(777,777,777);
#else
#error "Only 1,2,3 dimensions are supported.  Set CH_SPACEDIM to 1,2 or 3."
#endif
    Box outbox(lo,hi);
    boxint = outbox;
    box_it.setBox(boxint);
  }

  ///
  /**
     Destructor.
  */
  ~IVSIterator_old ()
  {}

  /// {\bf Modification functions}
  ///
  /**
     Sets this IVSIterator_old to the beginning of its IntVectSet_old.  The
     definition of the "beginning" of an IntVectSet_old is
     implementation-dependent.\\
      {\bf This:} \\
      ---This object is modified.---

   */
  void
  begin()
  {
    leaf_it.begin();
    //check to see if there is actually a box there
    //otherwise, give invalid box
    if(leaf_it.ok())
      {
        Box outbox = leaf_it.getDomain();
        boxint = outbox;
        box_it.setBox(boxint);
        box_it.begin();
      }
    else
      {
        Box outbox;
        boxint = outbox;
      }
  }

  //same as begin
  void
  reset()
  {
    begin();
  }

  ///
  /**
     Modify this IVSIterator_old to set it equal to the next location in
     its IntVectSet_old.  The definition of the "next location" of an
     IntVectSet_old is implementation-dependent.\\
      {\bf This:} \\
      ---This object is modified.--- */
  void
  operator++()
  {
    next();
  }

  //
  void
  next()
  {
    BoxIterator bit_temp(box_it);
    if (bit_temp.ok())
      {
        bit_temp.next();
        if (bit_temp.ok())
          {
            box_it.next();
          }
        else
          {
            leaf_it.next();
            if (leaf_it.ok())
              {
                Box outbox = leaf_it.getDomain();
                if (!outbox.isEmpty())
                  {
                    boxint = outbox;
                    box_it.setBox(boxint);
                    box_it.begin();
                  }
              }
          }
      }
    else
      {
        cout << "should not have made it into next" << endl;
        abort();
      }
  }

  ///{\bf Access functions}

  ///
  /**
     Returns the IntVect of this IntVectSet_old's current location.
   */
  IntVect
  operator() () 
  {
    return box_it();
  }

  ///
  /**
     Returns true if this IVSIterator_old's location is within its IntVectSet_old.
   */
  bool
  ok()
  {
    return ( leaf_it.ok() && box_it.ok() );
  }

protected:

  const IntVectSet_old* ivs_ptr;
  Box boxint;
  LeafIterator leaf_it;
  BoxIterator box_it;

};

inline const Box& 
IntVectSet_old::minBox() const
{
    return minbox;
}

#endif
