/*  _______              __
  / ___/ /  ___  __ _  / /  ___
 / /__/ _ \/ _ \/  ' \/ _ \/ _ \
 \___/_//_/\___/_/_/_/_.__/\___/ 
*/
/*

** This software is copyright (C) by the Lawrence Berkeley National
** Laboratory.  Permission is granted to reproduce this software for
** non-commercial purposes provided that this notice is left intact.
**  
** It is acknowledged that the U.S. Government has rights to this
** software under Contract DE-AC03-765F00098 between the U.S.  Department
** of Energy and the University of California.
**  
** This software is provided as a professional and academic contribution
** for joint exchange. Thus it is experimental, is provided ``as is'',
** with no warranties of any kind whatsoever, no support, no promise of
** updates, or printed documentation. By using this software, you
** acknowledge that the Lawrence Berkeley National Laboratory and Regents
** of the University of California shall have no liability with respect
** to the infringement of other copyrights by any part of this software.
*/

// Interval.H
// ============

//
// Little struct for passing component ranges in code.
//
// 

#ifndef INTERVAL_H
#define INTERVAL_H

/// Structure for passing component ranges in code.
/**
   A class to encapsulate component ranges
*/
struct Interval
{
  ///
  /**
      initialize with first and last component numbers
  */
  Interval(int a_firstComp, int a_lastComp):
    m_begin(a_firstComp), m_end(a_lastComp){}

  ///
  /**
     return first component number
  */
  int begin() const;

  ///
  /**
     return last component number
  */
  int end() const;

  ///
  /**
     return last - first + 1
   */
  int size() const {return m_end-m_begin+1;}


private:
  int m_begin, m_end;

};

inline int Interval::begin() const {return m_begin;}
inline int Interval::end()   const {return m_end;}


#endif // INTERVAL_H
