

#include "MayDay.H"
#include "DataIterator.H"
#include "SPMD.H"

template<class T>
inline const T& LayoutData<T>::operator[](const DataIndex& index) const
{
  assert(m_boxLayout.check(index));
  assert(m_boxLayout.procID(index) == procID()); // using a DataIndex for data on another processor
                                       //if you are reading this error in a debugger, then
	                               // you haven't used addBox(Box, int) correctly, or
                                       // you are using a LayoutIterator to access a data holder.
  return *(m_vector[m_boxLayout.index(index)]);
}

template<class T>
inline T& LayoutData<T>::operator[](const DataIndex& index)
{
  assert(m_boxLayout.check(index));
  assert(m_boxLayout.procID(index) == procID());// using a DataIndex for data on another processor
                                       //if you are reading this error in a debugger, then
                                       // you haven't used addBox(Box, int) correctly, or
                                       // you are using a LayoutIterator to access a data holder.

  return *(m_vector[m_boxLayout.index(index)]);
}

template<class T>
inline const Box& LayoutData<T>::box(const DataIndex& index) const
{
  return m_boxLayout.get(index);
}

template<class T>
inline DataIterator LayoutData<T>::dataIterator() const
{
  return m_boxLayout.dataIterator();
}

template<class T>
inline LayoutData<T>::LayoutData()
{
  m_boxLayout.close();
}

template<class T>
inline LayoutData<T>::LayoutData(const BoxLayout& dp)
  : m_boxLayout(dp)
{
  assert(dp.isClosed());
  allocate();
}
	
template<class T>
inline void LayoutData<T>::define(const BoxLayout& dp)
{
  assert(dp.isClosed());
  m_boxLayout = dp;
  allocate();
}
	

	
template<class T>
inline LayoutData<T>::~LayoutData()
{
  for(DataIterator it(dataIterator()); it.ok(); ++it)
    {
      delete m_vector[m_boxLayout.index(it())];
    }
}


template<class T>
inline void LayoutData<T>::allocate()
{

  for(unsigned int i=0; i<m_vector.size(); ++i)
    {
      delete m_vector[i];
      m_vector[i] = NULL;
    }

  m_vector.resize(m_boxLayout.size(), NULL);

  for(DataIterator it(dataIterator()); it.ok(); ++it)
    {
      unsigned int index = m_boxLayout.index(it());
      if(m_vector[index] == NULL) 
	{
	  m_vector[index] = new T();
	  if(m_vector[index] == NULL){
	    MayDay::Error("OutOfMemory in boxlayoutdata::setVector");
	  }
	}
 
    }
}


