/*  _______              __
  / ___/ /  ___  __ _  / /  ___
 / /__/ _ \/ _ \/  ' \/ _ \/ _ \
 \___/_//_/\___/_/_/_/_.__/\___/ 
*/
/*

** This software is copyright (C) by the Lawrence Berkeley National
** Laboratory.  Permission is granted to reproduce this software for
** non-commercial purposes provided that this notice is left intact.
**  
** It is acknowledged that the U.S. Government has rights to this
** software under Contract DE-AC03-765F00098 between the U.S.  Department
** of Energy and the University of California.
**  
** This software is provided as a professional and academic contribution
** for joint exchange. Thus it is experimental, is provided ``as is'',
** with no warranties of any kind whatsoever, no support, no promise of
** updates, or printed documentation. By using this software, you
** acknowledge that the Lawrence Berkeley National Laboratory and Regents
** of the University of California shall have no liability with respect
** to the infringement of other copyrights by any part of this software.
*/

#include "DataIndex.H"
#include "BoxLayout.H"


#ifndef LAYOUTITERATOR_H
#define LAYOUTITERATOR_H



///An Iterator based on a BoxLayout object. 
/**
   An Iterator based on a BoxLayout object.  It does not
   support a dereferencing operation(1), since it is intended
   to work with all of BoxLayouts, DisjointBoxLayouts, BoxLayoutDatas
   LevelData's, and any object that is built on top
   of a BoxLayout object.  LayoutIterator access the data in a BoxLayout-based
   object in a NON-data-parallel manner.

   BoxLayout-based objects act as the Factory for the LayoutIterator. 

 (1) STL-speak.  not critical for comprehension, but can help people
 familiar with STL iterators and expecting similar behaviour.

*/
class LayoutIterator
{
public:
  // default copy and null constructor should be fine

  // not useful to someone using the iterator.  Used by
  // other classes in Chombo.  Could make it private and
  // let BoxLayout have access....

  ///
  const LayoutIndex& operator()() const;

  ///
  void operator++();

  ///
  bool ok() const;

  ///
  void reset();

  ///
  void begin();

  ///
  /**
     skip the iterator to the end.
  */
  void end();


  
private:

  friend class BoxLayout;

  LayoutIterator(const BoxLayout& boxlayout, const int* layoutID);

  //int m_begin, m_end;

  const BoxLayout m_layout;

  unsigned int m_index;

  LayoutIndex m_current;

};


inline const LayoutIndex& LayoutIterator::operator()() const
{
  assert(ok());
  return m_current;
}

inline void LayoutIterator::operator++()
{
  ++m_index;
  if(ok())
    m_current.m_index = (*(m_layout.m_boxes))[m_index].index;
}

inline bool LayoutIterator::ok() const
{
  return m_index < m_layout.size();
}


inline void LayoutIterator::begin()
{
  m_index = 0;
  if(ok())
    m_current.m_index = (*(m_layout.m_boxes))[m_index].index;
}


#endif 
