#include "LayoutIterator.H"
#include "DataIterator.H"

LayoutIterator::LayoutIterator(const BoxLayout& plan, 
				      const int* layoutID)
  :m_layout(plan), m_index(0), m_current(0, layoutID)
{
  if(ok())
    m_current.m_index = (*(m_layout.m_boxes))[m_index].index;
}

void LayoutIterator::end()
{
  m_index = m_layout.size();
}

void LayoutIterator::reset()
{
  m_index = 0;
  if(ok())
    m_current.m_index = (*(m_layout.m_boxes))[m_index].index;
}
