/*  _______              __
  / ___/ /  ___  __ _  / /  ___
 / /__/ _ \/ _ \/  ' \/ _ \/ _ \
 \___/_//_/\___/_/_/_/_.__/\___/ 
*/
/*

** This software is copyright (C) by the Lawrence Berkeley National
** Laboratory.  Permission is granted to reproduce this software for
** non-commercial purposes provided that this notice is left intact.
**  
** It is acknowledged that the U.S. Government has rights to this
** software under Contract DE-AC03-765F00098 between the U.S.  Department
** of Energy and the University of California.
**  
** This software is provided as a professional and academic contribution
** for joint exchange. Thus it is experimental, is provided ``as is'',
** with no warranties of any kind whatsoever, no support, no promise of
** updates, or printed documentation. By using this software, you
** acknowledge that the Lawrence Berkeley National Laboratory and Regents
** of the University of California shall have no liability with respect
** to the infringement of other copyrights by any part of this software.
*/
#ifndef _LOHISIDE_H_
#define _LOHISIDE_H_

/// encapsulation of high or low side 
/**
   Encapsulation of high or low side.
*/
class Side
{
public:
  ///
  /**
     Lo is the low side \\
     Hi is the high side \\
  */
  enum LoHiSide {Invalid=-1, Lo=0, Hi, NUMSIDES};
  Side() {};
  ~Side() {};
///
/**
   Returns the other side.  I.e.  swap Hi for Lo and vice versa.
 */
friend 
Side::LoHiSide 
flip(Side::LoHiSide side);

///
/**
   Returns -1 for Lo side, +1 for Hi Side.
*/
friend
int 
sign(Side::LoHiSide side);

};



/// Iterator for low and high side
/**
   SideIterator iterates over the values Side::Lo and Side::Hi.  
   There are no adjustable parameters whatsoever.
*/
class SideIterator
{
public:

  ///{\bf Constructors, destructors}

  ///
  /** 
      Default, and only, constructor.
  */
  SideIterator();

  ///
  /**
     Default destructor.
  */
  ~SideIterator() {};

  ///{\bf Modification functions}

  ///
  /**
     Set the iterator to the first side. \\

     {\bf Arguments:} none. \\
     {\bf Returns:} none. \\
     {\bf This:} \\
     This object is modified.
  */
  void begin();

  ///
  /**
     Set the iterator to the first side. \\

     {\bf Arguments:} none. \\
     {\bf Returns:} none. \\
     {\bf This:} \\
     This object is modified.
  */
  void reset()
  {begin();}

  void next();

  ///
  /**
     Advances the iterator to the next face. \\

     {\bf Arguments:} none. \\
     {\bf Returns:} none. \\
     {\bf This:} \\
     This object is modified.
  */
  void operator++();

  ///{\bf Access functions}
   
  ///
  /**
     Returns the value of the side for the current iteration. \\

     {\bf Arguments:} none. \\
     {\bf Returns:} \\
     Returns the value of the side for the current iteration. \\
     {\bf This:} \\
     This object is not modified.
  */
  Side::LoHiSide operator() () const;

  ///
  /**
     Checks to see if there is a next side. \\

     {\bf Arguments:} none. \\
     {\bf Returns:} \\
     true if there is a next side. \\
     false otherwise. \\
     {\bf This:} \\
     This object is not modified.
  */
  bool ok() const;

private:
  int current;
};

#endif
