#include "LoHiSide.H"
#include <cassert>

Side::LoHiSide
flip(Side::LoHiSide side) 
{
    assert ( (side == Side::Lo) || (side == Side::Hi) );
    return ( (side == Side::Lo)
             ? Side::Hi
             : Side::Lo );
}


int 
sign(Side::LoHiSide side)
{
    assert ( (side == Side::Lo) || (side == Side::Hi) );
    return ( (side == Side::Lo) ? -1 : 1 );
}


SideIterator::SideIterator() : current(-1)
{    
}


void
SideIterator::begin()
{
    current = 0;
}


bool 
SideIterator::ok() const
{
    return ( (current > -1) && (current < Side::NUMSIDES) );
}


void
SideIterator::operator++()
{
    ++current;
}

void
SideIterator::next()
{
    ++current;
}


Side::LoHiSide
SideIterator::operator() () const
{
    switch (current)
    {
    case 0:
        return Side::Lo;
    case 1:
        return Side::Hi;
    default:
        return Side::Invalid;
    }
}
