/*
** This software is copyright (C) by the Lawrence Berkeley National
** Laboratory.  Permission is granted to reproduce this software for
** non-commercial purposes provided that this notice is left intact.
**  
** It is acknowledged that the U.S. Government has rights to this
** software under Contract DE-AC03-765F00098 between the U.S.  Department
** of Energy and the University of California.
**  
** This software is provided as a professional and academic contribution
** for joint exchange. Thus it is experimental, is provided ``as is'',
** with no warranties of any kind whatsoever, no support, no promise of
** updates, or printed documentation. By using this software, you
** acknowledge that the Lawrence Berkeley National Laboratory and Regents
** of the University of California shall have no liability with respect
** to the infringement of other copyrights by any part of this software.
**  
** For further information about this software, contact:
*/

#ifndef CH_MayDay_H
#define CH_MayDay_H

//
// $Id: MayDay.H,v 1.1.1.1 2000/09/05 23:55:57 graves Exp $
//

//
//@Man:
//@Memo: Error-reporting Functions and Version Number
/*@Doc:

  This class consists entirely of static error-reporting functions that
  are used throughout the MayDay implementation together with a version
  string.  In the best of all possible worlds we'd use a namespace, but
  we aren't there, yet :-)  Note that all the output functions add a
  terminating exclamation mark, so there is no need to add any punction
  to sentences that get output explicitly.
*/

class MayDay
{
protected:
  //
  // A null string used as a default argument by the following functions.
  //
  static const char* nullString;
public:
  ///
/**
  Print out message to cerr and exit via MayDay::Abort().
*/
  static void Error (const char * msg = nullString);

  ///
/**
  Print out message to cerr and exit via abort().
*/
  static void Abort (const char * msg = nullString);

  /// 
/**
   Issues warning to stderr, but does not halt program execution.
*/
  static void Warning(const char* msg = nullString);

  /* The MayDay version string.
    
    Has the form:
    
    MayDay version 2.0 built Jun 25 1996 at 14:52:36
    */
  static const char * const version;

};


#endif /*CH_MayDay_H*/
