/* _______              __
  / ___/ /  ___  __ _  / /  ___
 / /__/ _ \/ _ \/  ' \/ _ \/ _ \
 \___/_//_/\___/_/_/_/_.__/\___/ 
*/
/*
** This software is copyright (C) by the Lawrence Berkeley National
** Laboratory.  Permission is granted to reproduce this software for
** non-commercial purposes provided that this notice is left intact.
**  
** It is acknowledged that the U.S. Government has rights to this
** software under Contract DE-AC03-765F00098 between the U.S.  Department
** of Energy and the University of California.
**  
** This software is provided as a professional and academic contribution
** for joint exchange. Thus it is experimental, is provided ``as is'',
** with no warranties of any kind whatsoever, no support, no promise of
** updates, or printed documentation. By using this software, you
** acknowledge that the Lawrence Berkeley National Laboratory and Regents
** of the University of California shall have no liability with respect
** to the infringement of other copyrights by any part of this software.
**  
*/

#include <cstdio>
#include <cstdlib>
#include <iostream>
#include <cstring>
using std::cerr;
using namespace std;

#include "MayDay.H"
#include "CHOMBO_VERSION.H"

//
// The definition of our NULL string used as default argument.
//
const char* MayDay::nullString = "";

#define bl_str(s)  # s
#define bl_xstr(s) bl_str(s)

//
// The definition of our version string.
//
const char * const MayDay::version =

"MayDay version "
bl_xstr(CH_VERSION_MAJOR)
"."
bl_xstr(CH_VERSION_MINOR)
" built "
__DATE__
" at "
__TIME__;

#undef bl_str
#undef bl_xstr


//
// This is used by MayDay::Error(), MayDay::Abort(), and MayDay::Assert()
// to ensure that when writing the message to stderr, that no additional
// heap-based memory is allocated.
//

static
void
write_to_stderr_without_buffering (const char* str)
{
    //
    // Flush all buffers.
    //
    fflush(NULL);

    if (str)
    {
        //
        // Add some `!'s and a newline to the string.
        //
        const char * const end = " !!!\n";
        fwrite(str, strlen(str), 1, stderr);
        fwrite(end, strlen(end), 1, stderr);
    }
}

void
MayDay::Error (const char* msg)
{
    write_to_stderr_without_buffering(msg);
    abort();
}

void
MayDay::Abort (const char* msg)
{
    write_to_stderr_without_buffering(msg);
    abort();
}

void
MayDay::Warning (const char* msg)
{
    write_to_stderr_without_buffering(msg);
}


// ChomboFortran interfaces

#include "FORT_PROTO.H"

extern "C" {

void
FORTRAN_NAME(MAYDAY_ERROR ,mayday_error) (void)
{
  MayDay::Error( "A ChomboFortran routine took an error.  Rerun with the debugger to find where." ) ;
}

void
FORTRAN_NAME(MAYDAY_ABORT ,mayday_abort) (void)
{
  MayDay::Abort( "A ChomboFortran routine requested an abort.  Rerun with the debugger to find where." ) ;
}

}
