
#include "Vector.H"
#include "Box.H"
#include "IntVectSet.H"

#include "MeshRefine.H"
#include "MeshRefineObject.H"

MeshRefineObject::MeshRefineObject()
  :
  m_block_factor(1),
  m_max_size(INT_MAX),
  m_buffer_size(1),
  m_fill_ratio(0.75)
{
}


MeshRefineObject::~MeshRefineObject()
{
}


void
MeshRefineObject::regrid(Vector<Vector<Box> >& a_new_grids,
                         int& a_new_finest_level,
                         Vector<IntVectSet>& a_tags,
                         int a_base_level,
                         int a_top_level,
                         const Vector<Box>& a_prob_domains,
                         const Vector<Vector<Box> >& a_old_grids,
                         const Vector<int>& a_ref_ratioes)
  const
{
// set top_level to the finest level that actually has tags
  bool found_top = false;
  int top_level = a_top_level;
  //need this because .size() returns an unsigned int
  int isize = a_tags.size();
  for (int level = Min(a_top_level, isize-1); 
       !found_top && (level >= a_base_level); 
       --level)
  {
    if (!a_tags[level].isEmpty())
    {
      found_top = true;
      top_level = level;
    }
  }
  if (found_top)
  {
    meshRefine(a_new_grids,
               a_tags,
               a_base_level,
               top_level,
               a_prob_domains,
               a_old_grids,
               a_ref_ratioes,
               m_fill_ratio,
               m_block_factor,
               m_buffer_size,
               m_max_size);
// set to value returned by meshRefine
    a_new_finest_level = top_level + 1;
  }
  else
  {
    a_new_finest_level = a_base_level;
  }
}


void
MeshRefineObject::regrid(Vector<Vector<Box> >& a_new_grids,
                         IntVectSet& a_tags,
                         int a_base_level,
                         int a_top_level,
                         const Vector<Box>& a_prob_domains,
                         const Vector<Vector<Box> >& a_old_grids,
                         const Vector<int>& a_ref_ratioes)
  const
{
  meshRefine(a_new_grids,
             a_tags,
             a_base_level,
             a_top_level,
             a_prob_domains,
             a_old_grids,
             a_ref_ratioes,
             m_fill_ratio,
             m_block_factor,
             m_buffer_size,
             m_max_size);
}


void
MeshRefineObject::blockFactor(int a_block_factor)
{
  m_block_factor = a_block_factor;
}


void
MeshRefineObject::maxSize(int a_max_size)
{
  m_max_size = a_max_size;
}


void
MeshRefineObject::bufferSize(int a_buffer_size)
{
  m_buffer_size = a_buffer_size;
}


void
MeshRefineObject::fillRatio(Real a_fill_ratio)
{
  m_fill_ratio = a_fill_ratio;
}


int
MeshRefineObject::blockFactor() const
{
  return m_block_factor;
}


int
MeshRefineObject::maxSize() const
{
  return m_max_size;
}


int 
MeshRefineObject::bufferSize() const
{
  return m_buffer_size;
}


Real
MeshRefineObject::fillRatio() const
{
  return m_fill_ratio;
}


