#ifndef _PARMPARSE_IO_H_
#define _PARMPARSE_IO_H_
#include <iostream>
#include <fstream>
using std::ofstream;
#include <string>

#include "REAL.H" 
class Box;
class IntVect;
class FArrayBox;
class BoxLayout;
class DisjointBoxLayout;
template <class TTYPE> class LevelData;

class ParmParse;

class ParmParseIO
{
public:
  ParmParseIO ();
  ~ParmParseIO ();

  void
  openForRead (const std::string& a_filename);

  void
  openForWrite (const std::string& a_filename);

  void
  close ();

  void
  setGroup (const std::string& a_groupname);

  const std::string
  getGroup () const;

    const std::string&
    filename() const;

    const std::string&
    groupname() const;

  void set (const std::string& a_name, const Real&        a_value);
  void set (const std::string& a_name, const int&         a_value);
  void set (const std::string& a_name, const std::string& a_value);
  void set (const std::string& a_name, const IntVect&     a_value);
  void set (const std::string& a_name, const Box&         a_value);

  void get (const std::string& a_name, Real&        a_value) const;
  void get (const std::string& a_name, int&         a_value) const;
  void get (const std::string& a_name, std::string& a_value) const;
  void get (const std::string& a_name, IntVect&     a_value) const;
  void get (const std::string& a_name, Box&         a_value) const;

  bool
  found (const std::string& a_name) const;

  friend
  void
  write (ParmParseIO& a_ppio, const BoxLayout& a_layout);

// return code:
// 0: successful read
// 1: no num_boxes
// 2: no box_n (does not report n)
  friend
  int
  read (ParmParseIO& a_ppio, Vector<Box>& a_boxes);

// return codes:
// 0: successful read
// 1: no num_comps
// 2: bad fab read

protected:
  ParmParse* m_parmparse_ptr;
  ofstream m_ostrm;
  std::string m_groupname;
  std::string m_filename;
};


  void
  write (ParmParseIO& a_ppio, 
         const LevelData<FArrayBox>& a_data, 
         const std::string& a_name);

int
read  (ParmParseIO& a_ppio, 
                  LevelData<FArrayBox>& a_data, 
                  const std::string& a_name,
                  const DisjointBoxLayout& a_layout);



#endif
