//  -*- Mode: C++; c-file-style: "gnu"; Modified: "Thu 23 Dec 1999 16:13:09 by bvs"; -*- 
// file: Pool.H

/* _______              __
  / ___/ /  ___  __ _  / /  ___
 / /__/ _ \/ _ \/  ' \/ _ \/ _ \
 \___/_//_/\___/_/_/_/_.__/\___/ 
*/

//
// This software is copyright (C) by the Lawrence Berkeley
// National Laboratory.  Permission is granted to reproduce
// this software for non-commercial purposes provided that
// this notice is left intact.
// 
// It is acknowledged that the U.S. Government has rights to
// this software under Contract DE-AC03-765F00098 between
// the U.S.  Department of Energy and the University of
// California.
//
// This software is provided as a professional and academic
// contribution for joint exchange. Thus it is experimental,
// is provided ``as is'', with no warranties of any kind
// whatsoever, no support, no promise of updates, or printed
// documentation. By using this software, you acknowledge
// that the Lawrence Berkeley National Laboratory and
// Regents of the University of California shall have no
// liability with respect to the infringement of other
// copyrights by any part of this software.

#ifndef POOL_H
#define POOL_H

// Pool is a class to optimize memory allocation.  It is specialized to
// allocate fixed size chunks of memory specified by ptrSize in the
// constructor.  Its operation is analogous to malloc, not new.  It
// does not initialize the memory in any way.  The constructor can
// optionally specify an initial pool size, and memory alignment.  The
// pool size will grow as needed by calling ::new.  The pool size never
// shrinks.  Memory will be reclaimed at ~Pool().  The units of poolSize
// are number-of-ptrSize-chunks.  The units of alignment are bytes.

#include <cstdlib>
#include "Vector.H"

///
class Pool {
public:
  ///
  Pool(int ptrSize, int poolSize = 100, int alignment = sizeof(int));
  ///
  ~Pool();
  ///
  void* getPtr();
  ///
  void returnPtr(void* ptr);
protected:
private:
  ///
  Vector<char*> pool_;
  ///
  int ptrSize_;
  ///
  int poolSize_;
  ///
  int alignment_;
  ///
  void* next_;
  
  ///
  void* getMoreMemory();
  ///
  Pool(const Pool& rhs);  /// Not implemented
  const Pool& operator=(const Pool& rhs);  // Not implemented
};


#endif
