#ifndef CH_REAL_H
#define CH_REAL_H

#ifdef CH_USE_FLOAT /* precision */

#undef CH_USE_DOUBLE
#undef CH_USE_FLOAT
#define CH_USE_FLOAT 1

#else   /* precision */     

#  undef  CH_USE_FLOAT
#  undef  CH_USE_DOUBLE
#  define CH_USE_DOUBLE 1

#endif  /* precision */

#if !defined(CH_LANG_FORT) /* language */

#ifdef CH_USE_FLOAT /* precision */

     typedef float Real;
#define  MPI_CH_REAL MPI_FLOAT
#define  H5T_NATIVE_REAL H5T_NATIVE_FLOAT

#else   /* precision */     

     typedef double Real;
#    define MPI_CH_REAL MPI_DOUBLE
#    define H5T_NATIVE_REAL H5T_NATIVE_DOUBLE

#endif  /* precision */

#else /* language */

#ifdef CH_USE_FLOAT /* precision */
#define REAL_T REAL
#else /* precision */

#if defined(CH_CRAY)
#define REAL_T REAL
#else /*cray */
#define REAL_T DOUBLEPRECISION
#endif /*cray*/

#endif /* precision */
#endif /* language */

#if defined(CH_LANG_FORT)
#define Real_T REAL_T
#define Real_t REAL_T
#define real_t REAL_T
#endif

#if !defined(CH_USE_FLOAT) && !defined(CH_USE_DOUBLE)
#error Exactly one of CH_USE_FLOAT or CH_USE_DOUBLE must be defined
#endif

#endif /*CH_REAL_H*/
