/* _______              __
  / ___/ /  ___  __ _  / /  ___
 / /__/ _ \/ _ \/  ' \/ _ \/ _ \
 \___/_//_/\___/_/_/_/_.__/\___/ 
*/

/*
** This software is copyright (C) by the Lawrence Berkeley National
** Laboratory.  Permission is granted to reproduce this software for
** non-commercial purposes provided that this notice is left intact.
**  
** It is acknowledged that the U.S. Government has rights to this
** software under Contract DE-AC03-765F00098 between the U.S.  Department
** of Energy and the University of California.
**  
** This software is provided as a professional and academic contribution
** for joint exchange. Thus it is experimental, is provided ``as is'',
** with no warranties of any kind whatsoever, no support, no promise of
** updates, or printed documentation. By using this software, you
** acknowledge that the Lawrence Berkeley National Laboratory and Regents
** of the University of California shall have no liability with respect
** to the infringement of other copyrights by any part of this software.
*/

//

#include <cassert>
#include "MayDay.H"
#include "Misc.H"
#include "RealVect.H"
using std::ostream;
using std::istream;
using std::ws;


const RealVect RealVect::Unit(D_DECL(1.0,1.0,1.0));
const RealVect RealVect::Zero(D_DECL(0.0,0.0,0.0));

RealVect::RealVect (D_DECL(int i, int j, int k))
{
  D_EXPR(vect[0] = i, vect[1] = j, vect[2] = k);
}

RealVect::RealVect (const RealVect &iv)
{
  D_EXPR(vect[0]=iv.vect[0], vect[1]=iv.vect[1], vect[2]=iv.vect[2]);
}

RealVect::RealVect ()
{
  D_EXPR(vect[0]=0.0, vect[1]=0.0, vect[2] = 0.0);
}

RealVect&
RealVect::operator= (const RealVect &iv)
{
  D_EXPR(vect[0]=iv.vect[0], vect[1]=iv.vect[1], vect[2]=iv.vect[2]);
  return *this;
}

Real&
RealVect::operator[] (int i)
{
  assert(i>=0 && i < SpaceDim);
  return vect[i];
}

const Real&
RealVect::operator[] (int i) const
{
  assert(i>=0 && i < SpaceDim);
  return vect[i];
}

bool
RealVect::operator== (const RealVect& p) const
{
  return D_TERM(vect[0] == p[0], && vect[1] == p[1], && vect[2] == p[2]);
}

bool
RealVect::operator!= (const RealVect& p) const
{
  return D_TERM(vect[0] != p[0], || vect[1] != p[1], || vect[2] != p[2]);
}


RealVect&
RealVect::operator+= (Real s)
{
  D_EXPR(vect[0] += s, vect[1] += s, vect[2] += s);
  return *this;
}

RealVect&
RealVect::operator+= (const RealVect& p)
{
  D_EXPR(vect[0] += p[0], vect[1] += p[1], vect[2] += p[2]);
  return *this;
}

RealVect&
RealVect::operator*= (Real s)
{
  D_EXPR(vect[0] *= s, vect[1] *= s, vect[2] *= s);
  return *this;
}

RealVect&
RealVect::operator*= (const RealVect &p)
{
  D_EXPR(vect[0] *= p[0], vect[1] *= p[1], vect[2] *= p[2]);
  return *this;
}

RealVect&
RealVect::operator/= (Real s)
{
  D_EXPR(vect[0] /= s, vect[1] /= s, vect[2] /= s);
  return *this;
}

RealVect&
RealVect::operator/= (const RealVect& p)
{
  D_EXPR(vect[0] /= p[0], vect[1] /= p[1], vect[2] /= p[2]);
  return *this;
}

RealVect&
RealVect::operator-= (Real s)
{
  D_EXPR(vect[0] -= s, vect[1] -= s, vect[2] -= s);
  return *this;
}

RealVect&
RealVect::operator-= (const RealVect& p)
{
  D_EXPR(vect[0] -= p[0], vect[1] -= p[1], vect[2] -= p[2]);
  return *this;
}

RealVect
RealVect::operator+ (const RealVect& p) const
{
  return RealVect(D_DECL(vect[0] + p[0], vect[1] + p[1], vect[2] + p[2]));
}

RealVect
RealVect::operator+ (Real s) const
{
  return RealVect(D_DECL(vect[0] + s, vect[1] + s, vect[2] + s));
}

RealVect
RealVect::operator- (const RealVect& p) const
{
  return RealVect(D_DECL(vect[0] - p[0], vect[1] - p[1], vect[2] - p[2]));
}

RealVect
RealVect::operator- (Real s) const
{
  return RealVect(D_DECL(vect[0] - s, vect[1] - s, vect[2] - s));
}

RealVect
RealVect::operator* (const RealVect& p) const
{
  return RealVect(D_DECL(vect[0] * p[0], vect[1] * p[1], vect[2] * p[2]));
}

RealVect
RealVect::operator* (Real s) const
{
  return RealVect(D_DECL(vect[0] * s, vect[1] * s, vect[2] * s));
}

RealVect
RealVect::operator/ (const RealVect& p) const
{
  return RealVect(D_DECL(vect[0] / p[0], vect[1] / p[1], vect[2] / p[2]));
}

RealVect
RealVect::operator/ (Real s) const
{
  return RealVect(D_DECL(vect[0] / s, vect[1] / s, vect[2] / s));
}

RealVect
BASISREALV (int dir)
{
  assert(dir >= 0 && dir < SpaceDim);
  RealVect tmp = RealVect::Zero ;
  tmp.vect[dir] = 1;
  return tmp;
}


