
#include "SPMD.H"
#include <iostream>
#include <cstring>
using std::cout;
using std::endl;
#include "IntVectSet.H"

#ifndef MPI

int procID(){ return 0;}

// reset this to fool serial code into thinking its parallel
int num_procs = 1 ;

unsigned int numProc(){ return num_procs;}

#else // MPI version

int procID()
{
  int ret;
  MPI_Comm_rank(Chombo_MPI::comm, &ret);
  return ret;
}

unsigned int numProc()
{
  int ret;
  MPI_Comm_size(Chombo_MPI::comm, &ret);
  return ret;
}

// hopefully static copy of opaque handles
MPI_Comm Chombo_MPI::comm = MPI_COMM_WORLD;


#endif // MPI


/// these should work independent of MPI's existence
template < >
void linearIn<Real>(Real& a_outputT, const void* const a_inBuf)
{
  //this fandango is to avoid unaligned accesses
  char realBuf[sizeof(Real)];
  memcpy(realBuf, a_inBuf, sizeof(Real));
  Real* buffer = (Real*)realBuf;
  a_outputT = *buffer;
}

template < >
void linearOut<Real>(void* const a_outBuf, const Real& a_inputT)
{
  //this fandango is to avoid unaligned accesses
  char realBuf[sizeof(Real)];
  Real* realPtr = (Real*)realBuf;
  *realPtr = a_inputT;
  memcpy(a_outBuf, realBuf, sizeof(Real));
}

template < >
int linearSize<Real>(const Real& inputReal)
{
  return sizeof(Real);
}

template < >
void linearIn<int>(int& a_outputT, const void* const a_inBuf)
{
  int* buffer = (int*)a_inBuf;
  a_outputT = *buffer;
}

template < >
void linearOut<int>(void* const a_outBuf, const int& a_inputT)
{
  int* buffer = (int*)a_outBuf;
  *buffer = a_inputT;   
}

template < >
int linearSize<int>(const int& a_input)
{
  return sizeof(int);
}


template < >
void linearIn<Box>(Box& a_outputT, const void* const a_inBuf)
{
  int* intBuf = (int*)a_inBuf;
  IntVect lo, hi;
  //output is lo[0],lo[1],...
  for(int idir = 0; idir < SpaceDim; idir++)
    {
      lo[idir] = intBuf[idir];
      hi[idir] = intBuf[idir+SpaceDim];
    }
  a_outputT = Box(lo,hi);
}

template < >
void linearOut<Box>(void* const a_outBuf, const Box& a_inputT)
{
  int* intBuf = (int*)a_outBuf;
  const IntVect& lo = a_inputT.smallEnd();
  const IntVect& hi = a_inputT.bigEnd();
  //output is lo[0],lo[1],...
  for(int idir = 0; idir < SpaceDim; idir++)
    {
      intBuf[idir] = lo[idir];
      intBuf[idir+SpaceDim] = hi[idir];
    }
}

template < >
int linearSize<Box>(const Box& a_input)
{
  //box is stored as 2*spaceDim integers
  return(2*SpaceDim*sizeof(int));
}


template < >
void gather<IntVectSet>(Vector<IntVectSet>& a_outVec, 
            const IntVectSet& a_input, 
            int a_dest)
{
  Vector<Box> boxes = a_input.boxes();
  Vector<Vector<Box> > all_boxes;

  gather (all_boxes, boxes, a_dest);

  const int num_vecs = all_boxes.size();
  a_outVec.resize(num_vecs);

  for (int i = 0; i < num_vecs; ++i)
  {
    IntVectSet& ivs = a_outVec[i];
    const Vector<Box>& vb = all_boxes[i];
    for (int ibox = 0; ibox < vb.size(); ++ibox)
    {
      ivs |= vb[ibox];
    }
  }
}


// return id of unique processor for special serial tasks
int
uniqueProc(const SerialTask::task& a_task)
{
#ifdef NDEBUG
    switch (a_task)
    {
    case SerialTask::compute:
    default:
        return (0);
        break;
    }
#else
// in mpi, the debugger attaches to process 0
    return (0);
#endif
}

