0	/* install-info -- merge Info directory entries from an Info file.
1	   $Id: install-info.c 6165 2015-02-27 18:46:10Z gavin $
2	
3	   Copyright 1996, 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004,
4	   2005, 2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014, 2015
5	   Free Software Foundation, Inc.
6	
7	   This program is free software: you can redistribute it and/or modify
8	   it under the terms of the GNU General Public License as published by
9	   the Free Software Foundation, either version 3 of the License, or
10	   (at your option) any later version.
11	
12	   This program is distributed in the hope that it will be useful,
13	   but WITHOUT ANY WARRANTY; without even the implied warranty of
14	   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
15	   GNU General Public License for more details.
16	
17	   You should have received a copy of the GNU General Public License
18	   along with this program.  If not, see <http://www.gnu.org/licenses/>.  */
19	
20	#include "system.h"
21	#include <getopt.h>
22	#include <regex.h>
23	#include <argz.h>
24	
25	#define TAB_WIDTH 8
26	
27	static char *progname = "install-info";
28	static char *default_section = NULL;
29	
30	struct spec_entry;
31	struct spec_section;
32	
33	struct line_data *findlines (char *data, int size, int *nlinesp);
34	void insert_entry_here (struct spec_entry *entry, int line_number,
35	                        struct line_data *dir_lines, int n_entries); 
36	int compare_section_names (const void *s1, const void *s2);
37	int compare_entries_text (const void *e1, const void *e2); 
38	
39	/* Data structures.  */
40	
41	
42	/* Record info about a single line from a file as read into core.  */
43	struct line_data
44	{
45	  /* The start of the line.  */
46	  char *start;
47	  /* The number of characters in the line,
48	     excluding the terminating newline.  */
49	  int size;
50	  /* Vector containing pointers to the entries to add before this line.
51	     The vector is null-terminated.  */
52	  struct spec_entry **add_entries_before;
53	  /* Vector containing pointers to the sections to add before this line.
54	     The vector is not null-terminated.  */
55	  struct spec_section **add_sections_before;
56	  /* The vector ADD_SECTIONS_BEFORE_HERE contains exactly this many
57	     pointers to sections. */
58	  int num_sections_to_add;
59	  /* 1 means don't output this line.  */
60	  int delete;
61	};
62	
63	
64	/* This is used for a list of the specified menu section names
65	   in which entries should be added.  */
66	struct spec_section
67	{
68	  struct spec_section *next;
69	  char *name;
70	  /* 1 means we have not yet found an existing section with this name
71	     in the dir file--so we will need to add a new section.  */
72	  int missing;
73	};
74	
75	
76	/* This is used for a list of the entries specified to be added.  */
77	struct spec_entry
78	{
79	  struct spec_entry *next;
80	  char *text;
81	  size_t text_len;
82	  /* A pointer to the list of sections to which this entry should be
83	     added.  */
84	  struct spec_section *entry_sections;
85	  /* A pointer to a section that is beyond the end of the chain whose
86	     head is pointed to by entry_sections.  */
87	  struct spec_section *entry_sections_tail;
88	  /* Non-zero means that the entry doesn't have a name specified.  This
89	     can only happen if a --description preceeds a --name option. */
90	  int missing_name;
91	  /* Non-zero means that the entry doesn't have a description.  This
92	     happens when a --name option is given prior to a --description 
93	     option. */
94	  int missing_description;
95	  /* Non-zero means that the entry doesn't have an Info file specified.  
96	     This means that the entry was taken from the command-line but it
97	     only contains the name, and not the info file's basename, which
98	     we get later on.  This only happens on entries that originate
99	     from --name options. */
100	  int missing_basename;
101	};
102	
103	
104	/* This is used for a list of nodes found by parsing the dir file.  */
105	struct node
106	{
107	  struct node *next;
108	  /* The node name.  */
109	  char *name;
110	  /* The line number of the line where the node starts.
111	     This is the line that contains control-underscore.  */
112	  int start_line;
113	  /* The line number of the line where the node ends,
114	     which is the end of the file or where the next line starts.  */
115	  int end_line;
116	  /* Start of first line in this node's menu
117	     (the line after the * Menu: line).  */
118	  char *menu_start;
119	  /* The start of the chain of sections in this node's menu.  */
120	  struct menu_section *sections;
121	  /* The last menu section in the chain.  */
122	  struct menu_section *last_section;
123	};
124	
125	
126	/* This is used for a list of sections found in a node's menu.
127	   Each  struct node  has such a list in the  sections  field.  */
128	struct menu_section
129	{
130	  struct menu_section *next;
131	  char *name;
132	  /* Line number of start of section.  */
133	  int start_line;
134	  /* Line number of end of section.  */
135	  int end_line;
136	};
137	
138	/* This table defines all the long-named options, says whether they
139	   use an argument, and maps them into equivalent single-letter options.  */
140	
141	struct option longopts[] =
142	{
143	  { "add-once",  no_argument, NULL, '1'},
144	  { "align",     required_argument, NULL, 'A'},
145	  { "append-new-sections", no_argument, NULL, 'a'},
146	  { "calign",    required_argument, NULL, 'C'},
147	  { "debug",     no_argument, NULL, 'g' },
148	  { "delete",    no_argument, NULL, 'r' },
149	  { "defentry",  required_argument, NULL, 'E' },
150	  { "defsection",  required_argument, NULL, 'S' },
151	  { "dir-file",  required_argument, NULL, 'd' },
152	  { "entry",     required_argument, NULL, 'e' },
153	  { "name",      required_argument, NULL, 't' },
154	  { "menuentry", required_argument, NULL, 't' },
155	  { "description", required_argument, NULL, 'c' },
156	  { "help",      no_argument, NULL, 'h' },
157	  { "no-indent", no_argument, NULL, 'I' },
158	  { "infodir",   required_argument, NULL, 'D' },
159	  { "info-dir",  required_argument, NULL, 'D' },
160	  { "info-file", required_argument, NULL, 'i' },
161	  { "item",      required_argument, NULL, 'e' },
162	  { "keep-old",  no_argument, NULL, 'k' },
163	  { "maxwidth",  required_argument, NULL, 'W'},
164	  { "max-width", required_argument, NULL, 'W'},
165	  { "quiet",     no_argument, NULL, 'q' },
166	  { "remove",    no_argument, NULL, 'r' },
167	  { "remove-exactly",    no_argument, NULL, 'x' },
168	  { "section",           required_argument, NULL, 's' },
169	  { "regex",     required_argument, NULL, 'R' },
170	  { "silent",    no_argument, NULL, 'q' },
171	  { "test",      no_argument, NULL, 'n' },
172	  { "dry-run",   no_argument, NULL, 'n' },
173	  { "version",   no_argument, NULL, 'V' },
174	  { 0 }
175	};
176	
177	regex_t *psecreg = NULL;
178	
179	/* Nonzero means that the name specified for the Info file will be used
180	   (without removing .gz, .info extension or leading path) to match the
181	   entries that must be removed.  */
182	int remove_exactly = 0;
183	
184	/* Nonzero means that sections that don't have entries in them will be
185	   deleted.  */
186	int remove_empty_sections = 1;
187	
188	/* Nonzero means that new Info entries into the DIR file go into all 
189	   sections that match with --section-regex or --section.  Zero means 
190	   that new entries go into only the first section that matches.  */
191	int add_entries_into_all_matching_sections = 1;
192	
193	/* Nonzero means we do not replace same-named info entries.  */
194	int keep_old_flag = 0;
195	
196	/* Nonzero means --test was specified, to inhibit updating the dir file.  */
197	int chicken_flag = 0;
198	
199	/* Zero means that entries will not be formatted when they are either 
200	   added or replaced. */
201	int indent_flag = 1;
202	
203	/* Zero means that new sections will be added at the end of the DIR file. */
204	int order_new_sections_alphabetically_flag = 1;
205	
206	
207	/* Error message functions.  */
208	
209	void
210	vdiag (const char *fmt, const char *diagtype, va_list ap)
211	{
212	  fprintf (stderr, "%s: ", progname);
213	  if (diagtype)
214	    fprintf (stderr, "%s: ", diagtype);
215	  vfprintf (stderr, fmt, ap);
216	  putc ('\n', stderr);
217	}
218	
219	void
220	error (const char *fmt, ...)
221	{
222	  va_list ap;
223	
224	  va_start (ap, fmt);
225	  vdiag (fmt, NULL, ap);
226	  va_end (ap);
227	}
228	
229	/* VARARGS1 */
230	void
231	warning (const char *fmt, ...)
232	{
233	  va_list ap;
234	
235	  va_start (ap, fmt);
236	  vdiag (fmt, "warning", ap);
237	  va_end (ap);
238	}
239	
240	/* Print error message and exit.  */
241	
242	void
243	fatal (const char *fmt, ...)
244	{
245	  va_list ap;
246	
247	  va_start (ap, fmt);
248	  vdiag (fmt, NULL, ap);
249	  va_end (ap);
250	  exit (EXIT_FAILURE);
251	}
252	
253	/* Return a newly-allocated string
254	   whose contents concatenate those of S1, S2, S3.  */
255	char *
256	concat (const char *s1, const char *s2, const char *s3)
257	{
258	  int len1 = strlen (s1), len2 = strlen (s2), len3 = strlen (s3);
259	  char *result = (char *) xmalloc (len1 + len2 + len3 + 1);
260	
261	  strcpy (result, s1);
262	  strcpy (result + len1, s2);
263	  strcpy (result + len1 + len2, s3);
264	  *(result + len1 + len2 + len3) = 0;
265	
266	  return result;
267	}
268	
269	/* Return a string containing SIZE characters
270	   copied from starting at STRING.  */
271	
272	char *
273	copy_string (const char *string, int size)
274	{
275	  int i;
276	  char *copy = (char *) xmalloc (size + 1);
277	  for (i = 0; i < size; i++)
278	    copy[i] = string[i];
279	  copy[size] = 0;
280	  return copy;
281	}
282	
283	/* Print fatal error message based on errno, with file name NAME.  */
284	
285	void
286	pfatal_with_name (const char *name)
287	{
288	  /* Empty files don't set errno, so we get something like
289	     "install-info: No error for foo", which is confusing.  */
290	  if (errno == 0)
291	    fatal (_("%s: empty file"), name);
292	
293	  fatal (_("%s for %s"), strerror (errno), name);
294	}
295	
296	/* Compare the menu item names in LINE1 (line length LEN1)
297	   and LINE2 (line length LEN2).  Return 1 if the item name
298	   in LINE1 is less, 0 otherwise.  */
299	
300	static int
301	menu_line_lessp (char *line1, int len1, char *line2, int len2)
302	{
303	  int minlen = (len1 < len2 ? len1 : len2);
304	  int i;
305	
306	  for (i = 0; i < minlen; i++)
307	    {
308	      /* If one item name is a prefix of the other,
309	         the former one is less.  */
310	      if (line1[i] == ':' && line2[i] != ':')
311	        return 1;
312	      if (line2[i] == ':' && line1[i] != ':')
313	        return 0;
314	      /* If they both continue and differ, one is less.  */
315	      if (line1[i] < line2[i])
316	        return 1;
317	      if (line1[i] > line2[i])
318	        return 0;
319	    }
320	  /* With a properly formatted dir file,
321	     we can only get here if the item names are equal.  */
322	  return 0;
323	}
324	
325	/* Compare the menu item names in LINE1 (line length LEN1)
326	   and LINE2 (line length LEN2).  Return 1 if the item names are equal,
327	   0 otherwise.  */
328	
329	static int
330	menu_line_equal (char *line1, int len1, char *line2, int len2)
331	{
332	  int minlen = (len1 < len2 ? len1 : len2);
333	  int i;
334	
335	  for (i = 0; i < minlen; i++)
336	    {
337	      /* If both item names end here, they are equal.  */
338	      if (line1[i] == ':' && line2[i] == ':')
339	        return 1;
340	      /* If they both continue and differ, one is less.  */
341	      if (line1[i] != line2[i])
342	        return 0;
343	    }
344	  /* With a properly formatted dir file,
345	     we can only get here if the item names are equal.  */
346	  return 1;
347	}
348	
349	
350	/* Given the full text of a menu entry, null terminated,
351	   return just the menu item name (copied).  */
352	
353	char *
354	extract_menu_item_name (char *item_text)
355	{
356	  char *p;
357	
358	  if (*item_text == '*')
359	    item_text++;
360	  while (*item_text == ' ')
361	    item_text++;
362	
363	  p = item_text;
364	  while (*p && *p != ':') p++;
365	  return copy_string (item_text, p - item_text);
366	}
367	
368	/* Given the full text of a menu entry, terminated by null or newline,
369	   return just the menu item file (copied).  */
370	
371	char *
372	extract_menu_file_name (char *item_text)
373	{
374	  char *p = item_text;
375	
376	  /* If we have text that looks like * ITEM: (FILE)NODE...,
377	     extract just FILE.  Otherwise return "(none)".  */
378	
379	  if (*p == '*')
380	    p++;
381	  while (*p == ' ')
382	    p++;
383	
384	  /* Skip to and past the colon.  */
385	  while (*p && *p != '\n' && *p != ':') p++;
386	  if (*p == ':') p++;
387	
388	  /* Skip past the open-paren.  */
389	  while (1)
390	    {
391	      if (*p == '(')
392	        break;
393	      else if (*p == ' ' || *p == '\t')
394	        p++;
395	      else
396	        return "(none)";
397	    }
398	  p++;
399	
400	  item_text = p;
401	
402	  /* File name ends just before the close-paren.  */
403	  while (*p && *p != '\n' && *p != ')') p++;
404	  if (*p != ')')
405	    return "(none)";
406	
407	  return copy_string (item_text, p - item_text);
408	}
409	
410	
411	
412	/* Return FNAME with any [.info][.gz] suffix removed.  */
413	
414	static char *
415	strip_info_suffix (char *fname)
416	{
417	  char *ret = xstrdup (fname);
418	  unsigned len = strlen (ret);
419	
420	  if (len > 3 && FILENAME_CMP (ret + len - 3, ".gz") == 0)
421	    {
422	      len -= 3;
423	      ret[len] = 0;
424	    }
425	  else if (len > 3 && FILENAME_CMP (ret + len - 3, ".xz") == 0)
426	    {
427	      len -= 3;
428	      ret[len] = 0;
429	    }
430	  else if (len > 4 && FILENAME_CMP (ret + len - 4, ".bz2") == 0)
431	    {
432	      len -= 4;
433	      ret[len] = 0;
434	    }
435	  else if (len > 3 && FILENAME_CMP (ret + len - 3, ".lz") == 0)
436	    {
437	      len -= 3;
438	      ret[len] = 0;
439	    }
440	  else if (len > 5 && FILENAME_CMP (ret + len - 5, ".lzma") == 0)
441	   {
442	      len -= 5;
443	      ret[len] =0;
444	   }
445	
446	  if (len > 5 && FILENAME_CMP (ret + len - 5, ".info") == 0)
447	    {
448	      len -= 5;
449	      ret[len] = 0;
450	    }
451	  else if (len > 4 && FILENAME_CMP (ret + len - 4, ".inf") == 0)
452	    {
453	      len -= 4;
454	      ret[len] = 0;
455	    }
456	#ifdef __MSDOS__
457	  else if (len > 4 && (FILENAME_CMP (ret + len - 4, ".inz") == 0
458	                       || FILENAME_CMP (ret + len - 4, ".igz") == 0))
459	    {
460	      len -= 4;
461	      ret[len] = 0;
462	    }
463	#endif /* __MSDOS__ */
464	
465	  return ret;
466	}
467	
468	
469	/* Return true if ITEM matches NAME and is followed by TERM_CHAR.  ITEM
470	   can also be followed by `.gz', `.info.gz', or `.info' (and then
471	   TERM_CHAR) and still match.  */
472	
473	static int
474	menu_item_equal (const char *item, char term_char, const char *name)
475	{
476	  int ret;
477	  const char *item_basename = item;
478	  unsigned name_len = strlen (name);
479	
480	  /* We must compare the basename in ITEM, since we are passed the
481	     basename of the original info file.  Otherwise, a new entry like
482	     "lilypond/lilypond" won't match "lilypond".
483	     
484	     Actually, it seems to me that we should really compare the whole
485	     name, and not just the basename.  Couldn't there be dir1/foo.info
486	     and dir2/foo.info?  Also, it seems like we should be using the
487	     filename from the new dir entries, not the filename on the command
488	     line.  Not worrying about those things right now, though.  --karl,
489	     26mar04.  */
490	  if (!remove_exactly) {
491	  while (*item_basename && !IS_SLASH (*item_basename)
492	         && *item_basename != term_char)
493	    item_basename++;
494	  if (! *item_basename || *item_basename == term_char)
495	    item_basename = item;  /* no /, use original */
496	  else
497	    item_basename++;       /* have /, move past it */
498	  }
499	    
500	  /* First, ITEM must actually match NAME (usually it won't).  */
501	  ret = mbsncasecmp (item_basename, name, name_len) == 0;
502	  if (ret)
503	    {
504	      /* Then, `foobar' doesn't match `foo', so be sure we've got all of
505	         ITEM.  The various suffixes should never actually appear in the
506	         dir file, but sometimes people put them in.  */
507	      static char *suffixes[]
508	        = { "", ".info.gz", ".info", ".inf", ".gz",
509	#ifdef __MSDOS__
510	            ".inz", ".igz",
511	#endif
512	            NULL };
513	      unsigned i;
514	      ret = 0;
515	      for (i = 0; !ret && suffixes[i]; i++)
516	        {
517	          char *suffix = suffixes[i];
518	          unsigned suffix_len = strlen (suffix);
519	          ret = mbsncasecmp (item_basename + name_len, suffix, suffix_len) == 0
520	                && item_basename[name_len + suffix_len] == term_char;
521	        }
522	    }
523	
524	  return ret;
525	}
526	
527	
528	
529	void
530	suggest_asking_for_help (void)
531	{
532	  fprintf (stderr, _("\tTry `%s --help' for a complete list of options.\n"),
533	           progname);
534	  exit (EXIT_FAILURE);
535	}
536	
537	void
538	print_help (void)
539	{
540	  printf (_("Usage: %s [OPTION]... [INFO-FILE [DIR-FILE]]\n"), progname);
541	  puts ("");
542	  puts (_("Add or remove entries in INFO-FILE from the Info directory DIR-FILE."));
543	  puts (_("INFO-FILE and DIR-FILE are required unless the --info-file\n\
544	or --dir-file (or --info-dir) options are given, respectively."));
545	  puts ("");
546	
547	  puts (_("\
548	Options:\n\
549	 --add-once          add only to first matching section, not all.\n\
550	 --align=COL         start description of new entries at column COL.\n\
551	 --calign=COL        format second and subsequent description lines to\n\
552	                       start at column COL."));
553	
554	  puts (_("\
555	 --debug             report what is being done.\n\
556	 --delete            delete existing entries for INFO-FILE from DIR-FILE;\n\
557	                      don't insert any new entries.\n\
558	 --defsection=TEXT   like --section, but only use TEXT if no sections\n\
559	                      are present in INFO-FILE (replacing \"Miscellaneous\").\n\
560	 --description=TEXT  the description of the entry is TEXT; used with\n\
561	                      the --name option to become synonymous with the\n\
562	                      --entry option.\n\
563	 --dir-file=NAME     specify file name of Info directory file;\n\
564	                      equivalent to using the DIR-FILE argument.\n\
565	 --dry-run           same as --test."));
566	
567	  puts (_("\
568	 --entry=TEXT        insert TEXT as an Info directory entry,\n\
569	                      overriding any corresponding entry from DIR-FILE.\n\
570	                      TEXT is written as an Info menu item line followed\n\
571	                       by zero or more extra lines starting with whitespace.\n\
572	                      If you specify more than one entry, all are added.\n\
573	                      If you don't specify any entries, they are determined\n\
574	                       from information in the Info file itself."));
575	
576	  puts (_("\
577	 --help              display this help and exit.\n\
578	 --info-dir=DIR      same as --dir-file=DIR/dir.\n\
579	 --info-file=FILE    specify Info file to install in the directory;\n\
580	                      equivalent to using the INFO-FILE argument.\n\
581	 --item=TEXT         same as --entry=TEXT.\n\
582	 --keep-old          do not replace entries, or remove empty sections."));
583	
584	  puts (_("\
585	 --maxwidth, --max-width=COL  wrap description at column COL.\n\
586	 --menuentry=TEXT    same as --name=TEXT.\n\
587	 --name=TEXT         the name of the entry is TEXT; used with --description\n\
588	                      to become synonymous with the --entry option.\n\
589	 --no-indent         do not format new entries in the DIR file.\n\
590	 --quiet             suppress warnings."));
591	
592	  puts (_("\
593	 --regex=R           put this file's entries in all sections that match the\n\
594	                      regular expression R (ignoring case).\n\
595	 --remove            same as --delete.\n\
596	 --remove-exactly    only remove if the info file name matches exactly;\n\
597	                      suffixes such as .info and .gz are not ignored.\n\
598	 --section=SEC       put entries in section SEC of the directory.\n\
599	                      If you specify more than one section, all the entries\n\
600	                       are added in each of the sections.\n\
601	                      If you don't specify any sections, they are determined\n\
602	                       from information in the Info file itself;\n\
603	                       if nothing is available there, the --defsection\n\
604	                       value is used; if that is not specified, the\n\
605	                       final default is \"Miscellaneous\".\n\
606	 --section R SEC     equivalent to --regex=R --section=SEC --add-once."));
607	
608	  puts (_("\
609	 --silent            suppress warnings.\n\
610	 --test              suppress updating of DIR-FILE.\n\
611	 --version           display version information and exit."));
612	
613	  puts ("");
614	  
615	  puts (_("\
616	Email bug reports to bug-texinfo@gnu.org,\n\
617	general questions and discussion to help-texinfo@gnu.org.\n\
618	Texinfo home page: http://www.gnu.org/software/texinfo/"));
619	}
620	
621	
622	/* If DIRFILE does not exist, and we are not in test mode, create a
623	   minimal one (or abort).  If it already exists, do nothing.  */
624	
625	static void
626	ensure_dirfile_exists (char *dirfile)
627	{
628	  int desc;
629	  
630	  if (chicken_flag)
631	    return;
632	    
633	  desc = open (dirfile, O_RDONLY);
634	  if (desc < 0 && errno == ENOENT)
635	    {
636	      FILE *f;
637	      char *readerr = strerror (errno);
638	      close (desc);
639	      f = fopen (dirfile, "w");
640	      if (f)
641	        {
642	          fprintf (f, _("This is the file .../info/dir, which contains the\n\
643	topmost node of the Info hierarchy, called (dir)Top.\n\
644	The first time you invoke Info you start off looking at this node.\n\
645	%c\n\
646	%s\tThis is the top of the INFO tree\n\
647	\n\
648	  This (the Directory node) gives a menu of major topics.\n\
649	  Typing \"q\" exits, \"?\" lists all Info commands, \"d\" returns here,\n\
650	  \"h\" gives a primer for first-timers,\n\
651	  \"mEmacs<Return>\" visits the Emacs manual, etc.\n\
652	\n\
653	  In Emacs, you can click mouse button 2 on a menu item or cross reference\n\
654	  to select it.\n\
655	\n\
656	%s\n\
657	"),         /* These keywords must not be translated:  */
658	            '\x1f',  "File: dir,\tNode: Top",  "* Menu:"
659	          );
660	          if (fclose (f) < 0)
661	            pfatal_with_name (dirfile);
662	        }
663	      else
664	        {
665	          /* Didn't exist, but couldn't open for writing.  */
666		  fatal (_("%s: could not read (%s) and could not create (%s)"),
667			 dirfile, readerr, strerror (errno));
668	        }
669	    }
670	  else
671	    close (desc); /* It already existed, so fine.  */
672	}
673	
674	/* Open FILENAME and return the resulting stream pointer.  If it doesn't
675	   exist, try FILENAME.gz.  If that doesn't exist either, call
676	   CREATE_CALLBACK (with FILENAME as arg) to create it, if that is
677	   non-NULL.  If still no luck, return a null pointer.
678	
679	   Return the actual name of the file we tried to open in
680	   OPENED_FILENAME and the compress program to (de)compress it in
681	   COMPRESSION_PROGRAM.  The compression program is determined by the
682	   magic number, not the filename.
683	   
684	   Return either stdin reading the file, or a non-stdin pipe reading
685	   the output of the compression program.  */
686	FILE *
687	open_possibly_compressed_file (char *filename,
688	    void (*create_callback) (char *),
689	    char **opened_filename, char **compression_program) 
690	{
691	  char *local_opened_filename, *local_compression_program;
692	  int nread;
693	  char data[13];
694	  FILE *f;
695	
696	  /* We let them pass NULL if they don't want this info, but it's easier
697	     to always determine it.  */
698	  if (!opened_filename)
699	    opened_filename = &local_opened_filename;
700	
701	  *opened_filename = filename;
702	  f = fopen (*opened_filename, FOPEN_RBIN);
703	  if (!f)
704	    {
705	      *opened_filename = concat (filename, ".gz", "");
706	      f = fopen (*opened_filename, FOPEN_RBIN);
707	    }
708	  if (!f)
709	    {
710	      free (*opened_filename);
711	      *opened_filename = concat (filename, ".xz", "");
712	      f = fopen (*opened_filename, FOPEN_RBIN);
713	    }
714	  if (!f)
715	    {
716	      free (*opened_filename);
717	      *opened_filename = concat (filename, ".bz2", "");
718	      f = fopen (*opened_filename, FOPEN_RBIN);
719	    }
720	  if (!f)
721	    {
722	      free (*opened_filename);
723	      *opened_filename = concat (filename, ".lz", "");
724	      f = fopen (*opened_filename, FOPEN_RBIN);
725	    }
726	  if (!f)
727	    {
728	     free (*opened_filename);
729	     *opened_filename = concat (filename, ".lzma", "");
730	     f = fopen (*opened_filename, FOPEN_RBIN);
731	    }
732	#ifdef __MSDOS__
733	  if (!f)
734	    {
735	      free (*opened_filename);
736	      *opened_filename = concat (filename, ".igz", "");
737	      f = fopen (*opened_filename, FOPEN_RBIN);
738	    }
739	  if (!f)
740	    {
741	      free (*opened_filename);
742	      *opened_filename = concat (filename, ".inz", "");
743	      f = fopen (*opened_filename, FOPEN_RBIN);
744	    }
745	#endif /* __MSDOS__ */
746	  if (!f)
747	    {
748	      /* The file was not found with any extention added.  Try the
749	         original file again. */
750	      free (*opened_filename);
751	      *opened_filename = filename;
752	
753	      if (create_callback)
754	        {
755	          /* Create the file if we can.  */
756	          (*create_callback) (filename);
757	
758	          /* And try opening it again.  */
759	          f = fopen (*opened_filename, FOPEN_RBIN);
760	          if (!f)
761	            return 0;
762	        }
763	      else
764	        return 0;
765	    }
766	
767	  /* Read first few bytes of file rather than relying on the filename.
768	     If the file is shorter than this it can't be usable anyway.  */
769	  nread = fread (data, sizeof (data), 1, f);
770	  if (nread != 1)
771	    {
772	      /* Empty files don't set errno.  Calling code can check for
773	         this, so make sure errno == 0 just in case it isn't already. */
774	      if (nread == 0)
775	        errno = 0;
776	      return 0;
777	    }
778	
779	  if (!compression_program)
780	    compression_program = &local_compression_program;
781	
782	  if (data[0] == '\x1f' && data[1] == '\x8b')
783	#if STRIP_DOT_EXE
784	    /* An explicit .exe yields a better diagnostics from popen below
785	       if they don't have gzip installed.  */
786	    *compression_program = "gzip.exe";
787	#else
788	    *compression_program = "gzip";
789	#endif
790	
791	  else if (data[0] == '\xFD' && data[1] == '7' && data[2] == 'z'
792	           && data[3] == 'X' && data[4] == 'Z' && data[5] == 0)
793	#ifndef STRIP_DOT_EXE
794	    *compression_program = "xz.exe";
795	#else
796	    *compression_program = "xz";
797	#endif
798	
799	  else if (data[0] == 'B' && data[1] == 'Z' && data[2] == 'h')
800	#ifndef STRIP_DOT_EXE
801	    *compression_program = "bzip2.exe";
802	#else
803	    *compression_program = "bzip2";
804	#endif
805	
806	  else if (data[0] == 'B' && data[1] == 'Z' && data[2] == '0')
807	#ifndef STRIP_DOT_EXE
808	    *compression_program = "bzip.exe";
809	#else
810	    *compression_program = "bzip";
811	#endif
812	
813	  else if (data[0] == 0x4C && data[1] == 0x5A && data[2] == 0x49
814	           && data[3] == 0x50 && data[4] == 1)		/* "LZIP" */
815	#ifndef STRIP_DOT_EXE
816	    *compression_program = "lzip.exe";
817	#else
818	    *compression_program = "lzip";
819	#endif
820	
821	    /* We (try to) match against old lzma format (which lacks proper
822	       header, two first matches), as well as the new format (last match).  */
823	  else if ((data[9] == 0x00 && data[10] == 0x00 && data[11] == 0x00
824	            && data[12] == 0x00)
825	           || (data[5] == '\xFF' && data[6] == '\xFF' && data[7] == '\xFF'
826	               && data[8] == '\xFF' && data[9] == '\xFF' && data[10] == '\xFF'
827	               && data[11] == '\xFF' && data[12] == '\xFF') 
828	           || (data[0] == '\xFF' && data[1] == 'L' && data[2] == 'Z'
829	               && data[3] == 'M' && data[4] == 'A' && data[5] == 0x00))
830	#ifndef STRIP_DOT_EXE
831	    *compression_program = "lzma.exe";
832	#else
833	    *compression_program = "lzma";
834	#endif
835	
836	  else
837	    *compression_program = NULL;
838	
839	  /* Seek back over the magic bytes.  */
840	  if (fseek (f, 0, 0) < 0)
841	    return 0;
842	
843	  if (*compression_program)
844	    { /* It's compressed, so open a pipe.  */
845	      char *command = concat (*compression_program, " -d", "");
846	
847	      if (fclose (f) < 0)
848	        return 0;
849	      f = freopen (*opened_filename, FOPEN_RBIN, stdin);
850	      if (!f)
851	        return 0;
852	      f = popen (command, "r");
853	      if (!f)
854	        {
855	          /* Used for error message in calling code. */
856	          *opened_filename = command;
857	          return 0;
858	        }
859	    }
860	  else
861	    {
862	#if O_BINARY
863	      /* Since this is a text file, and we opened it in binary mode,
864	         switch back to text mode.  */
865	      f = freopen (*opened_filename, "r", f);
866	      if (! f)
867		return 0;
868	#endif
869	    }
870	
871	  return f;
872	}
873	
874	/* Read all of file FILENAME into memory and return the address of the
875	   data.  Store the size of the data into SIZEP.  If need be, uncompress
876	   (i.e., try FILENAME.gz et al. if FILENAME does not exist) and store
877	   the actual file name that was opened into OPENED_FILENAME (if it is
878	   non-NULL), and the companion compression program (if any, else NULL)
879	   into COMPRESSION_PROGRAM (if that is non-NULL).  If trouble, return
880	   a null pointer. */
881	
882	char *
883	readfile (char *filename, int *sizep,
884	    void (*create_callback) (char *), char **opened_filename,
885	    char **compression_program)
886	{
887	  FILE *f;
888	  int filled = 0;
889	  int data_size = 8192;
890	  char *data = xmalloc (data_size);
891	
892	  /* If they passed the space for the file name to return, use it.  */
893	  f = open_possibly_compressed_file (filename, create_callback,
894	                                     opened_filename,
895	                                     compression_program);
896	
897	  if (!f)
898	    return 0;
899	
900	  for (;;)
901	    {
902	      int nread = fread (data + filled, 1, data_size - filled, f);
903	      if (nread < 0)
904	        return 0;
905	      if (nread == 0)
906	        break;
907	
908	      filled += nread;
909	      if (filled == data_size)
910	        {
911	          data_size += 65536;
912	          data = xrealloc (data, data_size);
913	        }
914	    }
915	
916	  /* We'll end up wasting space if we're not passing the filename back
917	     and it is not just FILENAME, but so what.  */
918	  /* We need to close the stream, since on some systems the pipe created
919	     by popen is simulated by a temporary file which only gets removed
920	     inside pclose.  */
921	  if (f != stdin)
922	    pclose (f);
923	
924	  *sizep = filled;
925	  return data;
926	}
927	
928	/* Output the old dir file, interpolating the new sections
929	   and/or new entries where appropriate.  If COMPRESSION_PROGRAM is not
930	   null, pipe to it to create DIRFILE.  Thus if we read dir.gz on input,
931	   we'll write dir.gz on output.  */
932	
933	static void
934	output_dirfile (char *dirfile, int dir_nlines, struct line_data *dir_lines,
935	                int n_entries_to_add, struct spec_entry *entries_to_add,
936	                struct spec_section *input_sections, char *compression_program)
937	{
938	  int n_entries_added = 0;
939	  int i;
940	  FILE *output;
941	
942	  if (compression_program)
943	    {
944	      char *command = concat (compression_program, ">", dirfile);
945	      output = popen (command, "w");
946	    }
947	  else
948	    output = fopen (dirfile, "w");
949	
950	  if (!output)
951	    {
952	      perror (dirfile);
953	      exit (EXIT_FAILURE);
954	    }
955	
956	  for (i = 0; i <= dir_nlines; i++)
957	    {
958	      int j;
959	
960	      /* If we decided to output some new entries before this line,
961	         output them now.  */
962	      if (dir_lines[i].add_entries_before)
963	        for (j = 0; j < n_entries_to_add; j++)
964	          {
965	            struct spec_entry *this = dir_lines[i].add_entries_before[j];
966	            if (this == 0)
967	              break;
968	            if (n_entries_added >= 1 && 
969	                !add_entries_into_all_matching_sections)
970	              break;
971	            fputs (this->text, output);
972	            n_entries_added++;
973	          }
974	      /* If we decided to add some sections here
975	         because there are no such sections in the file,
976	         output them now.  
977	         FIXME:  we add all sections here, but they should
978	         be interspersed throughout the DIR file in 
979	         alphabetic order. */
980	      if (dir_lines[i].add_sections_before)
981	        {
982	          struct spec_section *spec;
983	          struct spec_entry *entry;
984	          struct spec_entry **entries;
985	          int n_entries = 0;
986	
987	          /* If we specified --add-once, and we've added an entry, then
988	             it's time to bail. */
989	          if (n_entries_added >= 1 && 
990	              !add_entries_into_all_matching_sections)
991	            break;
992	
993	          qsort (dir_lines[i].add_sections_before, 
994	                 dir_lines[i].num_sections_to_add, 
995	                 sizeof (struct spec_section *), compare_section_names);
996	
997	          /* Count the entries and allocate a vector for all of them.  */
998	          for (entry = entries_to_add; entry; entry = entry->next)
999	            n_entries++;
1000	          entries = ((struct spec_entry **)
1001	                     xmalloc (n_entries * sizeof (struct spec_entry *)));
1002	
1003	          /* Fill the vector ENTRIES with pointers to all the sections,
1004	             and sort them.  */
1005	          j = 0;
1006	          for (entry = entries_to_add; entry; entry = entry->next)
1007	            entries[j++] = entry;
1008	          qsort (entries, n_entries, sizeof (struct spec_entry *),
1009	                 compare_entries_text);
1010	
1011	          /* Generate the new sections in alphabetical order.  In each
1012	             new section, output all of the entries that belong to that
1013	             section, in alphabetical order.  */
1014	          for (j = 0; j < dir_lines[i].num_sections_to_add; j++)
1015	            {
1016	              spec = dir_lines[i].add_sections_before[j];
1017	              if (spec->missing)
1018	                {
1019	                  int k;
1020	
1021	                  putc ('\n', output);
1022	                  fputs (spec->name, output);
1023	                  putc ('\n', output);
1024	                  spec->missing = 0;
1025	                  for (k = 0; k < n_entries; k++)
1026	                    {
1027	                      struct spec_section *spec1;
1028	                      /* Did they at all want this entry to be put into
1029	                         this section?  */
1030	                      entry = entries[k];
1031	                      for (spec1 = entry->entry_sections;
1032	                           spec1 && spec1 != entry->entry_sections_tail;
1033	                           spec1 = spec1->next)
1034	                        {
1035	                          if (!strcmp (spec1->name, spec->name))
1036	                            break;
1037	                        }
1038	                      if (spec1 && spec1 != entry->entry_sections_tail)
1039	                        fputs (entry->text, output);
1040	                    }
1041	                }
1042	            }
1043	
1044	          n_entries_added++;
1045	          free (entries);
1046	        }
1047	
1048	      /* Output the original dir lines unless marked for deletion.  */
1049	      if (i < dir_nlines && !dir_lines[i].delete)
1050	        {
1051	          fwrite (dir_lines[i].start, 1, dir_lines[i].size, output);
1052	          putc ('\n', output);
1053	        }
1054	    }
1055	
1056	  /* Some systems, such as MS-DOS, simulate pipes with temporary files.
1057	     On those systems, the compressor actually gets run inside pclose,
1058	     so we must call pclose.  */
1059	  if (compression_program)
1060	    pclose (output);
1061	  else
1062	    fclose (output);
1063	}
1064	
1065	/* Parse the input to find the section names and the entry names it
1066	   specifies.  Return the number of entries to add from this file.  */
1067	int
1068	parse_input (const struct line_data *lines, int nlines,
1069	             struct spec_section **sections, struct spec_entry **entries,
1070	             int delete_flag) 
1071	{
1072	  int n_entries = 0;
1073	  int prefix_length = strlen ("INFO-DIR-SECTION ");
1074	  struct spec_section *head = *sections, *tail = NULL;
1075	  int reset_tail = 0;
1076	  char *start_of_this_entry = 0;
1077	  int ignore_sections = *sections != 0;
1078	  int ignore_entries  = delete_flag ? 0: *entries  != 0;
1079	
1080	  int i;
1081	
1082	  if (ignore_sections && ignore_entries)
1083	    return 0;
1084	
1085	  /* Loop here processing lines from the input file.  Each
1086	     INFO-DIR-SECTION entry is added to the SECTIONS linked list.
1087	     Each START-INFO-DIR-ENTRY block is added to the ENTRIES linked
1088	     list, and all its entries inherit the chain of SECTION entries
1089	     defined by the last group of INFO-DIR-SECTION entries we have
1090	     seen until that point.  */
1091	  for (i = 0; i < nlines; i++)
1092	    {
1093	      if (!ignore_sections
1094	          && !strncmp ("INFO-DIR-SECTION ", lines[i].start, prefix_length))
1095	        {
1096	          struct spec_section *next
1097	            = (struct spec_section *) xmalloc (sizeof (struct spec_section));
1098	          next->name = copy_string (lines[i].start + prefix_length,
1099	                                    lines[i].size - prefix_length);
1100	          next->next = *sections;
1101	          next->missing = 1;
1102	          if (reset_tail)
1103	            {
1104	              tail = *sections;
1105	              reset_tail = 0;
1106	            }
1107	          *sections = next;
1108	          head = *sections;
1109	        }
1110	      /* If entries were specified explicitly with command options,
1111	         ignore the entries in the input file.  */
1112	      else if (!ignore_entries)
1113	        {
1114	          if (!strncmp ("START-INFO-DIR-ENTRY", lines[i].start, lines[i].size)
1115	              && sizeof ("START-INFO-DIR-ENTRY") - 1 == lines[i].size)
1116	            {
1117	              if (!*sections)
1118	                {
1119	                  /* We found an entry, but didn't yet see any sections
1120	                     specified.  Default to section "Miscellaneous".  */
1121	                  *sections = (struct spec_section *)
1122	                    xmalloc (sizeof (struct spec_section));
1123	                  (*sections)->name = "Miscellaneous";
1124	                  (*sections)->next = 0;
1125	                  (*sections)->missing = 1;
1126	                  head = *sections;
1127	                }
1128	              /* Next time we see INFO-DIR-SECTION, we will reset the
1129	                 tail pointer.  */
1130	              reset_tail = 1;
1131	
1132	              if (start_of_this_entry != 0)
1133	                fatal (_("START-INFO-DIR-ENTRY without matching END-INFO-DIR-ENTRY"));
1134	              start_of_this_entry = lines[i + 1].start;
1135	            }
1136	          else if (start_of_this_entry)
1137	            {
1138	              if ((!strncmp ("* ", lines[i].start, 2)
1139	                   && lines[i].start > start_of_this_entry)
1140	                  || (!strncmp ("END-INFO-DIR-ENTRY",
1141	                                lines[i].start, lines[i].size)
1142	                      && sizeof ("END-INFO-DIR-ENTRY") - 1 == lines[i].size))
1143	                {
1144	                  /* We found an end of this entry.  Allocate another
1145	                     entry, fill its data, and add it to the linked
1146	                     list.  */
1147	                  struct spec_entry *next
1148	                    = (struct spec_entry *) xmalloc (sizeof (struct spec_entry));
1149	                  next->text
1150	                    = copy_string (start_of_this_entry,
1151	                                   lines[i].start - start_of_this_entry);
1152	                  next->text_len = lines[i].start - start_of_this_entry;
1153	                  next->entry_sections = head;
1154	                  next->entry_sections_tail = tail;
1155	                  next->next = *entries;
1156	                  *entries = next;
1157	                  n_entries++;
1158	                  if (!strncmp ("END-INFO-DIR-ENTRY",
1159	                                lines[i].start, lines[i].size)
1160	                      && sizeof ("END-INFO-DIR-ENTRY") - 1 == lines[i].size)
1161	                    start_of_this_entry = 0;
1162	                  else
1163	                    start_of_this_entry = lines[i].start;
1164	                }
1165	              else if (!strncmp ("END-INFO-DIR-ENTRY",
1166	                                 lines[i].start, lines[i].size)
1167	                       && sizeof ("END-INFO-DIR-ENTRY") - 1 == lines[i].size)
1168	                fatal (_("END-INFO-DIR-ENTRY without matching START-INFO-DIR-ENTRY"));
1169	            }
1170	        }
1171	    }
1172	  if (start_of_this_entry != 0)
1173	    fatal (_("START-INFO-DIR-ENTRY without matching END-INFO-DIR-ENTRY"));
1174	
1175	  /* If we ignored the INFO-DIR-ENTRY directives, we need now go back
1176	     and plug the names of all the sections we found into every
1177	     element of the ENTRIES list.  */
1178	  if (ignore_entries && *entries)
1179	    {
1180	      struct spec_entry *entry;
1181	
1182	      for (entry = *entries; entry; entry = entry->next)
1183	        {
1184	          entry->entry_sections = head;
1185	          entry->entry_sections_tail = tail;
1186	        }
1187	    }
1188	
1189	  return n_entries;
1190	}
1191	
1192	
1193	/* Parse the dir file whose basename is BASE_NAME.  Find all the
1194	   nodes, and their menus, and the sections of their menus.  */
1195	static void
1196	parse_dir_file (struct line_data *lines, int nlines, struct node **nodes)
1197	{
1198	  int node_header_flag = 0;
1199	  int i;
1200	
1201	  *nodes = 0;
1202	  for (i = 0; i < nlines; i++)
1203	    {
1204	      /* Parse node header lines.  */
1205	      if (node_header_flag)
1206	        {
1207	          int j, end;
1208	          for (j = 0; j < lines[i].size; j++)
1209	            /* Find the node name and store it in the `struct node'.  */
1210	            if (!strncmp ("Node:", lines[i].start + j, 5))
1211	              {
1212	                char *line = lines[i].start;
1213	                /* Find the start of the node name.  */
1214	                j += 5;
1215	                while (line[j] == ' ' || line[j] == '\t')
1216	                  j++;
1217	                /* Find the end of the node name.  */
1218	                end = j;
1219	                while (line[end] != 0 && line[end] != ',' && line[end] != '\n'
1220	                       && line[end] != '\t')
1221	                  end++;
1222	                (*nodes)->name = copy_string (line + j, end - j);
1223	              }
1224	          node_header_flag = 0;
1225	        }
1226	
1227	      /* Notice the start of a node.  */
1228	      if (*lines[i].start == 037)
1229	        {
1230	          struct node *next = (struct node *) xmalloc (sizeof (struct node));
1231	
1232	          next->next = *nodes;
1233	          next->name = NULL;
1234	          next->start_line = i;
1235	          next->end_line = 0;
1236	          next->menu_start = NULL;
1237	          next->sections = NULL;
1238	          next->last_section = NULL;
1239	
1240	          if (*nodes != 0)
1241	            (*nodes)->end_line = i;
1242	          /* Fill in the end of the last menu section
1243	             of the previous node.  */
1244	          if (*nodes != 0 && (*nodes)->last_section != 0)
1245	            (*nodes)->last_section->end_line = i;
1246	
1247	          *nodes = next;
1248	
1249	          /* The following line is the header of this node;
1250	             parse it.  */
1251	          node_header_flag = 1;
1252	        }
1253	
1254	      /* Notice the lines that start menus.  */
1255	      if (*nodes != 0 && !strncmp ("* Menu:", lines[i].start, 7))
1256	        (*nodes)->menu_start = lines[i + 1].start;
1257	
1258	      /* Notice sections in menus.  */
1259	      if (*nodes != 0
1260	          && (*nodes)->menu_start != 0
1261	          && *lines[i].start != '\n'
1262	          && *lines[i].start != '*'
1263	          && *lines[i].start != ' '
1264	          && *lines[i].start != '\t')
1265	        {
1266	          /* Add this menu section to the node's list.
1267	             This list grows in forward order.  */
1268	          struct menu_section *next
1269	            = (struct menu_section *) xmalloc (sizeof (struct menu_section));
1270	
1271	          next->start_line = i + 1;
1272	          next->next = 0;
1273	          next->end_line = 0;
1274	          next->name = copy_string (lines[i].start, lines[i].size);
1275	          if ((*nodes)->sections)
1276	            {
1277	              (*nodes)->last_section->next = next;
1278	              (*nodes)->last_section->end_line = i;
1279	            }
1280	          else
1281	            (*nodes)->sections = next;
1282	          (*nodes)->last_section = next;
1283	        }
1284	
1285	    }
1286	
1287	  /* Finish the info about the end of the last node.  */
1288	  if (*nodes != 0)
1289	    {
1290	      (*nodes)->end_line = nlines;
1291	      if ((*nodes)->last_section != 0)
1292	        (*nodes)->last_section->end_line = nlines;
1293	    }
1294	}
1295	
1296	
1297	/* Iterate through NLINES LINES looking for an entry that has a name
1298	   that matches NAME.  If such an entry is found, flag the entry for 
1299	   deletion later on. */
1300	
1301	int
1302	mark_entry_for_deletion (struct line_data *lines, int nlines, char *name)
1303	{
1304	  int something_deleted = 0;
1305	  int i;
1306	  for (i = 0; i < nlines; i++)
1307	    {
1308	      /* Check for an existing entry that should be deleted.
1309	         Delete all entries which specify this file name.  */
1310	      if (*lines[i].start == '*')
1311	        {
1312	          char *q;
1313	          char *p = lines[i].start;
1314	
1315	          p++; /* skip * */
1316	          while (*p == ' ') p++; /* ignore following spaces */
1317	          q = p; /* remember this, it's the beginning of the menu item.  */
1318	
1319	          /* Read menu item.  */
1320	          while (*p != 0 && *p != ':')
1321	            p++;
1322	          p++; /* skip : */
1323	
1324	          if (*p == ':')
1325	            { /* XEmacs-style entry, as in * Mew::Messaging.  */
1326	              if (menu_item_equal (q, ':', name))
1327	                {
1328	                  lines[i].delete = 1;
1329	                  something_deleted = 1;
1330	                }
1331	            }
1332	          else
1333	            { /* Emacs-style entry, as in * Emacs: (emacs).  */
1334	              while (*p == ' ') p++; /* skip spaces after : */
1335	              if (*p == '(')         /* if at parenthesized (FILENAME) */
1336	                {
1337	                  p++;
1338	                  if (menu_item_equal (p, ')', name))
1339	                    {
1340	                      lines[i].delete = 1;
1341	                      something_deleted = 1;
1342	                    }
1343	                }
1344	            }
1345	        }
1346	
1347	      /* Treat lines that start with whitespace
1348	         as continuations; if we are deleting an entry,
1349	         delete all its continuations as well.  */
1350	      else if (i > 0 && (*lines[i].start == ' ' || *lines[i].start == '\t'))
1351	        {
1352	          lines[i].delete = lines[i - 1].delete;
1353	        }
1354	    }
1355	  return something_deleted;
1356	}
1357	
1358	
1359	/* Assuming the current column is COLUMN, return the column that
1360	   printing C will move the cursor to.
1361	   The first column is 0.
1362	   This function is used to assist in indenting of entries. */
1363	
1364	static size_t
1365	adjust_column (size_t column, char c)
1366	{
1367	  if (c == '\b')
1368	    {
1369	      if (column > 0)
1370	        column--;
1371	    }
1372	  else if (c == '\r')
1373	    column = 0;
1374	  else if (c == '\t')
1375	    column += TAB_WIDTH - column % TAB_WIDTH;
1376	  else                          /* if (isprint (c)) */
1377	    column++;
1378	  return column;
1379	}
1380	
1381	/* Indent the Info entry's NAME and DESCRIPTION.  Lines are wrapped at the
1382	   WIDTH column.  The description on first line is indented at the CALIGN-th 
1383	   column, and all subsequent lines are indented at the ALIGN-th column.  
1384	   The resulting Info entry is put into OUTSTR.
1385	   NAME is of the form "* TEXT (TEXT)[:TEXT].".
1386	 */
1387	static int
1388	format_entry (char *name, size_t name_len, char *desc, size_t desc_len, 
1389	              int calign, int align, size_t width, 
1390	              char **outstr, size_t *outstr_len)
1391	{
1392	  int i, j;
1393	  char c;
1394	  size_t column = 0;            /* Screen column where next char will go */
1395	  size_t offset_out = 0;        /* Index in `line_out' for next char. */
1396	  static char *line_out = NULL;
1397	  static size_t allocated_out = 0;
1398	  char *slice = xmalloc(30);
1399	  
1400	  if (!desc || !name)
1401	    return 1;
1402	
1403	  *outstr = malloc (width  + 
1404	                    (((desc_len  + width) / (width - align)) * width) * 2 
1405	                    * sizeof (char));
1406	  *outstr[0] = '\0';
1407	
1408	  strncat (*outstr, name, name_len);
1409	  printf ("aw3: line 1410, name added, *outstr is\n%s\n", *outstr);
1410	
1411	  column = name_len;
1412	
1413	  if (name_len > calign - 2)
1414	    {
1415	      /* Name is too long to have description on the same line. */
1416	      if (desc_len > 1)
1417	        {
1418	          strncat (*outstr, "\n", 1);
1419		  printf ("aw3: line 1420, *outstr is\n%s\n", *outstr);
1420	          column = 0;
1421	          for (j = 0; j < calign - 1; j++)
1422	            {
1423	              column = adjust_column (column, ' ');
1424	              strncat (*outstr, " ", 1);
1425		      printf ("aw3: line 1426, *outstr is\n%s\n", *outstr);
1426	            }
1427	        }
1428	    }
1429	  else
1430	    for (j = 0; j < calign - name_len - 1; j++)
1431	      {
1432	        if (desc_len <= 2)
1433	          break;
1434	        column = adjust_column (column, ' ');
1435	        strncat (*outstr, " ", 1);
1436	      }
1437	  printf ("aw3: line 1438, *outstr is\n%s\n", *outstr);
1438	
1439	  for (i = 0; i < desc_len; i++)
1440	    {
1441	      if (desc_len <= 2)
1442	        break;
1443	      c = desc[i];
1444	      if (offset_out + 1 >= allocated_out)
1445	        {
1446	          allocated_out = offset_out + 1;
1447	          line_out = (char *) realloc ((void *)line_out, allocated_out);
1448	        }
1449	
1450	      if (c == '\n')
1451	        {
1452		  printf ("aw3: line 1453, line_out before adding linefeed is\n%s\n",
1453			  line_out);
1454	          line_out[offset_out++] = c;
1455		  printf ("aw3: line 1456, line_out[offset_out] =%c\n", line_out[offset_out]);
1456		  printf ("aw3: line 1457, offset_out is %zu\n", offset_out);
1457		  /* printf ("aw3: line 1458, sizeof(*line_out) is %lu\n", sizeof(*line_out)); */
1458		  /* {int k;
1459		      for (k = offset_out; k <= sizeof(line_out); k++)
1460			{
1461			  printf ("aw3: line 1462, line_out[k] = %c\n", line_out[k]);
1462			}
1463		  } */
1464	
1465	          line_out = (char *) realloc ((void *)line_out, allocated_out+1);
1466		  line_out[offset_out+1] = '\0';
1467		  /* strncat (line_out, "\n", 1); */
1468		  printf ("aw3: line 1469, line_out after adding linefeed is\n%s\n", line_out);
1469		  printf ("aw3: line 1470, length of line_out is %zu\n", strlen(line_out));
1470		  printf ("aw3: line 1471, *outstr before call to strncat is\n%s\n", *outstr);
1471	          strncat (*outstr, line_out, offset_out);
1472		  /* strncat (*outstr, "\n",1); */
1473		  printf ("aw3: line 1474, *outstr after call to strncat is\n%s\n", *outstr);
1474	          column = offset_out = 0;
1475	          continue;
1476	        }
1477	
1478	    rescan:
1479	      column = adjust_column (column, c);
1480	
1481	      if (column > width)
1482	        {
1483	          /* This character would make the line too long.
1484	             Print the line plus a newline, and make this character
1485	             start the next line. */
1486	
1487	          int found_blank = 0;
1488	          size_t logical_end = offset_out;
1489	
1490	          /* Look for the last blank. */
1491	          while (logical_end)
1492	            {
1493	              --logical_end;
1494	              if (line_out[logical_end] == ' '
1495	                  || line_out[logical_end] == '\t')
1496	                {
1497	                  found_blank = 1;
1498	                  break;
1499	                }
1500	            }
1501	
1502	          if (found_blank)
1503	            {
1504	              size_t i;
1505	
1506	              /* Found a blank.  Don't output the part after it. */
1507	              logical_end++;
1508	              strncat (*outstr, line_out, logical_end);
1509	              strncat (*outstr, "\n", 1);
1510		      printf ("aw3: line 1511, found blank, *outstr is\n%s\n", *outstr);
1511	              for (j = 0; j < align - 1; j++)
1512	                {
1513	                  column = adjust_column (column, ' ');
1514	                  strncat (*outstr, " ", 1);
1515	                }
1516		      printf ("aw3: line 1517, after adj columns, *outstr is\n%s\n", *outstr);
1517		      
1518	
1519	              /* Move the remainder to the beginning of the next 
1520	                 line.
1521	                 The areas being copied here might overlap. */
1522	              memmove (line_out, line_out + logical_end,
1523	                       offset_out - logical_end);
1524	              offset_out -= logical_end;
1525	              for (column = i = 0; i < offset_out; i++)
1526	                column = adjust_column (column, line_out[i]);
1527	              goto rescan;
1528	            }
1529	
1530	          if (offset_out == 0)
1531	            {
1532	              line_out[offset_out++] = c;
1533	              continue;
1534	            }
1535	
1536	          line_out[offset_out++] = '\n';
1537	          strncat (*outstr, line_out, offset_out);
1538		  printf ("aw3: line 1539, line feed added, *outstr is\n%s\n", *outstr);
1539	
1540	          column = offset_out = 0;
1541	          goto rescan;
1542	        }
1543	
1544	      line_out[offset_out++] = c;
1545	    }
1546	
1547	  if (desc_len <= 2) {
1548	    strncat (*outstr, "\n", 1);
1549	    printf ("aw3: line 1550, desc_len <= 2, *outstr is\n%s\n", *outstr);
1550	  }
1551	
1552	  if (offset_out) {
1553	    strncat (*outstr, line_out, offset_out);
1554	    printf ("aw3: line 1555, *outstr is\n%s\n", *outstr);
1555	    }
1556	
1557	  *outstr_len = strlen (*outstr);
1558	  return 1;
1559	}
1560	
1561	
1562	/* Extract the NAME and DESCRIPTION from ENTRY.  NAME and DESCRIPTION must be
1563	   free'd.
1564	 */
1565	static void
1566	split_entry (const char *entry, char **name, size_t *name_len,
1567	             char **description, size_t *description_len)
1568	{
1569	  char *endptr;
1570	
1571	  /* on the first line, the description starts after the first ". ";
1572	     that's a period and space -- our heuristic to handle item names like
1573	     "config.status", and node names like "config.status Invocation".
1574	     Also accept period-tab and period-newline.  */
1575	  char *ptr = strchr (entry, '.');
1576	  while (ptr && ptr[1] != ' ' && ptr[1] != '\t' && ptr[1] != '\n') {
1577	    ptr = strchr (ptr + 1, '.');
1578	  }
1579	  
1580	  /* Maybe there's no period, and no description */
1581	  if (!ptr)
1582	    {
1583	      size_t length = strlen (entry);
1584	      if (length == 0)
1585	        return;
1586	      *name = strdup (entry);
1587	      *name_len = length + 1;
1588	      return;
1589	    }
1590	
1591	  /* The name is everything up to and including the period. */
1592	  *name_len = (size_t) (ptr - entry + 1);
1593	  *name = xmalloc (*name_len + 1);
1594	  (*name)[0] = '\0';
1595	  strncat (*name, entry, *name_len);
1596	
1597	  ptr++;
1598	  *description = xmalloc (strlen (entry));
1599	  (*description)[0] = '\0';
1600	
1601	  while (ptr[0] != '\0')
1602	    {
1603	      /* Eat up the whitespace after the name, and at the start of a line. */
1604	      while (isspace(ptr[0]))
1605	        ptr++;
1606	
1607	      /* Okay, we're at the start of the description. */
1608	      if (ptr[0] == '\0')
1609	        continue;
1610	
1611	      /* See how far the description goes... */
1612	      endptr = strchr (ptr, '\n');
1613	      /* Either the description continues up to the next newline. */
1614	      if (endptr)
1615	        {
1616	          size_t length  = (size_t) (endptr - ptr) / sizeof (char);
1617	          strncat (*description, ptr, length);
1618	          ptr = endptr;
1619	          /* First of all, we eat the newline here.  But then what?
1620	             Sometimes the newline separates 2 sentences, so we
1621	             end up with the next word starting directly after the period,
1622	             instead of after the customary 2 spaces in english. 
1623	             If the previous character was a `.', then we should add 2
1624	             spaces if there is anything on the next line.
1625	             if it's a comma, then we should put one space.
1626	             If it's neither, we just put a space.
1627	             If it's some other whitespace, we shouldn't do anything. */
1628	          ptr++;
1629	          if (length > 1 && strlen (ptr) > 0)
1630	            {
1631	              endptr--;
1632	              /* *ENDPTR is the 2nd last character */
1633	              if (*endptr == '.')
1634	                strncat (*description, "  ", 2);
1635	              else if (!isspace (*endptr))
1636	                strncat (*description, " ", 1);
1637	            }
1638	        }
1639	      /* Or the description continues to the end of the string. */
1640	      else
1641	        {
1642	          /* Just show the rest when there's no newline. */
1643	          size_t length = strlen (ptr);
1644	          strncat (*description, ptr, length);
1645	          ptr += length;
1646	        }
1647	    }
1648	  /* Descriptions end in a new line. */
1649	  strncat (*description, "\n", 1);
1650	  *description_len = strlen (*description);
1651	}
1652	
1653	
1654	/* Indent all ENTRIES according to some formatting options. 
1655	   CALIGN_CLI is the starting column for the first line of the description.
1656	   ALIGN_CLI is the starting column for all subsequent lines of the 
1657	   description.  MAXWIDTH_CLI is the number of columns in the line. 
1658	   When CALIGN_CLI, ALIGN_CLI, or MAXWIDTH_CLI is -1, choose a sane default. */
1659	
1660	static void
1661	reformat_new_entries (struct spec_entry *entries, int calign_cli, int align_cli, 
1662	                      int maxwidth_cli)
1663	{
1664	  struct spec_entry *entry;
1665	  for (entry = entries; entry; entry = entry->next)
1666	    {
1667	      int calign = -1, align = -1, maxwidth = -1;
1668	      char *name = NULL, *desc = NULL;
1669	      size_t name_len = 0, desc_len = 0;
1670	      split_entry (entry->text, &name, &name_len, &desc, &desc_len);
1671	      free (entry->text);
1672	
1673	      /* Specify sane defaults if we need to */
1674	      if (calign_cli == -1 || align_cli == -1)
1675	        {
1676	          struct spec_section *section;
1677	          calign = calign_cli;
1678	          align = align_cli;
1679	          for (section = entry->entry_sections; 
1680	               section && section != entry->entry_sections_tail;
1681	               section = section->next)
1682	            {
1683	              if (!strcmp (section->name, "Individual utilities"))
1684	                {
1685	                  if (calign == -1)
1686	                    calign = 48 + 1;
1687	                  if (align == -1)
1688	                    align = 50 + 1;
1689	                  break;
1690	                }
1691	            }
1692	          if (calign == -1)
1693	            calign = 32 + 1;
1694	          if (align == -1)
1695	            align = 34 + 1;
1696	        }
1697	      else
1698	        {
1699	          calign = calign_cli;
1700	          align = align_cli;
1701	        }
1702	
1703	      maxwidth = maxwidth_cli == -1 ? 79 : maxwidth_cli; 
1704	
1705	      format_entry (name, name_len, desc, desc_len, calign, align, 
1706	                    maxwidth, &entry->text, &entry->text_len);
1707	    }
1708	}
1709	
1710	/* Insert NAME into every entry in ENTRIES that requires it. 
1711	   NAME is the basename of the Info file being installed. 
1712	   The idea here is that there was a --name on the command-line
1713	   and we need to put the basename in the empty parentheses. */
1714	void
1715	add_missing_basenames (struct spec_entry *entries, char *name)
1716	{
1717	  struct spec_entry *entry;
1718	  for (entry = entries; entry; entry = entry->next)
1719	    {
1720	      if (entry->missing_basename)
1721	        {
1722	          /* Insert NAME into the right place in ENTRY->TEXT. */
1723	          char *info, *rest, *text;
1724	          size_t name_len = strlen (name);
1725	          char *ptr = strstr (entry->text, ": (). ");
1726	          if (!ptr)
1727	            return;
1728	          ptr[0] = '\0';
1729	          rest = ptr += strlen (": (). ");
1730	
1731	          info = xmalloc (name_len + 7);
1732	          snprintf (info, name_len + 7, ": (%s). ", name);
1733	          text = concat (entry->text, info, rest);
1734	          free (info);
1735	          if (entry->text)
1736	            free (entry->text);
1737	          entry->text = text;
1738	          entry->text_len = strlen (entry->text);
1739	          entry->missing_name = 0;
1740	          entry->missing_basename = 0;
1741	        }
1742	    }
1743	}
1744	
1745	
1746	/* Add NAME to the start of any entry in ENTRIES that is missing a name 
1747	   component.  If NAME doesn't start with `*', it is formatted to look 
1748	   like an Info entry.  */
1749	void
1750	add_missing_names (struct spec_entry *entries, char *name)
1751	{
1752	  struct spec_entry *entry;
1753	  for (entry = entries; entry; entry = entry->next)
1754	    {
1755	      if (entry->missing_name)
1756	        {
1757	          char *text;
1758	          /* Prepend NAME onto ENTRY->TEXT. */
1759	          int add_nl = 1;
1760	          if (entry->text)
1761	            if (entry->text[entry->text_len - 1] == '\n')
1762	              add_nl = 0;
1763	
1764	          if (name[0] == '*')
1765	            text = concat (name, entry->text == NULL ? "" : entry->text, 
1766	                           add_nl ? "\n" : "");
1767	          else
1768	            {
1769	              size_t full_name_len = strlen (name) * 2 + 9;
1770	              char *full_name = xmalloc (full_name_len);
1771	              snprintf (full_name, full_name_len, "* %s: (%s).", name, name);
1772	              text = concat (full_name, 
1773	                             entry->text == NULL ? "" : entry->text, 
1774	                             add_nl ? "\n" : "");
1775	              free (full_name);
1776	            }
1777	          if (entry->text)
1778	            free (entry->text);
1779	          entry->text = text;
1780	          entry->text_len = strlen (entry->text);
1781	          entry->missing_name = 0;
1782	          entry->missing_basename = 0;
1783	        }
1784	    }
1785	}
1786	
1787	/* Append DESC to every entry in ENTRIES that needs it. */
1788	
1789	void
1790	add_missing_descriptions (struct spec_entry *entries, char *desc)
1791	{
1792	  struct spec_entry *entry;
1793	  for (entry = entries; entry; entry = entry->next)
1794	    {
1795	      if (entry->missing_description)
1796	        {
1797	          char *text;
1798	          int add_nl = 1;
1799	          if (strlen (desc) > 1)
1800	            if (desc[strlen (desc) - 1] == '\n')
1801	              add_nl = 0;
1802	          /* Append DESC onto ENTRY->TEXT. */
1803	          text = concat (entry->text == NULL ? "" : entry->text, desc,
1804	                               add_nl ? "\n" : "");
1805	          if (entry->text)
1806	            free (entry->text);
1807	          entry->text = text;
1808	          entry->text_len = strlen (entry->text);
1809	        }
1810	    }
1811	}
1812	
1813	
1814	/* Detect old-style Debian `--section REGEX TITLE' semantics in ARGV.
1815	   When detected the options are munged to look like:
1816	     `--regex REGEX --section TITLE --add-once'
1817	   Return 1 if munging took place, return 0 if not.
1818	   Otherwise return a negative number if something went wrong.
1819	   NEW_ARGC, and NEW_ARGV are filled with the newly munged options
1820	   when munging took place.
1821	 */
1822	static int
1823	munge_old_style_debian_options (int argc, char **argv, 
1824	                                int *new_argc, char ***new_argv)
1825	{
1826	  char *opt = NULL;
1827	  int i, err;
1828	  char *argz = NULL;
1829	  size_t argz_len = 0;
1830	  const char *regex, *title;
1831	  int munge = 0;
1832	
1833	  /* Flip through the options to detect the old `--section REGEX TITLE' 
1834	     syntax */
1835	  for (i = 0; i < argc; i++)
1836	    {
1837	      if (strcmp (argv[i], "--section") == 0)
1838	        {
1839	          FILE *fileptr;
1840	          /* Go forward one arg and obtain the REGEX. */
1841	          if (i + 1 < argc)
1842	            i++;
1843	          else
1844	            return -1;
1845	          regex = argv[i];
1846	          /* Go forward another arg and obtain the TITLE. */
1847	          if (i + 1 < argc)
1848	            i++;
1849	          else
1850	            return -1;
1851	          title = argv[i];
1852	          /* When the title starts with a `-' it's probably an option,
1853	             and not a title. */
1854	          if (title[0] == '-')
1855	            break;
1856	          /* When the title is a filename it's probably an Info file, or
1857	             a dir file, and not a title. */
1858	          fileptr = fopen (title, "r");
1859	          if (fileptr)
1860	            {
1861	              fclose (fileptr);
1862	              break;
1863	            }
1864	          /* Okay, it looks like we're using the old debian syntax 
1865	             for --section. */
1866	          munge = 1;
1867	        
1868	          /* Okay, we munge the options to look like this:
1869	             --regex=REGEX --section=TITLE --add-once */
1870	          opt = xmalloc (strlen (regex) + sizeof ("--regex="));
1871	          if (sprintf (opt, "--regex=%s", regex) == -1)
1872	            err = 1;
1873	          if (!err)
1874	            err = argz_add (&argz, &argz_len, opt);
1875	          free (opt); opt = NULL;
1876	
1877	          opt = xmalloc (strlen (title) + sizeof ("--section="));
1878	          if (sprintf (opt, "--section=%s", title) == -1)
1879	            err = 1;
1880	          if (!err)
1881	            err = argz_add (&argz, &argz_len, opt);
1882	          free (opt); opt = NULL;
1883	
1884	          if (!err)
1885	            err = argz_add (&argz, &argz_len, "--add-once");
1886	        }
1887	      else
1888	        err = argz_add (&argz, &argz_len, argv[i]); 
1889	      if (err)
1890	        return -1;
1891	    }
1892	
1893	  if (munge)
1894	    {
1895	      *new_argc = argz_count (argz, argz_len);
1896	      *new_argv = xmalloc ((*new_argc + 1) * sizeof (char *));
1897	
1898	      opt = NULL; i = 0;
1899	      while ((opt = argz_next (argz, argz_len, opt)))
1900	        {
1901	          (*new_argv)[i] = xstrdup (opt);
1902	          i++;
1903	        }
1904	      (*new_argv)[*new_argc] = NULL;
1905	    }
1906	  free (argz);
1907	  return munge;
1908	}
1909	
1910	
1911	int
1912	main (int argc, char *argv[])
1913	{
1914	  char *opened_dirfilename;
1915	  char *compression_program;
1916	  char *infile_sans_info;
1917	  char *infile = 0, *dirfile = 0;
1918	  int calign = -1;
1919	  int align  = -1;
1920	  int maxwidth = -1;
1921	
1922	  /* Record the text of the Info file, as a sequence of characters
1923	     and as a sequence of lines.  */
1924	  char *input_data = NULL;
1925	  int input_size = 0;
1926	  struct line_data *input_lines = NULL;
1927	  int input_nlines = 0;
1928	
1929	  /* Record here the specified section names and directory entries.  */
1930	  struct spec_section *input_sections = NULL;
1931	  struct spec_entry *entries_to_add = NULL;
1932	  struct spec_entry *entries_to_add_from_file = NULL;
1933	  int n_entries_to_add = 0;
1934	  struct spec_entry *default_entries_to_add = NULL;
1935	  int n_default_entries_to_add = 0;
1936	
1937	  /* Record the old text of the dir file, as plain characters,
1938	     as lines, and as nodes.  */
1939	  char *dir_data;
1940	  int dir_size;
1941	  int dir_nlines;
1942	  struct line_data *dir_lines;
1943	  struct node *dir_nodes;
1944	
1945	  /* Nonzero means --delete was specified (just delete existing entries).  */
1946	  int delete_flag = 0;
1947	  int something_deleted = 0;
1948	
1949	  /* Nonzero means -quiet/--silent was specified.  */
1950	  int quiet_flag = 0;
1951	
1952	  /* Nonzero means --debug was specified.  */
1953	  int debug_flag = 0;
1954	
1955	  int i;
1956	
1957	#ifdef HAVE_SETLOCALE
1958	  /* Set locale via LC_ALL.  */
1959	  setlocale (LC_ALL, "");
1960	#endif
1961	
1962	  /* Set the text message domain.  */
1963	  bindtextdomain (PACKAGE, LOCALEDIR);
1964	  textdomain (PACKAGE);
1965	
1966	  /* Make sure standard input can be freopened at will.  Otherwise,
1967	     when stdin starts off closed, bad things could happen if a plain fopen
1968	     returns stdin before open_possibly_compressed_file freopens it.  */
1969	  if (! freopen (NULL_DEVICE, "r", stdin))
1970	    pfatal_with_name (NULL_DEVICE);
1971	
1972	  munge_old_style_debian_options (argc, argv, &argc, &argv);
1973	
1974	  while (1)
1975	    {
1976	      int opt = getopt_long (argc, argv, 
1977	                             "i:d:e:s:t:E:c:C:W:A:hHrk1Ia", longopts, 0);
1978	
1979	      if (opt == EOF)
1980	        break;
1981	
1982	      switch (opt)
1983	        {
1984	        case 0:
1985	          /* If getopt returns 0, then it has already processed a
1986	             long-named option.  We should do nothing.  */
1987	          break;
1988	
1989	        case 1:
1990	          abort ();
1991	
1992	        case '1':
1993	          add_entries_into_all_matching_sections = 0;
1994	          break;
1995	
1996	        case 'a':
1997	          order_new_sections_alphabetically_flag = 0;
1998	          break;
1999	
2000	        case 'A':
2001	          {
2002	            char *end = NULL;
2003	            unsigned long int val;
2004	            val = strtoul (optarg, &end, 0);
2005	            if (end == NULL || end == optarg || *end != '\0')
2006	              suggest_asking_for_help ();
2007	            align = val;
2008	            if (align <= 0)
2009	              suggest_asking_for_help ();
2010	          }
2011	          break;
2012	
2013	        case 'c':
2014	        
2015	          {
2016	            struct spec_entry *next;
2017	            size_t length = strlen (optarg);
2018	
2019	            if (!entries_to_add)
2020	              {
2021	                next = 
2022	                  (struct spec_entry *) xmalloc (sizeof (struct spec_entry));
2023	            
2024	                next->text = NULL;
2025	                next->text_len = 0;
2026	                next->entry_sections = NULL;
2027	                next->entry_sections_tail = NULL;
2028	                next->missing_name = 1;
2029	                next->missing_basename = 1;
2030	                next->next = entries_to_add;
2031	                entries_to_add = next;
2032	                n_entries_to_add++;
2033	              }
2034	            else
2035	              next = entries_to_add;
2036	                
2037	            next->missing_description = 0;
2038	            if (next->text)
2039	              {
2040	                char *nl = strrchr (next->text, '\n');
2041	                if (nl)
2042	                  nl[0] = '\0';
2043	              }
2044	            /* Concat the description onto the current entry, adding a 
2045	               newline if we need one.  Prepend a space if we have no
2046	               previous text, since eventually we will be adding the
2047	               "* foo ()." and we want to end up with a ". " for parsing.  */
2048	            next->text = concat (next->text ? next->text : " ",
2049	                                 optarg, 
2050	                                 optarg[length - 1] == '\n' ? "" : "\n");
2051	            next->text_len = strlen (next->text);
2052	          }
2053	          break;
2054	
2055	        case 'C':
2056	          {
2057	            char *end = NULL;
2058	            unsigned long int val;
2059	            val = strtoul (optarg, &end, 0);
2060	            if (end == NULL || end == optarg || *end != '\0')
2061	              suggest_asking_for_help ();
2062	            calign = val;
2063	            if (calign <= 0)
2064	              suggest_asking_for_help ();
2065	          }
2066	          break;
2067	
2068	        case 'd':
2069	          if (dirfile)
2070	            {
2071	              fprintf (stderr, _("%s: already have dir file: %s\n"),
2072	                       progname, dirfile);
2073	              suggest_asking_for_help ();
2074	            }
2075	          dirfile = optarg;
2076	          break;
2077	
2078	        case 'D':
2079	          if (dirfile)
2080	            {
2081	              fprintf (stderr, _("%s: already have dir file: %s\n"),
2082	                       progname, dirfile);
2083	              suggest_asking_for_help ();
2084	            }
2085	          dirfile = concat (optarg, "", "/dir");
2086	          break;
2087	
2088	        case 't':
2089	          {
2090	            struct spec_entry *next
2091	              = (struct spec_entry *) xmalloc (sizeof (struct spec_entry));
2092	
2093	            size_t length;
2094	            if (optarg[0] != '*')
2095	              {
2096	                /* Make enough space for "* foo: (). ". */
2097	                length = strlen (optarg) + 9;
2098	                next->text = xmalloc (length);
2099	                snprintf (next->text, length, "* %s: (). ", optarg);
2100	                next->missing_basename = 1;
2101	                /* The basename will be inserted in between the parentheses
2102	                   at a later time.  See add_missing_basenames. */
2103	              }
2104	            else
2105	              {
2106	                /* Make enough space for "foo ". */
2107	                length = strlen (optarg) + 2;
2108	                next->text = xmalloc (length);
2109	                snprintf (next->text, length, "%s ", optarg);
2110	                next->missing_basename = 0;
2111	                /* FIXME: check for info entry correctness in TEXT. 
2112	                   e.g. `* Aaa: (bbb).' */
2113	              }
2114	
2115	            next->text_len = length - 1;
2116	            next->entry_sections = NULL;
2117	            next->entry_sections_tail = NULL;
2118	            next->next = entries_to_add;
2119	            next->missing_name = 0;
2120	            next->missing_description = 1;
2121	            entries_to_add = next;
2122	            n_entries_to_add++;
2123	          }
2124	          break;
2125	
2126		case 'E':
2127	        case 'e':
2128	          {
2129	            struct spec_entry *next
2130	              = (struct spec_entry *) xmalloc (sizeof (struct spec_entry));
2131	            int olen = strlen (optarg);
2132	            if (! (*optarg != 0 && optarg[olen - 1] == '\n'))
2133	              {
2134	                optarg = concat (optarg, "\n", "");
2135	                olen++;
2136	              }
2137	            next->text = optarg;
2138	            next->text_len = olen;
2139	            next->entry_sections = NULL;
2140	            next->entry_sections_tail = NULL;
2141	            next->missing_name = 0;
2142	            next->missing_basename = 0;
2143	            next->missing_description = 0;
2144		    if (opt == 'e')
2145	  	      {
2146			next->next = entries_to_add;
2147			entries_to_add = next;
2148			n_entries_to_add++;
2149		      } 
2150		    else
2151		      {
2152		        /* Although this list is maintained, nothing is ever
2153		           done with it.  So it seems no one cares about the
2154		           feature.  The intended --help string was:
2155	 --defentry=TEXT     like --entry, but only use TEXT if an entry\n\
2156	                      is not present in INFO-FILE.\n\
2157	                   in case anyone ever wants to finish it.  */
2158			next->next = default_entries_to_add;
2159			default_entries_to_add = next;
2160			n_default_entries_to_add++;
2161		      }
2162	          }
2163	          break;
2164	
2165	        case 'g':
2166	          debug_flag = 1;
2167	          break;
2168	
2169	        case 'h':
2170	        case 'H':
2171	          print_help ();
2172	          exit (EXIT_SUCCESS);
2173	
2174	        case 'i':
2175	          if (infile)
2176	            {
2177	              fprintf (stderr, _("%s: Specify the Info file only once.\n"),
2178	                       progname);
2179	              suggest_asking_for_help ();
2180	            }
2181	          infile = optarg;
2182	          break;
2183	
2184	        case 'I':
2185	          indent_flag = 0;
2186	          break;
2187	
2188	        case 'k':
2189	          keep_old_flag = 1;
2190	          break;
2191	
2192	        case 'n':
2193	          chicken_flag = 1;
2194	          break;
2195	
2196	        case 'q':
2197	          quiet_flag = 1;
2198	          break;
2199	
2200	        case 'r':
2201	          delete_flag = 1;
2202	          break;
2203	
2204	        case 'R':
2205	          {
2206	            int error;
2207	            if (psecreg)
2208	              {
2209	                warning 
2210	                  (_("Extra regular expression specified, ignoring `%s'"),
2211	                   optarg);
2212	                break;
2213	              }
2214	            psecreg = (regex_t *) xmalloc (sizeof (regex_t));
2215	
2216	            error = regcomp (psecreg, optarg, REG_ICASE|REG_NOSUB);
2217	            if (error != 0)
2218	              {
2219	                int errbuf_size = regerror (error, psecreg, NULL, 0);
2220	                char *errbuf = (char *) xmalloc (errbuf_size);
2221	                regerror (error, psecreg, errbuf, errbuf_size);
2222	                fatal (_("Error in regular expression `%s': %s"),
2223			       optarg, errbuf);
2224	              };
2225	          }
2226	          break;
2227	
2228		case 'S':
2229		  default_section = optarg;
2230		  break;
2231	
2232	        case 's':
2233	          {
2234	            struct spec_section *next
2235	              = (struct spec_section *) xmalloc (sizeof (struct spec_section));
2236	            next->name = optarg;
2237	            next->next = input_sections;
2238	            next->missing = 1;
2239	            input_sections = next;
2240	          }
2241	          break;
2242	
2243	        case 'V':
2244	          printf ("install-info (GNU %s) %s\n", PACKAGE, VERSION);
2245	          puts ("");
2246	          printf (_("Copyright (C) %s Free Software Foundation, Inc.\n\
2247	License GPLv3+: GNU GPL version 3 or later <http://gnu.org/licenses/gpl.html>\n\
2248	This is free software: you are free to change and redistribute it.\n\
2249	There is NO WARRANTY, to the extent permitted by law.\n"),
2250	              "2015");
2251	          exit (EXIT_SUCCESS);
2252	
2253	        case 'W':
2254	          {
2255	            char *end = NULL;
2256	            unsigned long int val;
2257	            val = strtoul (optarg, &end, 0);
2258	            if (end == NULL || end == optarg || *end != '\0')
2259	              suggest_asking_for_help ();
2260	            maxwidth = val;
2261	            if (maxwidth <= 0)
2262	              suggest_asking_for_help ();
2263	          }
2264	          break;
2265	
2266	        case 'x':
2267	          delete_flag = 1;
2268	          remove_exactly = 1;
2269	          break;
2270	
2271	        default:
2272	          suggest_asking_for_help ();
2273	        }
2274	    }
2275	
2276	  /* Interpret the non-option arguments as file names.  */
2277	  for (; optind < argc; ++optind)
2278	    {
2279	      if (infile == 0)
2280	        infile = argv[optind];
2281	      else if (dirfile == 0)
2282	        dirfile = argv[optind];
2283	      else
2284	        error (_("excess command line argument `%s'"), argv[optind]);
2285	    }
2286	
2287	  if (!infile)
2288	    fatal (_("No input file specified; try --help for more information."));
2289	  if (!dirfile)
2290	    fatal (_("No dir file specified; try --help for more information."));
2291	
2292	  /* Now read in the Info dir file.  */
2293	  if (debug_flag)
2294	    printf ("debug: reading dir file %s\n", dirfile);
2295	
2296	  if (!delete_flag)
2297	    {
2298	      dir_data = readfile (dirfile, &dir_size, ensure_dirfile_exists,
2299	                           &opened_dirfilename, &compression_program);
2300	      if (!dir_data)
2301	        pfatal_with_name (opened_dirfilename);
2302	    }
2303	  else
2304	    {
2305	      /* For "--remove" operation, it is not an error for the dir file
2306	         not to exist. */
2307	      dir_data = readfile (dirfile, &dir_size, NULL,
2308	                           &opened_dirfilename, &compression_program);
2309	      if (!dir_data)
2310	        {
2311	          warning (_("Could not read %s."), opened_dirfilename);
2312	          exit (EXIT_SUCCESS);
2313	        }
2314	    }
2315	
2316	  dir_lines = findlines (dir_data, dir_size, &dir_nlines);
2317	
2318	  parse_dir_file (dir_lines, dir_nlines, &dir_nodes);
2319	
2320	  if (!delete_flag)
2321	    {
2322	      /* Find which sections match our regular expression. */
2323	      if (psecreg)
2324	        {
2325	          struct node *node;
2326	          struct menu_section *section;
2327	          for (node = dir_nodes; node ; node = node->next)
2328	            for (section = node->sections; section ; section = section->next)
2329	              if (regexec (psecreg, section->name, 0, NULL, 0) == 0)
2330	                {
2331	                  /* we have a match! */
2332	                  struct spec_section *next = 
2333	                    (struct spec_section *) xmalloc 
2334	                    (sizeof (struct spec_section));
2335	                  next->name = section->name;
2336	                  next->next = input_sections;
2337	                  next->missing = 0;
2338	                  input_sections = next;
2339	                }
2340	        }
2341	
2342	    }
2343	
2344	  /* We will be comparing the entries in the dir file against the
2345	     current filename, so need to strip off any directory prefix and/or
2346	     [.info][.gz] suffix.  */
2347	  if (!remove_exactly) {
2348	    char *infile_basename = infile + strlen (infile);
2349	
2350	    if (HAVE_DRIVE (infile))
2351	      infile += 2;      /* get past the drive spec X: */
2352	
2353	    while (infile_basename > infile && !IS_SLASH (infile_basename[-1]))
2354	      infile_basename--;
2355	
2356	    infile_sans_info = strip_info_suffix (infile_basename);
2357	  } else
2358	    infile_sans_info = xstrdup(infile);
2359	
2360	  /* Now Read the Info file and parse it into lines, unless we're 
2361	     removing exactly.  */
2362	  if (!remove_exactly)
2363	    {
2364	      char *opened_infilename;
2365	
2366	      if (debug_flag)
2367	        printf ("debug: reading input file %s\n", infile);
2368	      input_data = readfile (infile, &input_size, NULL,
2369	                             &opened_infilename, NULL);
2370	      if (!input_data)
2371	        pfatal_with_name (opened_infilename);
2372	      input_lines = findlines (input_data, input_size, &input_nlines);
2373	    }
2374	
2375	  i = parse_input (input_lines, input_nlines,
2376	                   &input_sections, &entries_to_add_from_file, delete_flag);
2377	  if (!delete_flag)
2378	    {
2379	      /* If there are no entries on the command-line at all, so we use the 
2380	         entries found in the Info file itself (if any). */
2381	      if (entries_to_add == NULL)
2382	        {
2383	          entries_to_add = entries_to_add_from_file;
2384	          n_entries_to_add = i;
2385	        }
2386	      /* There are entries on the command-line, and they override the entries
2387	         found in the Info file. */
2388	      else if (entries_to_add)
2389	        {
2390	          if (entries_to_add_from_file == NULL)
2391	            {
2392	              /* No entries found in the file anyway.  Fill in any 
2393	                 missing names with the info file's basename.  We're out
2394	                 of luck for any missing descriptions. */
2395	              add_missing_names (entries_to_add, infile_sans_info);
2396	              /* add_missing_descriptions (entries_to_add, "\n"); */
2397	            }
2398	          else
2399	            {
2400	              /* Fill in any missing names or descriptions with what was
2401	                 found in the Info file. */
2402	              char *desc = NULL;
2403	              size_t desc_len = 0;
2404	              char *name = NULL;
2405	              size_t name_len = 0;
2406	              split_entry (entries_to_add_from_file->text, &name, &name_len,
2407	                           &desc, &desc_len);
2408	              if (name)
2409	                {
2410	                  /* If the name doesn't look right, bail and use the 
2411	                     name based on the Info file. */
2412	                  if (name[0] != '*')
2413	                    add_missing_names (entries_to_add, infile_sans_info);
2414	                  else
2415	                    add_missing_names (entries_to_add, name);
2416	                  free (name);
2417	                }
2418	
2419	              if (desc)
2420	                {
2421	                  add_missing_descriptions (entries_to_add, desc);
2422	                  free (desc);
2423	                }
2424	            }
2425	        }
2426	            
2427	      /* Lastly, fill in any missing basenames that might still be hanging
2428	         around from --name options on the command-line. */
2429	      add_missing_basenames (entries_to_add, infile_sans_info);
2430	
2431	      /* Reformat the new entries if we're doing that. */
2432	      if (indent_flag)
2433	        {
2434	          char *no_indent = getenv ("INSTALL_INFO_NO_INDENT");
2435	          if (!no_indent)
2436	            reformat_new_entries (entries_to_add, calign, align, maxwidth);
2437	        }
2438	
2439	      /* If we got no sections, use the --defsection value if it was
2440	         given, else "Miscellaneous".  */ 
2441	      if (input_sections == NULL)
2442	        {
2443	          input_sections = (struct spec_section *)
2444	            xmalloc (sizeof (struct spec_section));
2445	          input_sections->name = default_section ? default_section
2446	                                                 : "Miscellaneous";
2447	          input_sections->next = NULL;
2448	          input_sections->missing = 1;
2449	        }
2450	
2451	      if (entries_to_add == 0)
2452	        { /* No need to abort here, the original info file may not
2453	             have the requisite Texinfo commands.  This is not
2454	             something an installer should have to correct (it's a
2455	             problem for the maintainer), and there's no need to cause
2456	             subsequent parts of `make install' to fail.  */
2457	          if (!quiet_flag)
2458	            warning (_("no info dir entry in `%s'"), infile);
2459	          exit (EXIT_SUCCESS);
2460	        }
2461	
2462	      /* If the entries came from the command-line arguments, their
2463	         entry_sections pointers are not yet set.  Walk the chain of
2464	         the entries and for each entry update entry_sections to point
2465	         to the head of the list of sections where this entry should
2466	         be put.  Note that all the entries specified on the command
2467	         line get put into ALL the sections we've got, either from the
2468	         Info file, or (under --section) from the command line,
2469	         because in the loop below every entry inherits the entire
2470	         chain of sections.  */
2471	      if (n_entries_to_add > 0 && entries_to_add->entry_sections == NULL)
2472	        {
2473	          struct spec_entry *ep;
2474	
2475	          for (ep = entries_to_add; ep; ep = ep->next)
2476	            ep->entry_sections = input_sections;
2477	        }
2478	    }
2479	
2480	  if (delete_flag)
2481	    {
2482	      something_deleted = mark_entry_for_deletion (dir_lines, dir_nlines, 
2483	                                                   infile_sans_info);
2484	      if (!something_deleted && !remove_exactly)
2485	        {
2486	          struct spec_entry *entry;
2487	          for (entry = entries_to_add; entry; entry = entry->next)
2488	            {
2489	              /* If the entry came from the info file... */
2490	              if (entry->entry_sections != NULL)
2491	                {
2492	                  char *name = extract_menu_item_name (entry->text);
2493	                  something_deleted = 
2494	                    mark_entry_for_deletion (dir_lines, dir_nlines, name);
2495	                  free (name);
2496	                }
2497	            }
2498	      
2499	          if (!something_deleted)
2500	            {
2501	              struct spec_entry *entry;
2502	              for (entry = entries_to_add; entry; entry = entry->next)
2503	                {
2504	                  /* If the entry came from the command-line... */
2505	                  if (entry->entry_sections == NULL)
2506	                    something_deleted = 
2507	                      mark_entry_for_deletion (dir_lines, dir_nlines, 
2508	                                               entry->text);
2509	                }
2510	            }
2511	        }
2512	    }
2513	    
2514	  /* Check for sections with zero entries and mark them for deletion. */
2515	  if (delete_flag && something_deleted && !keep_old_flag)
2516	    {
2517	      struct node *node;
2518	      struct menu_section *section;
2519	      int section_empty;
2520	
2521	      for (node = dir_nodes; node ; node = node->next)
2522	        for (section = node->sections; section ; section = section->next)
2523	          {
2524	            section_empty = 1;
2525	            for (i = section->end_line; i > section->start_line; i--)
2526	              {
2527	                if (dir_lines[i - 1].delete == 0 && 
2528	                    dir_lines[i - 1].size != 0)
2529	                  {
2530	                    section_empty = 0;
2531	                    break;
2532	                  }
2533	              }
2534	
2535	            if (section_empty)
2536	              {
2537	                /* This gets rid of any trailing empty lines at the end  
2538	                   of the section, and the title too. */
2539	                for (i = section->end_line; i >= section->start_line; i--)
2540	                  dir_lines[i - 1].delete = 1;
2541	              }
2542	          }
2543	    }
2544	
2545	  /* Decide where to add the new entries (unless --delete was used).
2546	     Find the menu sections to add them in.
2547	     In each section, find the proper alphabetical place to add
2548	     each of the entries.  */
2549	  if (!delete_flag)
2550	    {
2551	      struct node *node;
2552	      struct menu_section *section;
2553	      struct spec_section *spec;
2554	
2555	      for (node = dir_nodes; node; node = node->next)
2556	        for (section = node->sections; section; section = section->next)
2557	          {
2558	            for (i = section->end_line; i > section->start_line; i--)
2559	              if (dir_lines[i - 1].size != 0)
2560	                break;
2561	            section->end_line = i;
2562	
2563	            for (spec = input_sections; spec; spec = spec->next)
2564	              if (!strcmp (spec->name, section->name))
2565	                break;
2566	            if (spec)
2567	              {
2568	                int add_at_line = section->end_line;
2569	                struct spec_entry *entry;
2570	                /* Say we have found at least one section with this name,
2571	                   so we need not add such a section.  */
2572	                spec->missing = 0;
2573	                /* For each entry, find the right place in this section
2574	                   to add it.  */
2575	                for (entry = entries_to_add; entry; entry = entry->next)
2576	                  {
2577	                    /* Did they at all want this entry to be put into
2578	                       this section?  */
2579	                    for (spec = entry->entry_sections;
2580	                         spec && spec != entry->entry_sections_tail;
2581	                         spec = spec->next)
2582	                      {
2583	                        if (!strcmp (spec->name, section->name))
2584	                          break;
2585	                      }
2586	                    if (!spec || spec == entry->entry_sections_tail)
2587	                      continue;
2588	
2589	                    /* Subtract one because dir_lines is zero-based,
2590	                       but the `end_line' and `start_line' members are
2591	                       one-based.  */
2592	                    for (i = section->end_line - 1;
2593	                         i >= section->start_line - 1; i--)
2594	                      {
2595	                        /* If an entry exists with the same name,
2596	                           and was not marked for deletion
2597	                           (which means it is for some other file),
2598	                           we are in trouble.  */
2599	                        if (dir_lines[i].start[0] == '*'
2600	                            && menu_line_equal (entry->text, entry->text_len,
2601	                                                dir_lines[i].start,
2602	                                                dir_lines[i].size)
2603	                            && !dir_lines[i].delete)
2604	                          {
2605	                            if (keep_old_flag)
2606	                              {
2607	                                add_at_line = -1;
2608	                                break;
2609	                              }
2610	                            else
2611	                              {
2612	                                int j;
2613	                                dir_lines[i].delete = 1;
2614	                                for (j = i + 1; j < section->end_line; j++)
2615	                                  {
2616	                                    if (dir_lines[j].start[0] == '*')
2617	                                      break;
2618	                                    dir_lines[j].delete = 1;
2619	                                  }
2620	                              }
2621	                          }
2622	                        if (dir_lines[i].start[0] == '*'
2623	                            && menu_line_lessp (entry->text, entry->text_len,
2624	                                                dir_lines[i].start,
2625	                                                dir_lines[i].size))
2626	                          add_at_line = i;
2627	                      }
2628	                    if (add_at_line < 0)
2629	                      continue;
2630	                    insert_entry_here (entry, add_at_line,
2631	                                       dir_lines, n_entries_to_add);
2632	                  }
2633	              }
2634	          }
2635	
2636	    }
2637	  /* Decide where to add the new sections (unless --delete was used).
2638	     Alphabetically find the menu sections to add them before.  */
2639	  if (!delete_flag)
2640	    {
2641	      struct node *node;
2642	      struct node *top = NULL;
2643	
2644	      /* Find the `Top' node. */
2645	      for (node = dir_nodes; node; node = node->next)
2646	        if (node->name && strcmp (node->name, "Top") == 0)
2647	          top = node;
2648	
2649	      if (top)
2650	        {
2651	          struct spec_section *spec;
2652	          int found = 0;
2653	          struct line_data *target_line = NULL;
2654	          for (spec = input_sections; spec; spec = spec->next)
2655	            {
2656	              found = 0;
2657	              target_line = NULL;
2658	              if (!spec->missing)
2659	                continue;
2660	              if (order_new_sections_alphabetically_flag)
2661	                {
2662	                  struct menu_section *section;
2663	                  struct menu_section *prev_section = NULL;
2664	              
2665	                  /* Look for the first section name that 
2666	                     exceeds SPEC->NAME. */
2667	                  for (section = top->sections; section ; 
2668	                       section = section->next)
2669	                    {
2670	                      found = (mbscasecmp (spec->name, section->name) < 0);
2671	                      if (found)
2672	                        {
2673	                          /* Mark the section for addition at this point. */
2674	                          if (prev_section)
2675	                            target_line = &dir_lines[prev_section->end_line];
2676	                          else
2677	                            target_line = 
2678	                              &dir_lines[top->sections->start_line - 2];
2679	
2680	                          break;
2681	                        }
2682	                      prev_section = section;
2683	                    }
2684	                }
2685	                  
2686	              /* When we can't put a section anywhere, we put it at the 
2687	                 bottom of the file. */
2688	              if (!found)
2689	                target_line = &dir_lines[top->end_line];
2690	
2691	              /* Add the section to our list of sections being added
2692	                 at this point of the DIR file. */
2693	              target_line->num_sections_to_add++;
2694	              target_line->add_sections_before = 
2695	                (struct spec_section **) xrealloc 
2696	                (target_line->add_sections_before, 
2697	                 (target_line->num_sections_to_add *
2698	                  sizeof (struct spec_section *)));
2699	              i = target_line->num_sections_to_add - 1;
2700	              target_line->add_sections_before[i] = spec;
2701	            }
2702	        }
2703	    }
2704	
2705	  if (delete_flag && !something_deleted && !quiet_flag)
2706	    warning (_("no entries found for `%s'; nothing deleted"), infile);
2707	
2708	  if (debug_flag)
2709	    printf ("debug: writing dir file %s\n", opened_dirfilename);
2710	  if (chicken_flag)
2711	    printf ("test mode, not updating dir file %s\n", opened_dirfilename);
2712	  else
2713	    output_dirfile (opened_dirfilename, dir_nlines, dir_lines,
2714	                    n_entries_to_add, entries_to_add,
2715	                    input_sections, compression_program);
2716	
2717	  exit (EXIT_SUCCESS);
2718	}
2719	
2720	/* Divide the text at DATA (of SIZE bytes) into lines.
2721	   Return a vector of struct line_data describing the lines.
2722	   Store the length of that vector into *NLINESP.  */
2723	
2724	struct line_data *
2725	findlines (char *data, int size, int *nlinesp)
2726	{
2727	  int i;
2728	  int lineflag = 1;
2729	  int lines_allocated = 511;
2730	  int filled = 0;
2731	  struct line_data *lines
2732	    = xmalloc ((lines_allocated + 1) * sizeof (struct line_data));
2733	
2734	  for (i = 0; i < size; i++)
2735	    {
2736	      if (lineflag)
2737	        {
2738	          if (filled == lines_allocated)
2739	            {
2740	              /* try to keep things somewhat page-aligned */
2741	              lines_allocated = ((lines_allocated + 1) * 2) - 1;
2742	              lines = xrealloc (lines, (lines_allocated + 1)
2743	                                       * sizeof (struct line_data));
2744	            }
2745	          lines[filled].start = &data[i];
2746	          lines[filled].add_entries_before = 0;
2747	          lines[filled].add_sections_before = NULL;
2748	          lines[filled].num_sections_to_add = 0;
2749	          lines[filled].delete = 0;
2750	          if (filled > 0)
2751	            lines[filled - 1].size
2752	              = lines[filled].start - lines[filled - 1].start - 1;
2753	          filled++;
2754	        }
2755	      lineflag = (data[i] == '\n');
2756	    }
2757	  if (filled > 0)
2758	    lines[filled - 1].size = &data[i] - lines[filled - 1].start - lineflag;
2759	
2760	  /* Do not leave garbage in the last element.  */
2761	  lines[filled].start = NULL;
2762	  lines[filled].add_entries_before = NULL;
2763	  lines[filled].add_sections_before = NULL;
2764	  lines[filled].num_sections_to_add = 0;
2765	  lines[filled].delete = 0;
2766	  lines[filled].size = 0;
2767	
2768	  *nlinesp = filled;
2769	  return lines;
2770	}
2771	
2772	/* This is the comparison function for qsort for a vector of pointers to
2773	   struct spec_section.  (Have to use const void * as the parameter type
2774	   to avoid incompatible-with-qsort warnings.)
2775	   Compare the section names.  */
2776	
2777	int
2778	compare_section_names (const void *p1, const void *p2)
2779	{
2780	  struct spec_section **sec1 = (struct spec_section **) p1;
2781	  struct spec_section **sec2 = (struct spec_section **) p2;
2782	  char *name1 = (*sec1)->name;
2783	  char *name2 = (*sec2)->name;
2784	  return strcmp (name1, name2);
2785	}
2786	
2787	/* This is the comparison function for qsort
2788	   for a vector of pointers to struct spec_entry.
2789	   Compare the entries' text.  */
2790	
2791	int
2792	compare_entries_text (const void *p1, const void *p2)
2793	{
2794	  struct spec_entry **entry1 = (struct spec_entry **) p1;
2795	  struct spec_entry **entry2 = (struct spec_entry **) p2;
2796	  char *text1 = (*entry1)->text;
2797	  char *text2 = (*entry2)->text;
2798	  char *colon1 = strchr (text1, ':');
2799	  char *colon2 = strchr (text2, ':');
2800	  int len1, len2;
2801	
2802	  if (!colon1)
2803	    len1 = strlen (text1);
2804	  else
2805	    len1 = colon1 - text1;
2806	  if (!colon2)
2807	    len2 = strlen (text2);
2808	  else
2809	    len2 = colon2 - text2;
2810	  return mbsncasecmp (text1, text2, len1 <= len2 ? len1 : len2);
2811	}
2812	
2813	/* Insert ENTRY into the add_entries_before vector
2814	   for line number LINE_NUMBER of the dir file.
2815	   DIR_LINES and N_ENTRIES carry information from like-named variables
2816	   in main.  */
2817	
2818	void
2819	insert_entry_here (struct spec_entry *entry, int line_number,
2820	                   struct line_data *dir_lines, int n_entries)
2821	{
2822	  int i, j;
2823	
2824	  if (dir_lines[line_number].add_entries_before == 0)
2825	    {
2826	      dir_lines[line_number].add_entries_before
2827	        = (struct spec_entry **) xmalloc (n_entries * sizeof (struct spec_entry *));
2828	      for (i = 0; i < n_entries; i++)
2829	        dir_lines[line_number].add_entries_before[i] = 0;
2830	    }
2831	
2832	  /* Find the place where this entry belongs.  If there are already
2833	     several entries to add before LINE_NUMBER, make sure they are in
2834	     alphabetical order.  */
2835	  for (i = 0; i < n_entries; i++)
2836	    if (dir_lines[line_number].add_entries_before[i] == 0
2837	        || menu_line_lessp (entry->text, strlen (entry->text),
2838	                            dir_lines[line_number].add_entries_before[i]->text,
2839	                            strlen (dir_lines[line_number].add_entries_before[i]->text)))
2840	      break;
2841	
2842	  if (i == n_entries)
2843	    abort ();
2844	
2845	  /* If we need to plug ENTRY into the middle of the
2846	     ADD_ENTRIES_BEFORE array, move the entries which should be output
2847	     after this one down one notch, before adding a new one.  */
2848	  if (dir_lines[line_number].add_entries_before[i] != 0)
2849	    for (j = n_entries - 1; j > i; j--)
2850	      dir_lines[line_number].add_entries_before[j]
2851	        = dir_lines[line_number].add_entries_before[j - 1];
2852	
2853	  dir_lines[line_number].add_entries_before[i] = entry;
2854	}
