0	/* install-info -- merge Info directory entries from an Info file.
1	   $Id: install-info.c 6165 2015-02-27 18:46:10Z gavin $
2	
3	   Copyright 1996, 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004,
4	   2005, 2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014, 2015
5	   Free Software Foundation, Inc.
6	
7	   This program is free software: you can redistribute it and/or modify
8	   it under the terms of the GNU General Public License as published by
9	   the Free Software Foundation, either version 3 of the License, or
10	   (at your option) any later version.
11	
12	   This program is distributed in the hope that it will be useful,
13	   but WITHOUT ANY WARRANTY; without even the implied warranty of
14	   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
15	   GNU General Public License for more details.
16	
17	   You should have received a copy of the GNU General Public License
18	   along with this program.  If not, see <http://www.gnu.org/licenses/>.  */
19	
20	#include "system.h"
21	#include <getopt.h>
22	#include <regex.h>
23	#include <argz.h>
24	
25	#define TAB_WIDTH 8
26	
27	static char *progname = "install-info";
28	static char *default_section = NULL;
29	
30	struct spec_entry;
31	struct spec_section;
32	
33	struct line_data *findlines (char *data, int size, int *nlinesp);
34	void insert_entry_here (struct spec_entry *entry, int line_number,
35	                        struct line_data *dir_lines, int n_entries); 
36	int compare_section_names (const void *s1, const void *s2);
37	int compare_entries_text (const void *e1, const void *e2); 
38	
39	/* Data structures.  */
40	
41	
42	/* Record info about a single line from a file as read into core.  */
43	struct line_data
44	{
45	  /* The start of the line.  */
46	  char *start;
47	  /* The number of characters in the line,
48	     excluding the terminating newline.  */
49	  int size;
50	  /* Vector containing pointers to the entries to add before this line.
51	     The vector is null-terminated.  */
52	  struct spec_entry **add_entries_before;
53	  /* Vector containing pointers to the sections to add before this line.
54	     The vector is not null-terminated.  */
55	  struct spec_section **add_sections_before;
56	  /* The vector ADD_SECTIONS_BEFORE_HERE contains exactly this many
57	     pointers to sections. */
58	  int num_sections_to_add;
59	  /* 1 means don't output this line.  */
60	  int delete;
61	};
62	
63	
64	/* This is used for a list of the specified menu section names
65	   in which entries should be added.  */
66	struct spec_section
67	{
68	  struct spec_section *next;
69	  char *name;
70	  /* 1 means we have not yet found an existing section with this name
71	     in the dir file--so we will need to add a new section.  */
72	  int missing;
73	};
74	
75	
76	/* This is used for a list of the entries specified to be added.  */
77	struct spec_entry
78	{
79	  struct spec_entry *next;
80	  char *text;
81	  size_t text_len;
82	  /* A pointer to the list of sections to which this entry should be
83	     added.  */
84	  struct spec_section *entry_sections;
85	  /* A pointer to a section that is beyond the end of the chain whose
86	     head is pointed to by entry_sections.  */
87	  struct spec_section *entry_sections_tail;
88	  /* Non-zero means that the entry doesn't have a name specified.  This
89	     can only happen if a --description preceeds a --name option. */
90	  int missing_name;
91	  /* Non-zero means that the entry doesn't have a description.  This
92	     happens when a --name option is given prior to a --description 
93	     option. */
94	  int missing_description;
95	  /* Non-zero means that the entry doesn't have an Info file specified.  
96	     This means that the entry was taken from the command-line but it
97	     only contains the name, and not the info file's basename, which
98	     we get later on.  This only happens on entries that originate
99	     from --name options. */
100	  int missing_basename;
101	};
102	
103	
104	/* This is used for a list of nodes found by parsing the dir file.  */
105	struct node
106	{
107	  struct node *next;
108	  /* The node name.  */
109	  char *name;
110	  /* The line number of the line where the node starts.
111	     This is the line that contains control-underscore.  */
112	  int start_line;
113	  /* The line number of the line where the node ends,
114	     which is the end of the file or where the next line starts.  */
115	  int end_line;
116	  /* Start of first line in this node's menu
117	     (the line after the * Menu: line).  */
118	  char *menu_start;
119	  /* The start of the chain of sections in this node's menu.  */
120	  struct menu_section *sections;
121	  /* The last menu section in the chain.  */
122	  struct menu_section *last_section;
123	};
124	
125	
126	/* This is used for a list of sections found in a node's menu.
127	   Each  struct node  has such a list in the  sections  field.  */
128	struct menu_section
129	{
130	  struct menu_section *next;
131	  char *name;
132	  /* Line number of start of section.  */
133	  int start_line;
134	  /* Line number of end of section.  */
135	  int end_line;
136	};
137	
138	/* This table defines all the long-named options, says whether they
139	   use an argument, and maps them into equivalent single-letter options.  */
140	
141	struct option longopts[] =
142	{
143	  { "add-once",  no_argument, NULL, '1'},
144	  { "align",     required_argument, NULL, 'A'},
145	  { "append-new-sections", no_argument, NULL, 'a'},
146	  { "calign",    required_argument, NULL, 'C'},
147	  { "debug",     no_argument, NULL, 'g' },
148	  { "delete",    no_argument, NULL, 'r' },
149	  { "defentry",  required_argument, NULL, 'E' },
150	  { "defsection",  required_argument, NULL, 'S' },
151	  { "dir-file",  required_argument, NULL, 'd' },
152	  { "entry",     required_argument, NULL, 'e' },
153	  { "name",      required_argument, NULL, 't' },
154	  { "menuentry", required_argument, NULL, 't' },
155	  { "description", required_argument, NULL, 'c' },
156	  { "help",      no_argument, NULL, 'h' },
157	  { "no-indent", no_argument, NULL, 'I' },
158	  { "infodir",   required_argument, NULL, 'D' },
159	  { "info-dir",  required_argument, NULL, 'D' },
160	  { "info-file", required_argument, NULL, 'i' },
161	  { "item",      required_argument, NULL, 'e' },
162	  { "keep-old",  no_argument, NULL, 'k' },
163	  { "maxwidth",  required_argument, NULL, 'W'},
164	  { "max-width", required_argument, NULL, 'W'},
165	  { "quiet",     no_argument, NULL, 'q' },
166	  { "remove",    no_argument, NULL, 'r' },
167	  { "remove-exactly",    no_argument, NULL, 'x' },
168	  { "section",           required_argument, NULL, 's' },
169	  { "regex",     required_argument, NULL, 'R' },
170	  { "silent",    no_argument, NULL, 'q' },
171	  { "test",      no_argument, NULL, 'n' },
172	  { "dry-run",   no_argument, NULL, 'n' },
173	  { "version",   no_argument, NULL, 'V' },
174	  { 0 }
175	};
176	
177	regex_t *psecreg = NULL;
178	
179	/* Nonzero means that the name specified for the Info file will be used
180	   (without removing .gz, .info extension or leading path) to match the
181	   entries that must be removed.  */
182	int remove_exactly = 0;
183	
184	/* Nonzero means that sections that don't have entries in them will be
185	   deleted.  */
186	int remove_empty_sections = 1;
187	
188	/* Nonzero means that new Info entries into the DIR file go into all 
189	   sections that match with --section-regex or --section.  Zero means 
190	   that new entries go into only the first section that matches.  */
191	int add_entries_into_all_matching_sections = 1;
192	
193	/* Nonzero means we do not replace same-named info entries.  */
194	int keep_old_flag = 0;
195	
196	/* Nonzero means --test was specified, to inhibit updating the dir file.  */
197	int chicken_flag = 0;
198	
199	/* Zero means that entries will not be formatted when they are either 
200	   added or replaced. */
201	int indent_flag = 1;
202	
203	/* Zero means that new sections will be added at the end of the DIR file. */
204	int order_new_sections_alphabetically_flag = 1;
205	
206	
207	/* Error message functions.  */
208	
209	void
210	vdiag (const char *fmt, const char *diagtype, va_list ap)
211	{
212	  fprintf (stderr, "%s: ", progname);
213	  if (diagtype)
214	    fprintf (stderr, "%s: ", diagtype);
215	  vfprintf (stderr, fmt, ap);
216	  putc ('\n', stderr);
217	}
218	
219	void
220	error (const char *fmt, ...)
221	{
222	  va_list ap;
223	
224	  va_start (ap, fmt);
225	  vdiag (fmt, NULL, ap);
226	  va_end (ap);
227	}
228	
229	/* VARARGS1 */
230	void
231	warning (const char *fmt, ...)
232	{
233	  va_list ap;
234	
235	  va_start (ap, fmt);
236	  vdiag (fmt, "warning", ap);
237	  va_end (ap);
238	}
239	
240	/* Print error message and exit.  */
241	
242	void
243	fatal (const char *fmt, ...)
244	{
245	  va_list ap;
246	
247	  va_start (ap, fmt);
248	  vdiag (fmt, NULL, ap);
249	  va_end (ap);
250	  exit (EXIT_FAILURE);
251	}
252	
253	/* Return a newly-allocated string
254	   whose contents concatenate those of S1, S2, S3.  */
255	char *
256	concat (const char *s1, const char *s2, const char *s3)
257	{
258	  int len1 = strlen (s1), len2 = strlen (s2), len3 = strlen (s3);
259	  char *result = (char *) xmalloc (len1 + len2 + len3 + 1);
260	
261	  strcpy (result, s1);
262	  strcpy (result + len1, s2);
263	  strcpy (result + len1 + len2, s3);
264	  *(result + len1 + len2 + len3) = 0;
265	
266	  return result;
267	}
268	
269	/* Return a string containing SIZE characters
270	   copied from starting at STRING.  */
271	
272	char *
273	copy_string (const char *string, int size)
274	{
275	  int i;
276	  char *copy = (char *) xmalloc (size + 1);
277	  for (i = 0; i < size; i++)
278	    copy[i] = string[i];
279	  copy[size] = 0;
280	  return copy;
281	}
282	
283	/* Print fatal error message based on errno, with file name NAME.  */
284	
285	void
286	pfatal_with_name (const char *name)
287	{
288	  /* Empty files don't set errno, so we get something like
289	     "install-info: No error for foo", which is confusing.  */
290	  if (errno == 0)
291	    fatal (_("%s: empty file"), name);
292	
293	  fatal (_("%s for %s"), strerror (errno), name);
294	}
295	
296	/* Compare the menu item names in LINE1 (line length LEN1)
297	   and LINE2 (line length LEN2).  Return 1 if the item name
298	   in LINE1 is less, 0 otherwise.  */
299	
300	static int
301	menu_line_lessp (char *line1, int len1, char *line2, int len2)
302	{
303	  int minlen = (len1 < len2 ? len1 : len2);
304	  int i;
305	
306	  for (i = 0; i < minlen; i++)
307	    {
308	      /* If one item name is a prefix of the other,
309	         the former one is less.  */
310	      if (line1[i] == ':' && line2[i] != ':')
311	        return 1;
312	      if (line2[i] == ':' && line1[i] != ':')
313	        return 0;
314	      /* If they both continue and differ, one is less.  */
315	      if (line1[i] < line2[i])
316	        return 1;
317	      if (line1[i] > line2[i])
318	        return 0;
319	    }
320	  /* With a properly formatted dir file,
321	     we can only get here if the item names are equal.  */
322	  return 0;
323	}
324	
325	/* Compare the menu item names in LINE1 (line length LEN1)
326	   and LINE2 (line length LEN2).  Return 1 if the item names are equal,
327	   0 otherwise.  */
328	
329	static int
330	menu_line_equal (char *line1, int len1, char *line2, int len2)
331	{
332	  int minlen = (len1 < len2 ? len1 : len2);
333	  int i;
334	
335	  for (i = 0; i < minlen; i++)
336	    {
337	      /* If both item names end here, they are equal.  */
338	      if (line1[i] == ':' && line2[i] == ':')
339	        return 1;
340	      /* If they both continue and differ, one is less.  */
341	      if (line1[i] != line2[i])
342	        return 0;
343	    }
344	  /* With a properly formatted dir file,
345	     we can only get here if the item names are equal.  */
346	  return 1;
347	}
348	
349	
350	/* Given the full text of a menu entry, null terminated,
351	   return just the menu item name (copied).  */
352	
353	char *
354	extract_menu_item_name (char *item_text)
355	{
356	  char *p;
357	
358	  if (*item_text == '*')
359	    item_text++;
360	  while (*item_text == ' ')
361	    item_text++;
362	
363	  p = item_text;
364	  while (*p && *p != ':') p++;
365	  return copy_string (item_text, p - item_text);
366	}
367	
368	/* Given the full text of a menu entry, terminated by null or newline,
369	   return just the menu item file (copied).  */
370	
371	char *
372	extract_menu_file_name (char *item_text)
373	{
374	  char *p = item_text;
375	
376	  /* If we have text that looks like * ITEM: (FILE)NODE...,
377	     extract just FILE.  Otherwise return "(none)".  */
378	
379	  if (*p == '*')
380	    p++;
381	  while (*p == ' ')
382	    p++;
383	
384	  /* Skip to and past the colon.  */
385	  while (*p && *p != '\n' && *p != ':') p++;
386	  if (*p == ':') p++;
387	
388	  /* Skip past the open-paren.  */
389	  while (1)
390	    {
391	      if (*p == '(')
392	        break;
393	      else if (*p == ' ' || *p == '\t')
394	        p++;
395	      else
396	        return "(none)";
397	    }
398	  p++;
399	
400	  item_text = p;
401	
402	  /* File name ends just before the close-paren.  */
403	  while (*p && *p != '\n' && *p != ')') p++;
404	  if (*p != ')')
405	    return "(none)";
406	
407	  return copy_string (item_text, p - item_text);
408	}
409	
410	
411	
412	/* Return FNAME with any [.info][.gz] suffix removed.  */
413	
414	static char *
415	strip_info_suffix (char *fname)
416	{
417	  char *ret = xstrdup (fname);
418	  unsigned len = strlen (ret);
419	
420	  if (len > 3 && FILENAME_CMP (ret + len - 3, ".gz") == 0)
421	    {
422	      len -= 3;
423	      ret[len] = 0;
424	    }
425	  else if (len > 3 && FILENAME_CMP (ret + len - 3, ".xz") == 0)
426	    {
427	      len -= 3;
428	      ret[len] = 0;
429	    }
430	  else if (len > 4 && FILENAME_CMP (ret + len - 4, ".bz2") == 0)
431	    {
432	      len -= 4;
433	      ret[len] = 0;
434	    }
435	  else if (len > 3 && FILENAME_CMP (ret + len - 3, ".lz") == 0)
436	    {
437	      len -= 3;
438	      ret[len] = 0;
439	    }
440	  else if (len > 5 && FILENAME_CMP (ret + len - 5, ".lzma") == 0)
441	   {
442	      len -= 5;
443	      ret[len] =0;
444	   }
445	
446	  if (len > 5 && FILENAME_CMP (ret + len - 5, ".info") == 0)
447	    {
448	      len -= 5;
449	      ret[len] = 0;
450	    }
451	  else if (len > 4 && FILENAME_CMP (ret + len - 4, ".inf") == 0)
452	    {
453	      len -= 4;
454	      ret[len] = 0;
455	    }
456	#ifdef __MSDOS__
457	  else if (len > 4 && (FILENAME_CMP (ret + len - 4, ".inz") == 0
458	                       || FILENAME_CMP (ret + len - 4, ".igz") == 0))
459	    {
460	      len -= 4;
461	      ret[len] = 0;
462	    }
463	#endif /* __MSDOS__ */
464	
465	  return ret;
466	}
467	
468	
469	/* Return true if ITEM matches NAME and is followed by TERM_CHAR.  ITEM
470	   can also be followed by `.gz', `.info.gz', or `.info' (and then
471	   TERM_CHAR) and still match.  */
472	
473	static int
474	menu_item_equal (const char *item, char term_char, const char *name)
475	{
476	  int ret;
477	  const char *item_basename = item;
478	  unsigned name_len = strlen (name);
479	
480	  /* We must compare the basename in ITEM, since we are passed the
481	     basename of the original info file.  Otherwise, a new entry like
482	     "lilypond/lilypond" won't match "lilypond".
483	     
484	     Actually, it seems to me that we should really compare the whole
485	     name, and not just the basename.  Couldn't there be dir1/foo.info
486	     and dir2/foo.info?  Also, it seems like we should be using the
487	     filename from the new dir entries, not the filename on the command
488	     line.  Not worrying about those things right now, though.  --karl,
489	     26mar04.  */
490	  if (!remove_exactly) {
491	  while (*item_basename && !IS_SLASH (*item_basename)
492	         && *item_basename != term_char)
493	    item_basename++;
494	  if (! *item_basename || *item_basename == term_char)
495	    item_basename = item;  /* no /, use original */
496	  else
497	    item_basename++;       /* have /, move past it */
498	  }
499	    
500	  /* First, ITEM must actually match NAME (usually it won't).  */
501	  ret = mbsncasecmp (item_basename, name, name_len) == 0;
502	  if (ret)
503	    {
504	      /* Then, `foobar' doesn't match `foo', so be sure we've got all of
505	         ITEM.  The various suffixes should never actually appear in the
506	         dir file, but sometimes people put them in.  */
507	      static char *suffixes[]
508	        = { "", ".info.gz", ".info", ".inf", ".gz",
509	#ifdef __MSDOS__
510	            ".inz", ".igz",
511	#endif
512	            NULL };
513	      unsigned i;
514	      ret = 0;
515	      for (i = 0; !ret && suffixes[i]; i++)
516	        {
517	          char *suffix = suffixes[i];
518	          unsigned suffix_len = strlen (suffix);
519	          ret = mbsncasecmp (item_basename + name_len, suffix, suffix_len) == 0
520	                && item_basename[name_len + suffix_len] == term_char;
521	        }
522	    }
523	
524	  return ret;
525	}
526	
527	
528	
529	void
530	suggest_asking_for_help (void)
531	{
532	  fprintf (stderr, _("\tTry `%s --help' for a complete list of options.\n"),
533	           progname);
534	  exit (EXIT_FAILURE);
535	}
536	
537	void
538	print_help (void)
539	{
540	  printf (_("Usage: %s [OPTION]... [INFO-FILE [DIR-FILE]]\n"), progname);
541	  puts ("");
542	  puts (_("Add or remove entries in INFO-FILE from the Info directory DIR-FILE."));
543	  puts (_("INFO-FILE and DIR-FILE are required unless the --info-file\n\
544	or --dir-file (or --info-dir) options are given, respectively."));
545	  puts ("");
546	
547	  puts (_("\
548	Options:\n\
549	 --add-once          add only to first matching section, not all.\n\
550	 --align=COL         start description of new entries at column COL.\n\
551	 --calign=COL        format second and subsequent description lines to\n\
552	                       start at column COL."));
553	
554	  puts (_("\
555	 --debug             report what is being done.\n\
556	 --delete            delete existing entries for INFO-FILE from DIR-FILE;\n\
557	                      don't insert any new entries.\n\
558	 --defsection=TEXT   like --section, but only use TEXT if no sections\n\
559	                      are present in INFO-FILE (replacing \"Miscellaneous\").\n\
560	 --description=TEXT  the description of the entry is TEXT; used with\n\
561	                      the --name option to become synonymous with the\n\
562	                      --entry option.\n\
563	 --dir-file=NAME     specify file name of Info directory file;\n\
564	                      equivalent to using the DIR-FILE argument.\n\
565	 --dry-run           same as --test."));
566	
567	  puts (_("\
568	 --entry=TEXT        insert TEXT as an Info directory entry,\n\
569	                      overriding any corresponding entry from DIR-FILE.\n\
570	                      TEXT is written as an Info menu item line followed\n\
571	                       by zero or more extra lines starting with whitespace.\n\
572	                      If you specify more than one entry, all are added.\n\
573	                      If you don't specify any entries, they are determined\n\
574	                       from information in the Info file itself."));
575	
576	  puts (_("\
577	 --help              display this help and exit.\n\
578	 --info-dir=DIR      same as --dir-file=DIR/dir.\n\
579	 --info-file=FILE    specify Info file to install in the directory;\n\
580	                      equivalent to using the INFO-FILE argument.\n\
581	 --item=TEXT         same as --entry=TEXT.\n\
582	 --keep-old          do not replace entries, or remove empty sections."));
583	
584	  puts (_("\
585	 --maxwidth, --max-width=COL  wrap description at column COL.\n\
586	 --menuentry=TEXT    same as --name=TEXT.\n\
587	 --name=TEXT         the name of the entry is TEXT; used with --description\n\
588	                      to become synonymous with the --entry option.\n\
589	 --no-indent         do not format new entries in the DIR file.\n\
590	 --quiet             suppress warnings."));
591	
592	  puts (_("\
593	 --regex=R           put this file's entries in all sections that match the\n\
594	                      regular expression R (ignoring case).\n\
595	 --remove            same as --delete.\n\
596	 --remove-exactly    only remove if the info file name matches exactly;\n\
597	                      suffixes such as .info and .gz are not ignored.\n\
598	 --section=SEC       put entries in section SEC of the directory.\n\
599	                      If you specify more than one section, all the entries\n\
600	                       are added in each of the sections.\n\
601	                      If you don't specify any sections, they are determined\n\
602	                       from information in the Info file itself;\n\
603	                       if nothing is available there, the --defsection\n\
604	                       value is used; if that is not specified, the\n\
605	                       final default is \"Miscellaneous\".\n\
606	 --section R SEC     equivalent to --regex=R --section=SEC --add-once."));
607	
608	  puts (_("\
609	 --silent            suppress warnings.\n\
610	 --test              suppress updating of DIR-FILE.\n\
611	 --version           display version information and exit."));
612	
613	  puts ("");
614	  
615	  puts (_("\
616	Email bug reports to bug-texinfo@gnu.org,\n\
617	general questions and discussion to help-texinfo@gnu.org.\n\
618	Texinfo home page: http://www.gnu.org/software/texinfo/"));
619	}
620	
621	
622	/* If DIRFILE does not exist, and we are not in test mode, create a
623	   minimal one (or abort).  If it already exists, do nothing.  */
624	
625	static void
626	ensure_dirfile_exists (char *dirfile)
627	{
628	  int desc;
629	  
630	  if (chicken_flag)
631	    return;
632	    
633	  desc = open (dirfile, O_RDONLY);
634	  if (desc < 0 && errno == ENOENT)
635	    {
636	      FILE *f;
637	      char *readerr = strerror (errno);
638	      close (desc);
639	      f = fopen (dirfile, "w");
640	      if (f)
641	        {
642	          fprintf (f, _("This is the file .../info/dir, which contains the\n\
643	topmost node of the Info hierarchy, called (dir)Top.\n\
644	The first time you invoke Info you start off looking at this node.\n\
645	%c\n\
646	%s\tThis is the top of the INFO tree\n\
647	\n\
648	  This (the Directory node) gives a menu of major topics.\n\
649	  Typing \"q\" exits, \"?\" lists all Info commands, \"d\" returns here,\n\
650	  \"h\" gives a primer for first-timers,\n\
651	  \"mEmacs<Return>\" visits the Emacs manual, etc.\n\
652	\n\
653	  In Emacs, you can click mouse button 2 on a menu item or cross reference\n\
654	  to select it.\n\
655	\n\
656	%s\n\
657	"),         /* These keywords must not be translated:  */
658	            '\x1f',  "File: dir,\tNode: Top",  "* Menu:"
659	          );
660	          if (fclose (f) < 0)
661	            pfatal_with_name (dirfile);
662	        }
663	      else
664	        {
665	          /* Didn't exist, but couldn't open for writing.  */
666		  fatal (_("%s: could not read (%s) and could not create (%s)"),
667			 dirfile, readerr, strerror (errno));
668	        }
669	    }
670	  else
671	    close (desc); /* It already existed, so fine.  */
672	}
673	
674	/* Open FILENAME and return the resulting stream pointer.  If it doesn't
675	   exist, try FILENAME.gz.  If that doesn't exist either, call
676	   CREATE_CALLBACK (with FILENAME as arg) to create it, if that is
677	   non-NULL.  If still no luck, return a null pointer.
678	
679	   Return the actual name of the file we tried to open in
680	   OPENED_FILENAME and the compress program to (de)compress it in
681	   COMPRESSION_PROGRAM.  The compression program is determined by the
682	   magic number, not the filename.
683	   
684	   Return either stdin reading the file, or a non-stdin pipe reading
685	   the output of the compression program.  */
686	FILE *
687	open_possibly_compressed_file (char *filename,
688	    void (*create_callback) (char *),
689	    char **opened_filename, char **compression_program) 
690	{
691	  char *local_opened_filename, *local_compression_program;
692	  int nread;
693	  char data[13];
694	  FILE *f;
695	
696	  /* We let them pass NULL if they don't want this info, but it's easier
697	     to always determine it.  */
698	  if (!opened_filename)
699	    opened_filename = &local_opened_filename;
700	
701	  *opened_filename = filename;
702	  f = fopen (*opened_filename, FOPEN_RBIN);
703	  if (!f)
704	    {
705	      *opened_filename = concat (filename, ".gz", "");
706	      f = fopen (*opened_filename, FOPEN_RBIN);
707	    }
708	  if (!f)
709	    {
710	      free (*opened_filename);
711	      *opened_filename = concat (filename, ".xz", "");
712	      f = fopen (*opened_filename, FOPEN_RBIN);
713	    }
714	  if (!f)
715	    {
716	      free (*opened_filename);
717	      *opened_filename = concat (filename, ".bz2", "");
718	      f = fopen (*opened_filename, FOPEN_RBIN);
719	    }
720	  if (!f)
721	    {
722	      free (*opened_filename);
723	      *opened_filename = concat (filename, ".lz", "");
724	      f = fopen (*opened_filename, FOPEN_RBIN);
725	    }
726	  if (!f)
727	    {
728	     free (*opened_filename);
729	     *opened_filename = concat (filename, ".lzma", "");
730	     f = fopen (*opened_filename, FOPEN_RBIN);
731	    }
732	#ifdef __MSDOS__
733	  if (!f)
734	    {
735	      free (*opened_filename);
736	      *opened_filename = concat (filename, ".igz", "");
737	      f = fopen (*opened_filename, FOPEN_RBIN);
738	    }
739	  if (!f)
740	    {
741	      free (*opened_filename);
742	      *opened_filename = concat (filename, ".inz", "");
743	      f = fopen (*opened_filename, FOPEN_RBIN);
744	    }
745	#endif /* __MSDOS__ */
746	  if (!f)
747	    {
748	      /* The file was not found with any extention added.  Try the
749	         original file again. */
750	      free (*opened_filename);
751	      *opened_filename = filename;
752	
753	      if (create_callback)
754	        {
755	          /* Create the file if we can.  */
756	          (*create_callback) (filename);
757	
758	          /* And try opening it again.  */
759	          f = fopen (*opened_filename, FOPEN_RBIN);
760	          if (!f)
761	            return 0;
762	        }
763	      else
764	        return 0;
765	    }
766	
767	  /* Read first few bytes of file rather than relying on the filename.
768	     If the file is shorter than this it can't be usable anyway.  */
769	  nread = fread (data, sizeof (data), 1, f);
770	  if (nread != 1)
771	    {
772	      /* Empty files don't set errno.  Calling code can check for
773	         this, so make sure errno == 0 just in case it isn't already. */
774	      if (nread == 0)
775	        errno = 0;
776	      return 0;
777	    }
778	
779	  if (!compression_program)
780	    compression_program = &local_compression_program;
781	
782	  if (data[0] == '\x1f' && data[1] == '\x8b')
783	#if STRIP_DOT_EXE
784	    /* An explicit .exe yields a better diagnostics from popen below
785	       if they don't have gzip installed.  */
786	    *compression_program = "gzip.exe";
787	#else
788	    *compression_program = "gzip";
789	#endif
790	
791	  else if (data[0] == '\xFD' && data[1] == '7' && data[2] == 'z'
792	           && data[3] == 'X' && data[4] == 'Z' && data[5] == 0)
793	#ifndef STRIP_DOT_EXE
794	    *compression_program = "xz.exe";
795	#else
796	    *compression_program = "xz";
797	#endif
798	
799	  else if (data[0] == 'B' && data[1] == 'Z' && data[2] == 'h')
800	#ifndef STRIP_DOT_EXE
801	    *compression_program = "bzip2.exe";
802	#else
803	    *compression_program = "bzip2";
804	#endif
805	
806	  else if (data[0] == 'B' && data[1] == 'Z' && data[2] == '0')
807	#ifndef STRIP_DOT_EXE
808	    *compression_program = "bzip.exe";
809	#else
810	    *compression_program = "bzip";
811	#endif
812	
813	  else if (data[0] == 0x4C && data[1] == 0x5A && data[2] == 0x49
814	           && data[3] == 0x50 && data[4] == 1)		/* "LZIP" */
815	#ifndef STRIP_DOT_EXE
816	    *compression_program = "lzip.exe";
817	#else
818	    *compression_program = "lzip";
819	#endif
820	
821	    /* We (try to) match against old lzma format (which lacks proper
822	       header, two first matches), as well as the new format (last match).  */
823	  else if ((data[9] == 0x00 && data[10] == 0x00 && data[11] == 0x00
824	            && data[12] == 0x00)
825	           || (data[5] == '\xFF' && data[6] == '\xFF' && data[7] == '\xFF'
826	               && data[8] == '\xFF' && data[9] == '\xFF' && data[10] == '\xFF'
827	               && data[11] == '\xFF' && data[12] == '\xFF') 
828	           || (data[0] == '\xFF' && data[1] == 'L' && data[2] == 'Z'
829	               && data[3] == 'M' && data[4] == 'A' && data[5] == 0x00))
830	#ifndef STRIP_DOT_EXE
831	    *compression_program = "lzma.exe";
832	#else
833	    *compression_program = "lzma";
834	#endif
835	
836	  else
837	    *compression_program = NULL;
838	
839	  /* Seek back over the magic bytes.  */
840	  if (fseek (f, 0, 0) < 0)
841	    return 0;
842	
843	  if (*compression_program)
844	    { /* It's compressed, so open a pipe.  */
845	      char *command = concat (*compression_program, " -d", "");
846	
847	      if (fclose (f) < 0)
848	        return 0;
849	      f = freopen (*opened_filename, FOPEN_RBIN, stdin);
850	      if (!f)
851	        return 0;
852	      f = popen (command, "r");
853	      if (!f)
854	        {
855	          /* Used for error message in calling code. */
856	          *opened_filename = command;
857	          return 0;
858	        }
859	    }
860	  else
861	    {
862	#if O_BINARY
863	      /* Since this is a text file, and we opened it in binary mode,
864	         switch back to text mode.  */
865	      f = freopen (*opened_filename, "r", f);
866	      if (! f)
867		return 0;
868	#endif
869	    }
870	
871	  return f;
872	}
873	
874	/* Read all of file FILENAME into memory and return the address of the
875	   data.  Store the size of the data into SIZEP.  If need be, uncompress
876	   (i.e., try FILENAME.gz et al. if FILENAME does not exist) and store
877	   the actual file name that was opened into OPENED_FILENAME (if it is
878	   non-NULL), and the companion compression program (if any, else NULL)
879	   into COMPRESSION_PROGRAM (if that is non-NULL).  If trouble, return
880	   a null pointer. */
881	
882	char *
883	readfile (char *filename, int *sizep,
884	    void (*create_callback) (char *), char **opened_filename,
885	    char **compression_program)
886	{
887	  FILE *f;
888	  int filled = 0;
889	  int data_size = 8192;
890	  char *data = xmalloc (data_size);
891	
892	  /* If they passed the space for the file name to return, use it.  */
893	  f = open_possibly_compressed_file (filename, create_callback,
894	                                     opened_filename,
895	                                     compression_program);
896	
897	  if (!f)
898	    return 0;
899	
900	  for (;;)
901	    {
902	      int nread = fread (data + filled, 1, data_size - filled, f);
903	      if (nread < 0)
904	        return 0;
905	      if (nread == 0)
906	        break;
907	
908	      filled += nread;
909	      if (filled == data_size)
910	        {
911	          data_size += 65536;
912	          data = xrealloc (data, data_size);
913	        }
914	    }
915	
916	  /* We'll end up wasting space if we're not passing the filename back
917	     and it is not just FILENAME, but so what.  */
918	  /* We need to close the stream, since on some systems the pipe created
919	     by popen is simulated by a temporary file which only gets removed
920	     inside pclose.  */
921	  if (f != stdin)
922	    pclose (f);
923	
924	  *sizep = filled;
925	  return data;
926	}
927	
928	/* Output the old dir file, interpolating the new sections
929	   and/or new entries where appropriate.  If COMPRESSION_PROGRAM is not
930	   null, pipe to it to create DIRFILE.  Thus if we read dir.gz on input,
931	   we'll write dir.gz on output.  */
932	
933	static void
934	output_dirfile (char *dirfile, int dir_nlines, struct line_data *dir_lines,
935	                int n_entries_to_add, struct spec_entry *entries_to_add,
936	                struct spec_section *input_sections, char *compression_program)
937	{
938	  int n_entries_added = 0;
939	  int i;
940	  FILE *output;
941	
942	  if (compression_program)
943	    {
944	      char *command = concat (compression_program, ">", dirfile);
945	      output = popen (command, "w");
946	    }
947	  else
948	    output = fopen (dirfile, "w");
949	
950	  if (!output)
951	    {
952	      perror (dirfile);
953	      exit (EXIT_FAILURE);
954	    }
955	
956	  for (i = 0; i <= dir_nlines; i++)
957	    {
958	      int j;
959	
960	      /* If we decided to output some new entries before this line,
961	         output them now.  */
962	      if (dir_lines[i].add_entries_before)
963	        for (j = 0; j < n_entries_to_add; j++)
964	          {
965	            struct spec_entry *this = dir_lines[i].add_entries_before[j];
966	            if (this == 0)
967	              break;
968	            if (n_entries_added >= 1 && 
969	                !add_entries_into_all_matching_sections)
970	              break;
971	            fputs (this->text, output);
972	            n_entries_added++;
973	          }
974	      /* If we decided to add some sections here
975	         because there are no such sections in the file,
976	         output them now.  
977	         FIXME:  we add all sections here, but they should
978	         be interspersed throughout the DIR file in 
979	         alphabetic order. */
980	      if (dir_lines[i].add_sections_before)
981	        {
982	          struct spec_section *spec;
983	          struct spec_entry *entry;
984	          struct spec_entry **entries;
985	          int n_entries = 0;
986	
987	          /* If we specified --add-once, and we've added an entry, then
988	             it's time to bail. */
989	          if (n_entries_added >= 1 && 
990	              !add_entries_into_all_matching_sections)
991	            break;
992	
993	          qsort (dir_lines[i].add_sections_before, 
994	                 dir_lines[i].num_sections_to_add, 
995	                 sizeof (struct spec_section *), compare_section_names);
996	
997	          /* Count the entries and allocate a vector for all of them.  */
998	          for (entry = entries_to_add; entry; entry = entry->next)
999	            n_entries++;
1000	          entries = ((struct spec_entry **)
1001	                     xmalloc (n_entries * sizeof (struct spec_entry *)));
1002	
1003	          /* Fill the vector ENTRIES with pointers to all the sections,
1004	             and sort them.  */
1005	          j = 0;
1006	          for (entry = entries_to_add; entry; entry = entry->next)
1007	            entries[j++] = entry;
1008	          qsort (entries, n_entries, sizeof (struct spec_entry *),
1009	                 compare_entries_text);
1010	
1011	          /* Generate the new sections in alphabetical order.  In each
1012	             new section, output all of the entries that belong to that
1013	             section, in alphabetical order.  */
1014	          for (j = 0; j < dir_lines[i].num_sections_to_add; j++)
1015	            {
1016	              spec = dir_lines[i].add_sections_before[j];
1017	              if (spec->missing)
1018	                {
1019	                  int k;
1020	
1021	                  putc ('\n', output);
1022	                  fputs (spec->name, output);
1023	                  putc ('\n', output);
1024	                  spec->missing = 0;
1025	                  for (k = 0; k < n_entries; k++)
1026	                    {
1027	                      struct spec_section *spec1;
1028	                      /* Did they at all want this entry to be put into
1029	                         this section?  */
1030	                      entry = entries[k];
1031	                      for (spec1 = entry->entry_sections;
1032	                           spec1 && spec1 != entry->entry_sections_tail;
1033	                           spec1 = spec1->next)
1034	                        {
1035	                          if (!strcmp (spec1->name, spec->name))
1036	                            break;
1037	                        }
1038	                      if (spec1 && spec1 != entry->entry_sections_tail)
1039	                        fputs (entry->text, output);
1040	                    }
1041	                }
1042	            }
1043	
1044	          n_entries_added++;
1045	          free (entries);
1046	        }
1047	
1048	      /* Output the original dir lines unless marked for deletion.  */
1049	      if (i < dir_nlines && !dir_lines[i].delete)
1050	        {
1051	          fwrite (dir_lines[i].start, 1, dir_lines[i].size, output);
1052	          putc ('\n', output);
1053	        }
1054	    }
1055	
1056	  /* Some systems, such as MS-DOS, simulate pipes with temporary files.
1057	     On those systems, the compressor actually gets run inside pclose,
1058	     so we must call pclose.  */
1059	  if (compression_program)
1060	    pclose (output);
1061	  else
1062	    fclose (output);
1063	}
1064	
1065	/* Parse the input to find the section names and the entry names it
1066	   specifies.  Return the number of entries to add from this file.  */
1067	int
1068	parse_input (const struct line_data *lines, int nlines,
1069	             struct spec_section **sections, struct spec_entry **entries,
1070	             int delete_flag) 
1071	{
1072	  int n_entries = 0;
1073	  int prefix_length = strlen ("INFO-DIR-SECTION ");
1074	  struct spec_section *head = *sections, *tail = NULL;
1075	  int reset_tail = 0;
1076	  char *start_of_this_entry = 0;
1077	  int ignore_sections = *sections != 0;
1078	  int ignore_entries  = delete_flag ? 0: *entries  != 0;
1079	
1080	  int i;
1081	
1082	  if (ignore_sections && ignore_entries)
1083	    return 0;
1084	
1085	  /* Loop here processing lines from the input file.  Each
1086	     INFO-DIR-SECTION entry is added to the SECTIONS linked list.
1087	     Each START-INFO-DIR-ENTRY block is added to the ENTRIES linked
1088	     list, and all its entries inherit the chain of SECTION entries
1089	     defined by the last group of INFO-DIR-SECTION entries we have
1090	     seen until that point.  */
1091	  for (i = 0; i < nlines; i++)
1092	    {
1093	      if (!ignore_sections
1094	          && !strncmp ("INFO-DIR-SECTION ", lines[i].start, prefix_length))
1095	        {
1096	          struct spec_section *next
1097	            = (struct spec_section *) xmalloc (sizeof (struct spec_section));
1098	          next->name = copy_string (lines[i].start + prefix_length,
1099	                                    lines[i].size - prefix_length);
1100	          next->next = *sections;
1101	          next->missing = 1;
1102	          if (reset_tail)
1103	            {
1104	              tail = *sections;
1105	              reset_tail = 0;
1106	            }
1107	          *sections = next;
1108	          head = *sections;
1109	        }
1110	      /* If entries were specified explicitly with command options,
1111	         ignore the entries in the input file.  */
1112	      else if (!ignore_entries)
1113	        {
1114	          if (!strncmp ("START-INFO-DIR-ENTRY", lines[i].start, lines[i].size)
1115	              && sizeof ("START-INFO-DIR-ENTRY") - 1 == lines[i].size)
1116	            {
1117	              if (!*sections)
1118	                {
1119	                  /* We found an entry, but didn't yet see any sections
1120	                     specified.  Default to section "Miscellaneous".  */
1121	                  *sections = (struct spec_section *)
1122	                    xmalloc (sizeof (struct spec_section));
1123	                  (*sections)->name = "Miscellaneous";
1124	                  (*sections)->next = 0;
1125	                  (*sections)->missing = 1;
1126	                  head = *sections;
1127	                }
1128	              /* Next time we see INFO-DIR-SECTION, we will reset the
1129	                 tail pointer.  */
1130	              reset_tail = 1;
1131	
1132	              if (start_of_this_entry != 0)
1133	                fatal (_("START-INFO-DIR-ENTRY without matching END-INFO-DIR-ENTRY"));
1134	              start_of_this_entry = lines[i + 1].start;
1135	            }
1136	          else if (start_of_this_entry)
1137	            {
1138	              if ((!strncmp ("* ", lines[i].start, 2)
1139	                   && lines[i].start > start_of_this_entry)
1140	                  || (!strncmp ("END-INFO-DIR-ENTRY",
1141	                                lines[i].start, lines[i].size)
1142	                      && sizeof ("END-INFO-DIR-ENTRY") - 1 == lines[i].size))
1143	                {
1144	                  /* We found an end of this entry.  Allocate another
1145	                     entry, fill its data, and add it to the linked
1146	                     list.  */
1147	                  struct spec_entry *next
1148	                    = (struct spec_entry *) xmalloc (sizeof (struct spec_entry));
1149	                  next->text
1150	                    = copy_string (start_of_this_entry,
1151	                                   lines[i].start - start_of_this_entry);
1152	                  next->text_len = lines[i].start - start_of_this_entry;
1153	                  next->entry_sections = head;
1154	                  next->entry_sections_tail = tail;
1155	                  next->next = *entries;
1156	                  *entries = next;
1157	                  n_entries++;
1158	                  if (!strncmp ("END-INFO-DIR-ENTRY",
1159	                                lines[i].start, lines[i].size)
1160	                      && sizeof ("END-INFO-DIR-ENTRY") - 1 == lines[i].size)
1161	                    start_of_this_entry = 0;
1162	                  else
1163	                    start_of_this_entry = lines[i].start;
1164	                }
1165	              else if (!strncmp ("END-INFO-DIR-ENTRY",
1166	                                 lines[i].start, lines[i].size)
1167	                       && sizeof ("END-INFO-DIR-ENTRY") - 1 == lines[i].size)
1168	                fatal (_("END-INFO-DIR-ENTRY without matching START-INFO-DIR-ENTRY"));
1169	            }
1170	        }
1171	    }
1172	  if (start_of_this_entry != 0)
1173	    fatal (_("START-INFO-DIR-ENTRY without matching END-INFO-DIR-ENTRY"));
1174	
1175	  /* If we ignored the INFO-DIR-ENTRY directives, we need now go back
1176	     and plug the names of all the sections we found into every
1177	     element of the ENTRIES list.  */
1178	  if (ignore_entries && *entries)
1179	    {
1180	      struct spec_entry *entry;
1181	
1182	      for (entry = *entries; entry; entry = entry->next)
1183	        {
1184	          entry->entry_sections = head;
1185	          entry->entry_sections_tail = tail;
1186	        }
1187	    }
1188	
1189	  return n_entries;
1190	}
1191	
1192	
1193	/* Parse the dir file whose basename is BASE_NAME.  Find all the
1194	   nodes, and their menus, and the sections of their menus.  */
1195	static void
1196	parse_dir_file (struct line_data *lines, int nlines, struct node **nodes)
1197	{
1198	  int node_header_flag = 0;
1199	  int i;
1200	
1201	  *nodes = 0;
1202	  for (i = 0; i < nlines; i++)
1203	    {
1204	      /* Parse node header lines.  */
1205	      if (node_header_flag)
1206	        {
1207	          int j, end;
1208	          for (j = 0; j < lines[i].size; j++)
1209	            /* Find the node name and store it in the `struct node'.  */
1210	            if (!strncmp ("Node:", lines[i].start + j, 5))
1211	              {
1212	                char *line = lines[i].start;
1213	                /* Find the start of the node name.  */
1214	                j += 5;
1215	                while (line[j] == ' ' || line[j] == '\t')
1216	                  j++;
1217	                /* Find the end of the node name.  */
1218	                end = j;
1219	                while (line[end] != 0 && line[end] != ',' && line[end] != '\n'
1220	                       && line[end] != '\t')
1221	                  end++;
1222	                (*nodes)->name = copy_string (line + j, end - j);
1223	              }
1224	          node_header_flag = 0;
1225	        }
1226	
1227	      /* Notice the start of a node.  */
1228	      if (*lines[i].start == 037)
1229	        {
1230	          struct node *next = (struct node *) xmalloc (sizeof (struct node));
1231	
1232	          next->next = *nodes;
1233	          next->name = NULL;
1234	          next->start_line = i;
1235	          next->end_line = 0;
1236	          next->menu_start = NULL;
1237	          next->sections = NULL;
1238	          next->last_section = NULL;
1239	
1240	          if (*nodes != 0)
1241	            (*nodes)->end_line = i;
1242	          /* Fill in the end of the last menu section
1243	             of the previous node.  */
1244	          if (*nodes != 0 && (*nodes)->last_section != 0)
1245	            (*nodes)->last_section->end_line = i;
1246	
1247	          *nodes = next;
1248	
1249	          /* The following line is the header of this node;
1250	             parse it.  */
1251	          node_header_flag = 1;
1252	        }
1253	
1254	      /* Notice the lines that start menus.  */
1255	      if (*nodes != 0 && !strncmp ("* Menu:", lines[i].start, 7))
1256	        (*nodes)->menu_start = lines[i + 1].start;
1257	
1258	      /* Notice sections in menus.  */
1259	      if (*nodes != 0
1260	          && (*nodes)->menu_start != 0
1261	          && *lines[i].start != '\n'
1262	          && *lines[i].start != '*'
1263	          && *lines[i].start != ' '
1264	          && *lines[i].start != '\t')
1265	        {
1266	          /* Add this menu section to the node's list.
1267	             This list grows in forward order.  */
1268	          struct menu_section *next
1269	            = (struct menu_section *) xmalloc (sizeof (struct menu_section));
1270	
1271	          next->start_line = i + 1;
1272	          next->next = 0;
1273	          next->end_line = 0;
1274	          next->name = copy_string (lines[i].start, lines[i].size);
1275	          if ((*nodes)->sections)
1276	            {
1277	              (*nodes)->last_section->next = next;
1278	              (*nodes)->last_section->end_line = i;
1279	            }
1280	          else
1281	            (*nodes)->sections = next;
1282	          (*nodes)->last_section = next;
1283	        }
1284	
1285	    }
1286	
1287	  /* Finish the info about the end of the last node.  */
1288	  if (*nodes != 0)
1289	    {
1290	      (*nodes)->end_line = nlines;
1291	      if ((*nodes)->last_section != 0)
1292	        (*nodes)->last_section->end_line = nlines;
1293	    }
1294	}
1295	
1296	
1297	/* Iterate through NLINES LINES looking for an entry that has a name
1298	   that matches NAME.  If such an entry is found, flag the entry for 
1299	   deletion later on. */
1300	
1301	int
1302	mark_entry_for_deletion (struct line_data *lines, int nlines, char *name)
1303	{
1304	  int something_deleted = 0;
1305	  int i;
1306	  for (i = 0; i < nlines; i++)
1307	    {
1308	      /* Check for an existing entry that should be deleted.
1309	         Delete all entries which specify this file name.  */
1310	      if (*lines[i].start == '*')
1311	        {
1312	          char *q;
1313	          char *p = lines[i].start;
1314	
1315	          p++; /* skip * */
1316	          while (*p == ' ') p++; /* ignore following spaces */
1317	          q = p; /* remember this, it's the beginning of the menu item.  */
1318	
1319	          /* Read menu item.  */
1320	          while (*p != 0 && *p != ':')
1321	            p++;
1322	          p++; /* skip : */
1323	
1324	          if (*p == ':')
1325	            { /* XEmacs-style entry, as in * Mew::Messaging.  */
1326	              if (menu_item_equal (q, ':', name))
1327	                {
1328	                  lines[i].delete = 1;
1329	                  something_deleted = 1;
1330	                }
1331	            }
1332	          else
1333	            { /* Emacs-style entry, as in * Emacs: (emacs).  */
1334	              while (*p == ' ') p++; /* skip spaces after : */
1335	              if (*p == '(')         /* if at parenthesized (FILENAME) */
1336	                {
1337	                  p++;
1338	                  if (menu_item_equal (p, ')', name))
1339	                    {
1340	                      lines[i].delete = 1;
1341	                      something_deleted = 1;
1342	                    }
1343	                }
1344	            }
1345	        }
1346	
1347	      /* Treat lines that start with whitespace
1348	         as continuations; if we are deleting an entry,
1349	         delete all its continuations as well.  */
1350	      else if (i > 0 && (*lines[i].start == ' ' || *lines[i].start == '\t'))
1351	        {
1352	          lines[i].delete = lines[i - 1].delete;
1353	        }
1354	    }
1355	  return something_deleted;
1356	}
1357	
1358	
1359	/* Assuming the current column is COLUMN, return the column that
1360	   printing C will move the cursor to.
1361	   The first column is 0.
1362	   This function is used to assist in indenting of entries. */
1363	
1364	static size_t
1365	adjust_column (size_t column, char c)
1366	{
1367	  if (c == '\b')
1368	    {
1369	      if (column > 0)
1370	        column--;
1371	    }
1372	  else if (c == '\r')
1373	    column = 0;
1374	  else if (c == '\t')
1375	    column += TAB_WIDTH - column % TAB_WIDTH;
1376	  else                          /* if (isprint (c)) */
1377	    column++;
1378	  return column;
1379	}
1380	
1381	/* Indent the Info entry's NAME and DESCRIPTION.  Lines are wrapped at the
1382	   WIDTH column.  The description on first line is indented at the CALIGN-th 
1383	   column, and all subsequent lines are indented at the ALIGN-th column.  
1384	   The resulting Info entry is put into OUTSTR.
1385	   NAME is of the form "* TEXT (TEXT)[:TEXT].".
1386	 */
1387	static int
1388	format_entry (char *name, size_t name_len, char *desc, size_t desc_len, 
1389	              int calign, int align, size_t width, 
1390	              char **outstr, size_t *outstr_len)
1391	{
1392	  int i, j;
1393	  char c;
1394	  size_t column = 0;            /* Screen column where next char will go */
1395	  size_t offset_out = 0;        /* Index in `line_out' for next char. */
1396	  static char *line_out = NULL;
1397	  static size_t allocated_out = 0;
1398	  if (!desc || !name)
1399	    return 1;
1400	
1401	  *outstr = malloc (width  + 
1402	                    (((desc_len  + width) / (width - align)) * width) * 2 
1403	                    * sizeof (char));
1404	  *outstr[0] = '\0';
1405	
1406	  strncat (*outstr, name, name_len);
1407	
1408	  column = name_len;
1409	
1410	  if (name_len > calign - 2)
1411	    {
1412	      /* Name is too long to have description on the same line. */
1413	      if (desc_len > 1)
1414	        {
1415	          strncat (*outstr, "\n", 1);
1416	          column = 0;
1417	          for (j = 0; j < calign - 1; j++)
1418	            {
1419	              column = adjust_column (column, ' ');
1420	              strncat (*outstr, " ", 1);
1421	            }
1422	        }
1423	    }
1424	  else
1425	    for (j = 0; j < calign - name_len - 1; j++)
1426	      {
1427	        if (desc_len <= 2)
1428	          break;
1429	        column = adjust_column (column, ' ');
1430	        strncat (*outstr, " ", 1);
1431	      }
1432	
1433	  for (i = 0; i < desc_len; i++)
1434	    {
1435	      if (desc_len <= 2)
1436	        break;
1437	      c = desc[i];
1438	      if (offset_out + 1 >= allocated_out)
1439	        {
1440	          allocated_out = offset_out + 1;
1441	          line_out = (char *) realloc ((void *)line_out, allocated_out);
1442	        }
1443	
1444	      if (c == '\n')
1445	        {
1446	          line_out[offset_out++] = c;
1447	          strncat (*outstr, line_out, offset_out);
1448	          column = offset_out = 0;
1449	          continue;
1450	        }
1451	
1452	    rescan:
1453	      column = adjust_column (column, c);
1454	
1455	      if (column > width)
1456	        {
1457	          /* This character would make the line too long.
1458	             Print the line plus a newline, and make this character
1459	             start the next line. */
1460	
1461	          int found_blank = 0;
1462	          size_t logical_end = offset_out;
1463	
1464	          /* Look for the last blank. */
1465	          while (logical_end)
1466	            {
1467	              --logical_end;
1468	              if (line_out[logical_end] == ' '
1469	                  || line_out[logical_end] == '\t')
1470	                {
1471	                  found_blank = 1;
1472	                  break;
1473	                }
1474	            }
1475	
1476	          if (found_blank)
1477	            {
1478	              size_t i;
1479	
1480	              /* Found a blank.  Don't output the part after it. */
1481	              logical_end++;
1482	              strncat (*outstr, line_out, logical_end);
1483	              strncat (*outstr, "\n", 1);
1484	              for (j = 0; j < align - 1; j++)
1485	                {
1486	                  column = adjust_column (column, ' ');
1487	                  strncat (*outstr, " ", 1);
1488	                }
1489	
1490	              /* Move the remainder to the beginning of the next 
1491	                 line.
1492	                 The areas being copied here might overlap. */
1493	              memmove (line_out, line_out + logical_end,
1494	                       offset_out - logical_end);
1495	              offset_out -= logical_end;
1496	              for (column = i = 0; i < offset_out; i++)
1497	                column = adjust_column (column, line_out[i]);
1498	              goto rescan;
1499	            }
1500	
1501	          if (offset_out == 0)
1502	            {
1503	              line_out[offset_out++] = c;
1504	              continue;
1505	            }
1506	
1507	          line_out[offset_out++] = '\n';
1508	          strncat (*outstr, line_out, offset_out);
1509	          column = offset_out = 0;
1510	          goto rescan;
1511	        }
1512	
1513	      line_out[offset_out++] = c;
1514	    }
1515	
1516	  if (desc_len <= 2)
1517	    strncat (*outstr, "\n", 1);
1518	
1519	  if (offset_out)
1520	    strncat (*outstr, line_out, offset_out);
1521	
1522	  *outstr_len = strlen (*outstr);
1523	  return 1;
1524	}
1525	
1526	
1527	/* Extract the NAME and DESCRIPTION from ENTRY.  NAME and DESCRIPTION must be
1528	   free'd.
1529	 */
1530	static void
1531	split_entry (const char *entry, char **name, size_t *name_len,
1532	             char **description, size_t *description_len)
1533	{
1534	  char *endptr;
1535	
1536	  /* on the first line, the description starts after the first ". ";
1537	     that's a period and space -- our heuristic to handle item names like
1538	     "config.status", and node names like "config.status Invocation".
1539	     Also accept period-tab and period-newline.  */
1540	  char *ptr = strchr (entry, '.');
1541	  while (ptr && ptr[1] != ' ' && ptr[1] != '\t' && ptr[1] != '\n') {
1542	    ptr = strchr (ptr + 1, '.');
1543	  }
1544	  
1545	  /* Maybe there's no period, and no description */
1546	  if (!ptr)
1547	    {
1548	      size_t length = strlen (entry);
1549	      if (length == 0)
1550	        return;
1551	      *name = strdup (entry);
1552	      *name_len = length + 1;
1553	      return;
1554	    }
1555	
1556	  /* The name is everything up to and including the period. */
1557	  *name_len = (size_t) (ptr - entry + 1);
1558	  *name = xmalloc (*name_len + 1);
1559	  (*name)[0] = '\0';
1560	  strncat (*name, entry, *name_len);
1561	
1562	  ptr++;
1563	  *description = xmalloc (strlen (entry));
1564	  (*description)[0] = '\0';
1565	
1566	  while (ptr[0] != '\0')
1567	    {
1568	      /* Eat up the whitespace after the name, and at the start of a line. */
1569	      while (isspace(ptr[0]))
1570	        ptr++;
1571	
1572	      /* Okay, we're at the start of the description. */
1573	      if (ptr[0] == '\0')
1574	        continue;
1575	
1576	      /* See how far the description goes... */
1577	      endptr = strchr (ptr, '\n');
1578	      /* Either the description continues up to the next newline. */
1579	      if (endptr)
1580	        {
1581	          size_t length  = (size_t) (endptr - ptr) / sizeof (char);
1582	          strncat (*description, ptr, length);
1583	          ptr = endptr;
1584	          /* First of all, we eat the newline here.  But then what?
1585	             Sometimes the newline separates 2 sentences, so we
1586	             end up with the next word starting directly after the period,
1587	             instead of after the customary 2 spaces in english. 
1588	             If the previous character was a `.', then we should add 2
1589	             spaces if there is anything on the next line.
1590	             if it's a comma, then we should put one space.
1591	             If it's neither, we just put a space.
1592	             If it's some other whitespace, we shouldn't do anything. */
1593	          ptr++;
1594	          if (length > 1 && strlen (ptr) > 0)
1595	            {
1596	              endptr--;
1597	              /* *ENDPTR is the 2nd last character */
1598	              if (*endptr == '.')
1599	                strncat (*description, "  ", 2);
1600	              else if (!isspace (*endptr))
1601	                strncat (*description, " ", 1);
1602	            }
1603	        }
1604	      /* Or the description continues to the end of the string. */
1605	      else
1606	        {
1607	          /* Just show the rest when there's no newline. */
1608	          size_t length = strlen (ptr);
1609	          strncat (*description, ptr, length);
1610	          ptr += length;
1611	        }
1612	    }
1613	  /* Descriptions end in a new line. */
1614	  strncat (*description, "\n", 1);
1615	  *description_len = strlen (*description);
1616	}
1617	
1618	
1619	/* Indent all ENTRIES according to some formatting options. 
1620	   CALIGN_CLI is the starting column for the first line of the description.
1621	   ALIGN_CLI is the starting column for all subsequent lines of the 
1622	   description.  MAXWIDTH_CLI is the number of columns in the line. 
1623	   When CALIGN_CLI, ALIGN_CLI, or MAXWIDTH_CLI is -1, choose a sane default. */
1624	
1625	static void
1626	reformat_new_entries (struct spec_entry *entries, int calign_cli, int align_cli, 
1627	                      int maxwidth_cli)
1628	{
1629	  struct spec_entry *entry;
1630	  for (entry = entries; entry; entry = entry->next)
1631	    {
1632	      int calign = -1, align = -1, maxwidth = -1;
1633	      char *name = NULL, *desc = NULL;
1634	      size_t name_len = 0, desc_len = 0;
1635	      split_entry (entry->text, &name, &name_len, &desc, &desc_len);
1636	      free (entry->text);
1637	
1638	      /* Specify sane defaults if we need to */
1639	      if (calign_cli == -1 || align_cli == -1)
1640	        {
1641	          struct spec_section *section;
1642	          calign = calign_cli;
1643	          align = align_cli;
1644	          for (section = entry->entry_sections; 
1645	               section && section != entry->entry_sections_tail;
1646	               section = section->next)
1647	            {
1648	              if (!strcmp (section->name, "Individual utilities"))
1649	                {
1650	                  if (calign == -1)
1651	                    calign = 48 + 1;
1652	                  if (align == -1)
1653	                    align = 50 + 1;
1654	                  break;
1655	                }
1656	            }
1657	          if (calign == -1)
1658	            calign = 32 + 1;
1659	          if (align == -1)
1660	            align = 34 + 1;
1661	        }
1662	      else
1663	        {
1664	          calign = calign_cli;
1665	          align = align_cli;
1666	        }
1667	
1668	      maxwidth = maxwidth_cli == -1 ? 79 : maxwidth_cli; 
1669	
1670	      format_entry (name, name_len, desc, desc_len, calign, align, 
1671	                    maxwidth, &entry->text, &entry->text_len);
1672	    }
1673	}
1674	
1675	/* Insert NAME into every entry in ENTRIES that requires it. 
1676	   NAME is the basename of the Info file being installed. 
1677	   The idea here is that there was a --name on the command-line
1678	   and we need to put the basename in the empty parentheses. */
1679	void
1680	add_missing_basenames (struct spec_entry *entries, char *name)
1681	{
1682	  struct spec_entry *entry;
1683	  for (entry = entries; entry; entry = entry->next)
1684	    {
1685	      if (entry->missing_basename)
1686	        {
1687	          /* Insert NAME into the right place in ENTRY->TEXT. */
1688	          char *info, *rest, *text;
1689	          size_t name_len = strlen (name);
1690	          char *ptr = strstr (entry->text, ": (). ");
1691	          if (!ptr)
1692	            return;
1693	          ptr[0] = '\0';
1694	          rest = ptr += strlen (": (). ");
1695	
1696	          info = xmalloc (name_len + 7);
1697	          snprintf (info, name_len + 7, ": (%s). ", name);
1698	          text = concat (entry->text, info, rest);
1699	          free (info);
1700	          if (entry->text)
1701	            free (entry->text);
1702	          entry->text = text;
1703	          entry->text_len = strlen (entry->text);
1704	          entry->missing_name = 0;
1705	          entry->missing_basename = 0;
1706	        }
1707	    }
1708	}
1709	
1710	
1711	/* Add NAME to the start of any entry in ENTRIES that is missing a name 
1712	   component.  If NAME doesn't start with `*', it is formatted to look 
1713	   like an Info entry.  */
1714	void
1715	add_missing_names (struct spec_entry *entries, char *name)
1716	{
1717	  struct spec_entry *entry;
1718	  for (entry = entries; entry; entry = entry->next)
1719	    {
1720	      if (entry->missing_name)
1721	        {
1722	          char *text;
1723	          /* Prepend NAME onto ENTRY->TEXT. */
1724	          int add_nl = 1;
1725	          if (entry->text)
1726	            if (entry->text[entry->text_len - 1] == '\n')
1727	              add_nl = 0;
1728	
1729	          if (name[0] == '*')
1730	            text = concat (name, entry->text == NULL ? "" : entry->text, 
1731	                           add_nl ? "\n" : "");
1732	          else
1733	            {
1734	              size_t full_name_len = strlen (name) * 2 + 9;
1735	              char *full_name = xmalloc (full_name_len);
1736	              snprintf (full_name, full_name_len, "* %s: (%s).", name, name);
1737	              text = concat (full_name, 
1738	                             entry->text == NULL ? "" : entry->text, 
1739	                             add_nl ? "\n" : "");
1740	              free (full_name);
1741	            }
1742	          if (entry->text)
1743	            free (entry->text);
1744	          entry->text = text;
1745	          entry->text_len = strlen (entry->text);
1746	          entry->missing_name = 0;
1747	          entry->missing_basename = 0;
1748	        }
1749	    }
1750	}
1751	
1752	/* Append DESC to every entry in ENTRIES that needs it. */
1753	
1754	void
1755	add_missing_descriptions (struct spec_entry *entries, char *desc)
1756	{
1757	  struct spec_entry *entry;
1758	  for (entry = entries; entry; entry = entry->next)
1759	    {
1760	      if (entry->missing_description)
1761	        {
1762	          char *text;
1763	          int add_nl = 1;
1764	          if (strlen (desc) > 1)
1765	            if (desc[strlen (desc) - 1] == '\n')
1766	              add_nl = 0;
1767	          /* Append DESC onto ENTRY->TEXT. */
1768	          text = concat (entry->text == NULL ? "" : entry->text, desc,
1769	                               add_nl ? "\n" : "");
1770	          if (entry->text)
1771	            free (entry->text);
1772	          entry->text = text;
1773	          entry->text_len = strlen (entry->text);
1774	        }
1775	    }
1776	}
1777	
1778	
1779	/* Detect old-style Debian `--section REGEX TITLE' semantics in ARGV.
1780	   When detected the options are munged to look like:
1781	     `--regex REGEX --section TITLE --add-once'
1782	   Return 1 if munging took place, return 0 if not.
1783	   Otherwise return a negative number if something went wrong.
1784	   NEW_ARGC, and NEW_ARGV are filled with the newly munged options
1785	   when munging took place.
1786	 */
1787	static int
1788	munge_old_style_debian_options (int argc, char **argv, 
1789	                                int *new_argc, char ***new_argv)
1790	{
1791	  char *opt = NULL;
1792	  int i, err;
1793	  char *argz = NULL;
1794	  size_t argz_len = 0;
1795	  const char *regex, *title;
1796	  int munge = 0;
1797	
1798	  /* Flip through the options to detect the old `--section REGEX TITLE' 
1799	     syntax */
1800	  for (i = 0; i < argc; i++)
1801	    {
1802	      if (strcmp (argv[i], "--section") == 0)
1803	        {
1804	          FILE *fileptr;
1805	          /* Go forward one arg and obtain the REGEX. */
1806	          if (i + 1 < argc)
1807	            i++;
1808	          else
1809	            return -1;
1810	          regex = argv[i];
1811	          /* Go forward another arg and obtain the TITLE. */
1812	          if (i + 1 < argc)
1813	            i++;
1814	          else
1815	            return -1;
1816	          title = argv[i];
1817	          /* When the title starts with a `-' it's probably an option,
1818	             and not a title. */
1819	          if (title[0] == '-')
1820	            break;
1821	          /* When the title is a filename it's probably an Info file, or
1822	             a dir file, and not a title. */
1823	          fileptr = fopen (title, "r");
1824	          if (fileptr)
1825	            {
1826	              fclose (fileptr);
1827	              break;
1828	            }
1829	          /* Okay, it looks like we're using the old debian syntax 
1830	             for --section. */
1831	          munge = 1;
1832	        
1833	          /* Okay, we munge the options to look like this:
1834	             --regex=REGEX --section=TITLE --add-once */
1835	          opt = xmalloc (strlen (regex) + sizeof ("--regex="));
1836	          if (sprintf (opt, "--regex=%s", regex) == -1)
1837	            err = 1;
1838	          if (!err)
1839	            err = argz_add (&argz, &argz_len, opt);
1840	          free (opt); opt = NULL;
1841	
1842	          opt = xmalloc (strlen (title) + sizeof ("--section="));
1843	          if (sprintf (opt, "--section=%s", title) == -1)
1844	            err = 1;
1845	          if (!err)
1846	            err = argz_add (&argz, &argz_len, opt);
1847	          free (opt); opt = NULL;
1848	
1849	          if (!err)
1850	            err = argz_add (&argz, &argz_len, "--add-once");
1851	        }
1852	      else
1853	        err = argz_add (&argz, &argz_len, argv[i]); 
1854	      if (err)
1855	        return -1;
1856	    }
1857	
1858	  if (munge)
1859	    {
1860	      *new_argc = argz_count (argz, argz_len);
1861	      *new_argv = xmalloc ((*new_argc + 1) * sizeof (char *));
1862	
1863	      opt = NULL; i = 0;
1864	      while ((opt = argz_next (argz, argz_len, opt)))
1865	        {
1866	          (*new_argv)[i] = xstrdup (opt);
1867	          i++;
1868	        }
1869	      (*new_argv)[*new_argc] = NULL;
1870	    }
1871	  free (argz);
1872	  return munge;
1873	}
1874	
1875	
1876	int
1877	main (int argc, char *argv[])
1878	{
1879	  char *opened_dirfilename;
1880	  char *compression_program;
1881	  char *infile_sans_info;
1882	  char *infile = 0, *dirfile = 0;
1883	  int calign = -1;
1884	  int align  = -1;
1885	  int maxwidth = -1;
1886	
1887	  /* Record the text of the Info file, as a sequence of characters
1888	     and as a sequence of lines.  */
1889	  char *input_data = NULL;
1890	  int input_size = 0;
1891	  struct line_data *input_lines = NULL;
1892	  int input_nlines = 0;
1893	
1894	  /* Record here the specified section names and directory entries.  */
1895	  struct spec_section *input_sections = NULL;
1896	  struct spec_entry *entries_to_add = NULL;
1897	  struct spec_entry *entries_to_add_from_file = NULL;
1898	  int n_entries_to_add = 0;
1899	  struct spec_entry *default_entries_to_add = NULL;
1900	  int n_default_entries_to_add = 0;
1901	
1902	  /* Record the old text of the dir file, as plain characters,
1903	     as lines, and as nodes.  */
1904	  char *dir_data;
1905	  int dir_size;
1906	  int dir_nlines;
1907	  struct line_data *dir_lines;
1908	  struct node *dir_nodes;
1909	
1910	  /* Nonzero means --delete was specified (just delete existing entries).  */
1911	  int delete_flag = 0;
1912	  int something_deleted = 0;
1913	
1914	  /* Nonzero means -quiet/--silent was specified.  */
1915	  int quiet_flag = 0;
1916	
1917	  /* Nonzero means --debug was specified.  */
1918	  int debug_flag = 0;
1919	
1920	  int i;
1921	
1922	#ifdef HAVE_SETLOCALE
1923	  /* Set locale via LC_ALL.  */
1924	  setlocale (LC_ALL, "");
1925	#endif
1926	
1927	  /* Set the text message domain.  */
1928	  bindtextdomain (PACKAGE, LOCALEDIR);
1929	  textdomain (PACKAGE);
1930	
1931	  /* Make sure standard input can be freopened at will.  Otherwise,
1932	     when stdin starts off closed, bad things could happen if a plain fopen
1933	     returns stdin before open_possibly_compressed_file freopens it.  */
1934	  if (! freopen (NULL_DEVICE, "r", stdin))
1935	    pfatal_with_name (NULL_DEVICE);
1936	
1937	  munge_old_style_debian_options (argc, argv, &argc, &argv);
1938	
1939	  while (1)
1940	    {
1941	      int opt = getopt_long (argc, argv, 
1942	                             "i:d:e:s:t:E:c:C:W:A:hHrk1Ia", longopts, 0);
1943	
1944	      if (opt == EOF)
1945	        break;
1946	
1947	      switch (opt)
1948	        {
1949	        case 0:
1950	          /* If getopt returns 0, then it has already processed a
1951	             long-named option.  We should do nothing.  */
1952	          break;
1953	
1954	        case 1:
1955	          abort ();
1956	
1957	        case '1':
1958	          add_entries_into_all_matching_sections = 0;
1959	          break;
1960	
1961	        case 'a':
1962	          order_new_sections_alphabetically_flag = 0;
1963	          break;
1964	
1965	        case 'A':
1966	          {
1967	            char *end = NULL;
1968	            unsigned long int val;
1969	            val = strtoul (optarg, &end, 0);
1970	            if (end == NULL || end == optarg || *end != '\0')
1971	              suggest_asking_for_help ();
1972	            align = val;
1973	            if (align <= 0)
1974	              suggest_asking_for_help ();
1975	          }
1976	          break;
1977	
1978	        case 'c':
1979	        
1980	          {
1981	            struct spec_entry *next;
1982	            size_t length = strlen (optarg);
1983	
1984	            if (!entries_to_add)
1985	              {
1986	                next = 
1987	                  (struct spec_entry *) xmalloc (sizeof (struct spec_entry));
1988	            
1989	                next->text = NULL;
1990	                next->text_len = 0;
1991	                next->entry_sections = NULL;
1992	                next->entry_sections_tail = NULL;
1993	                next->missing_name = 1;
1994	                next->missing_basename = 1;
1995	                next->next = entries_to_add;
1996	                entries_to_add = next;
1997	                n_entries_to_add++;
1998	              }
1999	            else
2000	              next = entries_to_add;
2001	                
2002	            next->missing_description = 0;
2003	            if (next->text)
2004	              {
2005	                char *nl = strrchr (next->text, '\n');
2006	                if (nl)
2007	                  nl[0] = '\0';
2008	              }
2009	            /* Concat the description onto the current entry, adding a 
2010	               newline if we need one.  Prepend a space if we have no
2011	               previous text, since eventually we will be adding the
2012	               "* foo ()." and we want to end up with a ". " for parsing.  */
2013	            next->text = concat (next->text ? next->text : " ",
2014	                                 optarg, 
2015	                                 optarg[length - 1] == '\n' ? "" : "\n");
2016	            next->text_len = strlen (next->text);
2017	          }
2018	          break;
2019	
2020	        case 'C':
2021	          {
2022	            char *end = NULL;
2023	            unsigned long int val;
2024	            val = strtoul (optarg, &end, 0);
2025	            if (end == NULL || end == optarg || *end != '\0')
2026	              suggest_asking_for_help ();
2027	            calign = val;
2028	            if (calign <= 0)
2029	              suggest_asking_for_help ();
2030	          }
2031	          break;
2032	
2033	        case 'd':
2034	          if (dirfile)
2035	            {
2036	              fprintf (stderr, _("%s: already have dir file: %s\n"),
2037	                       progname, dirfile);
2038	              suggest_asking_for_help ();
2039	            }
2040	          dirfile = optarg;
2041	          break;
2042	
2043	        case 'D':
2044	          if (dirfile)
2045	            {
2046	              fprintf (stderr, _("%s: already have dir file: %s\n"),
2047	                       progname, dirfile);
2048	              suggest_asking_for_help ();
2049	            }
2050	          dirfile = concat (optarg, "", "/dir");
2051	          break;
2052	
2053	        case 't':
2054	          {
2055	            struct spec_entry *next
2056	              = (struct spec_entry *) xmalloc (sizeof (struct spec_entry));
2057	
2058	            size_t length;
2059	            if (optarg[0] != '*')
2060	              {
2061	                /* Make enough space for "* foo: (). ". */
2062	                length = strlen (optarg) + 9;
2063	                next->text = xmalloc (length);
2064	                snprintf (next->text, length, "* %s: (). ", optarg);
2065	                next->missing_basename = 1;
2066	                /* The basename will be inserted in between the parentheses
2067	                   at a later time.  See add_missing_basenames. */
2068	              }
2069	            else
2070	              {
2071	                /* Make enough space for "foo ". */
2072	                length = strlen (optarg) + 2;
2073	                next->text = xmalloc (length);
2074	                snprintf (next->text, length, "%s ", optarg);
2075	                next->missing_basename = 0;
2076	                /* FIXME: check for info entry correctness in TEXT. 
2077	                   e.g. `* Aaa: (bbb).' */
2078	              }
2079	
2080	            next->text_len = length - 1;
2081	            next->entry_sections = NULL;
2082	            next->entry_sections_tail = NULL;
2083	            next->next = entries_to_add;
2084	            next->missing_name = 0;
2085	            next->missing_description = 1;
2086	            entries_to_add = next;
2087	            n_entries_to_add++;
2088	          }
2089	          break;
2090	
2091		case 'E':
2092	        case 'e':
2093	          {
2094	            struct spec_entry *next
2095	              = (struct spec_entry *) xmalloc (sizeof (struct spec_entry));
2096	            int olen = strlen (optarg);
2097	            if (! (*optarg != 0 && optarg[olen - 1] == '\n'))
2098	              {
2099	                optarg = concat (optarg, "\n", "");
2100	                olen++;
2101	              }
2102	            next->text = optarg;
2103	            next->text_len = olen;
2104	            next->entry_sections = NULL;
2105	            next->entry_sections_tail = NULL;
2106	            next->missing_name = 0;
2107	            next->missing_basename = 0;
2108	            next->missing_description = 0;
2109		    if (opt == 'e')
2110	  	      {
2111			next->next = entries_to_add;
2112			entries_to_add = next;
2113			n_entries_to_add++;
2114		      } 
2115		    else
2116		      {
2117		        /* Although this list is maintained, nothing is ever
2118		           done with it.  So it seems no one cares about the
2119		           feature.  The intended --help string was:
2120	 --defentry=TEXT     like --entry, but only use TEXT if an entry\n\
2121	                      is not present in INFO-FILE.\n\
2122	                   in case anyone ever wants to finish it.  */
2123			next->next = default_entries_to_add;
2124			default_entries_to_add = next;
2125			n_default_entries_to_add++;
2126		      }
2127	          }
2128	          break;
2129	
2130	        case 'g':
2131	          debug_flag = 1;
2132	          break;
2133	
2134	        case 'h':
2135	        case 'H':
2136	          print_help ();
2137	          exit (EXIT_SUCCESS);
2138	
2139	        case 'i':
2140	          if (infile)
2141	            {
2142	              fprintf (stderr, _("%s: Specify the Info file only once.\n"),
2143	                       progname);
2144	              suggest_asking_for_help ();
2145	            }
2146	          infile = optarg;
2147	          break;
2148	
2149	        case 'I':
2150	          indent_flag = 0;
2151	          break;
2152	
2153	        case 'k':
2154	          keep_old_flag = 1;
2155	          break;
2156	
2157	        case 'n':
2158	          chicken_flag = 1;
2159	          break;
2160	
2161	        case 'q':
2162	          quiet_flag = 1;
2163	          break;
2164	
2165	        case 'r':
2166	          delete_flag = 1;
2167	          break;
2168	
2169	        case 'R':
2170	          {
2171	            int error;
2172	            if (psecreg)
2173	              {
2174	                warning 
2175	                  (_("Extra regular expression specified, ignoring `%s'"),
2176	                   optarg);
2177	                break;
2178	              }
2179	            psecreg = (regex_t *) xmalloc (sizeof (regex_t));
2180	
2181	            error = regcomp (psecreg, optarg, REG_ICASE|REG_NOSUB);
2182	            if (error != 0)
2183	              {
2184	                int errbuf_size = regerror (error, psecreg, NULL, 0);
2185	                char *errbuf = (char *) xmalloc (errbuf_size);
2186	                regerror (error, psecreg, errbuf, errbuf_size);
2187	                fatal (_("Error in regular expression `%s': %s"),
2188			       optarg, errbuf);
2189	              };
2190	          }
2191	          break;
2192	
2193		case 'S':
2194		  default_section = optarg;
2195		  break;
2196	
2197	        case 's':
2198	          {
2199	            struct spec_section *next
2200	              = (struct spec_section *) xmalloc (sizeof (struct spec_section));
2201	            next->name = optarg;
2202	            next->next = input_sections;
2203	            next->missing = 1;
2204	            input_sections = next;
2205	          }
2206	          break;
2207	
2208	        case 'V':
2209	          printf ("install-info (GNU %s) %s\n", PACKAGE, VERSION);
2210	          puts ("");
2211	          printf (_("Copyright (C) %s Free Software Foundation, Inc.\n\
2212	License GPLv3+: GNU GPL version 3 or later <http://gnu.org/licenses/gpl.html>\n\
2213	This is free software: you are free to change and redistribute it.\n\
2214	There is NO WARRANTY, to the extent permitted by law.\n"),
2215	              "2015");
2216	          exit (EXIT_SUCCESS);
2217	
2218	        case 'W':
2219	          {
2220	            char *end = NULL;
2221	            unsigned long int val;
2222	            val = strtoul (optarg, &end, 0);
2223	            if (end == NULL || end == optarg || *end != '\0')
2224	              suggest_asking_for_help ();
2225	            maxwidth = val;
2226	            if (maxwidth <= 0)
2227	              suggest_asking_for_help ();
2228	          }
2229	          break;
2230	
2231	        case 'x':
2232	          delete_flag = 1;
2233	          remove_exactly = 1;
2234	          break;
2235	
2236	        default:
2237	          suggest_asking_for_help ();
2238	        }
2239	    }
2240	
2241	  /* Interpret the non-option arguments as file names.  */
2242	  for (; optind < argc; ++optind)
2243	    {
2244	      if (infile == 0)
2245	        infile = argv[optind];
2246	      else if (dirfile == 0)
2247	        dirfile = argv[optind];
2248	      else
2249	        error (_("excess command line argument `%s'"), argv[optind]);
2250	    }
2251	
2252	  if (!infile)
2253	    fatal (_("No input file specified; try --help for more information."));
2254	  if (!dirfile)
2255	    fatal (_("No dir file specified; try --help for more information."));
2256	
2257	  /* Now read in the Info dir file.  */
2258	  if (debug_flag)
2259	    printf ("debug: reading dir file %s\n", dirfile);
2260	
2261	  if (!delete_flag)
2262	    {
2263	      dir_data = readfile (dirfile, &dir_size, ensure_dirfile_exists,
2264	                           &opened_dirfilename, &compression_program);
2265	      if (!dir_data)
2266	        pfatal_with_name (opened_dirfilename);
2267	    }
2268	  else
2269	    {
2270	      /* For "--remove" operation, it is not an error for the dir file
2271	         not to exist. */
2272	      dir_data = readfile (dirfile, &dir_size, NULL,
2273	                           &opened_dirfilename, &compression_program);
2274	      if (!dir_data)
2275	        {
2276	          warning (_("Could not read %s."), opened_dirfilename);
2277	          exit (EXIT_SUCCESS);
2278	        }
2279	    }
2280	
2281	  dir_lines = findlines (dir_data, dir_size, &dir_nlines);
2282	
2283	  parse_dir_file (dir_lines, dir_nlines, &dir_nodes);
2284	
2285	  if (!delete_flag)
2286	    {
2287	      /* Find which sections match our regular expression. */
2288	      if (psecreg)
2289	        {
2290	          struct node *node;
2291	          struct menu_section *section;
2292	          for (node = dir_nodes; node ; node = node->next)
2293	            for (section = node->sections; section ; section = section->next)
2294	              if (regexec (psecreg, section->name, 0, NULL, 0) == 0)
2295	                {
2296	                  /* we have a match! */
2297	                  struct spec_section *next = 
2298	                    (struct spec_section *) xmalloc 
2299	                    (sizeof (struct spec_section));
2300	                  next->name = section->name;
2301	                  next->next = input_sections;
2302	                  next->missing = 0;
2303	                  input_sections = next;
2304	                }
2305	        }
2306	
2307	    }
2308	
2309	  /* We will be comparing the entries in the dir file against the
2310	     current filename, so need to strip off any directory prefix and/or
2311	     [.info][.gz] suffix.  */
2312	  if (!remove_exactly) {
2313	    char *infile_basename = infile + strlen (infile);
2314	
2315	    if (HAVE_DRIVE (infile))
2316	      infile += 2;      /* get past the drive spec X: */
2317	
2318	    while (infile_basename > infile && !IS_SLASH (infile_basename[-1]))
2319	      infile_basename--;
2320	
2321	    infile_sans_info = strip_info_suffix (infile_basename);
2322	  } else
2323	    infile_sans_info = xstrdup(infile);
2324	
2325	  /* Now Read the Info file and parse it into lines, unless we're 
2326	     removing exactly.  */
2327	  if (!remove_exactly)
2328	    {
2329	      char *opened_infilename;
2330	
2331	      if (debug_flag)
2332	        printf ("debug: reading input file %s\n", infile);
2333	      input_data = readfile (infile, &input_size, NULL,
2334	                             &opened_infilename, NULL);
2335	      if (!input_data)
2336	        pfatal_with_name (opened_infilename);
2337	      input_lines = findlines (input_data, input_size, &input_nlines);
2338	    }
2339	
2340	  i = parse_input (input_lines, input_nlines,
2341	                   &input_sections, &entries_to_add_from_file, delete_flag);
2342	  if (!delete_flag)
2343	    {
2344	      /* If there are no entries on the command-line at all, so we use the 
2345	         entries found in the Info file itself (if any). */
2346	      if (entries_to_add == NULL)
2347	        {
2348	          entries_to_add = entries_to_add_from_file;
2349	          n_entries_to_add = i;
2350	        }
2351	      /* There are entries on the command-line, and they override the entries
2352	         found in the Info file. */
2353	      else if (entries_to_add)
2354	        {
2355	          if (entries_to_add_from_file == NULL)
2356	            {
2357	              /* No entries found in the file anyway.  Fill in any 
2358	                 missing names with the info file's basename.  We're out
2359	                 of luck for any missing descriptions. */
2360	              add_missing_names (entries_to_add, infile_sans_info);
2361	              /* add_missing_descriptions (entries_to_add, "\n"); */
2362	            }
2363	          else
2364	            {
2365	              /* Fill in any missing names or descriptions with what was
2366	                 found in the Info file. */
2367	              char *desc = NULL;
2368	              size_t desc_len = 0;
2369	              char *name = NULL;
2370	              size_t name_len = 0;
2371	              split_entry (entries_to_add_from_file->text, &name, &name_len,
2372	                           &desc, &desc_len);
2373	              if (name)
2374	                {
2375	                  /* If the name doesn't look right, bail and use the 
2376	                     name based on the Info file. */
2377	                  if (name[0] != '*')
2378	                    add_missing_names (entries_to_add, infile_sans_info);
2379	                  else
2380	                    add_missing_names (entries_to_add, name);
2381	                  free (name);
2382	                }
2383	
2384	              if (desc)
2385	                {
2386	                  add_missing_descriptions (entries_to_add, desc);
2387	                  free (desc);
2388	                }
2389	            }
2390	        }
2391	            
2392	      /* Lastly, fill in any missing basenames that might still be hanging
2393	         around from --name options on the command-line. */
2394	      add_missing_basenames (entries_to_add, infile_sans_info);
2395	
2396	      /* Reformat the new entries if we're doing that. */
2397	      if (indent_flag)
2398	        {
2399	          char *no_indent = getenv ("INSTALL_INFO_NO_INDENT");
2400	          if (!no_indent)
2401	            reformat_new_entries (entries_to_add, calign, align, maxwidth);
2402	        }
2403	
2404	      /* If we got no sections, use the --defsection value if it was
2405	         given, else "Miscellaneous".  */ 
2406	      if (input_sections == NULL)
2407	        {
2408	          input_sections = (struct spec_section *)
2409	            xmalloc (sizeof (struct spec_section));
2410	          input_sections->name = default_section ? default_section
2411	                                                 : "Miscellaneous";
2412	          input_sections->next = NULL;
2413	          input_sections->missing = 1;
2414	        }
2415	
2416	      if (entries_to_add == 0)
2417	        { /* No need to abort here, the original info file may not
2418	             have the requisite Texinfo commands.  This is not
2419	             something an installer should have to correct (it's a
2420	             problem for the maintainer), and there's no need to cause
2421	             subsequent parts of `make install' to fail.  */
2422	          if (!quiet_flag)
2423	            warning (_("no info dir entry in `%s'"), infile);
2424	          exit (EXIT_SUCCESS);
2425	        }
2426	
2427	      /* If the entries came from the command-line arguments, their
2428	         entry_sections pointers are not yet set.  Walk the chain of
2429	         the entries and for each entry update entry_sections to point
2430	         to the head of the list of sections where this entry should
2431	         be put.  Note that all the entries specified on the command
2432	         line get put into ALL the sections we've got, either from the
2433	         Info file, or (under --section) from the command line,
2434	         because in the loop below every entry inherits the entire
2435	         chain of sections.  */
2436	      if (n_entries_to_add > 0 && entries_to_add->entry_sections == NULL)
2437	        {
2438	          struct spec_entry *ep;
2439	
2440	          for (ep = entries_to_add; ep; ep = ep->next)
2441	            ep->entry_sections = input_sections;
2442	        }
2443	    }
2444	
2445	  if (delete_flag)
2446	    {
2447	      something_deleted = mark_entry_for_deletion (dir_lines, dir_nlines, 
2448	                                                   infile_sans_info);
2449	      if (!something_deleted && !remove_exactly)
2450	        {
2451	          struct spec_entry *entry;
2452	          for (entry = entries_to_add; entry; entry = entry->next)
2453	            {
2454	              /* If the entry came from the info file... */
2455	              if (entry->entry_sections != NULL)
2456	                {
2457	                  char *name = extract_menu_item_name (entry->text);
2458	                  something_deleted = 
2459	                    mark_entry_for_deletion (dir_lines, dir_nlines, name);
2460	                  free (name);
2461	                }
2462	            }
2463	      
2464	          if (!something_deleted)
2465	            {
2466	              struct spec_entry *entry;
2467	              for (entry = entries_to_add; entry; entry = entry->next)
2468	                {
2469	                  /* If the entry came from the command-line... */
2470	                  if (entry->entry_sections == NULL)
2471	                    something_deleted = 
2472	                      mark_entry_for_deletion (dir_lines, dir_nlines, 
2473	                                               entry->text);
2474	                }
2475	            }
2476	        }
2477	    }
2478	    
2479	  /* Check for sections with zero entries and mark them for deletion. */
2480	  if (delete_flag && something_deleted && !keep_old_flag)
2481	    {
2482	      struct node *node;
2483	      struct menu_section *section;
2484	      int section_empty;
2485	
2486	      for (node = dir_nodes; node ; node = node->next)
2487	        for (section = node->sections; section ; section = section->next)
2488	          {
2489	            section_empty = 1;
2490	            for (i = section->end_line; i > section->start_line; i--)
2491	              {
2492	                if (dir_lines[i - 1].delete == 0 && 
2493	                    dir_lines[i - 1].size != 0)
2494	                  {
2495	                    section_empty = 0;
2496	                    break;
2497	                  }
2498	              }
2499	
2500	            if (section_empty)
2501	              {
2502	                /* This gets rid of any trailing empty lines at the end  
2503	                   of the section, and the title too. */
2504	                for (i = section->end_line; i >= section->start_line; i--)
2505	                  dir_lines[i - 1].delete = 1;
2506	              }
2507	          }
2508	    }
2509	
2510	  /* Decide where to add the new entries (unless --delete was used).
2511	     Find the menu sections to add them in.
2512	     In each section, find the proper alphabetical place to add
2513	     each of the entries.  */
2514	  if (!delete_flag)
2515	    {
2516	      struct node *node;
2517	      struct menu_section *section;
2518	      struct spec_section *spec;
2519	
2520	      for (node = dir_nodes; node; node = node->next)
2521	        for (section = node->sections; section; section = section->next)
2522	          {
2523	            for (i = section->end_line; i > section->start_line; i--)
2524	              if (dir_lines[i - 1].size != 0)
2525	                break;
2526	            section->end_line = i;
2527	
2528	            for (spec = input_sections; spec; spec = spec->next)
2529	              if (!strcmp (spec->name, section->name))
2530	                break;
2531	            if (spec)
2532	              {
2533	                int add_at_line = section->end_line;
2534	                struct spec_entry *entry;
2535	                /* Say we have found at least one section with this name,
2536	                   so we need not add such a section.  */
2537	                spec->missing = 0;
2538	                /* For each entry, find the right place in this section
2539	                   to add it.  */
2540	                for (entry = entries_to_add; entry; entry = entry->next)
2541	                  {
2542	                    /* Did they at all want this entry to be put into
2543	                       this section?  */
2544	                    for (spec = entry->entry_sections;
2545	                         spec && spec != entry->entry_sections_tail;
2546	                         spec = spec->next)
2547	                      {
2548	                        if (!strcmp (spec->name, section->name))
2549	                          break;
2550	                      }
2551	                    if (!spec || spec == entry->entry_sections_tail)
2552	                      continue;
2553	
2554	                    /* Subtract one because dir_lines is zero-based,
2555	                       but the `end_line' and `start_line' members are
2556	                       one-based.  */
2557	                    for (i = section->end_line - 1;
2558	                         i >= section->start_line - 1; i--)
2559	                      {
2560	                        /* If an entry exists with the same name,
2561	                           and was not marked for deletion
2562	                           (which means it is for some other file),
2563	                           we are in trouble.  */
2564	                        if (dir_lines[i].start[0] == '*'
2565	                            && menu_line_equal (entry->text, entry->text_len,
2566	                                                dir_lines[i].start,
2567	                                                dir_lines[i].size)
2568	                            && !dir_lines[i].delete)
2569	                          {
2570	                            if (keep_old_flag)
2571	                              {
2572	                                add_at_line = -1;
2573	                                break;
2574	                              }
2575	                            else
2576	                              {
2577	                                int j;
2578	                                dir_lines[i].delete = 1;
2579	                                for (j = i + 1; j < section->end_line; j++)
2580	                                  {
2581	                                    if (dir_lines[j].start[0] == '*')
2582	                                      break;
2583	                                    dir_lines[j].delete = 1;
2584	                                  }
2585	                              }
2586	                          }
2587	                        if (dir_lines[i].start[0] == '*'
2588	                            && menu_line_lessp (entry->text, entry->text_len,
2589	                                                dir_lines[i].start,
2590	                                                dir_lines[i].size))
2591	                          add_at_line = i;
2592	                      }
2593	                    if (add_at_line < 0)
2594	                      continue;
2595	                    insert_entry_here (entry, add_at_line,
2596	                                       dir_lines, n_entries_to_add);
2597	                  }
2598	              }
2599	          }
2600	
2601	    }
2602	  /* Decide where to add the new sections (unless --delete was used).
2603	     Alphabetically find the menu sections to add them before.  */
2604	  if (!delete_flag)
2605	    {
2606	      struct node *node;
2607	      struct node *top = NULL;
2608	
2609	      /* Find the `Top' node. */
2610	      for (node = dir_nodes; node; node = node->next)
2611	        if (node->name && strcmp (node->name, "Top") == 0)
2612	          top = node;
2613	
2614	      if (top)
2615	        {
2616	          struct spec_section *spec;
2617	          int found = 0;
2618	          struct line_data *target_line = NULL;
2619	          for (spec = input_sections; spec; spec = spec->next)
2620	            {
2621	              found = 0;
2622	              target_line = NULL;
2623	              if (!spec->missing)
2624	                continue;
2625	              if (order_new_sections_alphabetically_flag)
2626	                {
2627	                  struct menu_section *section;
2628	                  struct menu_section *prev_section = NULL;
2629	              
2630	                  /* Look for the first section name that 
2631	                     exceeds SPEC->NAME. */
2632	                  for (section = top->sections; section ; 
2633	                       section = section->next)
2634	                    {
2635	                      found = (mbscasecmp (spec->name, section->name) < 0);
2636	                      if (found)
2637	                        {
2638	                          /* Mark the section for addition at this point. */
2639	                          if (prev_section)
2640	                            target_line = &dir_lines[prev_section->end_line];
2641	                          else
2642	                            target_line = 
2643	                              &dir_lines[top->sections->start_line - 2];
2644	
2645	                          break;
2646	                        }
2647	                      prev_section = section;
2648	                    }
2649	                }
2650	                  
2651	              /* When we can't put a section anywhere, we put it at the 
2652	                 bottom of the file. */
2653	              if (!found)
2654	                target_line = &dir_lines[top->end_line];
2655	
2656	              /* Add the section to our list of sections being added
2657	                 at this point of the DIR file. */
2658	              target_line->num_sections_to_add++;
2659	              target_line->add_sections_before = 
2660	                (struct spec_section **) xrealloc 
2661	                (target_line->add_sections_before, 
2662	                 (target_line->num_sections_to_add *
2663	                  sizeof (struct spec_section *)));
2664	              i = target_line->num_sections_to_add - 1;
2665	              target_line->add_sections_before[i] = spec;
2666	            }
2667	        }
2668	    }
2669	
2670	  if (delete_flag && !something_deleted && !quiet_flag)
2671	    warning (_("no entries found for `%s'; nothing deleted"), infile);
2672	
2673	  if (debug_flag)
2674	    printf ("debug: writing dir file %s\n", opened_dirfilename);
2675	  if (chicken_flag)
2676	    printf ("test mode, not updating dir file %s\n", opened_dirfilename);
2677	  else
2678	    output_dirfile (opened_dirfilename, dir_nlines, dir_lines,
2679	                    n_entries_to_add, entries_to_add,
2680	                    input_sections, compression_program);
2681	
2682	  exit (EXIT_SUCCESS);
2683	}
2684	
2685	/* Divide the text at DATA (of SIZE bytes) into lines.
2686	   Return a vector of struct line_data describing the lines.
2687	   Store the length of that vector into *NLINESP.  */
2688	
2689	struct line_data *
2690	findlines (char *data, int size, int *nlinesp)
2691	{
2692	  int i;
2693	  int lineflag = 1;
2694	  int lines_allocated = 511;
2695	  int filled = 0;
2696	  struct line_data *lines
2697	    = xmalloc ((lines_allocated + 1) * sizeof (struct line_data));
2698	
2699	  for (i = 0; i < size; i++)
2700	    {
2701	      if (lineflag)
2702	        {
2703	          if (filled == lines_allocated)
2704	            {
2705	              /* try to keep things somewhat page-aligned */
2706	              lines_allocated = ((lines_allocated + 1) * 2) - 1;
2707	              lines = xrealloc (lines, (lines_allocated + 1)
2708	                                       * sizeof (struct line_data));
2709	            }
2710	          lines[filled].start = &data[i];
2711	          lines[filled].add_entries_before = 0;
2712	          lines[filled].add_sections_before = NULL;
2713	          lines[filled].num_sections_to_add = 0;
2714	          lines[filled].delete = 0;
2715	          if (filled > 0)
2716	            lines[filled - 1].size
2717	              = lines[filled].start - lines[filled - 1].start - 1;
2718	          filled++;
2719	        }
2720	      lineflag = (data[i] == '\n');
2721	    }
2722	  if (filled > 0)
2723	    lines[filled - 1].size = &data[i] - lines[filled - 1].start - lineflag;
2724	
2725	  /* Do not leave garbage in the last element.  */
2726	  lines[filled].start = NULL;
2727	  lines[filled].add_entries_before = NULL;
2728	  lines[filled].add_sections_before = NULL;
2729	  lines[filled].num_sections_to_add = 0;
2730	  lines[filled].delete = 0;
2731	  lines[filled].size = 0;
2732	
2733	  *nlinesp = filled;
2734	  return lines;
2735	}
2736	
2737	/* This is the comparison function for qsort for a vector of pointers to
2738	   struct spec_section.  (Have to use const void * as the parameter type
2739	   to avoid incompatible-with-qsort warnings.)
2740	   Compare the section names.  */
2741	
2742	int
2743	compare_section_names (const void *p1, const void *p2)
2744	{
2745	  struct spec_section **sec1 = (struct spec_section **) p1;
2746	  struct spec_section **sec2 = (struct spec_section **) p2;
2747	  char *name1 = (*sec1)->name;
2748	  char *name2 = (*sec2)->name;
2749	  return strcmp (name1, name2);
2750	}
2751	
2752	/* This is the comparison function for qsort
2753	   for a vector of pointers to struct spec_entry.
2754	   Compare the entries' text.  */
2755	
2756	int
2757	compare_entries_text (const void *p1, const void *p2)
2758	{
2759	  struct spec_entry **entry1 = (struct spec_entry **) p1;
2760	  struct spec_entry **entry2 = (struct spec_entry **) p2;
2761	  char *text1 = (*entry1)->text;
2762	  char *text2 = (*entry2)->text;
2763	  char *colon1 = strchr (text1, ':');
2764	  char *colon2 = strchr (text2, ':');
2765	  int len1, len2;
2766	
2767	  if (!colon1)
2768	    len1 = strlen (text1);
2769	  else
2770	    len1 = colon1 - text1;
2771	  if (!colon2)
2772	    len2 = strlen (text2);
2773	  else
2774	    len2 = colon2 - text2;
2775	  return mbsncasecmp (text1, text2, len1 <= len2 ? len1 : len2);
2776	}
2777	
2778	/* Insert ENTRY into the add_entries_before vector
2779	   for line number LINE_NUMBER of the dir file.
2780	   DIR_LINES and N_ENTRIES carry information from like-named variables
2781	   in main.  */
2782	
2783	void
2784	insert_entry_here (struct spec_entry *entry, int line_number,
2785	                   struct line_data *dir_lines, int n_entries)
2786	{
2787	  int i, j;
2788	
2789	  if (dir_lines[line_number].add_entries_before == 0)
2790	    {
2791	      dir_lines[line_number].add_entries_before
2792	        = (struct spec_entry **) xmalloc (n_entries * sizeof (struct spec_entry *));
2793	      for (i = 0; i < n_entries; i++)
2794	        dir_lines[line_number].add_entries_before[i] = 0;
2795	    }
2796	
2797	  /* Find the place where this entry belongs.  If there are already
2798	     several entries to add before LINE_NUMBER, make sure they are in
2799	     alphabetical order.  */
2800	  for (i = 0; i < n_entries; i++)
2801	    if (dir_lines[line_number].add_entries_before[i] == 0
2802	        || menu_line_lessp (entry->text, strlen (entry->text),
2803	                            dir_lines[line_number].add_entries_before[i]->text,
2804	                            strlen (dir_lines[line_number].add_entries_before[i]->text)))
2805	      break;
2806	
2807	  if (i == n_entries)
2808	    abort ();
2809	
2810	  /* If we need to plug ENTRY into the middle of the
2811	     ADD_ENTRIES_BEFORE array, move the entries which should be output
2812	     after this one down one notch, before adding a new one.  */
2813	  if (dir_lines[line_number].add_entries_before[i] != 0)
2814	    for (j = n_entries - 1; j > i; j--)
2815	      dir_lines[line_number].add_entries_before[j]
2816	        = dir_lines[line_number].add_entries_before[j - 1];
2817	
2818	  dir_lines[line_number].add_entries_before[i] = entry;
2819	}
