#!/bin/sh

rm -fr pdftex/ luatex/ xetex/ mix/

# pdfTeX

rm -f *.aux *.toc *.log *.pdf

texi2pdf aaa.texi
texi2pdf bbb.texi
## For pdfTeX, \txiuseunicodedestnamefalse is default.
#texi2pdf aaa-false.texi
texi2pdf aaa-latin1.texi
texi2pdf aaa-latin15.texi

mkdir pdftex
mv *.pdf *.aux *.toc *.log pdftex/

# LuaTeX

rm -f *.aux *.toc *.log *.pdf

PDFTEX=luatex texi2pdf aaa.texi
PDFTEX=luatex texi2pdf bbb.texi
PDFTEX=luatex texi2pdf aaa-false.texi
PDFTEX=luatex texi2pdf aaa-latin1.texi
PDFTEX=luatex texi2pdf aaa-latin15.texi

mkdir luatex
mv *.pdf *.aux *.toc *.log luatex/

# XeTeX

rm -f *.aux *.toc *.log *.pdf

PDFTEX=xetex texi2pdf aaa.texi
PDFTEX=xetex texi2pdf bbb.texi
PDFTEX=xetex texi2pdf aaa-false.texi
## For XeTeX, non-UTF-8 / non-ASCII encodings are broken.
#PDFTEX=xetex texi2pdf aaa-latin1.texi
#PDFTEX=xetex texi2pdf aaa-latin15.texi

mkdir xetex
mv *.pdf *.aux *.toc *.log xetex/

# mix

rm -f *.aux *.toc *.log *.pdf

mkdir mix
cp xetex/aaa.pdf mix/
cp luatex/bbb.pdf mix/
