#!/bin/bash

mkdir -p ./tests-results.d
cd ./tests-results.d

run_metalink_test()
{
    local metafile="$1"

    rm bash43-001* &> /dev/null
    echo "wget --input-metalink=$metafile"
    valgrind --log-file="${metafile##*/}.valgrind" --leak-check=full wget --input-metalink=$metafile -o "${metafile##*/}.wget"

    rm bash43-001* &> /dev/null
    echo "wget -c --input-metalink=$metafile"
    valgrind --log-file="${metafile##*/}_c.valgrind" --leak-check=full wget -c --input-metalink=$metafile -o "${metafile##*/}_c.wget"

    rm bash43-001* &> /dev/null
    echo "wget --keep-badhash --input-metalink=$metafile"
    valgrind --log-file="${metafile##*/}_keep-badhash.valgrind" --leak-check=full wget --keep-badhash --input-metalink=$metafile -o "${metafile##*/}_keep-badhash.wget"

    rm bash43-001* &> /dev/null
    echo "wget --keep-badhash -c --input-metalink=$metafile"
    valgrind --log-file="${metafile##*/}_keep-badhash_c.valgrind" --leak-check=full wget --keep-badhash -c --input-metalink=$metafile -o "${metafile##*/}_keep-badhash_c.wget"

    rm bash43-001* &> /dev/null
    return 0
}

run_metalink_test "../metalink-tests/test-file-sha256.meta4"
run_metalink_test "../metalink-tests/test-file-sha256-badhash.meta4"
run_metalink_test "../metalink-tests/test-pathfile-sha256.meta4"
run_metalink_test "../metalink-tests/test-pathfile-sha256-badhash.meta4"

echo "-----"

grep 'SIGSEGV' *

exit 0
