#!/usr/bin/tclsh
#
# By Nicholas W. Blasgen, 1999
#
# Thanks to Tim Jones <cybersysop813@HOTMAIL.COM> for the BugTraq post
#
# Distributed under GPL licence
#

proc doConnect { host } {
	set s [socket $host 80]
	puts $s "GET /publisher/ HTTP/1.0"
	puts $s ""
	flush $s
	foreach b [split [read $s] "\n"] {
		if { $b == "" } {continue}
		set object [lindex $b 0]
		if {$object == "Server:" } {
			set version [split [lindex $b 1] "//"]
			if { [lindex $version 0] != "Netscape-Enterprise" } { puts "${host}: Not Netscape-Enterprise"; exit }
			set version [split [lindex $version 1] "."]
			set version "[lindex $version 0].[lindex $version 1]"
			if { $version > 3.5 } { puts "${host}: New Version..."; return }
		}

		if {$object == "Last-modified:" } {
			set year [lindex $b 4]
			if { $year < 1998 } { puts "${host}: Looks like this might have a problem"; return }
		}
	}
	puts "${host}: No problem"
	return
}


set nohost 0

if { [lindex $argv 0] == "-i" } {
	set nohost 1
	set host [lindex $argv 1]
	doConnect $host
	exit
} else {
	set fd [open "check_hosts" r]
	foreach a [split [read $fd] "\n"] {
		if { $a == "" } { continue }
		doConnect $a
	}
}



#
# HTTP/1.1 200 OK
# Server: Netscape-Enterprise/3.5.1I
# Date: Mon, 08 Nov 1999 02:55:57 GMT
# Content-type: text/html
# Link: <http://www.fbi.gov/publisher/?PageServices>; rel="PageServices"
# Last-modified: Wed, 31 Dec 1997 02:44:03 GMT
# Content-length: 11421
# Accept-ranges: bytes
# Connection: close
#
