<?php
// $Id: pnuserapi.php,v 1.51.2.1 2002/04/20 07:10:39 epsilon7 Exp $
/********************************************************/
/* PostCalendar                                         */
/* Version 2.6,  see changes.txt for details            */
/* Originally by Rob Sutton (Events Calendar)           */
/* Development continued by                             */
/*                                                      */
/*  The PostCalendar Development Team                   */
/*     Mahmood Al-Yousif - mahmood@bahraini.tv          */
/*     Craig Hamlin - craig@hamlinworld.com             */
/*     HotBird - ramses@bzone.de                        */
/*     Roger Raymond - iansym@yahoo.com                 */
/*                                                      */
/* This program is opensource so you can do whatever    */
/* you want with it. However, I'm happy about any       */
/* clever idea or nifty change you might have or have   */
/* done, send them to                                   */
/* calendar@bahraini.tv                                 */
/*                                                      */
/* Any new versions can be found at                     */
/* http://www.bahraini.tv first                         */
/********************************************************/

// set some globals for easier code readability
define('_EVENT_NONE',      -1);
define('_EVENT_DAILY',      0);
define('_EVENT_WEEKLY',     1);
define('_EVENT_MONTHLY',    2);
define('_EVENT_YEARLY',     3);
define('_IS_SUNDAY',        0);
define('_IS_MONDAY',        1);
define('_IS_SATURDAY',      2);
define('_RECUR_SAME_DAY',   0);
define('_RECUR_SAME_DATE',  1);
if(!defined('_AM_VAL')) define('_AM_VAL', 1);
if(!defined('_PM_VAL')) define('_PM_VAL', 2);
if(!defined('_ACTION_DELETE')) define('_ACTION_DELETE',    1);
if(!defined('_ACTION_EDIT')) define('_ACTION_EDIT',      2);

/**
 * return the translated month name
 * @param $args['pc_month'] month number to get '01-12'
 * @returns string
 * @return month name in user's language
 */
function PostCalendar_userapi_getmonthname($args)
{   
    extract($args);
    
    if(!isset($Date)) {
        return false;
    }
    switch(date('m',$Date)) {   
        case '01':
            return _CALJAN;
            break;
        case '02':
            return _CALFEB;
            break;
        case '03':
            return _CALMAR;
            break;
        case '04':
            return _CALAPR;
            break;
        case '05':
            return _CALMAY;
            break;
        case '06':
            return _CALJUN;
            break;
        case '07':
            return _CALJUL;
            break;
        case '08':
            return _CALAUG;
            break;
        case '09':
            return _CALSEP;
            break;
        case '10':
            return _CALOCT;
            break;
        case '11':
            return _CALNOV;
            break;
        case '12':
            return _CALDEC;
            break;
        default:
            return date('m',$Date);
            break;
    }

}

/**
 *  Returns an array of form data for FormSelectMultiple
 */
function PostCalendar_userapi_buildMonthSelect($args) 
{
    extract($args);
    
    if(!isset($pc_month)) {   
        $pc_month = Date('m');
    } 
    // create the return object to be inserted into the form
    $output = array();
    $count = 0;
    if(!isset($selected)) $selected = '';
    for ($i = 1; $i <= 12; $i++) {
        if($selected) {
            $sel = $selected == $i ? true : false;
        } elseif ($i == $pc_month) {
            $sel = true;
        } else {
            $sel = false;
        }
         
        $output[$count]['id']         = $i;
        $output[$count]['selected']   = $sel;
        $output[$count]['name']       = $i;
        $count++;
    }
    
    return $output;
}

/**
 *  Returns an array of form data for FormSelectMultiple
 */
function PostCalendar_userapi_buildDaySelect($args) 
{   
    extract($args);

    if(!isset($pc_day)) {   
        $pc_day = Date('d');
    }
    // create the return object to be inserted into the form
    $output = array();
    $count = 0;
    if(!isset($selected)) $selected = '';
    for ($i = 1; $i <= 31; $i++) {   
        if($selected) {
            $sel = $selected == $i ? true : false;
        } elseif ($i == $pc_day) {
            $sel = true;
        } else {
            $sel = false;
        }
        $output[$count]['id']         = $i;
        $output[$count]['selected']   = $sel;
        $output[$count]['name']       = $i;
        $count++;
    }
    
    return $output;
}

/**
 *  Returns an array of form data for FormSelectMultiple
 */
function PostCalendar_userapi_buildYearSelect($args) 
{   
    extract($args);
    
    if(!isset($pc_year)) {   
        $pc_year = Date('Y');
    }
    // create the return object to be inserted into the form
    $output = array();
    // we want the list to contain 10 year before today and 30 years after
    // maybe this will eventually become a user defined value
    $pc_start_year = $pc_year - 10;
    $pc_end_year = $pc_year + 30;
    $count = 0;
    if(!isset($selected)) $selected = '';
    for ($i = $pc_start_year; $i <= $pc_end_year; $i++) {   
        if($selected) {
            $sel = $selected == $i ? true : false;
        } elseif ($i == $pc_year) {
            $sel = true;
        } else {
            $sel = false;
        }
        $output[$count]['id']         = $i;
        $output[$count]['selected']   = $sel;
        $output[$count]['name']       = $i;
        $count++;
    }
    
    return $output;
}

/**
 *  Returns an array of form data for FormSelectMultiple
 */
function PostCalendar_userapi_buildTimeSelect($args) 
{   
    $time24hours = pnModGetVar('PostCalendar','time24hours');
    $inc = 15; // <--- should this be a setting?
    
    extract($args);
    
    $output         = array();
    $output['h']    = array();
    $output['m']    = array();
    
    if($time24hours) {
        $start  = 0;
        $end    = 23;
    } else {
        $start  = 1;
        $end    = 12;
    }
    
    if(!$time24hours) {
        $hselected = $hselected > 12 ? $hselected-=12 : $hselected ;
    }
    
    $count = 0;
    for ($h = $start; $h <= $end; $h++) {   
        $hour = $h < 10 ? "0$h" : "$h";
        $selected = $hselected == $hour ? true : false;
        $output['h'][$count]['id']         = pnVarPrepForStore($h);
        $output['h'][$count]['selected']   = $selected;
        $output['h'][$count]['name']       = pnVarPrepForDisplay($hour);
        $count++;
    }
    
    $count = 0;
    for ($m = 0; $m <= 60-$inc; $m+=$inc) {   
        $min = $m < 10 ? "0$m" : "$m";
        $selected = $mselected == $min ? true : false;
        $output['m'][$count]['id']         = pnVarPrepForStore($m);
        $output['m'][$count]['selected']   = $selected;
        $output['m'][$count]['name']       = pnVarPrepForDisplay($min);
        $count++;
    }
    
    return $output;
}

function PostCalendar_userapi_getTime($args) 
{
    extract($args);
    if(!isset($time)) {
        return false;
    }
    
    $time_Array = explode(":",$time);
    $min = $time_Array[1];
    if ($time_Array[0] == "00") {
        $hour = "12";
        $ampm = "AM";
    } elseif ($time_Array[0] == "12") {
        $hour = "12";
        $ampm = "PM";
    } elseif ($time_Array[0] > 12) {
        $hour = $time_Array[0] - 12;
        $ampm = "PM";
    } else {
        if ($time_Array[0] < 10) {
            $hour = substr($time_Array[0],1,1);
        } else {
            $hour = $time_Array[0];
            $ampm = "AM";
        }
    }
    $time = "$hour:$min $ampm";
    return $time;
}

function PostCalendar_userapi_getLongDayName($args) 
{
    extract($args);
    if(!isset($Date)) {
        return false;
    }
    
    $pc_long_day = array(_CALLONGFIRSTDAY,
                         _CALLONGSECONDDAY,
                         _CALLONGTHIRDDAY,
                         _CALLONGFOURTHDAY,
                         _CALLONGFIFTHDAY,
                         _CALLONGSIXTHDAY,
                         _CALLONGSEVENTHDAY);
    
    return $pc_long_day[Date("w",$Date)];
}

function PostCalendar_userapi_valueToText($args) 
{
    extract($args);
    if(!isset($tmp)) {
        return false;
    }
    
    $tmp = ereg_replace(10,"",$tmp);
    $tmp = ereg_replace(9,"&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;",$tmp);
    $tmp = ereg_replace("<","&lt;",$tmp);
    $tmp = ereg_replace(">","&gt;",$tmp);
    $tmp = ereg_replace("\"","&quot;",$tmp);
    $tmp = ereg_replace(13,"<br>",$tmp);
    //$tmp = str_replace("\\","\\\\",$tmp);
    $tmp = ereg_replace("'","`",$tmp);
    return $tmp;
}

//$startTime,$endTime,$year,$month,$day
function PostCalendar_userapi_addTimeRange($args)
{   
    // get the theme globals :: is there a better way to do this?
    global $bgcolor1, $bgcolor2, $bgcolor3, $bgcolor4, $bgcolor5;
    global $textcolor1, $textcolor2;
    
    extract($args);
    // make sure we've got everything we need
    if(!isset($startTime)   || 
       !isset($endTime)     || 
       !isset($year)        || 
       !isset($month)       || 
       !isset($day)) {
        return false;
    }
    
    $output = new pnHTML();
    $output->SetInputMode(_PNH_VERBATIMINPUT);
    $output->SetOutputMode(_PNH_KEEPOUTPUT);
    
    $dayhighlightcolor = pnModGetVar('PostCalendar','dayhighlightcolor');
  
    pnModDBInfoLoad('PostCalendar');
    list($dbconn) = pnDBGetConn();
    $pntable = pnDBGetTables();
    $events_table = $pntable['postcalendar_events'];
    $events_column = &$pntable['postcalendar_events_column'];
    
    if (pnModGetVar('PostCalendar','time24hours')) {
        $tmpTime    = substr($startTime,0,5);
        $tmpTime2   = substr($endTime,0,5);
    } else {
        $tmpTime    = pnModAPIFunc('PostCalendar','user','getTime',array('time'=>$startTime));
        $tmpTime2   = pnModAPIFunc('PostCalendar','user','getTime',array('time'=>$endTime));
    }
    
    $output->Linebreak(2);
    $output->Text('<font class="pn-normal" color='.$textcolor1.'>'.$tmpTime - $tmpTime2.'</font>');
    
    $sql = "SELECT $events_column[eid],
                   $events_column[title],
                   $events_column[startTime],
                   $events_column[endTime],
                   $events_column[barcolor],
                   $events_column[topic]
                    
            FROM   $events_table
            
            WHERE  (($events_column[recurrtype]=0
                   AND $events_column[eventDate] <= '$year-$month-$day'
                   AND $events_column[endDate] >= '$year-$month-$day'
                   AND $events_column[alldayevent]='0'
                   AND $events_column[startTime] >= '$startTime'
                   AND $events_column[startTime] < '$endTime')

                   OR ($events_column[recurrtype]=1
                   AND $events_column[eventDate] <= '$year-$month-$day'
                   AND $events_column[endDate] >= '$year-$month-$day'
                   AND (DAYOFWEEK($events_column[eventDate])=DAYOFWEEK('$year-$month-$day'))
                   AND $events_column[alldayevent]='0'
                   AND $events_column[startTime] >= '$startTime'
                   AND $events_column[startTime] < '$endTime')

                   OR ($events_column[recurrtype]=2
                   AND $events_column[eventDate] <= '$year-$month-$day'
                   AND $events_column[endDate] >= '$year-$month-$day'
                   AND (DAYOFMONTH($events_column[eventDate])=DAYOFMONTH('$year-$month-$day'))
                   AND $events_column[alldayevent]='0'
                   AND $events_column[startTime] >= '$startTime'
                   AND $events_column[startTime] < '$endTime')


	               OR ($events_column[recurrtype]=3
                   AND $events_column[eventDate] <= '$year-$month-$day'
                   AND $events_column[endDate] >= '$year-$month-$day'
                   AND (DAYOFMONTH($events_column[eventDate])=DAYOFMONTH('$year-$month-$day'))
                   AND (MONTH($events_column[eventDate])=MONTH('$year-$month-$day'))
                   AND $events_column[alldayevent]='0'
                   AND $events_column[startTime] >= '$startTime'
                   AND $events_column[startTime] < '$endTime'))
                   
                   AND $events_column[eventstatus] = 1
               
               
            ORDER BY $events_column[topic], 
                     $events_column[title] ASC";

    $output->Text(pnModAPIFunc('PostCalendar','user','printAppt',array('sql'=>$sql)));
    return $output->GetOutput();
}


function PostCalendar_userapi_buildDay($args)
{
    // get the theme globals :: is there a better way to do this?
    global $bgcolor1, $bgcolor2, $bgcolor3, $bgcolor4, $bgcolor5;
    global $textcolor1, $textcolor2;
    
    extract($args);
    
    // if we've not been given a date, get the current one
    if(!isset($Date)) {
        $Date = date('m/d/Y');
    }

    // break down the date
    list($the_month,$the_day,$the_year) = explode('/',$Date);

    // get DB information
    pnModDBInfoLoad('PostCalendar');
    list($dbconn) = pnDBGetConn();
    $pntable = pnDBGetTables();
    
    // link to the events tables
    $events_table = $pntable['postcalendar_events'];
    $events_column = &$pntable['postcalendar_events_column'];
    
    // link to the topics table
    $topics_table = $pntable['topics'];
    $topics_column = &$pntable['topics_column'];
    
    // let's load the User API so we can use it
    if(!pnModAPILoad('PostCalendar','user')) {
        die('Could not load PostCalendar user API');
    }
    
    // grab the modules information
    $modinfo = pnModGetInfo(pnModGetIDFromName('PostCalendar'));
    
    $usepopups              = pnModGetVar('PostCalendar','usepopups');
    $useinternationaldates  = pnModGetVar('PostCalendar','useinternationaldates');
    $eventsopeninnewwindow  = pnModGetVar('PostCalendar','eventsopeninnewwindow');
    $dayhighlightcolor      = pnModGetVar('PostCalendar','dayhighlightcolor');
    $firstdayofweek         = pnModGetVar('PostCalendar','firstdayofweek');
    $doappointments         = pnModGetVar('PostCalendar','doappointments');
    
    // start the output container
    $output = new pnHTML();
    $output->SetInputMode(_PNH_VERBATIMINPUT);
    $output->SetOutputMode(_PNH_KEEPOUTPUT);
    
    // load the DHTML JavaScript code and insert it into the page
    if ($usepopups) {
        $output->Text(pnModAPIFunc('PostCalendar','user','loadPopups'));
    }

    // insert the js popup code into the page
    if($eventsopeninnewwindow) {
        $output->Text(pnModAPIFunc('PostCalendar','user','jsPopup'));
    }
    
    $pc_long_day_names = array(_CALSUNDAY,
                               _CALMONDAY,
                               _CALTUESDAY,
                               _CALWEDNESDAY,
                               _CALTHURSDAY,
                               _CALFRIDAY,
                               _CALSATURDAY);
    
    $prev_day = date('m/d/Y',mktime(0,0,0,$the_month,$the_day-1,$the_year));
    $next_day = date('m/d/Y',mktime(0,0,0,$the_month,$the_day+1,$the_year));
    
    //*******************************************************************
    //  Here we get the events for the current week view
    //*******************************************************************
    
    // this query is still intense, especially when there are a lot of results
    // there's gotta be something that can be done about it
    
    $sql =  "SELECT $events_column[eid], 
                    $events_column[title], 
                    $events_column[hometext], 
                    $events_column[eventDate], 
                    $events_column[endDate], 
                    $events_column[startTime], 
                    $events_column[endTime], 
                    $events_column[barcolor], 
                    $events_column[recurrtype], 
                    $events_column[recurrfreq],
                    $events_column[alldayevent],
                    $events_column[topic] 
             
             FROM   $events_table
             
             WHERE  $events_column[eventstatus] = 1
             
             ORDER BY $events_column[startTime],$events_column[eventDate] ASC";
             
    $result = $dbconn->Execute($sql);
    
    // put the information into an array for easy access
    $events = array();
    
    for($e=0; !$result->EOF; $result->MoveNext()) {
        list($eid,$title,$hometext,$eventDate,$endDate,$startTime,$endTime,
             $barcolor,$recurrtype,$recurrfreq,$alldayevent,$topic) = $result->fields;
             
        $events[$e]['eid']          = $eid;
        $events[$e]['title']        = $title;
        $events[$e]['hometext']     = $hometext;
        $events[$e]['eventDate']    = $eventDate;
        $events[$e]['endDate']      = $endDate;
        $events[$e]['startTime']    = $startTime;
        $events[$e]['endTime']      = $endTime;
        $events[$e]['barcolor']     = $barcolor;
        $events[$e]['recurrtype']   = $recurrtype;
        $events[$e]['recurrfreq']   = $recurrfreq;
        $events[$e]['alldayevent']  = $alldayevent;
        $events[$e]['topic']        = $topic;
        $e++;
    }
    
    //*******************************************************************
    //  START the day header and navigation
    //  << Prev     DATE      Next >>
    //*******************************************************************
    $output->Text('<table border="0" cellpadding="1" cellspacing="0" width="100%"><tr><td bgcolor="'.$bgcolor2.'">');
    $output->Text('<table border="0" cellpadding="5" cellspacing="0" width="100%"><tr><td bgcolor="'.$bgcolor1.'">');
        $output->TableStart();
        $output->SetOutputMode(_PNH_RETURNOUTPUT);
        
        $pc_prev = pnModURL('PostCalendar','user','view',array('viewtype'=>'day','Date'=>$prev_day));
        $pc_next = pnModURL('PostCalendar','user','view',array('viewtype'=>'day','Date'=>$next_day));
        $pc_prev_url = $output->URL($pc_prev,'&lt;&lt; '._PC_PREV_DAY);
        $pc_next_url = $output->URL($pc_next,_PC_NEXT_DAY.' &gt;&gt;');
        $pc_month_name = pnModAPIFunc('PostCalendar',
                                      'user',
                                      'getmonthname',
                                      array('Date'=>mktime(0,0,0,$the_month,$the_day,$the_year)));
        $day_link_url = pnModURL('PostCalendar',
                                   'user',
                                   'view',
                                   array('viewtype'=>'day','Date'=>date('m/d/Y',mktime(0,0,0,$the_month,$the_day,$the_year))));
        
        if($useinternationaldates) {
            $day_link_text = $the_day.' '.$pc_month_name.' '.$the_year;
                            
        } else {
            $day_link_text = $pc_month_name.' '.$the_day.' '.$the_year;
        }
        
        
        $pc_link = $output->URL($day_link_url,$day_link_text);
            $row = array();
            $row[0]['content']  = $pc_prev_url;
            $row[0]['align']    = 'left';
            $row[0]['valign']   = 'middle';
            
            $row[1]['content']  = $pc_link;
            $row[1]['align']    = 'center';
            $row[1]['valign']   = 'middle';
               
            $row[2]['content']  = $pc_next_url;
            $row[2]['align']    = 'right';
            $row[2]['valign']   = 'middle';
                
        $output->SetOutputMode(_PNH_KEEPOUTPUT);
        $output->TableAddRow($row);
        $output->TableEnd();
    $output->Text('</td></tr></table>');
    $output->Text('</td></tr></table>');
    //*******************************************************************
    //  END the day header and navigation
    //  << Prev     DATE      Next >>
    //*******************************************************************
    
    //*******************************************************************
    //  START CALENDAR TABLE
    //*******************************************************************
    $output->Text('<table border="0" cellpadding="1" cellspacing="0" width="100%"><tr><td bgcolor="'.$bgcolor2.'">');
    $output->Text('<table border="0" cellpadding="0" cellspacing="0" width="100%">');
    
    //*******************************************************************
    //  START CALENDAR CONTENT
    //*******************************************************************
    $output->Text('<tr>');
    //for($i=0; $i<7; $i++) {
        //*******************************************************************
        //  START CALENDAR DAY CONTENT CELL
        //*******************************************************************
        $output->Text('<td height="70" bgcolor="'.$bgcolor1.'" align="left" valign="top">');
            //*******************************************************************
            //  START TABLE DATE AND ADD BUTTON
            //*******************************************************************
            $output->Text('<table border="0" cellpadding="5" cellspacing="0" width="100%"><tr>');
                $output->Text('<td bgcolor="'.$bgcolor2.'" align="left" valign="top" nowrap>');
            
                    $output->SetOutputMode(_PNH_RETURNOUTPUT);
                        $this_date  = date('m/d/Y',mktime(0,0,0,$the_month,$the_day,$the_year));
                        $day        = date('d',mktime(0,0,0,$the_month,$the_day,$the_year));
                        $day_url    = pnModURL('PostCalendar','user','view',array('viewtype'=>'day','Date'=>$this_date));
                        $day_link   = $output->URL($day_url,'<b>'.$day_link_text.'</b>');
                    $output->SetOutputMode(_PNH_KEEPOUTPUT);
                    if($doappointments) {
                        $output->Text(_PC_APPOINTMENTS.' '.$day_link);
                    } else {
                        $output->Text(_PC_EVENTS.' '.$day_link);
                    }
                $output->Text('</td>');
                
                if($doappointments) { // create the events column
                    $output->Text('<td bgcolor="'.$bgcolor2.'" align="left" valign="top" nowrap>');
                        $output->Text(_PC_ALLDAY_EVENTS.' '.$day_link);
                    $output->Text('</td>');
                }
            //*******************************************************************
            //  END TABLE DATE AND ADD BUTTON
            //*******************************************************************
            $output->Text('</tr>');
            
            //*******************************************************************
            //  START TABLE EVENTS
            //*******************************************************************
            
            $column1 = '';
            $column2 = '';
            for($e=0; $e<count($events); $e++) {
                // start the tests
                list($this_month,$this_day,$this_year) = explode('/',$this_date);
                $compare_to_date = $this_year.'-'.$this_month.'-'.$this_day;
                $day_of_week = date('w',mktime(0,0,0,$the_month,$the_day,$the_year)); 
                $output->SetOutputMode(_PNH_RETURNOUTPUT);   
                switch ($events[$e]['recurrtype']) {
                    
                    case _EVENT_NONE :
                    // display an event on a certain day
                        if($events[$e]['eventDate'] <= $compare_to_date && $events[$e]['endDate'] >= $compare_to_date) {
                        
                            if($doappointments && $events[$e]['alldayevent'] < 1) {
                                $column1 .= $output->Text(pnModAPIFunc('PostCalendar','user','createEventLink',
                                                                        array('event'=>$events[$e],'dayofweek'=>$day_of_week)));
                            } elseif($doappointments && $events[$e]['alldayevent'] == 1) {
                                $column2 .= $output->Text(pnModAPIFunc('PostCalendar','user','createEventLink',
                                                                        array('event'=>$events[$e],'dayofweek'=>$day_of_week)));
                            } else {
                                $column1 .= $output->Text(pnModAPIFunc('PostCalendar','user','createEventLink',
                                                                        array('event'=>$events[$e],'dayofweek'=>$day_of_week)));
                            }
                        }
                        break;
                    
                    case _EVENT_DAILY :
                        // display an event on a certain day
                        if($events[$e]['eventDate'] <= $compare_to_date && $events[$e]['endDate'] >= $compare_to_date) {
                            if($doappointments && $events[$e]['alldayevent'] < 1) {
                                $column1 .= $output->Text(pnModAPIFunc('PostCalendar','user','createEventLink',
                                                                        array('event'=>$events[$e],'dayofweek'=>$day_of_week)));
                            } elseif($doappointments && $events[$e]['alldayevent'] == 1) {
                                $column2 .= $output->Text(pnModAPIFunc('PostCalendar','user','createEventLink',
                                                                        array('event'=>$events[$e],'dayofweek'=>$day_of_week)));
                            } else {
                                $column1 .= $output->Text(pnModAPIFunc('PostCalendar','user','createEventLink',
                                                                        array('event'=>$events[$e],'dayofweek'=>$day_of_week)));
                            }
                        }
                        break;
                
                    case _EVENT_WEEKLY :
                        // display an event weekly on a certain day
                        if($events[$e]['eventDate'] <= $compare_to_date && $events[$e]['endDate'] >= $compare_to_date) {
                            list($event_year,$event_month,$event_day) = explode('-',$events[$e]['eventDate']);
                        
                            $current_week_day   = date('w',mktime(0,0,0,$this_month,$this_day,$this_year));
                            $event_week_day     = date('w',mktime(0,0,0,$event_month,$event_day,$event_year)); 
                        
                            if($current_week_day === $event_week_day) {
                                if($doappointments && $events[$e]['alldayevent'] < 1) {
                                    $column1 .= $output->Text(pnModAPIFunc('PostCalendar','user','createEventLink',
                                                                            array('event'=>$events[$e],'dayofweek'=>$day_of_week)));
                                } elseif($doappointments && $events[$e]['alldayevent'] == 1) {
                                    $column2 .= $output->Text(pnModAPIFunc('PostCalendar','user','createEventLink',
                                                                            array('event'=>$events[$e],'dayofweek'=>$day_of_week)));
                                } else {
                                    $column1 .= $output->Text(pnModAPIFunc('PostCalendar','user','createEventLink',
                                                                            array('event'=>$events[$e],'dayofweek'=>$day_of_week)));
                                }
                            }
                        }
                        break;
                
                    case _EVENT_MONTHLY :
                        // display an event once a month on a certain day
                        if($events[$e]['eventDate'] <= $compare_to_date && $events[$e]['endDate'] >= $compare_to_date) {
                            list($event_year,$event_month,$event_day) = explode('-',$events[$e]['eventDate']);
                            
                            /**
                             *  Display event on same WEEK DAY each Month
                             *  This will cause a monthly event to always show on the same day of the month
                             *  If an event is started on the 1st Monday, it will always display on the 1st Monday
                             *  of each month for it's duration.
                             */
                            if($events[$e]['recurrfreq'] == _RECUR_SAME_DAY) {
                                $current_day_of_week = date('w',mktime(0,0,0,$this_month,$this_day,$this_year));
                                $event_day_of_week   = date('w',mktime(0,0,0,$event_month,$event_day,$event_year));
                             
                                $event_day_occurance=0;
                                for($d=1; $d<=$event_day; $d++) {
                                    $current_day = date('w',mktime(0,0,0,$event_month,$d,$event_year));
                                    if($current_day === $event_day_of_week) {
                                        $event_day_occurance++;
                                    }
                                }
                            
                                $curr_day = date('d',mktime(0,0,0,$this_month,$this_day,$this_year));
                                $current_day_occurance=0;
                                for($d=1; $d<=$curr_day; $d++) {
                                    $current_day = date('w',mktime(0,0,0,$this_month,$d,$this_year));
                                    if($current_day === $current_day_of_week) {
                                        $current_day_occurance++;
                                    }
                                }
                            
                                if($current_day_occurance === $event_day_occurance  && $current_day_of_week === $event_day_of_week) {
                                    if($doappointments && $events[$e]['alldayevent'] < 1) {
                                        $column1 .= $output->Text(pnModAPIFunc('PostCalendar','user','createEventLink',
                                                                                array('event'=>$events[$e],'dayofweek'=>$day_of_week)));
                                    } elseif($doappointments && $events[$e]['alldayevent'] == 1) {
                                        $column2 .= $output->Text(pnModAPIFunc('PostCalendar','user','createEventLink',
                                                                                array('event'=>$events[$e],'dayofweek'=>$day_of_week)));
                                    } else {
                                        $column1 .= $output->Text(pnModAPIFunc('PostCalendar','user','createEventLink',
                                                                                array('event'=>$events[$e],'dayofweek'=>$day_of_week)));
                                    }
                                }
                            }
                            
                            /**
                             *  Display event on same DATE each Month
                             *  This will cause a monthly event to always show on the same date of the month
                             *  If an event is started on the 25th of the Month it will always display
                             *  on the 25th of each month for its duration
                             *  (this is not yet implemented as it needs DB changes
                             */
                            if($events[$e]['recurrfreq'] == _RECUR_SAME_DATE) {
                                if($this_day === $event_day) {
                                    if($doappointments && $events[$e]['alldayevent'] < 1) {
                                        $column1 .= $output->Text(pnModAPIFunc('PostCalendar','user','createEventLink',
                                                                                array('event'=>$events[$e],'dayofweek'=>$day_of_week)));
                                    } elseif($doappointments && $events[$e]['alldayevent'] == 1) {
                                        $column2 .= $output->Text(pnModAPIFunc('PostCalendar','user','createEventLink',
                                                                                array('event'=>$events[$e],'dayofweek'=>$day_of_week)));
                                    } else {
                                        $column1 .= $output->Text(pnModAPIFunc('PostCalendar','user','createEventLink',
                                                                                array('event'=>$events[$e],'dayofweek'=>$day_of_week)));
                                    }
                                }    
                            }
                            
                        }
                        break;
                    case _EVENT_YEARLY :
                    // display an event once a year on a certain day
                    if($events[$e]['eventDate'] <= $compare_to_date && $events[$e]['endDate'] >= $compare_to_date) {
                        list($event_year,$event_month,$event_day) = explode('-',$events[$e]['eventDate']);    
                        
                        /**
                         *  Display event on same WEEK DAY each Month
                         *  This will cause a monthly event to always show on the same day of the month
                         *  If an event is started on the 1st Monday, it will always display on the 1st Monday
                         *  of each month for it's duration.
                         */
                        if($events[$e]['recurrfreq'] == _RECUR_SAME_DAY) {
                            $current_day_of_week = date('w',mktime(0,0,0,$this_month,$this_day,$this_year));
                            $event_day_of_week   = date('w',mktime(0,0,0,$event_month,$event_day,$event_year));
                         
                            $event_day_occurance=0;
                            for($d=1; $d<=$event_day; $d++) {
                                $current_day = date('w',mktime(0,0,0,$event_month,$d,$event_year));
                                if($current_day === $event_day_of_week) {
                                    $event_day_occurance++;
                                }
                            }
                            
                            $curr_day = date('d',mktime(0,0,0,$this_month,$this_day,$this_year));
                            $current_day_occurance=0;
                            for($d=1; $d<=$curr_day; $d++) {
                                $current_day = date('w',mktime(0,0,0,$this_month,$d,$this_year));
                                if($current_day === $current_day_of_week) {
                                    $current_day_occurance++;
                                }
                            }
                            
                            if(   $current_day_occurance === $event_day_occurance  
                               && $current_day_of_week === $event_day_of_week
                               && $this_month === $event_month) {
                                if($doappointments && $events[$e]['alldayevent'] < 1) {
                                    $column1 .= $output->Text(pnModAPIFunc('PostCalendar','user','createEventLink',
                                                                            array('event'=>$events[$e],'dayofweek'=>$day_of_week)));
                                } elseif($doappointments && $events[$e]['alldayevent'] == 1) {
                                    $column2 .= $output->Text(pnModAPIFunc('PostCalendar','user','createEventLink',
                                                                            array('event'=>$events[$e],'dayofweek'=>$day_of_week)));
                                } else {
                                    $column1 .= $output->Text(pnModAPIFunc('PostCalendar','user','createEventLink',
                                                                            array('event'=>$events[$e],'dayofweek'=>$day_of_week)));
                                }
                            }
                        }
                        /**
                         *  Display event on same DATE each Month
                         *  This will cause a monthly event to always show on the same date of the month
                         *  If an event is started on the 25th of the Month it will always display
                         *  on the 25th of each month for its duration
                         *  (this is not yet implemented as it needs DB changes
                         */
                        if($events[$e]['recurrfreq'] == _RECUR_SAME_DATE) {
                            if(   $this_day === $event_day 
                               && $this_month === $event_month) {
                                if($doappointments && $events[$e]['alldayevent'] < 1) {
                                    $column1 .= $output->Text(pnModAPIFunc('PostCalendar','user','createEventLink',
                                                                            array('event'=>$events[$e],'dayofweek'=>$day_of_week)));
                                } elseif($doappointments && $events[$e]['alldayevent'] == 1) {
                                    $column2 .= $output->Text(pnModAPIFunc('PostCalendar','user','createEventLink',
                                                                            array('event'=>$events[$e],'dayofweek'=>$day_of_week)));
                                } else {
                                    $column1 .= $output->Text(pnModAPIFunc('PostCalendar','user','createEventLink',
                                                                            array('event'=>$events[$e],'dayofweek'=>$day_of_week)));
                                }
                            }    
                        }
                        
                    }
                    break;
                    
                    default:
                        break;
                }
            
            }
            $output->SetOutputMode(_PNH_KEEPOUTPUT);
            // ouput the events
            $output->Text('<tr><td align="left" valign="top">');
            $output->Text($column1);
            if($doappointments) {
                $output->Text('</td><td align="left" valign="top">'); 
                $output->Text($column2); 
            } 
            $output->Text('</td></tr></table>');
            //*******************************************************************
            //  END TABLE EVENTS
            //*******************************************************************
        
        $output->Text('</td>');
        //*******************************************************************
        //  END CALENDAR DAY CONTENT CELL
        //*******************************************************************
    //}
    $output->Text('</tr>');
    //*******************************************************************
    //  END CALENDAR DAY NAMES ROW (7 columns)
    //*******************************************************************
    
    $output->Text('</table>');
    $output->Text('</td></tr></table>');
    //*******************************************************************
    //  END CALENDAR TABLE
    //*******************************************************************
    
    return $output->GetOutput();
}



/**
 *  PostCalendar_userapi_buildWeek
 *
 *  Builds the month display
 *  @param string $Date mm/dd/yyyy format (using timestamps might need less calculations)
 *  @return string html output generated
 *  @access public
 */
function PostCalendar_userapi_buildWeek($args)
{   
    // get the theme globals :: is there a better way to do this?
    global $bgcolor1, $bgcolor2, $bgcolor3, $bgcolor4, $bgcolor5;
    global $textcolor1, $textcolor2;
    
    extract($args);
    
    // if we've not been given a date, get the current one
    if(!isset($Date)) {
        $Date = date('m/d/Y');
    }
    
    // break down the date
    list($the_month,$the_day,$the_year) = explode('/',$Date);
    
    // get DB information
    pnModDBInfoLoad('PostCalendar');
    list($dbconn) = pnDBGetConn();
    $pntable = pnDBGetTables();
    
    // link to the events tables
    $events_table = $pntable['postcalendar_events'];
    $events_column = &$pntable['postcalendar_events_column'];
    
    // link to the topics table
    $topics_table = $pntable['topics'];
    $topics_column = &$pntable['topics_column'];
    
    // let's load the User API so we can use it
    if(!pnModAPILoad('PostCalendar','user')) {
        die('Could not load PostCalendar user API');
    }
    
    // grab the modules information
    $modinfo = pnModGetInfo(pnModGetIDFromName('PostCalendar'));
    
    $usepopups              = pnModGetVar('PostCalendar','usepopups');
    $useinternationaldates  = pnModGetVar('PostCalendar','useinternationaldates');
    $eventsopeninnewwindow  = pnModGetVar('PostCalendar','eventsopeninnewwindow');
    $dayhighlightcolor      = pnModGetVar('PostCalendar','dayhighlightcolor');
    $firstdayofweek         = pnModGetVar('PostCalendar','firstdayofweek');
    
    // start the output container
    $output = new pnHTML();
    $output->SetInputMode(_PNH_VERBATIMINPUT);
    $output->SetOutputMode(_PNH_KEEPOUTPUT);
    
    // load the DHTML JavaScript code and insert it into the page
    if ($usepopups) {
        $output->Text(pnModAPIFunc('PostCalendar','user','loadPopups'));
    }

    // insert the js popup code into the page
    if($eventsopeninnewwindow) {
        $output->Text(pnModAPIFunc('PostCalendar','user','jsPopup'));
    }
    
    //*******************************************************************
    //  Determine the first day of the week
    //*******************************************************************
    
    $pc_long_day_names = array(_CALSUNDAY,
                               _CALMONDAY,
                               _CALTUESDAY,
                               _CALWEDNESDAY,
                               _CALTHURSDAY,
                               _CALFRIDAY,
                               _CALSATURDAY);
    
    switch ($firstdayofweek) 
    {
        case _IS_SUNDAY:
            $pc_array_pos = 0;
            $what_day  = date('w',mktime(0,0,0,$the_month,$the_day,$the_year));
           break;
        case _IS_MONDAY:
            $pc_array_pos = 1;
            $what_day  = date('w',mktime(0,0,0,$the_month,$the_day-1,$the_year));
            //if ($what_day == 0) {
            //    $what_day = 7; 
            //}
            break;
        case _IS_SATURDAY:
            $pc_array_pos = 6;
            $what_day  = date('w',mktime(0,0,0,$the_month,$the_day+1,$the_year));
            //if ($what_day == 0) { 
            //    $what_day = 6; 
            //}
            break;
        default:
            // sunday is the first day of the week
            $pc_array_pos = 0;
            $what_day  = date('w',mktime(0,0,0,$the_month,$the_day,$the_year));
            break;
    }
    
    $first_day_of_week = $the_day-$what_day;
    
    $week_first_day = date('m/d/Y',mktime(0,0,0,$the_month,$first_day_of_week,$the_year));
    list($week_first_day_month, 
         $week_first_day_date, 
         $week_first_day_year) = explode('/',$week_first_day);
    $week_first_day_month_name  = pnModAPIFunc('PostCalendar',
                                              'user',
                                              'getmonthname',
                                              array('Date'=>mktime(0,0,0,$week_first_day_month,$week_first_day_date,$week_first_day_year)));
                                                                                      
    $week_last_day = date('m/d/Y',mktime(0,0,0,$the_month,$first_day_of_week+6,$the_year));
    list($week_last_day_month, 
         $week_last_day_date, 
         $week_last_day_year) = explode('/',$week_last_day);
    $week_last_day_month_name = pnModAPIFunc('PostCalendar',
                                             'user',
                                             'getmonthname',
                                             array('Date'=>mktime(0,0,0,$week_last_day_month,$week_last_day_date,$week_last_day_year)));
    // get the week (does this approach work on all DB?)
    $the_week = date('Y-m-d',mktime(0,0,0,$week_first_day_month,$week_first_day_date,$week_first_day_year));
    $week_result = $dbconn->Execute("SELECT WEEK('$the_week')");
    list($the_week) = $week_result->fields;
    
    // if the start day is saturday we need to increment the week number by 1
    if ($firstdayofweek == _IS_SATURDAY) {
        $the_week++; 
    }
    // if the week number is greater than 52, make it 1
    if($the_week > 52) {
        $the_week = 1;
    }
    
    $prev_week = date('m/d/Y',mktime(0,0,0,$week_first_day_month,$week_first_day_date-7,$week_first_day_year));
    $next_week = date('m/d/Y',mktime(0,0,0,$week_last_day_month,$week_last_day_date+1,$week_last_day_year));
    
    //*******************************************************************
    //  Here we get the events for the current week view
    //*******************************************************************
    
    // this query is still intense, especially when there are a lot of results
    // there's gotta be something that can be done about it
    
    $sql =  "SELECT $events_column[eid], 
                    $events_column[title], 
                    $events_column[hometext], 
                    $events_column[eventDate], 
                    $events_column[endDate], 
                    $events_column[startTime], 
                    $events_column[endTime], 
                    $events_column[barcolor], 
                    $events_column[recurrtype], 
                    $events_column[recurrfreq],
                    $events_column[topic], 
                    $events_column[alldayevent] 
             
             FROM   $events_table
             
             WHERE  $events_column[eventstatus] = 1
             
             ORDER BY $events_column[startTime], $events_column[eventDate] ASC";
             
    $result = $dbconn->Execute($sql);
    
    // put the information into an array for easy access
    $events = array();
    
    for($e=0; !$result->EOF; $result->MoveNext()) {
        list($eid,$title,$hometext,$eventDate,$endDate,$startTime,$endTime,$barcolor,$recurrtype,$recurrfreq,$topic,$alldayevent) = $result->fields;
        $events[$e]['eid']          = $eid;
        $events[$e]['title']        = $title;
        $events[$e]['hometext']     = $hometext;
        $events[$e]['eventDate']    = $eventDate;
        $events[$e]['endDate']      = $endDate;
        $events[$e]['startTime']    = $startTime;
        $events[$e]['endTime']      = $endTime;
        $events[$e]['barcolor']     = $barcolor;
        $events[$e]['recurrtype']   = $recurrtype;
        $events[$e]['recurrfreq']   = $recurrfreq;
        $events[$e]['topic']        = $topic;
        $events[$e]['alldayevent']  = $alldayevent;
        $e++;
    }
    
    $monthtableborder       = pnModGetVar('PostCalendar','monthtableborder');
    $monthtablecellspacing  = pnModGetVar('PostCalendar','monthtablecellspacing');
    $monthtablecellpadding  = pnModGetVar('PostCalendar','monthtablecellpadding');
    
    
    //*******************************************************************
    //  START the week header and navigation
    //  << Prev     WEEK      Next >>
    //*******************************************************************
    $output->Text('<table border="0" cellpadding="1" cellspacing="0" width="100%"><tr><td bgcolor="'.$bgcolor2.'">');
    $output->Text('<table border="0" cellpadding="5" cellspacing="0" width="100%"><tr><td bgcolor="'.$bgcolor1.'">');
        $output->TableStart();
        $output->SetOutputMode(_PNH_RETURNOUTPUT);
        
        $pc_prev = pnModURL('PostCalendar','user','view',array('viewtype'=>'week','Date'=>$prev_week));
        $pc_next = pnModURL('PostCalendar','user','view',array('viewtype'=>'week','Date'=>$next_week));
        $pc_prev_url = $output->URL($pc_prev,'&lt;&lt; '._PC_PREV_MONTH);
        $pc_next_url = $output->URL($pc_next,_PC_NEXT_MONTH.' &gt;&gt;');
        $pc_month_name = pnModAPIFunc('PostCalendar',
                                      'user',
                                      'getmonthname',
                                      array('Date'=>mktime(0,0,0,$the_month,$the_day,$the_year)));
        $week_link_url = pnModURL('PostCalendar',
                                   'user',
                                   'view',
                                   array('viewtype'=>'week','Date'=>date('m/d/Y',mktime(0,0,0,$the_month,$week_first_day_date,$the_year))));
        
        if($useinternationaldates) {
            $week_link_text = $week_first_day_date.' '.$week_first_day_month_name.' '.$week_first_day_year.' - '
                            . $week_last_day_date.' '.$week_last_day_month_name.' '.$week_last_day_year;
                            
        } else {
            $week_link_text = $week_first_day_month_name.' '.$week_first_day_date.' '.$week_first_day_year.' - '
                            . $week_last_day_month_name.' '.$week_last_day_date.' '.$week_last_day_year;
        }
        
        
        $pc_link = $output->URL($week_link_url,$week_link_text);
            $row = array();
            $row[0]['content']  = $pc_prev_url;
            $row[0]['align']    = 'left';
            $row[0]['valign']   = 'middle';
            
            $row[1]['content']  = $pc_link;
            $row[1]['align']    = 'center';
            $row[1]['valign']   = 'middle';
               
            $row[2]['content']  = $pc_next_url;
            $row[2]['align']    = 'right';
            $row[2]['valign']   = 'middle';
                
        $output->SetOutputMode(_PNH_KEEPOUTPUT);
        $output->TableAddRow($row);
        $output->TableEnd();
    $output->Text('</td></tr></table>');
    $output->Text('</td></tr></table>');
    //*******************************************************************
    //  END the week header and navigation
    //  << Prev     WEEK      Next >>
    //*******************************************************************
    
    //*******************************************************************
    //  START CALENDAR TABLE
    //*******************************************************************
    $output->Text('<table border="0" cellpadding="1" cellspacing="0" width="100%"><tr><td bgcolor="'.$bgcolor2.'">');
    $output->Text('<table border="'.$monthtableborder.'" cellpadding="'.$monthtablecellspacing.'" cellspacing="'.$monthtablecellpadding.'" width="100%">');
    
    //*******************************************************************
    //  START CALENDAR DAY NAMES ROW (7 columns)
    //*******************************************************************
    $output->Text('<tr>');
    // build the long day name header row
    $daynames_row = '';
    for($i=0; $i < count($pc_long_day_names); $i++)
    {
        if($pc_array_pos >= count($pc_long_day_names)) {
            $pc_array_pos = 0;
        }
        $header_width = 100/7;
        $daynames_row .= '<th width="'.$header_width.'%">';
        $daynames_row .= $pc_long_day_names[$pc_array_pos];
        $daynames_row .= '</th>';
        $pc_array_pos++;
    }
    $output->Text($daynames_row);
    $output->Text('</tr>');
    //*******************************************************************
    //  END CALENDAR DAY NAMES ROW (7 columns)
    //*******************************************************************
    
    //*******************************************************************
    //  START CALENDAR DAY NAMES ROW (7 columns)
    //*******************************************************************
    $output->Text('<tr>');
    $week_displayed = 0;
    for($i=0; $i<7; $i++) {
        //*******************************************************************
        //  START CALENDAR DAY CONTENT CELL
        //*******************************************************************
        $output->Text('<td height="70" bgcolor="'.$bgcolor1.'" align="left" valign="top">');
            //*******************************************************************
            //  START TABLE DATE AND ADD BUTTON
            //*******************************************************************
            $output->Text('<table border="0" cellpadding="0" cellspacing="0" width="100%"><tr>');
                $highlight = date('m/d/Y',mktime(0,0,0,$week_first_day_month,($week_first_day_date+$i),$week_first_day_year)) == date('m/d/Y') ? $dayhighlightcolor : $bgcolor1;
                $output->Text('<td bgcolor="'.$highlight.'" align="left" valign="top" nowrap>');
            
                    $output->SetOutputMode(_PNH_RETURNOUTPUT);
                        $this_date  = date('m/d/Y',mktime(0,0,0,$week_first_day_month,($week_first_day_date+$i),$week_first_day_year));
                        $day        = date('d',mktime(0,0,0,$week_first_day_month,($week_first_day_date+$i),$week_first_day_year));
                        $day_url    = pnModURL('PostCalendar','user','view',array('viewtype'=>'day','Date'=>$this_date));
                        $day_link   = $output->URL($day_url,'<b>'.$day.'</b>');
                    $output->SetOutputMode(_PNH_KEEPOUTPUT);
                    $output->Text($day_link);
                    if(!$week_displayed++) {
                        $output->SetOutputMode(_PNH_RETURNOUTPUT);
                            $week_date = date('m/d/Y',mktime(0,0,0,$week_first_day_month,$week_first_day_date,$week_first_day_year));
                            $week_url = pnModURL('PostCalendar','user','view',array('viewtype'=>'week','Date'=>$week_date));
                            $week_link = $output->URL($week_url,_PC_WEEK.' '.$the_week);
                        $output->SetOutputMode(_PNH_KEEPOUTPUT);
                        $output->Text(' (');
                        $output->Text($week_link);
                        $output->Text(')');
                    }
                $output->Text('</td>');
                
                $output->Text('<td bgcolor="'.$highlight.'" align="right" valign="top">');
                    $submit_url = pnModURL('PostCalendar','user','submit',array('Date'=>$this_date));
                    $img_src = '<img src="modules/'.$modinfo['directory'].'/pnimages/new.gif" border="0">';
                        
                    if($useinternationaldates) {
                        $popup_date = date('d/m/Y',mktime(0,0,0,$week_first_day_month,($week_first_day_date+$i),$week_first_day_year));
                    } else {
                        $popup_date = date('m/d/Y',mktime(0,0,0,$week_first_day_month,($week_first_day_date+$i),$week_first_day_year));
                    }
                    
                    if($usepopups) {
                        if($usepopups) {
                            if($i < 1) {
                                $align = 'RIGHT';
                            } elseif ($i < 5) {
                                $align = 'CENTER';
                            } else {
                                $align = 'LEFT';
                            }   
                            $popuptext = "onmouseover=\"return overlib('".addslashes(_PC_ADD_EVENT)." ".addslashes($popup_date)."',$align);\" onmouseout=\"return nd();\"";
                        } else {
                            $popuptext = '';
                        }    
                    }   
                    $output->Text('<a href="'.$submit_url.'" '.$popuptext.'>'.$img_src.'</a>');
                $output->Text('</td>');
            //*******************************************************************
            //  END TABLE DATE AND ADD BUTTON
            //*******************************************************************
            $output->Text('</tr></table>');
            
            //*******************************************************************
            //  START TABLE EVENTS
            //*******************************************************************
            $output->Text('<table border="0" cellpadding="0" cellspacing="0" width="100%">');
            for($e=0; $e<count($events); $e++) {
                // start the tests
                list($this_month,$this_day,$this_year) = explode('/',$this_date);
                $compare_to_date = $this_year.'-'.$this_month.'-'.$this_day;
                      
                switch ($events[$e]['recurrtype']) {
                    
                    case _EVENT_NONE :
                    // display an event on a certain day
                    if($events[$e]['eventDate'] <= $compare_to_date && $events[$e]['endDate'] >= $compare_to_date) {
                        $output->Text('<tr><td align="left" valign="top">');
                            $output->Text(pnModAPIFunc('PostCalendar',
                                                       'user',
                                                       'createEventLink',
                                                       array('event'=>$events[$e],
                                                             'dayofweek'=>$i+1)));
                        $output->Text('</td></tr>');
                    }
                    break;
                    
                    case _EVENT_DAILY :
                        // display an event on a certain day
                        if($events[$e]['eventDate'] <= $compare_to_date && $events[$e]['endDate'] >= $compare_to_date) {
                            $output->Text('<tr><td align="left" valign="top">');
                                $output->Text(pnModAPIFunc('PostCalendar',
                                                           'user',
                                                           'createEventLink',
                                                           array('event'=>$events[$e],
                                                                 'dayofweek'=>$i+1)));
                            $output->Text('</td></tr>');
                        }
                        break;
                
                    case _EVENT_WEEKLY :
                        // display an event weekly on a certain day
                        if($events[$e]['eventDate'] <= $compare_to_date && $events[$e]['endDate'] >= $compare_to_date) {
                            list($event_year,$event_month,$event_day) = explode('-',$events[$e]['eventDate']);
                        
                            $current_week_day   = date('w',mktime(0,0,0,$this_month,$this_day,$this_year));
                            $event_week_day     = date('w',mktime(0,0,0,$event_month,$event_day,$event_year)); 
                        
                            if($current_week_day === $event_week_day) {
                                $output->Text('<tr><td align="left" valign="top">');
                                    $output->Text(pnModAPIFunc('PostCalendar',
                                                               'user',
                                                               'createEventLink',
                                                               array('event'=>$events[$e],
                                                                     'dayofweek'=>$i+1)));
                                $output->Text('</td></tr>');
                            }
                        }
                        break;
                
                    case _EVENT_MONTHLY :
                        // display an event once a month on a certain day
                        if($events[$e]['eventDate'] <= $compare_to_date && $events[$e]['endDate'] >= $compare_to_date) {
                            list($event_year,$event_month,$event_day) = explode('-',$events[$e]['eventDate']);
                            
                            /**
                             *  Display event on same WEEK DAY each Month
                             *  This will cause a monthly event to always show on the same day of the month
                             *  If an event is started on the 1st Monday, it will always display on the 1st Monday
                             *  of each month for it's duration.
                             */
                            if($events[$e]['recurrfreq'] == _RECUR_SAME_DAY) {
                                $current_day_of_week = date('w',mktime(0,0,0,$this_month,$this_day,$this_year));
                                $event_day_of_week   = date('w',mktime(0,0,0,$event_month,$event_day,$event_year));
                             
                                $event_day_occurance=0;
                                for($d=1; $d<=$event_day; $d++) {
                                    $current_day = date('w',mktime(0,0,0,$event_month,$d,$event_year));
                                    if($current_day === $event_day_of_week) {
                                        $event_day_occurance++;
                                    }
                                }
                            
                                $curr_day = date('d',mktime(0,0,0,$this_month,$this_day,$this_year));
                                $current_day_occurance=0;
                                for($d=1; $d<=$curr_day; $d++) {
                                    $current_day = date('w',mktime(0,0,0,$this_month,$d,$this_year));
                                    if($current_day === $current_day_of_week) {
                                        $current_day_occurance++;
                                    }
                                }
                            
                                if($current_day_occurance === $event_day_occurance  && $current_day_of_week === $event_day_of_week) {
                                    $output->Text('<tr><td align="left" valign="top">');
                                    $output->Text(pnModAPIFunc('PostCalendar',
                                                               'user',
                                                               'createEventLink',
                                                               array('event'=>$events[$e],
                                                                     'dayofweek'=>$i+1)));
                                    $output->Text('</td></tr>');
                                }
                            }
                            
                            /**
                             *  Display event on same DATE each Month
                             *  This will cause a monthly event to always show on the same date of the month
                             *  If an event is started on the 25th of the Month it will always display
                             *  on the 25th of each month for its duration
                             *  (this is not yet implemented as it needs DB changes
                             */
                            if($events[$e]['recurrfreq'] == _RECUR_SAME_DATE) {
                                if($this_day === $event_day) {
                                    $output->Text('<tr><td align="left" valign="top">');
                                    $output->Text(pnModAPIFunc('PostCalendar',
                                                               'user',
                                                               'createEventLink',
                                                               array('event'=>$events[$e],
                                                                     'dayofweek'=>$i+1)));
                                    $output->Text('</td></tr>');
                                }    
                            }
                            
                        }
                        break;
                    case _EVENT_YEARLY :
                    // display an event once a year on a certain day
                    if($events[$e]['eventDate'] <= $compare_to_date && $events[$e]['endDate'] >= $compare_to_date) {
                        list($event_year,$event_month,$event_day) = explode('-',$events[$e]['eventDate']);    
                        
                        /**
                         *  Display event on same WEEK DAY each Month
                         *  This will cause a monthly event to always show on the same day of the month
                         *  If an event is started on the 1st Monday, it will always display on the 1st Monday
                         *  of each month for it's duration.
                         */
                        if($events[$e]['recurrfreq'] == _RECUR_SAME_DAY) {
                            $current_day_of_week = date('w',mktime(0,0,0,$this_month,$this_day,$this_year));
                            $event_day_of_week   = date('w',mktime(0,0,0,$event_month,$event_day,$event_year));
                         
                            $event_day_occurance=0;
                            for($d=1; $d<=$event_day; $d++) {
                                $current_day = date('w',mktime(0,0,0,$event_month,$d,$event_year));
                                if($current_day === $event_day_of_week) {
                                    $event_day_occurance++;
                                }
                            }
                            
                            $curr_day = date('d',mktime(0,0,0,$this_month,$this_day,$this_year));
                            $current_day_occurance=0;
                            for($d=1; $d<=$curr_day; $d++) {
                                $current_day = date('w',mktime(0,0,0,$this_month,$d,$this_year));
                                if($current_day === $current_day_of_week) {
                                    $current_day_occurance++;
                                }
                            }
                            
                            if(   $current_day_occurance === $event_day_occurance  
                               && $current_day_of_week === $event_day_of_week
                               && $this_month === $event_month) {
                               
                                $output->Text('<tr><td align="left" valign="top">');
                                $output->Text(pnModAPIFunc('PostCalendar',
                                                           'user',
                                                           'createEventLink',
                                                           array('event'=>$events[$e],
                                                                 'dayofweek'=>$day_of_week)));
                                $output->Text('</td></tr>');
                            }
                        }
                        /**
                         *  Display event on same DATE each Month
                         *  This will cause a monthly event to always show on the same date of the month
                         *  If an event is started on the 25th of the Month it will always display
                         *  on the 25th of each month for its duration
                         *  (this is not yet implemented as it needs DB changes
                         */
                        if($events[$e]['recurrfreq'] == _RECUR_SAME_DATE) {
                            if(   $this_day === $event_day 
                               && $this_month === $event_month) {
                               
                                $output->Text('<tr><td align="left" valign="top">');
                                $output->Text(pnModAPIFunc('PostCalendar',
                                                           'user',
                                                           'createEventLink',
                                                           array('event'=>$events[$e],
                                                                 'dayofweek'=>$day_of_week)));
                                $output->Text('</td></tr>');
                            }    
                        }
                        
                    }
                    break;
                    
                    default:
                        break;
                }
            
            }
            $output->Text('</table>');
            //*******************************************************************
            //  END TABLE EVENTS
            //*******************************************************************
        
        $output->Text('</td>');
        //*******************************************************************
        //  END CALENDAR DAY CONTENT CELL
        //*******************************************************************
    }
    $output->Text('</tr>');
    //*******************************************************************
    //  END CALENDAR DAY NAMES ROW (7 columns)
    //*******************************************************************
    
    $output->Text('</table>');
    $output->Text('</td></tr></table>');
    //*******************************************************************
    //  END CALENDAR TABLE
    //*******************************************************************
    
    return $output->GetOutput();
}

/**
 *  PostCalendar_userapi_buildMonth
 *
 *  Builds the month display
 *  @param string $Date mm/dd/yyyy format (we should use timestamps)
 *  @return string html output generated
 *  @access public
 */
function PostCalendar_userapi_buildMonth($args)
{   
    // get the theme globals :: is there a better way to do this?
    global $bgcolor1, $bgcolor2, $bgcolor3, $bgcolor4, $bgcolor5;
    global $textcolor1, $textcolor2;
    
    extract($args);
    
    // if we've not been given a date, get the current one
    if(!isset($Date)) {
        $Date = date('m/d/Y');
    }
    
    // lets break the date down into seperate pieces
    list($the_month,$the_day,$the_year) = explode('/',$Date);
    // set up the next and previous months to move to
    $prev_month = date('m/d/Y',mktime(0,0,0,$the_month-1,1,$the_year));
    $next_month = date('m/d/Y',mktime(0,0,0,$the_month+1,1,$the_year));
    $last_day   = date('t',mktime(0,0,0,$the_month,1,$the_year));
    $first_day  = date('w',mktime(0,0,0,$the_month,1,$the_year));
    
    // get DB information
    pnModDBInfoLoad('PostCalendar');
    list($dbconn) = pnDBGetConn();
    $pntable = pnDBGetTables();
    
    // link to the events tables
    $events_table = $pntable['postcalendar_events'];
    $events_column = &$pntable['postcalendar_events_column'];
    
    // link to the topics table
    $topics_table = $pntable['topics'];
    $topics_column = &$pntable['topics_column'];
    
    // let's load the User API so we can use it
    if(!pnModAPILoad('PostCalendar','user')) {
        die('Could not load PostCalendar user API');
    }
    
    // grab the modules information
    $modinfo = pnModGetInfo(pnModGetIDFromName('PostCalendar'));
    
    // set some variables
    $usepopups              = pnModGetVar('PostCalendar','usepopups');
    $useinternationaldates  = pnModGetVar('PostCalendar','useinternationaldates');
    $eventsopeninnewwindow  = pnModGetVar('PostCalendar','eventsopeninnewwindow');
    $dayhighlightcolor      = pnModGetVar('PostCalendar','dayhighlightcolor');
    $firstdayofweek         = pnModGetVar('PostCalendar','firstdayofweek');       
    
    // start the output container
    $output = new pnHTML();
    $output->SetInputMode(_PNH_VERBATIMINPUT);
    $output->SetOutputMode(_PNH_KEEPOUTPUT);
    
    // load the DHTML JavaScript code and insert it into the page
    if ($usepopups) {
        $output->Text(pnModAPIFunc('PostCalendar','user','loadPopups'));
    }

    // insert the js popup code into the page
    if($eventsopeninnewwindow) {
        $output->Text(pnModAPIFunc('PostCalendar','user','jsPopup'));
    }
    
    
    //*******************************************************************
    //  Here we build the month header and navigation
    //  << Prev     MONTH YEAR      Next >>
    //*******************************************************************
    $output->Text('<table border="0" cellpadding="1" cellspacing="0" width="100%"><tr><td bgcolor="'.$bgcolor2.'">');
    $output->Text('<table border="0" cellpadding="5" cellspacing="0" width="100%"><tr><td bgcolor="'.$bgcolor1.'">');
        $output->TableStart();
        $output->SetOutputMode(_PNH_RETURNOUTPUT);
        
        $pc_prev = pnModURL('PostCalendar','user','view',array('viewtype'=>'month','Date'=>$prev_month));
        $pc_next = pnModURL('PostCalendar','user','view',array('viewtype'=>'month','Date'=>$next_month));
        $pc_prev_url = $output->URL($pc_prev,'&lt;&lt; '._PC_PREV_MONTH);
        $pc_next_url = $output->URL($pc_next,_PC_NEXT_MONTH.' &gt;&gt;');
        $pc_month_name = pnModAPIFunc('PostCalendar',
                                      'user',
                                      'getmonthname',
                                      array('Date'=>mktime(0,0,0,$the_month,$the_day,$the_year)));
        $month_link_url = pnModURL('PostCalendar',
                                   'user',
                                   'view',
                                   array('viewtype'=>'month','Date'=>date('m/d/Y',mktime(0,0,0,$the_month,$the_day,$the_year))));
        $month_link_text = $pc_month_name.' '.$the_year;
        $pc_link = $output->URL($month_link_url,$month_link_text);
            $row = array();
            $row[0]['content']  = $pc_prev_url;
            $row[0]['align']    = 'left';
            $row[0]['valign']   = 'middle';
            
            $row[1]['content']  = $pc_link;
            $row[1]['align']    = 'center';
            $row[1]['valign']   = 'middle';
               
            $row[2]['content']  = $pc_next_url;
            $row[2]['align']    = 'right';
            $row[2]['valign']   = 'middle';
                
        $output->SetOutputMode(_PNH_KEEPOUTPUT);
        $output->TableAddRow($row);
        $output->TableEnd();
    $output->Text('</td></tr></table>');
    $output->Text('</td></tr></table>');
    
    //*******************************************************************
    //  Here we get the events for the current month view
    //*******************************************************************
    
    $day_of_week = 1;
    $pc_long_day_names = array(_CALSUNDAY,
                               _CALMONDAY,
                               _CALTUESDAY,
                               _CALWEDNESDAY,
                               _CALTHURSDAY,
                               _CALFRIDAY,
                               _CALSATURDAY);
                                
    switch ($firstdayofweek) 
    {
        case _IS_SUNDAY:
            // sunday is the first day of the week
            $pc_array_pos = 0;
            $first_day  = date('w',mktime(0,0,0,$the_month,1,$the_year));
            break;
        case _IS_MONDAY:
            // monday is the first day of the week
            $pc_array_pos = 1;
            //$Day_of_First_Week = Date("w",$First_Day_of_Month_Date) -1;
            $first_day  = date('w',mktime(0,0,0,$the_month,1-1,$the_year));
            break;
        case _IS_SATURDAY:
            // saturday is the first day of the week
            $pc_array_pos = 6;
            $first_day  = date('w',mktime(0,0,0,$the_month,1+1,$the_year));
            break;
        default:
            // sunday is the first day of the week
            $pc_array_pos = 0;
            $first_day  = date('w',mktime(0,0,0,$the_month,1,$the_year));
            break;
    }
    
    $sql =  "SELECT $events_column[eid], 
                    $events_column[title], 
                    $events_column[hometext], 
                    $events_column[eventDate], 
                    $events_column[endDate], 
                    $events_column[startTime], 
                    $events_column[endTime], 
                    $events_column[barcolor], 
                    $events_column[recurrtype], 
                    $events_column[recurrfreq],
                    $events_column[topic],
                    $events_column[alldayevent] 
             
             FROM   $events_table
             
             WHERE  $events_column[eventstatus] = 1
             
             ORDER BY $events_column[startTime],$events_column[eventDate] ASC";

    $result = $dbconn->Execute($sql);
    
    // put the information into an array for easy access
    $events = array();
    for($i=0; !$result->EOF; $result->MoveNext()) {
        list($eid,$title,$hometext,$eventDate,$endDate,$startTime,$endTime,$barcolor,$recurrtype,$recurrfreq,$topic,$alldayevent) = $result->fields;
        $events[$i]['eid']          = $eid;
        $events[$i]['title']        = $title;
        $events[$i]['hometext']     = $hometext;
        $events[$i]['eventDate']    = $eventDate;
        $events[$i]['endDate']      = $endDate;
        $events[$i]['startTime']    = $startTime;
        $events[$i]['endTime']      = $endTime;
        $events[$i]['barcolor']     = $barcolor;
        $events[$i]['recurrtype']   = $recurrtype;
        $events[$i]['recurrfreq']   = $recurrfreq;
        $events[$i]['topic']        = $topic;
        $events[$i]['alldayevent']  = $alldayevent;
        $i++;
    }
    
    
    $monthtableborder       = pnModGetVar('PostCalendar','monthtableborder');
    $monthtablecellspacing  = pnModGetVar('PostCalendar','monthtablecellspacing');
    $monthtablecellpadding  = pnModGetVar('PostCalendar','monthtablecellpadding');
    //*******************************************************************
    //  START CALENDAR TABLE
    //*******************************************************************
    $output->Text('<table border="0" cellpadding="1" cellspacing="0" width="100%"><tr><td bgcolor="'.$bgcolor2.'">');
    $output->Text('<table border="'.$monthtableborder.'" cellpadding="'.$monthtablecellspacing.'" cellspacing="'.$monthtablecellpadding.'" width="100%"><tr>');
    
    // build the long day name header row
    $daynames_row = '';
    for($i=0; $i < count($pc_long_day_names); $i++)
    {
        if($pc_array_pos >= count($pc_long_day_names)) {
            $pc_array_pos = 0;
        }
        $header_width = 100/7;
        $daynames_row .= '<th width="'.$header_width.'%">';
        $daynames_row .= $pc_long_day_names[$pc_array_pos];
        $daynames_row .= '</th>';
        $pc_array_pos++;
    }
    $output->Text($daynames_row);
    
    //*******************************************************************
    //  Previous Month Grayed Out Days
    //*******************************************************************
    $day_of_week = 1;
    while ($day_of_week <= $first_day) {
        if ($day_of_week == 1) {
            $output->Text('<tr>');
        }
        $past_day = date('d',mktime(0,0,0,$the_month,$day_of_week-$first_day,$the_year));
        $output->Text('<td height="70" bgcolor="'.$bgcolor2.'" align="left" valign="top">');
            $output->SetOutputMode(_PNH_RETURNOUTPUT);
                $this_date = date('m/d/Y',mktime(0,0,0,$the_month,$day_of_week-$first_day,$the_year));
                $day_url = pnModURL('PostCalendar','user','view',array('viewtype'=>'day','Date'=>$this_date));
                $day_link = $output->URL($day_url,$past_day);
            $output->SetOutputMode(_PNH_KEEPOUTPUT);
            $output->Text($day_link);
            if($day_of_week === 1) {
                $week = date('Y-m-d',mktime(0,0,0,$the_month,$day_of_week-$first_day,$the_year));
                $week_result = $dbconn->Execute("SELECT WEEK('$week')");
                list($week) = $week_result->fields;
                
                if ($pc_array_pos == 6) {
                    $week++;
                }
                if($week > 52) {
                    $week = 1;
                }
                
                $output->SetOutputMode(_PNH_RETURNOUTPUT);
                    $this_date = date('m/d/Y',mktime(0,0,0,$the_month,$day_of_week-$first_day,$the_year));
                    $week_url = pnModURL('PostCalendar','user','view',array('viewtype'=>'week','Date'=>$this_date));
                    $week_link = $output->URL($week_url,_PC_WEEK.' '.$week);
                $output->SetOutputMode(_PNH_KEEPOUTPUT);
                $output->Text(' (');
                $output->Text($week_link);
                $output->Text(')');
            }
        $output->Text('</td>');
        $day_of_week++;
    }
    
    //*******************************************************************
    //  Main Calendar Display Area
    //*******************************************************************
    $day = 1;
    while ($day <= $last_day) {
        if ($day_of_week == 1) {
            $output->Text('<tr>');
        }
        
        $highlight = date('m/d/Y',mktime(0,0,0,$the_month,$day,$the_year)) == date('m/d/Y') ? $dayhighlightcolor : $bgcolor1;
        $output->Text('<td height="70" bgcolor="'.$bgcolor1.'" align="left" valign="top">');
            $output->Text('<table border="0" cellpadding="0" cellspacing="0" width="100%"><tr>');
                $output->Text('<td bgcolor="'.$highlight.'" align="left" valign="top" nowrap>');
            
                $output->SetOutputMode(_PNH_RETURNOUTPUT);
                    $this_date  = date('m/d/Y',mktime(0,0,0,$the_month,$day,$the_year));
                    $today      = date('d',mktime(0,0,0,$the_month,$day,$the_year));
                    $day_url    = pnModURL('PostCalendar','user','view',array('viewtype'=>'day','Date'=>$this_date));
                    $day_link   = $output->URL($day_url,'<b>'.$today.'</b>');
                $output->SetOutputMode(_PNH_KEEPOUTPUT);
                $output->Text($day_link);
                if($day_of_week === 1) {
                    $week = date('Y-m-d',mktime(0,0,0,$the_month,$day,$the_year));
                    $week_result = $dbconn->Execute("SELECT WEEK('$week')");
                    list($week) = $week_result->fields;
                    if ($firstdayofweek == _IS_SATURDAY) {
                        $week++;
                    }
                    if($week > 52) {
                        $week = 1;
                    }
                
                    $output->SetOutputMode(_PNH_RETURNOUTPUT);
                        $this_date = date('m/d/Y',mktime(0,0,0,$the_month,$day,$the_year));
                        $week_url = pnModURL('PostCalendar','user','view',array('viewtype'=>'week','Date'=>$this_date));
                        $week_link = $output->URL($week_url,_PC_WEEK.' '.$week);
                    $output->SetOutputMode(_PNH_KEEPOUTPUT);
                    $output->Text(' (');
                    $output->Text($week_link);
                    $output->Text(')');
                }
                $output->Text('</td>');
                $output->Text('<td bgcolor="'.$highlight.'" align="right" valign="top">');
                        
                        $this_date = date('m/d/Y',mktime(0,0,0,$the_month,$day,$the_year));
                        $submit_url = pnModURL('PostCalendar','user','submit',array('Date'=>$this_date));
                        $img_src = '<img src="modules/'.$modinfo['directory'].'/pnimages/new.gif" border="0">';
                        
                        if($useinternationaldates) {
                            $popup_date = date('d/m/Y',mktime(0,0,0,$the_month,$day,$the_year));
                        } else {
                            $popup_date = date('m/d/Y',mktime(0,0,0,$the_month,$day,$the_year));
                        }
                        
                        if($usepopups) {
                            if($day_of_week < 3) {
                                $align = 'RIGHT';
                            } elseif ($day_of_week < 6) {
                               $align = 'CENTER';
                            } else {
                               $align = 'LEFT';
                            }   
                            $popuptext = "onmouseover=\"return overlib('".addslashes(_PC_ADD_EVENT)." ".addslashes($popup_date)."',$align);\" onmouseout=\"return nd();\"";
                        } else {
                            $popuptext = '';
                        }    
                    $output->Text('<a href="'.$submit_url.'" '.$popuptext.'>'.$img_src.'</a>');
                $output->Text('</td>');
            $output->Text('</tr></table>');

        // *** Here's where we fill in the content for each day *** //
        $output->Text('<table border="0" cellpadding="0" cellspacing="0" width="100%">');
        for($i=0; $i<count($events); $i++) {
            // start the tests
            list($this_month,$this_day,$this_year) = explode('/',$this_date);
            $compare_to_date = $this_year.'-'.$this_month.'-'.$this_day;
                      
            switch ($events[$i]['recurrtype']) {
                
                
                case _EVENT_NONE :
                    // display an event on a certain day
                    if($events[$i]['eventDate'] <= $compare_to_date && $events[$i]['endDate'] >= $compare_to_date) {
                        $output->Text('<tr><td align="left" valign="top">');
                            $output->Text(pnModAPIFunc('PostCalendar',
                                                       'user',
                                                       'createEventLink',
                                                       array('event'=>$events[$i],
                                                             'dayofweek'=>$day_of_week)));
                        $output->Text('</td></tr>');
                    }
                    break;
                    
                case _EVENT_DAILY :
                    // display an event on a certain day
                    if($events[$i]['eventDate'] <= $compare_to_date && $events[$i]['endDate'] >= $compare_to_date) {
                        $output->Text('<tr><td align="left" valign="top">');
                            $output->Text(pnModAPIFunc('PostCalendar',
                                                       'user',
                                                       'createEventLink',
                                                       array('event'=>$events[$i],
                                                             'dayofweek'=>$day_of_week)));
                        $output->Text('</td></tr>');
                    }
                    break;
                
                case _EVENT_WEEKLY :
                    // display an event weekly on a certain day
                    if($events[$i]['eventDate'] <= $compare_to_date && $events[$i]['endDate'] >= $compare_to_date) {
                        list($event_year,$event_month,$event_day) = explode('-',$events[$i]['eventDate']);
                        
                        $current_week_day   = date('w',mktime(0,0,0,$this_month,$this_day,$this_year));
                        $event_week_day     = date('w',mktime(0,0,0,$event_month,$event_day,$event_year)); 
                        
                        if($current_week_day === $event_week_day) {
                            $output->Text('<tr><td align="left" valign="top">');
                                $output->Text(pnModAPIFunc('PostCalendar',
                                                           'user',
                                                           'createEventLink',
                                                           array('event'=>$events[$i],
                                                                 'dayofweek'=>$day_of_week)));
                            $output->Text('</td></tr>');
                        }
                    }
                    break;
                
                case _EVENT_MONTHLY :
                    // display an event once a month on a certain day
                    if($events[$i]['eventDate'] <= $compare_to_date && $events[$i]['endDate'] >= $compare_to_date) {
                        list($event_year,$event_month,$event_day) = explode('-',$events[$i]['eventDate']);
                          
                        /**
                         *  Display event on same WEEK DAY each Month
                         *  This will cause a monthly event to always show on the same day of the month
                         *  If an event is started on the 1st Monday, it will always display on the 1st Monday
                         *  of each month for it's duration.
                         */
                        if($events[$i]['recurrfreq'] == _RECUR_SAME_DAY) {
                            $current_day_of_week = date('w',mktime(0,0,0,$this_month,$this_day,$this_year));
                            $event_day_of_week   = date('w',mktime(0,0,0,$event_month,$event_day,$event_year));
                         
                            $event_day_occurance=0;
                            for($d=1; $d<=$event_day; $d++) {
                                $current_day = date('w',mktime(0,0,0,$event_month,$d,$event_year));
                                if($current_day === $event_day_of_week) {
                                    $event_day_occurance++;
                                }
                            }
                            
                            $curr_day = date('d',mktime(0,0,0,$this_month,$this_day,$this_year));
                            $current_day_occurance=0;
                            for($d=1; $d<=$curr_day; $d++) {
                                $current_day = date('w',mktime(0,0,0,$this_month,$d,$this_year));
                                if($current_day === $current_day_of_week) {
                                    $current_day_occurance++;
                                }
                            }
                            
                            if($current_day_occurance === $event_day_occurance  && $current_day_of_week === $event_day_of_week) {
                                $output->Text('<tr><td align="left" valign="top">');
                                $output->Text(pnModAPIFunc('PostCalendar',
                                                           'user',
                                                           'createEventLink',
                                                           array('event'=>$events[$i],
                                                                 'dayofweek'=>$day_of_week)));
                                $output->Text('</td></tr>');
                            }
                        }
                            
                        /**
                         *  Display event on same DATE each Month
                         *  This will cause a monthly event to always show on the same date of the month
                         *  If an event is started on the 25th of the Month it will always display
                         *  on the 25th of each month for its duration
                         *  (this is not yet implemented as it needs DB changes
                         */
                        if($events[$i]['recurrfreq'] == _RECUR_SAME_DATE) {
                            if($this_day === $event_day) {
                                $output->Text('<tr><td align="left" valign="top">');
                                $output->Text(pnModAPIFunc('PostCalendar',
                                                           'user',
                                                           'createEventLink',
                                                           array('event'=>$events[$i],
                                                                 'dayofweek'=>$day_of_week)));
                                $output->Text('</td></tr>');
                            }    
                        }
                            
                    }
                    break;    
                     
                case _EVENT_YEARLY :
                    // display an event once a year on a certain day
                    if($events[$i]['eventDate'] <= $compare_to_date && $events[$i]['endDate'] >= $compare_to_date) {
                        list($event_year,$event_month,$event_day) = explode('-',$events[$i]['eventDate']);    
                        
                        /**
                         *  Display event on same WEEK DAY each Month
                         *  This will cause a monthly event to always show on the same day of the month
                         *  If an event is started on the 1st Monday, it will always display on the 1st Monday
                         *  of each month for it's duration.
                         */
                        if($events[$i]['recurrfreq'] == _RECUR_SAME_DAY) {
                            $current_day_of_week = date('w',mktime(0,0,0,$this_month,$this_day,$this_year));
                            $event_day_of_week   = date('w',mktime(0,0,0,$event_month,$event_day,$event_year));
                         
                            $event_day_occurance=0;
                            for($d=1; $d<=$event_day; $d++) {
                                $current_day = date('w',mktime(0,0,0,$event_month,$d,$event_year));
                                if($current_day === $event_day_of_week) {
                                    $event_day_occurance++;
                                }
                            }
                            
                            $curr_day = date('d',mktime(0,0,0,$this_month,$this_day,$this_year));
                            $current_day_occurance=0;
                            for($d=1; $d<=$curr_day; $d++) {
                                $current_day = date('w',mktime(0,0,0,$this_month,$d,$this_year));
                                if($current_day === $current_day_of_week) {
                                    $current_day_occurance++;
                                }
                            }
                            
                            if(   $current_day_occurance === $event_day_occurance  
                               && $current_day_of_week === $event_day_of_week
                               && $this_month === $event_month) {
                               
                                $output->Text('<tr><td align="left" valign="top">');
                                $output->Text(pnModAPIFunc('PostCalendar',
                                                           'user',
                                                           'createEventLink',
                                                           array('event'=>$events[$i],
                                                                 'dayofweek'=>$day_of_week)));
                                $output->Text('</td></tr>');
                            }
                        }
                        /**
                         *  Display event on same DATE each Month
                         *  This will cause a monthly event to always show on the same date of the month
                         *  If an event is started on the 25th of the Month it will always display
                         *  on the 25th of each month for its duration
                         *  (this is not yet implemented as it needs DB changes
                         */
                        if($events[$i]['recurrfreq'] == _RECUR_SAME_DATE) {
                            if(   $this_day === $event_day 
                               && $this_month === $event_month) {
                               
                                $output->Text('<tr><td align="left" valign="top">');
                                $output->Text(pnModAPIFunc('PostCalendar',
                                                           'user',
                                                           'createEventLink',
                                                           array('event'=>$events[$i],
                                                                 'dayofweek'=>$day_of_week)));
                                $output->Text('</td></tr>');
                            }    
                        }
                        
                    }
                    break;
                    
                default:
                    break;
            }
            
        }
        $output->Text('</table>');
        // *** end content *** //
        $output->Text('</td>');
        $day++;
        $day_of_week++;
        if($day_of_week > 7) {
            $day_of_week = 1;
            $output->Text('</tr>');
        }
    }
    
    //*******************************************************************
    //  Next Month Grayed Out Days
    //*******************************************************************
    $day = 1;
    while (($day_of_week <= 7) && ($day_of_week != 1)) {
        $output->Text('<td bgcolor="'.$bgcolor2.'" align="left" valign="top">');
        //$day = $day < 10 ? '0'.$day : $day;
        $output->SetOutputMode(_PNH_RETURNOUTPUT);
            $this_date = date('m/d/Y',mktime(0,0,0,$the_month+1,$day,$the_year));
            $today = date('d',mktime(0,0,0,$the_month+1,$day,$the_year));
            $day_url = pnModURL('PostCalendar','user','view',array('viewtype'=>'day','Date'=>$this_date));
            $day_link = $output->URL($day_url,$today);
        $output->SetOutputMode(_PNH_KEEPOUTPUT);
        $output->Text($day_link);
        //$output->Text($day);
        if($day_of_week === 1) {
                $week = date('W',mktime(0,0,0,$the_month+1,$day,$the_year));
                $output->SetOutputMode(_PNH_RETURNOUTPUT);
                    $this_date = date('m/d/Y',mktime(0,0,0,$the_month+1,$day,$the_year));
                    $week_url = pnModURL('PostCalendar','user','view',array('viewtype'=>'week','Date'=>$this_date));
                    $week_link = $output->URL($week_url,_PC_WEEK.' '.$week);
                $output->SetOutputMode(_PNH_KEEPOUTPUT);
                $output->Text(' [');
                $output->Text($week_link);
                $output->Text(']');
            }
        $output->Text('</td>');
        $day_of_week += 1;
        $day += 1;
    }
    
    //*******************************************************************
    //  END CALENDAR TABLE
    //*******************************************************************
    $output->Text('</tr></table>');
    $output->Text('</td></tr></table>');
      
    return $output->GetOutput();    
}

function PostCalendar_userapi_buildYear($args)
{
    // start the output container
    $output = new pnHTML();
    $output->SetInputMode(_PNH_VERBATIMINPUT);
    $output->SetOutputMode(_PNH_KEEPOUTPUT);
    
    // get the theme globals :: is there a better way to do this?
    global $bgcolor1, $bgcolor2, $bgcolor3, $bgcolor4, $bgcolor5;
    global $textcolor1, $textcolor2;
    
    extract($args);
    
    // if we've not been given a date, get the current one
    if(!isset($Date)) {
        $Date = date('m/d/Y');
    }
    
    // get DB information
    pnModDBInfoLoad('PostCalendar');
    list($dbconn) = pnDBGetConn();
    $pntable = pnDBGetTables();
    
    // link to the events tables
    $events_table = $pntable['postcalendar_events'];
    $events_column = &$pntable['postcalendar_events_column'];
    
    // link to the topics table
    $topics_table = $pntable['topics'];
    $topics_column = &$pntable['topics_column'];
    
    // let's load the User API so we can use it
    if(!pnModAPILoad('PostCalendar','user')) {
        die('Could not load PostCalendar user API');
    }
    
     // grab the modules information
    $modinfo = pnModGetInfo(pnModGetIDFromName('PostCalendar'));
    
    // block specific vars
    $usepopups              = pnModGetVar('PostCalendar','usepopups');
    $useinternationaldates  = pnModGetVar('PostCalendar','useinternationaldates');
    $eventsopeninnewwindow  = pnModGetVar('PostCalendar','eventsopeninnewwindow');
    $dayhighlightcolor      = pnModGetVar('PostCalendar','dayhighlightcolor');
    $firstdayofweek         = pnModGetVar('PostCalendar','firstdayofweek'); 
    $displayballs           = pnModGetVar('PostCalendar','displayballs'); 
    $yeartableborder        = pnModGetVar('PostCalendar','yeartableborder');
    $yeartablecellspacing   = pnModGetVar('PostCalendar','yeartablecellspacing');
    $yeartablecellpadding   = pnModGetVar('PostCalendar','yeartablecellpadding');     
    $showeventsinyear       = pnModGetVar('PostCalendar','showeventsinyear');
    $numcols                = pnModGetVar('PostCalendar','numcolsinyearview');
    
    // create some vars for later
    $submit_event_url = pnModURL('PostCalendar','user','submit');
    $search_event_url = pnModURL('PostCalendar','user','search');    

   
    // load the DHTML JavaScript code and insert it into the page
    if ($usepopups) {
        $output->Text(pnModAPIFunc('PostCalendar','user','loadPopups'));
    }

    // insert the js popup code into the page
    if($eventsopeninnewwindow) {
        $output->Text(pnModAPIFunc('PostCalendar','user','jsPopup'));
    }
       
    // Let's setup the info to build this sucka!
    list($the_month,$the_day,$the_year) = explode('/',$Date);
    
    $sql =  "SELECT DISTINCT $events_column[eid], 
                    $events_column[title], 
                    $events_column[hometext], 
                    $events_column[eventDate], 
                    $events_column[endDate], 
                    $events_column[startTime], 
                    $events_column[endTime], 
                    $events_column[barcolor], 
                    $events_column[recurrtype], 
                    $events_column[recurrfreq],
                    $events_column[topic] 
             
             FROM   $events_table
             
             WHERE  $events_column[eventstatus] = 1
             
             ORDER BY $events_column[startTime] ASC";
             
             //WHERE  ($events_column[eventDate] >= '$the_year-1-1' OR $events_column[endDate] <= '$the_year-12-31')
    
    $result = $dbconn->Execute($sql);
    
    // put the information into an array for easy access
    $events = array();
    for($i=0; !$result->EOF; $result->MoveNext()) {
        list($eid,$title,$hometext,$eventDate,$endDate,$startTime,$endTime,$barcolor,$recurrtype,$recurrfreq,$topic) = $result->fields;
        $events[$i]['eid']          = $eid;
        $events[$i]['title']        = $title;
        $events[$i]['hometext']     = $hometext;
        $events[$i]['eventDate']    = $eventDate;
        $events[$i]['endDate']      = $endDate;
        $events[$i]['startTime']    = $startTime;
        $events[$i]['endTime']      = $endTime;
        $events[$i]['barcolor']     = $barcolor;
        $events[$i]['recurrtype']   = $recurrtype;
        $events[$i]['recurrfreq']   = $recurrfreq;
        $events[$i]['topic']        = $topic;
        $i++;
    }
    
    $pc_short_day_names = array(_CALSUNDAYSHORT,
                               _CALMONDAYSHORT,
                               _CALTUESDAYSHORT,
                               _CALWEDNESDAYSHORT,
                               _CALTHURSDAYSHORT,
                               _CALFRIDAYSHORT,
                               _CALSATURDAYSHORT);

    //$numcols = 4; //make this a config setting
    //year view build  
    $output->Text('<table align="center" border="'.$yeartableborder.'" cellpadding="'.$yeartablecellpadding.'" cellspacing="'.$yeartablecellspacing.'">');
    for($m=1; $m<=12; $m++) {
    if( $m % $numcols == 1 ) {
        $output->Text('<tr>');
    }
    $output->Text('<td align="center" valign="top" bgcolor="'.$bgcolor1.'">');

    $the_month = date('m',mktime(0,0,0,$m,1,$the_year));
    // set up the next and previous months to move to
    //$first_month    = date('m/d/Y',mktime(0,0,0,1,1,$the_year));
    //$last_month     = date('m/d/Y',mktime(0,0,0,12,1,$the_year));
    $prev_month     = date('m/d/Y',mktime(0,0,0,$m-1,1,$the_year));
    $next_month     = date('m/d/Y',mktime(0,0,0,$m+1,1,$the_year));
    $last_day       = date('t',mktime(0,0,0,$m,1,$the_year));
    $first_day      = date('w',mktime(0,0,0,$m,1,$the_year));
    
    //*******************************************************************
    //  Here we get the events for the current month view
    //*******************************************************************
    $day_of_week = 1;
                                   
    switch ($firstdayofweek) 
    {
        case _IS_SUNDAY:
            $pc_array_pos = 0;
            $first_day  = date('w',mktime(0,0,0,$m,1,$the_year));
            break;
        case _IS_MONDAY:
            $pc_array_pos = 1;
            $first_day  = date('w',mktime(0,0,0,$m,0,$the_year));
            break;
        case _IS_SATURDAY:
            $pc_array_pos = 6;
            $first_day  = date('w',mktime(0,0,0,$m,2,$the_year));
            break;
        default:
            $pc_array_pos = 0;
            $first_day  = date('w',mktime(0,0,0,$m,1,$the_year));
            break;
    }
    
    //*******************************************************************
    //  START month header and navigation
    //  <<     MONTH YEAR      >>
    //*******************************************************************
    $output->Text('<table border="0" cellpadding="0" cellspacing="1"><tr><td bgcolor="'.$bgcolor2.'">');
    $output->Text('<table border="0" cellpadding="1" cellspacing="1" width="100%"><tr><td colspan="8" bgcolor="'.$bgcolor1.'">');
        $output->TableStart();
        $output->SetOutputMode(_PNH_RETURNOUTPUT);
        
        //$pc_prev = pnModURL('PostCalendar','user','view',array('viewtype'=>'month','Date'=>$prev_month));
        //$pc_next = pnModURL('PostCalendar','user','view',array('viewtype'=>'month','Date'=>$next_month));
        //$pc_prev_url = $output->URL($pc_prev,'&lt;&lt;');
        //$pc_next_url = $output->URL($pc_next,'&gt;&gt;');
        $pc_month_name = pnModAPIFunc('PostCalendar',
                                      'user',
                                      'getmonthname',
                                      array('Date'=>mktime(0,0,0,$m,1,$the_year)));
        $month_link_url = pnModURL('PostCalendar',
                                   'user',
                                   'view',
                                   array('viewtype'=>'month','Date'=>date('m/d/Y',mktime(0,0,0,$m,1,$the_year))));
        $month_link_text = $pc_month_name.' '.$the_year;
        $pc_link = $output->URL($month_link_url,$month_link_text);
            $row = array();
            $row[0]['content']  = $pc_link;
            $row[0]['align']    = 'center';
            $row[0]['valign']   = 'middle';
               
        $output->SetOutputMode(_PNH_KEEPOUTPUT);
        $output->TableAddRow($row);
        $output->TableEnd();
    $output->Text('</td></tr>');
    //*******************************************************************
    //  END month header and navigation
    //  << Prev     MONTH YEAR      Next >>
    //*******************************************************************
    
    //*******************************************************************
    //  START CALENDAR TABLE
    //*******************************************************************
    // build the short day name header row
    $header_width = 100/8;
    $daynames_row = '';
    $output->Text('<td align="center" bgcolor="'.$bgcolor1.'"width="'.$header_width.'%">&nbsp;</td>');
    for($i=0; $i < count($pc_short_day_names); $i++)
    {
        if($pc_array_pos >= count($pc_short_day_names)) {
            $pc_array_pos = 0;
        }
        $daynames_row .= '<td align="center" bgcolor="'.$bgcolor1.'"width="'.$header_width.'%">';
        $daynames_row .= $pc_short_day_names[$pc_array_pos];
        $daynames_row .= '</td>';
        $pc_array_pos++;
    }
    $output->Text($daynames_row);
    //$output->Text('</tr>');
    
    //*******************************************************************
    //  Previous Month Grayed Out Days
    //*******************************************************************
    $day_of_week = 1;
    $week_displayed = false;
    while ($day_of_week <= $first_day) {
        if (!$week_displayed) {
            $output->Text('<tr><td valign="top">');
            $week = date('Y-m-d',mktime(0,0,0,$the_month,$day_of_week-$first_day,$the_year));
            $week_result = $dbconn->Execute("SELECT WEEK('$week')");
            list($week) = $week_result->fields;
                
            if ($firstdayofweek == _IS_SATURDAY) {
                $week++;
            }
            if($week > 52) {
                $week = 1;
            }
                
            $output->SetOutputMode(_PNH_RETURNOUTPUT);
                $this_date = date('m/d/Y',mktime(0,0,0,$the_month,$day_of_week-$first_day,$the_year));
                $week_url = pnModURL('PostCalendar','user','view',array('viewtype'=>'week','Date'=>$this_date));
                $week_link = $output->URL($week_url,'&gt;&gt;');
            $output->SetOutputMode(_PNH_KEEPOUTPUT);
            $output->Text($week_link);
            $output->Text('</td>');
            $week_displayed = true;
            continue;
        }
        $output->Text('<td bgcolor="'.$bgcolor2.'" align="center" valign="top">');
            $output->SetOutputMode(_PNH_RETURNOUTPUT);
                $past_day  = date('d',mktime(0,0,0,$the_month,$day_of_week-$first_day,$the_year));
                $this_date = date('m/d/Y',mktime(0,0,0,$the_month,$day_of_week-$first_day,$the_year));
                $day_url   = pnModURL('PostCalendar','user','view',array('viewtype'=>'day','Date'=>$this_date));
                $day_link  = $output->URL($day_url,$past_day);
            $output->SetOutputMode(_PNH_KEEPOUTPUT);
            $output->Text($day_link);
        $output->Text('</td>');
        $day_of_week++;
    }
    //*******************************************************************
    //  Main Calendar Display Area
    //*******************************************************************
    $day = 1;
    while ($day <= $last_day) {
        if (!$week_displayed) {
            $output->Text('<tr><td  valign="top" bgcolor="'.$bgcolor1.'">');
            $week = date('Y-m-d',mktime(0,0,0,$the_month,$day,$the_year));
            $week_result = $dbconn->Execute("SELECT WEEK('$week')");
            list($week) = $week_result->fields;
                
            if ($firstdayofweek == _IS_SATURDAY) {
                $week++;
            }
            if($week > 52) {
                $week = 1;
            }
            
            $output->SetOutputMode(_PNH_RETURNOUTPUT);
                $this_date = date('m/d/Y',mktime(0,0,0,$the_month,$day,$the_year));
                $week_url = pnModURL('PostCalendar','user','view',array('viewtype'=>'week','Date'=>$this_date));
                $week_link = $output->URL($week_url,'&gt;&gt;');
            $output->SetOutputMode(_PNH_KEEPOUTPUT);
            $output->Text($week_link);
            $output->Text('</td>');
            $week_displayed = true;
            continue;
        }
        $highlight = date('m/d/Y',mktime(0,0,0,$the_month,$day,$the_year)) == date('m/d/Y') ? $dayhighlightcolor : $bgcolor1;
        $output->Text('<td bgcolor="'.$highlight.'" align="center" valign="top">');
        
        // *** Here's where we fill in the content for each day *** //
        $events_found = 0;
        $poptext = '';
        
        for($i=0; $i<count($events) && $showeventsinyear; $i++) {
            // start the tests
            $this_date = date('m/d/Y',mktime(0,0,0,$the_month,$day,$the_year));
            list($this_month,$this_day,$this_year) = explode('/',$this_date);
            $compare_to_date = $the_year.'-'.$the_month.'-'.$this_day;
                      
            switch ($events[$i]['recurrtype']) {
                
                case _EVENT_NONE :
                    // display an event on a certain day
                    if($events[$i]['eventDate'] <= $compare_to_date && $events[$i]['endDate'] >= $compare_to_date) {
                        $output->Text('<tr><td align="left" valign="top">');
                            $output->Text(pnModAPIFunc('PostCalendar',
                                                       'user',
                                                       'createEventLink',
                                                       array('event'=>$events[$i],
                                                             'dayofweek'=>$day_of_week)));
                        $output->Text('</td></tr>');
                    }
                    break;
                
                case _EVENT_DAILY :
                    // display an event on a certain day
                    if($events[$i]['eventDate'] <= $compare_to_date && $events[$i]['endDate'] >= $compare_to_date) {
                        
                        $events_found++;
                        if(!empty($poptext)) $poptext .= '<br><br>';
                        //list($eid,$title,$topic,$eventDate,$endDate,$startTime,$endTime) = $result->fields;
                        $poptext .= addslashes($events[$i]['title']);
                    }
                    break;
                
                case _EVENT_WEEKLY :
                    // display an event weekly on a certain day
                    if($events[$i]['eventDate'] <= $compare_to_date && $events[$i]['endDate'] >= $compare_to_date) {
                        list($event_year,$event_month,$event_day) = explode('-',$events[$i]['eventDate']);
                        
                        $current_week_day   = date('w',mktime(0,0,0,$this_month,$this_day,$this_year));
                        $event_week_day     = date('w',mktime(0,0,0,$event_month,$event_day,$event_year)); 
                        
                        if($current_week_day === $event_week_day) {
                            
                            $events_found++;
                            if(!empty($poptext)) $poptext .= '<br><br>';
                            list($eid,$title,$topic,$eventDate,$endDate,$startTime,$endTime) = $result->fields;
                            $poptext .= addslashes($events[$i]['title']);
                        }
                    }
                    break;
                
                case _EVENT_MONTHLY :
                    // display an event once a month on a certain day
                    if($events[$i]['eventDate'] <= $compare_to_date && $events[$i]['endDate'] >= $compare_to_date) {
                        list($event_year,$event_month,$event_day) = explode('-',$events[$i]['eventDate']);
                          
                        /**
                         *  Display event on same WEEK DAY each Month
                         *  This will cause a monthly event to always show on the same day of the month
                         *  If an event is started on the 1st Monday, it will always display on the 1st Monday
                         *  of each month for it's duration.
                         */
                        
                        if($events[$i]['recurrfreq'] == _RECUR_SAME_DAY) {
                            $current_day_of_week = date('w',mktime(0,0,0,$this_month,$this_day,$this_year));
                            $event_day_of_week   = date('w',mktime(0,0,0,$event_month,$event_day,$event_year));
                         
                            $event_day_occurance=0;
                            for($d=1; $d<=$event_day; $d++) {
                                $current_day = date('w',mktime(0,0,0,$event_month,$d,$event_year));
                                if($current_day === $event_day_of_week) {
                                    $event_day_occurance++;
                                }
                            }
                            
                            $curr_day = date('d',mktime(0,0,0,$this_month,$this_day,$this_year));
                            $current_day_occurance=0;
                            for($d=1; $d<=$curr_day; $d++) {
                                $current_day = date('w',mktime(0,0,0,$this_month,$d,$this_year));
                                if($current_day === $current_day_of_week) {
                                    $current_day_occurance++;
                                }
                            }
                            
                            if($current_day_occurance === $event_day_occurance  && $current_day_of_week === $event_day_of_week) {
                                $events_found++;
                                if(!empty($poptext)) $poptext .= '<br><br>';
                                //list($eid,$title,$topic,$eventDate,$endDate,$startTime,$endTime) = $result->fields;
                                $poptext .= addslashes($events[$i]['title']);
                            }
                        }
                            
                        /**
                         *  Display event on same DATE each Month
                         *  This will cause a monthly event to always show on the same date of the month
                         *  If an event is started on the 25th of the Month it will always display
                         *  on the 25th of each month for its duration
                         *  (this is not yet implemented as it needs DB changes
                         */
                        
                        if($events[$i]['recurrfreq'] == _RECUR_SAME_DATE) {
                            if($this_day === $event_day) {
                                $events_found++;
                                if(!empty($poptext)) $poptext .= '<br><br>';
                                //list($eid,$title,$topic,$eventDate,$endDate,$startTime,$endTime) = $result->fields;
                                $poptext .= addslashes($events[$i]['title']);
                            }    
                        }
                            
                    }
                    break;    
                
                case _EVENT_YEARLY :
                    // display an event once a year on a certain day
                    if($events[$i]['eventDate'] <= $compare_to_date && $events[$i]['endDate'] >= $compare_to_date) {
                        list($event_year,$event_month,$event_day) = explode('-',$events[$i]['eventDate']);    
                        
                        /**
                         *  Display event on same WEEK DAY each Month
                         *  This will cause a monthly event to always show on the same day of the month
                         *  If an event is started on the 1st Monday, it will always display on the 1st Monday
                         *  of each month for it's duration.
                         */
                        if($events[$i]['recurrfreq'] == _RECUR_SAME_DAY) {
                            $current_day_of_week = date('w',mktime(0,0,0,$this_month,$this_day,$this_year));
                            $event_day_of_week   = date('w',mktime(0,0,0,$event_month,$event_day,$event_year));
                         
                            $event_day_occurance=0;
                            for($d=1; $d<=$event_day; $d++) {
                                $current_day = date('w',mktime(0,0,0,$event_month,$d,$event_year));
                                if($current_day === $event_day_of_week) {
                                    $event_day_occurance++;
                                }
                            }
                            
                            $curr_day = date('d',mktime(0,0,0,$this_month,$this_day,$this_year));
                            $current_day_occurance=0;
                            for($d=1; $d<=$curr_day; $d++) {
                                $current_day = date('w',mktime(0,0,0,$this_month,$d,$this_year));
                                if($current_day === $current_day_of_week) {
                                    $current_day_occurance++;
                                }
                            }
                            
                            if(   $current_day_occurance === $event_day_occurance  
                               && $current_day_of_week === $event_day_of_week
                               && $this_month === $event_month) {
                               
                                $events_found++;
                                if(!empty($poptext)) $poptext .= '<br><br>';
                                //list($eid,$title,$topic,$eventDate,$endDate,$startTime,$endTime) = $result->fields;
                                $poptext .= addslashes($events[$i]['title']);
                            }
                        }
                        /**
                         *  Display event on same DATE each Month
                         *  This will cause a monthly event to always show on the same date of the month
                         *  If an event is started on the 25th of the Month it will always display
                         *  on the 25th of each month for its duration
                         *  (this is not yet implemented as it needs DB changes
                         */
                        if($events[$i]['recurrfreq'] == _RECUR_SAME_DATE) {
                            if(   $this_day === $event_day 
                               && $this_month === $event_month) {
                               
                                $events_found++;
                                if(!empty($poptext)) $poptext .= '<br><br>';
                                //list($eid,$title,$topic,$eventDate,$endDate,$startTime,$endTime) = $result->fields;
                                $poptext .= addslashes($events[$i]['title']);
                            }    
                        }
                        
                    }
                    break;
                
                default:
                    break;
            }
        }
        
        if($usepopups) {
            if($day_of_week < 3) {
                $align = 'RIGHT';
            } elseif($day_of_week < 6) {
                $align = 'LEFT';
            } else {
                $align = 'CENTER';
            }
            if(!empty($poptext)) {
                $popuptext = "onmouseover=\"return overlib('".$poptext."',$align);\" " 
                           . "onmouseout=\"return nd();\"";
            } else {
                $popuptext = '';
            }
        } else {
            $popuptext = '';
        }
        
        // ok build the day
        $this_date = date('m/d/Y',mktime(0,0,0,$the_month,$day,$the_year));
        $day_date = date('d',mktime(0,0,0,$the_month,$day,$the_year));
        $day_link = pnModURL('PostCalendar','user','view',array('viewtype'=>'day','Date'=>$this_date));
        $output->Text("<a href=\"$day_link\" $popuptext>$day_date</a>");
        
        if($displayballs && $showeventsinyear) {
            $ballnum = $events_found > 4 ? 4 : $events_found;
            $pc_img_src = "<img border=\"0\" src=\"modules/$modinfo[directory]/pnimages/events$ballnum.gif\">";
            $output->LineBreak();
            $output->Text("<a href=\"$day_link\" $popuptext>$pc_img_src</a>");
        }
        
        
        // *** end content *** //
        $output->Text('</td>');
        $day++;
        $day_of_week++;
        if($day_of_week > 7) {
            $day_of_week = 1;
            $week_displayed = false;
            $output->Text('</tr>');
        }
    }
    
    //*******************************************************************
    //  Next Month Grayed Out Days
    //*******************************************************************
    $day=1;
    while (($day_of_week <= 7) && ($day_of_week != 1)) {
        $output->Text('<td bgcolor="'.$bgcolor2.'" align="center" valign="top">');
        //$day = $day < 10 ? '0'.$day : $day;
        $output->SetOutputMode(_PNH_RETURNOUTPUT);
            $this_date = date('m/d/Y',mktime(0,0,0,$the_month+1,$day,$the_year));
            $day_date = date('d',mktime(0,0,0,$the_month+1,$day,$the_year));
            $day_url = pnModURL('PostCalendar','user','view',array('viewtype'=>'day','Date'=>$this_date));
            $day_link = $output->URL($day_url,$day_date);
        $output->SetOutputMode(_PNH_KEEPOUTPUT);
        $output->Text($day_link);
        $output->Text('</td>');
        $day_of_week++;
        $day++;
    }
    
    //*******************************************************************
    //  END CALENDAR TABLE
    //*******************************************************************
    $output->Text('</tr></table>');
    $output->Text('</td></tr></table>');

    $output->Text('</td>');
    if($m % $numcols == 0 || $m == 12 ) {
        $output->Text('</tr>');  
    }

    //$output->Linebreak();
    
    } // end year build for loop
    $output->Text('</td></tr></table>');
    return $output->GetOutput();
}

function PostCalendar_userapi_createEventLink($args)
{   // get the theme globals :: is there a better way to do this?
    global $bgcolor1, $bgcolor2, $bgcolor3, $bgcolor4, $bgcolor5;
    global $textcolor1, $textcolor2;
    
    extract($args);
    
    if(!isset($event)) {
        return false;
    }
    
    if(!isset($dayofweek)) {
        $dayofweek = 1;
    }
    
    if(!isset($forblock)) {
        $forblock = false;
    }
    
    if(!isset($search)) {
        $search = false;
    }
    
    if(!isset($usepopups)) {
        $usepopups = pnModGetVar('PostCalendar','usepopups');
    }
    
    if(!isset($showdates)) {
        $showdates = false;
    }
    
    // let's load the User API so we can use it
    if(!pnModAPILoad('PostCalendar','user')) {
        die('Could not load PostCalendar user API');
    }
    
    // grab the modules information
    $modinfo = pnModGetInfo(pnModGetIDFromName('PostCalendar'));
    
    // set some variables
    $useinternationaldates  = pnModGetVar('PostCalendar','useinternationaldates');
    $eventsopeninnewwindow  = pnModGetVar('PostCalendar','eventsopeninnewwindow');
    $displayballs           = pnModGetVar('PostCalendar','displayballs');
    $time24hours            = pnModGetVar('PostCalendar','time24hours');
    $showtimeonevents       = pnModGetVar('PostCalendar','showtimeonevents');
    $displaytopics          = pnModGetVar('PostCalendar','displaytopics');
    
    if ($eventsopeninnewwindow) { 
        $link = 'javascript:opencal('.$event['eid'].');'; 
    } else { 
        $link = pnModURL('PostCalendar','user','view',array('viewtype'=>'details','eid'=>$event['eid']));
    }
    
    $output = new pnHTML();
    $output->SetInputMode(_PNH_VERBATIMINPUT);
    $output->SetOutputMode(_PNH_KEEPOUTPUT);
    
    // build the link structure
    if(!preg_match('/[rgby]/',$event['barcolor'])) {
        $barcolor = 'w';
    } else {
        $barcolor = $event['barcolor'];
    }
    
    $img_src = '<img width="9" height="9" src="modules/'.pnVarPrepForOS($modinfo['directory']).'/pnimages/ball'.$barcolor.'.gif" border="0"> ';
    
    $date_text = '';
    if($showdates) {
        list($sy,$sm,$sd) = explode('-',$event['eventDate']);
        list($ey,$em,$ed) = explode('-',$event['endDate']);
        if($useinternationaldates) {
            $startDate = $sd.'/'.$sm.'/'.$sy;
            $endDate = $ed.'/'.$em.'/'.$ey;
        } else {
            $startDate = $sm.'/'.$sd.'/'.$sy;
            $endDate = $em.'/'.$ed.'/'.$ey;
        }
        $date_text = $startDate; //.' - '.$endDate.'<br />';
    }
    
    if($showtimeonevents && !$event['alldayevent']) {
        if (pnModGetVar('PostCalendar','time24hours')) {
            $time_Array = explode(":",$event['startTime']);
            $startTime = $time_Array[0].":".$time_Array[1];
            $time_Array = explode(":",$event['endTime']);
            $endTime = $time_Array[0].":".$time_Array[1];
        } else {
            $startTime  = pnModAPIFunc('PostCalendar','user','getTime',array('time'=>$event['startTime']));
            $endTime    = pnModAPIFunc('PostCalendar','user','getTime',array('time'=>$event['endTime']));
        }
        $time_text = $startTime.'<br />';
        $time_text_popup = $startTime/*.' - '.$endTime*/.'<br />';
    } else {
        $time_text = '<br />';
        $time_text_popup = '<br />';
    }
    
    if($search) {
        $time_text = $event['eventDate'].' '.$startTime/*.' - '.$endTime*/.'<br />';
        $time_text_popup = $event['eventDate'].' '.$startTime/*.' - '.$endTime*/.'<br />';
    }
    
    if($usepopups) {
        if($dayofweek < 3) {
            $align = 'RIGHT';
        } elseif ($dayofweek < 6) {
            $align = 'CENTER';
        } else {
            $align = 'LEFT';
        }
        // clean up the results to make them javascript friendly
        $desc = preg_replace('/[\r\n]/','<br /><br />',$event['hometext']);
        $desc = preg_replace('/(<br[ \f\r\t\n\v\/]*>){3,}/i','<br /><br />',$desc);
        if(!$forblock) {
            $popuptext = "onmouseover=\"return overlib('" .
            addslashes(pnVarPrepForDisplay(pnVarPrepHTMLDisplay($date_text.' '.$time_text_popup.$desc)))."',CAPTION,'" .
            addslashes(pnVarPrepForDisplay(pnVarPrepHTMLDisplay($event['title'])))."',$align);\" onmouseout=\"return nd();\"";
        } else {
            $popuptext = addslashes(pnVarPrepForDisplay(pnVarPrepHTMLDisplay($date_text.$time_text_popup.$event['title'])));
        }
    } else {
        $popuptext = '';
    }
    
    list($dbconn) = pnDBGetConn();
    $pntable = pnDBGetTables();
    $topics_table = $pntable['topics'];
    $topics_column = &$pntable['topics_column'];
    $topicsql = "SELECT $topics_column[topictext],$topics_column[topicimage]
                 FROM $topics_table 
                 WHERE $topics_column[topicid] = $event[topic]
                 LIMIT 1";
    $topic_result = $dbconn->Execute($topicsql);
    list($topictext,$topicimage) = $topic_result->fields;

    if(!$forblock) {
        $output->Text('<table border="0" cellpadding="1" cellspacing="0"><tr><td valign="top" align="left">');
        $output->Text('<a href="'.$link.'" '.$popuptext.'>'.$img_src.'</a>');
        $output->Text('</td><td valign="top" align="left">');
        $output->Text('<a href="'.$link.'" '.$popuptext.'>'.$date_text.' '.$time_text.pnVarPrepForDisplay($event['title']).'</a>');
        if($displaytopics) {
            $output->Linebreak();
            $output->Text('<font class="pn-sub">['.$topictext.']</font>');
        }
        $output->Text('</td></tr></table>');
        $output->Linebreak();
    } else {
        $output->Text($popuptext);
    }
    
    return $output->GetOutput();
}

/**
 *  PostCalendar_userapi_eventDetail
 *  Creates the detailed event display and outputs html.  
 *  Accepts an array of key/value pairs
 *  @param int $eid the id of the event to display
 *  @return string html output 
 *  @access public               
 */
function PostCalendar_userapi_eventDetail($args)
{
    // get the theme globals :: is there a better way to do this?
    global $bgcolor1, $bgcolor2, $bgcolor3, $bgcolor4, $bgcolor5;
    global $textcolor1, $textcolor2;
    
    extract($args);
    if(!isset($eid)) {
        return false;
    }
    
    $output = new pnHTML();
    $output->SetInputMode(_PNH_VERBATIMINPUT);

    // let's load the User API so we can use it
    if(!pnModAPILoad('PostCalendar','user')) {
        die('Could not load PostCalendar user API');
    }
    // let's get the DB information
    pnModDBInfoLoad('PostCalendar');
    list($dbconn) = pnDBGetConn();
    $pntable = pnDBGetTables();

    $events_table = $pntable['postcalendar_events'];
    $events_column = &$pntable['postcalendar_events_column'];

    $useinternationaldates  = pnModGetVar('PostCalendar','useinternationaldates');
    $eventsopeninnewwindow  = pnModGetVar('PostCalendar','eventsopeninnewwindow');
    $time24hours            = pnModGetVar('PostCalendar','time24hours');

    /********************************************************************************
        START PAGE DISPLAY AREA
    ********************************************************************************/
    $sql = "SELECT $events_column[eid], 
                   $events_column[title], 
                   $events_column[hometext], 
                   $events_column[eventDate], 
                   $events_column[endDate], 
                   $events_column[startTime], 
                   $events_column[endTime], 
                   $events_column[barcolor], 
                   $events_column[recurrtype],
                   $events_column[recurrfreq],
                   $events_column[topic],
                   $events_column[time], 
                   $events_column[informant],
                   $events_column[alldayevent],
                   $events_column[location],
                   $events_column[conttel],
                   $events_column[contname],
                   $events_column[contemail],
                   $events_column[website],
                   $events_column[fee]
            FROM   $events_table 
            WHERE  $events_column[eid]=$eid";
            
    $result = $dbconn->Execute($sql);

    list($eid,
         $title,
         $body,
         $eventDate,
         $endDate,
         $startTime,
         $endTime,
         $ballcolor,
         $recurrtype,
         $recurrfreq,
         $topic,
         $datePosted,
         $informant,
         $alldayevent,
         $location,
         $conttel,
         $contname,
         $contemail,
         $website,
         $fee) = $result->fields;

    $topics_table = $pntable['topics'];
    $topics_column = &$pntable['topics_column'];
    $topicsql = "SELECT $topics_column[topictext],$topics_column[topicimage]
                 FROM $topics_table 
                 WHERE $topics_column[topicid] = $topic
                 LIMIT 1";
    $topic_result = $dbconn->Execute($topicsql);
    list($topictext,$topicimage) = $topic_result->fields;

    $Date_Array = explode("-", $eventDate);
    $endDate_Array = explode("-", $endDate);
    $Date_Array2 = explode(" ", $datePosted);
    $Date_Array2 = explode("-",$Date_Array2[0]);

    if (pnModGetVar('PostCalendar','time24hours')) {
        $startTime = substr($startTime,0,5);
        $endTime = substr($endTime,0,5);
    } else {
        $startTime  = pnModAPIFunc('PostCalendar','user','getTime',array('time'=>$startTime));
        $endTime    = pnModAPIFunc('PostCalendar','user','getTime',array('time'=>$endTime));
    }   

    switch ($useinternationaldates) {
        case 0:
            $start_date_text = "$Date_Array[1]/$Date_Array[2]/$Date_Array[0]";
            $end_date_text = "$endDate_Array[1]/$endDate_Array[2]/$endDate_Array[0]";
            break;
        case 1:
            $start_date_text = "$Date_Array[2]/$Date_Array[1]/$Date_Array[0]";
            $end_date_text = "$endDate_Array[2]/$endDate_Array[1]/$endDate_Array[0]";
            break;
    }

    $output->Text("<table cellspacing=\"0\" cellpadding=\"1\" bgcolor=$bgcolor2 width=\"100%\" valign=\"top\"><tr><td>");
    
        $start_date_modurl = pnModURL('PostCalendar','user','view',array('viewtype'=>'day','Date'=>$Date_Array[1].'/'.$Date_Array[2].'/'.$Date_Array[0]));
        $end_date_modurl = pnModURL('PostCalendar','user','view',array('viewtype'=>'day','Date'=>$endDate_Array[1].'/'.$endDate_Array[2].'/'.$endDate_Array[0]));
        /*** START EVENT HEADER INFORMATION TABLE ***/
        $output->Text("<table cellspacing=\"0\" cellpadding=\"5\" bgcolor=$bgcolor2 width=\"100%\" valign=\"top\"><tr>");
        $output->Text('<td width="50%" align="left" valign="top">');
        $output->Text('<h2><img hspace="2" align="left" src="images/topics/'.$topicimage.'">');
        $output->Text(pnVarPrepForDisplay($title).'</h2>');
        $output->Linebreak();
        $output->Text('</td><td>');
            
            $target='';
            if($eventsopeninnewwindow && !$nopop) {
                $target = 'target="csCalendar"';
            }
            
            $output->Text('<table width="100%" border="0" cellpadding="2" cellspacing="0"><tr>');
            $output->Text('<th align="left" valign="top">'._CALEVENTDATEPREVIEW.'</th>');
            $output->Text('<th align="left" valign="top">'._CALENDDATEPREVIEW.'</th>');
            $output->Text('</tr><tr>');
            $output->Text('<td align="left" valign="top">');
            $output->Text("<a class=\"pn-normal\" href=\"$start_date_modurl\" $target>$start_date_text</a>");
            $output->Text('</td>');
                
            if (strtotime($eventDate) != strtotime($endDate)) {
                $output->Text('<td align="left" valign="top">');
                $output->Text("<a class=\"pn-normal\" href=\"$end_date_modurl\" $target>$end_date_text</a>");
                $output->Text('</td>');
            } else {
                $output->Text('<td align="left" valign="top">');
                $output->Text("<a class=\"pn-normal\" href=\"$end_date_modurl\" $target>"._CALSAMEDAY."</a>");
                $output->Text('</td>');
            }
        
            if (!$alldayevent) {
                $output->Text('<tr><td align="left" valign="top">'.$startTime.'</th>');
                $output->Text('<td align="left" valign="top">'.$endTime.'</th></tr>');
            } elseif (pnModGetVar('PostCalendar','showtimeonevents')) { 
                // all day events can have a start time
                $output->Text('<tr><td align="left" valign="top">'.$startTime.'</td>');
                $output->Text('<td align="left" valign="top">'.$endTime.'</th></tr>');
            }
        
            $output->Text("</tr></table>");
        
        $output->Text("</td></tr></table>");
        /*** END EVENT HEADER INFORMATION TABLE ***/
    
        /*** START EVENT INFORMATION TABLE ***/
        $output->Text("<table bgcolor=\"$bgcolor1\" width=\"100%\">");
    
            $output->Text('<tr><td width="25%" valign="top"><font class="pn-normal">'._CALARTICLETEXT.'</td>');
            $output->Text('<td width="100%" valign="top"><b>'.pnVarPrepHTMLDisplay($body).'</b></font></td></tr>');
    
        if (!empty($location)) {
            $output->Text('<tr><td width="25%" valign="top"><font class="pn-normal">'._CALLOCATION.'</td>');
            $output->Text('<td width="100%" valign="top"><b>'.pnVarPrepForDisplay($location).'</b></font></td></tr>');
        }
        if (!empty($conttel)) {
            $output->Text('<tr><td width="25%" valign="top"><font class="pn-normal">'._CONTTEL.'</td>');
            $output->Text('<td width="100%" valign="top"><b>'.pnVarPrepForDisplay($conttel).'</b></font></td></tr>');
        }
        if (!empty($contname)) {
            $output->Text('<tr><td width="25%" valign="top"><font class="pn-normal">'._CONTNAME.'</td>');
            $output->Text('<td width="100%" valign="top"><b>'.pnVarPrepForDisplay($contname).'</b></font></td></tr>');
        }
        if (!empty($contemail)) {
            $output->Text('<tr><td width="25%" valign="top"><font class="pn-normal">'._CONTEMAIL.'</td>');
            $output->Text('<td width="100%" valign="top"><b>'.pnVarPrepForDisplay($contemail).'</b></font></td></tr>');
        }
        if (!empty($website)) {
            $output->Text('<tr><td width="25%" valign="top"><font class="pn-normal">'._CONTWEBSITE.'</td>');
            $output->Text('<td width="100%" valign="top"><b>'.pnVarPrepForDisplay($website).'</b></font></td></tr>');
        }
        if (!empty($fee)) {
            $output->Text('<tr><td width="25%" valign="top"><font class="pn-normal">'._FEE.'</td>');
            $output->Text('<td width="100%" valign="top"><b>'.pnVarPrepForDisplay($fee).'</b></font></td></tr>');
        }
    
        $output->Text("</td></tr></table>");
        /*** END EVENT INFORMATION TABLE ***/
    
        // format the posted on date
        if(isset($datePosted)) {
            list($posteddate,$postedtime) = explode(' ',$datePosted);
            list($y,$m,$d) = explode('-',$posteddate);
            list($h,$min,$s) = explode(':',$postedtime);
    
            if($useinternationaldates) {
                $datePosted = date('d/m/Y',mktime($h,$min,$s,$m,$d,$y));
            } else {
                $datePosted = date('m/d/Y',mktime($h,$min,$s,$m,$d,$y));
            }
    
            if($time24hours) {
                $timePosted = date('H:i',mktime($h,$min,$s,$m,$d,$y));
            } else {
                $timePosted = date('h:i A',mktime($h,$min,$s,$m,$d,$y));
            }
        }
        
        /*** START EVENT FOOTER INFORMATION TABLE ***/
        $output->Text("<table bgcolor=\"$bgcolor1\" width=\"100%\"><tr><td width=\"100%\" valign=\"top\">");
        $output->Text("<font class=\"pn-tiny\">"._CALPOSTEDBY." <a href=\"user.php?op=userinfo&amp;uname=$informant\" target=\"csCalendar\">$informant</a> "._CALPOSTEDON);
        $output->Text("&nbsp;$datePosted $timePosted</font></center>");
        $output->Text('</td></tr></table>');
        /*** END EVENT FOOTER INFORMATION TABLE ***/
  
    $output->Text('</td></tr></table>');
    /*** START ADMIN LINKS ***/ 
    if (pnSecAuthAction(0, 'PostCalendar::Item', '::', ACCESS_EDIT)) {
        $admin_edit_url     = pnModURL('PostCalendar','admin','new',array('pc_event_id[]'=>$eid));
        $admin_delete_url   = pnModURL('PostCalendar','admin','adminevents',array('action'=>_ACTION_DELETE,'pc_event_id[]'=>$eid));
        
        $output->Text("<center>[ <a class=\"pn-normal\" href=\"$admin_edit_url\" $target>"._EDIT."</a> | ");
        $output->Text("<a class=\"pn-normal\" href=\"$admin_delete_url\" $target>"._DELETE."</a> ]</center>\n");
    }
    
    /********************************************************************************
        END PAGE DISPLAY AREA
    ********************************************************************************/
   
   return $output->GetOutput();
}

/**
 *  PostCalendar_userapi_eventPreview
 *  Creates the detailed event display and outputs html.  
 *  Accepts an array of key/value pairs
 *  @param array $event array of event details from the form
 *  @return string html output 
 *  @access public               
 */
function PostCalendar_userapi_eventPreview($args)
{
    // get the theme globals :: is there a better way to do this?
    global $bgcolor1, $bgcolor2, $bgcolor3, $bgcolor4, $bgcolor5;
    global $textcolor1, $textcolor2;
    
    $ampm = array(_AM_VAL=>_PC_AM,_PM_VAL=>_PC_PM);
    
    extract($args);
    
    $output = new pnHTML();
    $output->SetInputMode(_PNH_VERBATIMINPUT);

    // let's load the User API so we can use it
    if(!pnModAPILoad('PostCalendar','user')) {
        die('Could not load PostCalendar user API');
    }
    // let's get the DB information
    pnModDBInfoLoad('PostCalendar');
    list($dbconn) = pnDBGetConn();
    $pntable = pnDBGetTables();

    $topics_table = $pntable['topics'];
    $topics_column = &$pntable['topics_column'];
    $topicsql = "SELECT $topics_column[topictext],$topics_column[topicimage]
                 FROM $topics_table 
                 WHERE $topics_column[topicid] = $event_topic
                 LIMIT 1";
    $topic_result = $dbconn->Execute($topicsql);
    list($topictext,$topicimage) = $topic_result->fields;
    $useinternationaldates = pnModGetVar('PostCalendar','useinternationaldates');
    $time24hours = pnModGetVar('PostCalendar','time24hours');

    /********************************************************************************
        START PAGE DISPLAY AREA
    ********************************************************************************/
    // add preceding zeros
    $event_starttimeh   = $event_starttimeh < 10 ? '0'.$event_starttimeh : $event_starttimeh;
    $event_starttimem   = $event_starttimem < 10 ? '0'.$event_starttimem : $event_starttimem;
    $event_endtimeh     = $event_endtimeh   < 10 ? '0'.$event_endtimeh   : $event_endtimeh;
    $event_endtimem     = $event_endtimem   < 10 ? '0'.$event_endtimem   : $event_endtimem;
    $event_startday     = $event_startday   < 10 ? '0'.$event_startday   : $event_startday;
    $event_startmonth   = $event_startmonth < 10 ? '0'.$event_startmonth : $event_startmonth;
    $event_endday       = $event_endday     < 10 ? '0'.$event_endday     : $event_endday;
    $event_endmonth     = $event_endmonth   < 10 ? '0'.$event_endmonth   : $event_endmonth;
    
   if(!$time24hours) {
        if($ampm[$event_startampm] == _PC_PM) {
            $event_starttimeh =  $event_starttimeh > 12 ? $event_starttimeh-=12 : $event_starttimeh;
        }
        if($ampm[$event_endampm] == _PC_PM) {
            $event_endtimeh =  $event_endtimeh > 12 ? $event_endtimeh-=12 : $event_endtimeh;
        }
    }
    $startTime = $event_starttimeh.':'.$event_starttimem.' ';
    if(isset($event_startampm)) {
        $startTime .= $ampm[$event_startampm];
    }
    
    $endTime = $event_endtimeh.':'.$event_endtimem.' ';
    if(isset($event_endampm)) {
        $endTime .= $ampm[$event_endampm];
    }
    
    switch ($useinternationaldates) {
        case 0:
            $start_date_text = "$event_startmonth/$event_startday/$event_startyear";
            $end_date_text = "$event_endmonth/$event_endday/$event_endyear";
            $today = date('m/d/Y');
            break;
        case 1:
            $start_date_text = "$event_startday/$event_startmonth/$event_startyear";
            $end_date_text = "$event_endday/$event_endmonth/$event_endyear";
            $today = date('d/m/Y');
            break;
    }

    $output->Text("<table cellspacing=\"0\" cellpadding=\"1\" bgcolor=$bgcolor2 width=\"100%\" valign=\"top\"><tr><td>");
    
        /*** START EVENT HEADER INFORMATION TABLE ***/
        $output->Text("<table cellspacing=\"0\" cellpadding=\"5\" bgcolor=$bgcolor2 width=\"100%\" valign=\"top\"><tr>");
        $output->Text('<td width="50%" align="left" valign="top">');
        $output->Text('<h2><img hspace="2" align="left" src="images/topics/'.$topicimage.'">');
        $output->Text(pnVarPrepForDisplay($event_subject).'</h2>');
        $output->Linebreak();
        $output->Text('</td><td>');
    
            $output->Text('<table width="100%" border="0" cellpadding="2" cellspacing="0"><tr>');
            $output->Text('<th align="left" valign="top">'._CALEVENTDATEPREVIEW.'</th>');
            $output->Text('<th align="left" valign="top">'._CALENDDATEPREVIEW.'</th>');
            $output->Text('</tr><tr>');
            $output->Text('<td align="left" valign="top">');
            $output->Text($start_date_text);
            $output->Text('</td>');
                
            if (strtotime($start_date_text) != strtotime($end_date_text)) {
                $output->Text('<td align="left" valign="top">');
                $output->Text($end_date_text);
                $output->Text('</td>');
            } else {
                $output->Text('<td align="left" valign="top">');
                $output->Text(_CALSAMEDAY);
                $output->Text('</td>');
            }
        
            if (!$event_allday) {
                $output->Text('<tr><td align="left" valign="top">'.$startTime.'</th>');
                $output->Text('<td align="left" valign="top">'.$endTime.'</th></tr>');
            } elseif (pnModGetVar('PostCalendar','showtimeonevents')) { 
                // all day events can have a start time
                $output->Text('<tr><td align="left" valign="top">'.$startTime.'</td>');
                $output->Text('<td align="left" valign="top">'.$endTime.'</th></tr>');
            }
        
            $output->Text("</tr></table>");
        
        $output->Text("</td></tr></table>");
        /*** END EVENT HEADER INFORMATION TABLE ***/
    
        /*** START EVENT INFORMATION TABLE ***/
        $output->Text("<table bgcolor=\"$bgcolor1\" width=\"100%\">");
    
            $output->Text('<tr><td width="25%" valign="top"><font class="pn-normal">'._CALARTICLETEXT.'</td>');
            $output->Text('<td width="100%" valign="top"><b>'.pnVarPrepHTMLDisplay($event_desc).'</b></font></td></tr>');
    
        if (!empty($event_location)) {
            $output->Text('<tr><td width="25%" valign="top"><font class="pn-normal">'._CALLOCATION.'</td>');
            $output->Text('<td width="100%" valign="top"><b>'.pnVarPrepForDisplay($event_location).'</b></font></td></tr>');
        }
        if (!empty($event_conttel)) {
            $output->Text('<tr><td width="25%" valign="top"><font class="pn-normal">'._CONTTEL.'</td>');
            $output->Text('<td width="100%" valign="top"><b>'.pnVarPrepForDisplay($event_conttel).'</b></font></td></tr>');
        }
        if (!empty($event_contname)) {
            $output->Text('<tr><td width="25%" valign="top"><font class="pn-normal">'._CONTNAME.'</td>');
            $output->Text('<td width="100%" valign="top"><b>'.pnVarPrepForDisplay($event_contname).'</b></font></td></tr>');
        }
        if (!empty($event_contemail)) {
            $output->Text('<tr><td width="25%" valign="top"><font class="pn-normal">'._CONTEMAIL.'</td>');
            $output->Text('<td width="100%" valign="top"><b>'.pnVarPrepForDisplay($event_contemail).'</b></font></td></tr>');
        }
        if (!empty($event_website)) {
            $output->Text('<tr><td width="25%" valign="top"><font class="pn-normal">'._CONTWEBSITE.'</td>');
            $output->Text('<td width="100%" valign="top"><b>'.pnVarPrepForDisplay($event_website).'</b></font></td></tr>');
        }
        if (!empty($event_fee)) {
            $output->Text('<tr><td width="25%" valign="top"><font class="pn-normal">'._FEE.'</td>');
            $output->Text('<td width="100%" valign="top"><b>'.pnVarPrepForDisplay($event_fee).'</b></font></td></tr>');
        }
    
        $output->Text("</td></tr></table>");
        /*** END EVENT INFORMATION TABLE ***/
    
        /*** START EVENT FOOTER INFORMATION TABLE ***/
        $output->Text("<table bgcolor=\"$bgcolor1\" width=\"100%\"><tr><td width=\"100%\" valign=\"top\">");
        $output->Text("<font class=\"pn-tiny\">"._CALPOSTEDBY." <a href=\"user.php?op=userinfo&amp;uname=$uname\" target=\"csCalendar\">$uname</a> "._CALPOSTEDON);
        $output->Text("&nbsp;$today</font></center>");
        $output->Text('</td></tr></table>');
        /*** END EVENT FOOTER INFORMATION TABLE ***/
  
    $output->Text('</td></tr></table>');
    /********************************************************************************
        END PAGE DISPLAY AREA
    ********************************************************************************/
   
   return $output->GetOutput();
}



/**
 * PostCalendar_userapi_jsPopup
 * Creates the necessary javascript code for a popup window
 */
function PostCalendar_userapi_jsPopup() 
{   if(defined('_POSTCALENDAR_JSPOPUPS_LOADED')) {
        // only put the script on the page once
        return false;
    }
    define('_POSTCALENDAR_JSPOPUPS_LOADED',true);
    
    // lets get the module's information
    $modinfo = pnModGetInfo(pnModGetIDFromName('PostCalendar'));
    // build the correct link
    $js_link    = "'modules.php?op=modload&name=$modinfo[directory]&file=popup&eid='+eid";
    $js_window_options = 'toolbar=no,'
                       . 'location=no,'
                       . 'directories=no,'
                       . 'status=no,'
                       . 'menubar=no,'
                       . 'scrollbars=yes,'
                       . 'resizable=no,'
                       . 'width=600,'
                       . 'height=300';
    
    $output = new pnHTML();
    $output->SetInputMode(_PNH_VERBATIMINPUT);
    
    // create the js text
    $output->Text('<script language="javascript">'."\n");
    $output->Text('<!--'."\n");
    $output->Text('function opencal(eid) {'."\n");
    $output->Text('window.name=\'csCalendar\';'."\n");
    $output->Text('w = window.open('.$js_link.',\'PostCalendarEvents\',\''.$js_window_options.'\');'."\n");   
    $output->Text('}'."\n");   
    $output->Text('// -->'."\n");
    $output->Text('</script>'."\n");

    return $output->GetOutput();
}

/**
 * PostCalendar_userapi_loadPopups
 * Creates the necessary javascript code for mouseover dHTML popups
 */
function PostCalendar_userapi_loadPopups()
{   if(defined('_POSTCALENDAR_LOADPOPUPS_LOADED')) {
        // only put the script on the page once
        return false;
    }
    define('_POSTCALENDAR_LOADPOPUPS_LOADED',true);
    
    // get the theme globals :: is there a better way to do this?
    global $bgcolor1, $bgcolor2, $bgcolor3, $bgcolor4, $bgcolor5;
    global $textcolor1, $textcolor2;
    
    // lets get the module's information
    $modinfo = pnModGetInfo(pnModGetIDFromName('PostCalendar'));
    $output = new pnHTML();
    $output->SetInputMode(_PNH_VERBATIMINPUT);
    //$capicon = "modules/$modinfo[directory]/pnimages/admin.gif";
    $capicon = '';
    // eventually move these to the PostCalendar Config
    $output->Text('<script language="JavaScript">'                  ."\n");
    $output->Text('<!-- overLIB configuration -->'                  ."\n");
    $output->Text('ol_fgcolor       = "'.$bgcolor1.'";'             ."\n");
	$output->Text('ol_bgcolor       = "'.$bgcolor2.'";'             ."\n");
	$output->Text('ol_textcolor     = "'.$textcolor1.'";'           ."\n");
	$output->Text('ol_capcolor      = "'.$textcolor2.'";'           ."\n");
    $output->Text('ol_closecolor    = "'.$textcolor2.'";'           ."\n");
    // font settings
    $output->Text('ol_textfont      = "Verdana,Arial,Helvetica";'   ."\n");
    $output->Text('ol_captionfont   = "Verdana,Arial,Helvetica";'   ."\n");
    $output->Text('ol_captionsize   = 2;'                           ."\n");
    $output->Text('ol_textsize      = 2;'                           ."\n");
    // popup border width
    $output->Text('ol_border        = 2;'                           ."\n");
    // width of the popup
    $output->Text('ol_width         = 200;'                         ."\n");
    // offset of popup from mouse pointer
    $output->Text('ol_offsetx       = 10;'                          ."\n");
    $output->Text('ol_offsety       = 10;'                          ."\n");
    // sticky by default
    $output->Text('ol_sticky        = 0;'                           ."\n");
    // close link text
    $output->Text('ol_close         = "'._PC_OL_CLOSE.'";'          ."\n");
    $output->Text('ol_closeclick    = 0;'                           ."\n");
    // display 0=nothing, 1=title, 2=caption in staus bar
    $output->Text('ol_autostatus    = 2;'                           ."\n");
    // snap the popup to pixel
    $output->Text('ol_snapx         = 5;'                           ."\n");
    $output->Text('ol_snapy         = 5;'                           ."\n");
    // popup displays in fixed position
    $output->Text('ol_fixx          = -1;'                          ."\n");
    $output->Text('ol_fixy          = -1;'                          ."\n");
    // background image settings
    $output->Text('ol_background    = "";'                          ."\n");
    $output->Text('ol_fgbackground  = "";'                          ."\n");
    $output->Text('ol_bgbackground  = "";'                          ."\n");
    // background image text padding
    $output->Text('ol_padxl         = 1;'                           ."\n");
    $output->Text('ol_padxr         = 1;'                           ."\n");
    $output->Text('ol_padyt         = 1;'                           ."\n");
    $output->Text('ol_padyb         = 1;'                           ."\n");
    // caption icon
    $output->Text('ol_capicon       = "'.$capicon.'";'              ."\n");
    // let overlib place the popups
    $output->Text('ol_hauto         = 1;'                           ."\n");
    $output->Text('ol_vauto         = 1;'                           ."\n");
    $output->Text('</script>');
    $output->Text('<div id="overDiv" style="position:absolute; visibility:hidden; z-index:1000;"></div>'."\n");
    $output->Text('<script language="JavaScript" src="modules/'.$modinfo['directory'].'/pnincludes/overlib_mini.js">'."\n");
    $output->Text('<!-- overLIB (c) Erik Bosrup -->'."\n");
    $output->Text('</script>'."\n");
    
    return $output->GetOutput();
}

?>
