<?php
// $Id: popup.php,v 1.8.2.1 2002/04/20 07:10:39 epsilon7 Exp $
/********************************************************/
/* PostCalendar                                         */
/* Version 2.6,  see changes.txt for details            */
/* Originally by Rob Sutton (Events Calendar)           */
/* Development continued by                             */
/*                                                      */
/*  The PostCalendar Development Team                   */
/*     Mahmood Al-Yousif - mahmood@bahraini.tv          */
/*     Craig Hamlin - craig@hamlinworld.com             */
/*     HotBird - ramses@bzone.de                        */
/*     Roger Raymond - iansym@yahoo.com                 */
/*                                                      */
/* This program is opensource so you can do whatever    */
/* you want with it. However, I'm happy about any       */
/* clever idea or nifty change you might have or have   */
/* done, send them to                                   */
/* calendar@bahraini.tv                                 */
/*                                                      */
/* Any new versions can be found at                     */
/* http://www.bahraini.tv first                         */
/********************************************************/

/**
 *  popup view for events displayed in a new window  
 */
$output = new pnHTML();
$output->SetInputMode(_PNH_VERBATIMINPUT);

// don't know why this isn't working
//if (!pnLocalReferer()) {
//    $output->Text('You can not access this page directly.');
//    $output->PrintPage();
//    exit;
//}

// let's load the User API so we can use it :)
if(!pnModAPILoad('PostCalendar','user')) {
    die('Could not load PostCalendar user API');
}
if(!pnThemeLoad()) {
    die('Could not load theme');
}
$thetheme = pnUserGetTheme();

// let's get the DB information
pnModDBInfoLoad('PostCalendar');
list($dbconn) = pnDBGetConn();
$pntable = pnDBGetTables();

$events_table = $pntable['postcalendar_events'];
$events_column = &$pntable['postcalendar_events_column'];

$eid = pnVarCleanFromInput('eid');
$useinternationaldates = pnModGetVar('PostCalendar','useinternationaldates');
$time24hours = pnModGetVar('PostCalendar','time24hours');

$output->Text('<html><head>');
$output->Text("<title>"._CALVIEWEVENT." :: ".pnConfigGetVar('sitename').' :: '.pnConfigGetVar('slogan')."</title>\n");
$output->Text('<link rel="StyleSheet" href="themes/'.$thetheme.'/style/styleNN.css" type="text/css" />');
$output->Text('<style type="text/css">@import url("themes/'.$thetheme.'/style/style.css"); </style>');
$output->Text('</head>');
$output->Text('<body bgcolor="'.$bgcolor1.'">');
/********************************************************************************
    START PAGE DISPLAY AREA
********************************************************************************/
$sql = "SELECT $events_column[eid], 
               $events_column[title], 
               $events_column[hometext], 
               $events_column[eventDate], 
               $events_column[endDate], 
               $events_column[startTime], 
               $events_column[endTime], 
               $events_column[barcolor], 
               $events_column[recurrtype],
               $events_column[recurrfreq],
               $events_column[topic],
               $events_column[time], 
               $events_column[informant],
               $events_column[alldayevent],
               $events_column[location],
               $events_column[conttel],
               $events_column[contname],
               $events_column[contemail],
               $events_column[website],
               $events_column[fee]
        FROM   $events_table 
        WHERE  $events_column[eid]=$eid";
            
$result = $dbconn->Execute($sql);

    list($eid,
         $title,
         $body,
         $eventDate,
         $endDate,
         $startTime,
         $endTime,
         $ballcolor,
         $recurrtype,
         $recurrfreq,
         $topic,
         $datePosted,
         $informant,
         $alldayevent,
         $location,
         $conttel,
         $contname,
         $contemail,
         $website,
         $fee) = $result->fields;


$topics_table = $pntable['topics'];
$topics_column = &$pntable['topics_column'];
$topicsql = "SELECT $topics_column[topictext],$topics_column[topicimage]
             FROM $topics_table 
             WHERE $topics_column[topicid] = $topic
             LIMIT 1";
$topic_result = $dbconn->Execute($topicsql);
list($topictext,$topicimage) = $topic_result->fields;

$Date_Array = explode("-", $eventDate);
$endDate_Array = explode("-", $endDate);
$Date_Array2 = explode(" ", $datePosted);
$Date_Array2 = explode("-",$Date_Array2[0]);

if (pnModGetVar('PostCalendar','time24hours')) {
    $startTime = substr($startTime,0,5);
    $endTime = substr($endTime,0,5);
} else {
    $startTime  = pnModAPIFunc('PostCalendar','user','getTime',array('time'=>$startTime));
    $endTime    = pnModAPIFunc('PostCalendar','user','getTime',array('time'=>$endTime));
}

switch ($useinternationaldates) {
    case 0:
        $start_date_text = "$Date_Array[1]/$Date_Array[2]/$Date_Array[0]";
        $end_date_text = "$endDate_Array[1]/$endDate_Array[2]/$endDate_Array[0]";
        break;
    case 1:
        $start_date_text = "$Date_Array[2]/$Date_Array[1]/$Date_Array[0]";
        $end_date_text = "$endDate_Array[2]/$endDate_Array[1]/$endDate_Array[0]";
        break;
}

$output->Text("<table cellspacing=\"0\" cellpadding=\"1\" bgcolor=$bgcolor2 width=\"100%\" valign=\"top\"><tr><td>");
    
    $start_date_modurl = pnModURL('PostCalendar','user','view',array('viewtype'=>'day','Date'=>$Date_Array[1].'/'.$Date_Array[2].'/'.$Date_Array[0]));
    $end_date_modurl = pnModURL('PostCalendar','user','view',array('viewtype'=>'day','Date'=>$endDate_Array[1].'/'.$endDate_Array[2].'/'.$endDate_Array[0]));
    /*** START EVENT HEADER INFORMATION TABLE ***/
    $output->Text("<table cellspacing=\"0\" cellpadding=\"5\" bgcolor=$bgcolor2 width=\"100%\" valign=\"top\"><tr>");
    $output->Text('<td width="50%" align="left" valign="top">');
    $output->Text('<h2><img hspace="2" align="left" src="images/topics/'.$topicimage.'">');
    $output->Text(pnVarPrepForDisplay($title).'</h2>');
    $output->Linebreak();
    $output->Text('</td><td>');
    
        $output->Text('<table width="100%" border="0" cellpadding="2" cellspacing="0"><tr>');
        $output->Text('<th align="left" valign="top">'._CALEVENTDATEPREVIEW.'</th>');
        $output->Text('<th align="left" valign="top">'._CALENDDATEPREVIEW.'</th>');
        $output->Text('</tr><tr>');
        $output->Text('<td align="left" valign="top">');
        $output->Text("<a class=\"pn-normal\" href=\"$start_date_modurl\" target=\"csCalendar\">$start_date_text</a>");
        $output->Text('</td>');
                
        if (strtotime($eventDate) != strtotime($endDate)) {
            $output->Text('<td align="left" valign="top">');
            $output->Text("<a class=\"pn-normal\" href=\"$end_date_modurl\" target=\"csCalendar\">$end_date_text</a>");
            $output->Text('</td>');
        } else {
            $output->Text('<td align="left" valign="top">');
            $output->Text("<a class=\"pn-normal\" href=\"$end_date_modurl\" target=\"csCalendar\">"._CALSAMEDAY."</a>");
            $output->Text('</td>');
        }
        
        if (!$alldayevent) {
            $output->Text('<tr><td align="left" valign="top">'.$startTime.'</th>');
            $output->Text('<td align="left" valign="top">'.$endTime.'</th></tr>');
        } elseif (pnModGetVar('PostCalendar','showtimeonevents')) { 
            // all day events can have a start time
            $output->Text('<tr><td align="left" valign="top">'.$startTime.'</td>');
            $output->Text('<td align="left" valign="top">'.$endTime.'</th></tr>');
        }
        
        $output->Text("</tr></table>");
        
    $output->Text("</td></tr></table>");
    /*** END EVENT HEADER INFORMATION TABLE ***/
    
    /*** START EVENT INFORMATION TABLE ***/
    $output->Text("<table bgcolor=\"$bgcolor1\" width=\"100%\">");
    
        $output->Text('<tr><td width="25%" valign="top"><font class="pn-normal">'._CALARTICLETEXT.'</td>');
        $output->Text('<td width="100%" valign="top"><b>'.pnVarPrepHTMLDisplay($body).'</b></font></td></tr>');
    
    if (!empty($location)) {
        $output->Text('<tr><td width="25%" valign="top"><font class="pn-normal">'._CALLOCATION.'</td>');
        $output->Text('<td width="100%" valign="top"><b>'.pnVarPrepForDisplay($location).'</b></font></td></tr>');
    }
    if (!empty($conttel)) {
        $output->Text('<tr><td width="25%" valign="top"><font class="pn-normal">'._CONTTEL.'</td>');
        $output->Text('<td width="100%" valign="top"><b>'.pnVarPrepForDisplay($conttel).'</b></font></td></tr>');
    }
    if (!empty($contname)) {
        $output->Text('<tr><td width="25%" valign="top"><font class="pn-normal">'._CONTNAME.'</td>');
        $output->Text('<td width="100%" valign="top"><b>'.pnVarPrepForDisplay($contname).'</b></font></td></tr>');
    }
    if (!empty($contemail)) {
        $output->Text('<tr><td width="25%" valign="top"><font class="pn-normal">'._CONTEMAIL.'</td>');
        $output->Text('<td width="100%" valign="top"><b>'.pnVarPrepForDisplay($contemail).'</b></font></td></tr>');
    }
    if (!empty($website)) {
        $output->Text('<tr><td width="25%" valign="top"><font class="pn-normal">'._CONTWEBSITE.'</td>');
        $output->Text('<td width="100%" valign="top"><b>'.pnVarPrepForDisplay($website).'</b></font></td></tr>');
    }
    if (!empty($fee)) {
        $output->Text('<tr><td width="25%" valign="top"><font class="pn-normal">'._FEE.'</td>');
        $output->Text('<td width="100%" valign="top"><b>'.pnVarPrepForDisplay($fee).'</b></font></td></tr>');
    }
    
    $output->Text("</td></tr></table>");
    
    /*** END EVENT INFORMATION TABLE ***/
    
    // format the posted on date
    list($posteddate,$postedtime) = explode(' ',$datePosted);
    list($y,$m,$d) = explode('-',$posteddate);
    list($h,$min,$s) = explode(':',$postedtime);
    
    if($useinternationaldates) {
        $datePosted = date('d/m/Y',mktime($h,$min,$s,$m,$d,$y));
    } else {
        $datePosted = date('m/d/Y',mktime($h,$min,$s,$m,$d,$y));
    }
    
    if($time24hours) {
        $timePosted = date('H:i',mktime($h,$min,$s,$m,$d,$y));
    } else {
        $timePosted = date('h:i A',mktime($h,$min,$s,$m,$d,$y));
    }
    
    /*** START EVENT FOOTER INFORMATION TABLE ***/
    $output->Text("<table bgcolor=\"$bgcolor1\" width=\"100%\"><tr><td width=\"100%\" valign=\"top\">");
    $output->Text("<font class=\"pn-tiny\">"._CALPOSTEDBY." <a href=\"user.php?op=userinfo&amp;uname=$informant\" target=\"csCalendar\">$informant</a> "._CALPOSTEDON);
    $output->Text("&nbsp;$datePosted $timePosted</font></center>");
    $output->Text('</td></tr></table>');
    /*** END EVENT FOOTER INFORMATION TABLE ***/
  
$output->Text('</td></tr></table>');

$output->Text("<table bgcolor=\"$bgcolor1\" width=\"100%\"><tr>");
$output->Text('<td width="33%" valign="top">&nbsp;</td>');
$output->Text('<td width="33%" align="center" valign="top">');
/*** START ADMIN AND CLOSE WINDOW LINKS ***/ 
/*** START ADMIN LINKS ***/ 
    if (pnSecAuthAction(0, 'PostCalendar::Item', '::', ACCESS_EDIT)) {
        $target = '';
        if(pnModGetVar('PostCalendar','eventsopeninnewwindow')) {
            $target = 'target="csCalendar"';
        }
        $admin_edit_url     = pnModURL('PostCalendar','admin','new',array('pc_event_id[]'=>$eid));
        $admin_delete_url   = pnModURL('PostCalendar','admin','adminevents',array('action'=>_ACTION_DELETE,'pc_event_id[]'=>$eid));
        
        $output->Text("<center>[ <a class=\"pn-normal\" href=\"$admin_edit_url\" $target>"._EDIT."</a> | ");
        $output->Text("<a class=\"pn-normal\" href=\"$admin_delete_url\" $target>"._DELETE."</a> ]</center>\n");
    } else {
        $output->Text('&nbsp;');
    }
$output->Text('</td>');

$output->Text('<td width="33%" align="right" valign="top">');
$output->Text('<p class="pn-tiny" align="right"><a href="#" onclick="javascript:window.close();">'._CALCLOSEWINDOW.'</a></p>');
$output->Text('</td>');
$output->Text('</tr></table>');  
/********************************************************************************
    END PAGE DISPLAY AREA
********************************************************************************/

$output->Text('</body></html>');
$output->PrintPage();

?>
