/*
 * System Down: A systemd-journald exploit
 * https://www.qualys.com/2019/01/09/system-down/system-down.txt
 * Copyright (C) 2019 Qualys, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

#include <stdbool.h>
#include <stddef.h>
#include <stdint.h>

void initialize_infoleak(void);
size_t infoleak_n_iovec_fields(void);
size_t infoleak_n_iovec_extra_fields(void);
ssize_t infoleak_lowest_stack_offset(void);

typedef struct {
    ssize_t offset;
    uintptr_t value;
} address_t;

void infoleak(address_t * addresses, size_t n_addresses,
    size_t binary_item_heap_size, size_t tempfile_heap_size);

